/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.MinimalState;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundlePlugin;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.plugin.Plugin;

public class ClasspathUtilCore {
    public static IClasspathEntry createContainerEntry() {
        return JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins"));
    }

    public static IClasspathEntry createJREEntry() {
        return JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
    }

    public static void addLibraries(IPluginModelBase model, ArrayList result) throws CoreException {
        if (new File(model.getInstallLocation()).isFile()) {
            ClasspathUtilCore.addJARdPlugin(model, result);
        } else {
            IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
            int i = 0;
            while (i < libraries.length) {
                IClasspathEntry entry;
                if (!"resource".equals(libraries[i].getType()) && (entry = ClasspathUtilCore.createLibraryEntry(libraries[i])) != null && !result.contains(entry)) {
                    result.add(entry);
                }
                ++i;
            }
        }
    }

    private static void addJARdPlugin(IPluginModelBase model, ArrayList result) throws CoreException {
        IClasspathEntry entry;
        IPath sourcePath = ClasspathUtilCore.getSourceAnnotation(model, ".");
        if (sourcePath == null) {
            sourcePath = new Path(model.getInstallLocation());
        }
        if ((entry = JavaCore.newLibraryEntry((IPath)new Path(model.getInstallLocation()), (IPath)sourcePath, null, (boolean)false)) != null && !result.contains(entry)) {
            result.add(entry);
        }
    }

    protected static IClasspathEntry createLibraryEntry(IPluginLibrary library) {
        IClasspathEntry entry = null;
        try {
            String name = library.getName();
            String expandedName = ClasspathUtilCore.expandLibraryName(name);
            IPluginModelBase model = library.getPluginModel();
            IPath path = ClasspathUtilCore.getPath(model, expandedName);
            if (path == null) {
                if (model.isFragmentModel() || !ClasspathUtilCore.containsVariables(name)) {
                    return null;
                }
                model = ClasspathUtilCore.resolveLibraryInFragments(library, expandedName);
                if (model == null) {
                    return null;
                }
                path = ClasspathUtilCore.getPath(model, expandedName);
            }
            if (model.getUnderlyingResource() == null && path.toFile().isDirectory()) {
                return null;
            }
            entry = JavaCore.newLibraryEntry((IPath)path, (IPath)ClasspathUtilCore.getSourceAnnotation(model, expandedName), null, (boolean)false);
        }
        catch (CoreException coreException) {}
        return entry;
    }

    public static boolean hasExtensibleAPI(IPlugin plugin) {
        if (plugin instanceof Plugin) {
            return ((Plugin)plugin).hasExtensibleAPI();
        }
        if (plugin instanceof BundlePlugin) {
            return ((BundlePlugin)plugin).hasExtensibleAPI();
        }
        return false;
    }

    public static boolean isBundle(IPluginModelBase model) {
        if (model instanceof IBundlePluginModelBase) {
            return true;
        }
        if (model.getUnderlyingResource() == null) {
            File location = new File(model.getInstallLocation());
            if (location.isDirectory() && !new File(location, "META-INF/MANIFEST.MF").exists()) {
                return false;
            }
            Dictionary manifest = MinimalState.loadManifest(location);
            if (manifest == null) {
                return false;
            }
            Enumeration keys = manifest.keys();
            while (keys.hasMoreElements()) {
                if (!keys.nextElement().toString().equals("Bundle-SymbolicName")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean containsVariables(String name) {
        return name.indexOf("$os$") != -1 || name.indexOf("$ws$") != -1 || name.indexOf("$nl$") != -1 || name.indexOf("$arch$") != -1;
    }

    public static String expandLibraryName(String source) {
        if (source == null || source.length() == 0) {
            return "";
        }
        if (source.indexOf("$ws$") != -1) {
            source = source.replaceAll("\\$ws\\$", "ws/" + TargetPlatform.getWS());
        }
        if (source.indexOf("$os$") != -1) {
            source = source.replaceAll("\\$os\\$", "os/" + TargetPlatform.getOS());
        }
        if (source.indexOf("$nl$") != -1) {
            source = source.replaceAll("\\$nl\\$", "nl/" + TargetPlatform.getNL());
        }
        if (source.indexOf("$arch$") != -1) {
            source = source.replaceAll("\\$arch\\$", "arch/" + TargetPlatform.getOSArch());
        }
        return source;
    }

    public static IPath getSourceAnnotation(IPluginModelBase model, String libraryName) throws CoreException {
        String zipName = ClasspathUtilCore.getSourceZipName(libraryName);
        IPath path = ClasspathUtilCore.getPath(model, zipName);
        if (path == null) {
            SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
            path = manager.findSourcePath(model.getPluginBase(), (IPath)new Path(zipName));
        }
        return path;
    }

    public static String getSourceZipName(String libraryName) {
        int dot = libraryName.lastIndexOf(46);
        return dot != -1 ? String.valueOf(libraryName.substring(0, dot)) + "src.zip" : libraryName;
    }

    private static IPluginModelBase resolveLibraryInFragments(IPluginLibrary library, String libraryName) {
        IFragment[] fragments = PDECore.getDefault().findFragmentsFor(library.getPluginBase().getId(), library.getPluginBase().getVersion());
        int i = 0;
        while (i < fragments.length) {
            ModelEntry entry;
            IPluginModelBase model;
            IPath path = ClasspathUtilCore.getPath(fragments[i].getPluginModel(), libraryName);
            if (path != null) {
                return fragments[i].getPluginModel();
            }
            if (fragments[i].getModel().getUnderlyingResource() != null && (model = (entry = PDECore.getDefault().getModelManager().findEntry(fragments[i].getId())).getExternalModel()) != null && model instanceof IFragmentModel && (path = ClasspathUtilCore.getPath(model, libraryName)) != null) {
                return model;
            }
            ++i;
        }
        return null;
    }

    private static IPath getPath(IPluginModelBase model, String libraryName) {
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            IResource jarFile = resource.getProject().findMember(libraryName);
            if (jarFile != null) {
                return jarFile.getFullPath();
            }
        } else {
            File file = new File(model.getInstallLocation(), libraryName);
            if (file.exists()) {
                return new Path(file.getAbsolutePath());
            }
        }
        return null;
    }

    protected static IBuild getBuild(IPluginModelBase model) throws CoreException {
        IProject project;
        IFile buildFile;
        IBuildModel buildModel = model.getBuildModel();
        if (buildModel == null && (buildFile = (project = model.getUnderlyingResource().getProject()).getFile("build.properties")).exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        return buildModel != null ? buildModel.getBuild() : null;
    }
}

