/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IAnnotationModelFactory;
import org.eclipse.core.filebuffers.IDocumentFactory;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.IStateValidationSupport;
import org.eclipse.core.filebuffers.ISynchronizationContext;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.internal.filebuffers.AbstractFileBuffer;
import org.eclipse.core.internal.filebuffers.ExtensionsRegistry;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.internal.filebuffers.JavaTextFileBuffer;
import org.eclipse.core.internal.filebuffers.ResourceTextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.source.IAnnotationModel;

public class TextFileBufferManager
implements ITextFileBufferManager {
    private Map fFilesBuffers = new HashMap();
    private List fFileBufferListeners = new ArrayList();
    private ExtensionsRegistry fRegistry = new ExtensionsRegistry();
    private ISynchronizationContext fSynchronizationContext;

    public void connect(IPath location, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = (AbstractFileBuffer)this.fFilesBuffers.get(location);
        if (fileBuffer == null) {
            fileBuffer = this.createFileBuffer(location);
            if (fileBuffer == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 2, FileBuffersMessages.FileBufferManager_error_canNotCreateFilebuffer, null));
            }
            fileBuffer.create(location, monitor);
            fileBuffer.connect();
            this.fFilesBuffers.put(location, fileBuffer);
            this.fireBufferCreated(fileBuffer);
        } else {
            fileBuffer.connect();
        }
    }

    public void disconnect(IPath location, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = (AbstractFileBuffer)this.fFilesBuffers.get(location);
        if (fileBuffer != null) {
            fileBuffer.disconnect();
            if (fileBuffer.isDisconnected()) {
                this.fFilesBuffers.remove(location);
                this.fireBufferDisposed(fileBuffer);
                fileBuffer.dispose();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isTextFileLocation(IPath location) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [4 : 269->272)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IFileBuffer getFileBuffer(IPath location) {
        location = FileBuffers.normalizeLocation(location);
        return (IFileBuffer)this.fFilesBuffers.get(location);
    }

    public ITextFileBuffer getTextFileBuffer(IPath location) {
        location = FileBuffers.normalizeLocation(location);
        return (ITextFileBuffer)this.fFilesBuffers.get(location);
    }

    public String getDefaultEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    public IDocument createEmptyDocument(IPath location) {
        IDocumentSetupParticipant[] participants;
        String initalLineDelimiter;
        Object document;
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        final IDocument[] runnableResult = new IDocument[1];
        final IDocumentFactory factory = this.fRegistry.getDocumentFactory(location);
        if (factory != null) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    runnableResult[0] = factory.createDocument();
                }

                public void handleException(Throwable t) {
                    Status status = new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.TextFileBufferManager_error_documentFactoryFailed, t);
                    FileBuffersPlugin.getDefault().getLog().log((IStatus)status);
                    if (t instanceof VirtualMachineError) {
                        throw (VirtualMachineError)t;
                    }
                }
            };
            Platform.run((ISafeRunnable)runnable);
        }
        if ((document = runnableResult[0] != null ? runnableResult[0] : new Document()) instanceof IDocumentExtension4 && (initalLineDelimiter = this.getLineDelimiterPreference(location)) != null) {
            ((IDocumentExtension4)document).setInitialLineDelimiter(initalLineDelimiter);
        }
        if ((participants = this.fRegistry.getDocumentSetupParticipants(location)) != null) {
            int i = 0;
            while (i < participants.length) {
                final IDocumentSetupParticipant participant = participants[i];
                ISafeRunnable runnable = new ISafeRunnable((IDocument)document){
                    private final /* synthetic */ IDocument val$document;
                    {
                        this.val$document = iDocument;
                    }

                    public void run() throws Exception {
                        participant.setup(this.val$document);
                    }

                    public void handleException(Throwable t) {
                        Status status = new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.TextFileBufferManager_error_documentSetupFailed, t);
                        FileBuffersPlugin.getDefault().getLog().log((IStatus)status);
                        if (t instanceof VirtualMachineError) {
                            throw (VirtualMachineError)t;
                        }
                    }
                };
                Platform.run((ISafeRunnable)runnable);
                ++i;
            }
        }
        return document;
    }

    public IAnnotationModel createAnnotationModel(IPath location) {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        IAnnotationModelFactory factory = this.fRegistry.getAnnotationModelFactory(location);
        if (factory != null) {
            return factory.createAnnotationModel(location);
        }
        return null;
    }

    public void addFileBufferListener(IFileBufferListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.fFileBufferListeners.contains(listener)) {
            this.fFileBufferListeners.add(listener);
        }
    }

    public void removeFileBufferListener(IFileBufferListener listener) {
        Assert.isNotNull((Object)listener);
        this.fFileBufferListeners.remove(listener);
    }

    public void setSynchronizationContext(ISynchronizationContext context) {
        this.fSynchronizationContext = context;
    }

    public void requestSynchronizationContext(IPath location) {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = (AbstractFileBuffer)this.fFilesBuffers.get(location);
        if (fileBuffer != null) {
            fileBuffer.requestSynchronizationContext();
        }
    }

    public void releaseSynchronizationContext(IPath location) {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = (AbstractFileBuffer)this.fFilesBuffers.get(location);
        if (fileBuffer != null) {
            fileBuffer.releaseSynchronizationContext();
        }
    }

    public void execute(Runnable runnable, boolean requestSynchronizationContext) {
        if (requestSynchronizationContext && this.fSynchronizationContext != null) {
            this.fSynchronizationContext.run(runnable);
        } else {
            runnable.run();
        }
    }

    private AbstractFileBuffer createFileBuffer(IPath location) {
        if (this.isTextFileLocation(location)) {
            if (FileBuffers.getWorkspaceFileAtLocation(location) != null) {
                return new ResourceTextFileBuffer(this);
            }
            return new JavaTextFileBuffer(this);
        }
        return null;
    }

    protected void fireDirtyStateChanged(final IFileBuffer buffer, final boolean isDirty) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            Platform.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.dirtyStateChanged(buffer, isDirty);
                }
            });
        }
    }

    protected void fireBufferContentAboutToBeReplaced(final IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            Platform.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferContentAboutToBeReplaced(buffer);
                }
            });
        }
    }

    protected void fireBufferContentReplaced(final IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            Platform.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferContentReplaced(buffer);
                }
            });
        }
    }

    protected void fireUnderlyingFileMoved(final IFileBuffer buffer, final IPath target) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            Platform.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.underlyingFileMoved(buffer, target);
                }
            });
        }
    }

    protected void fireUnderlyingFileDeleted(final IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            Platform.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.underlyingFileDeleted(buffer);
                }
            });
        }
    }

    protected void fireStateValidationChanged(final IFileBuffer buffer, final boolean isStateValidated) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            Platform.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.stateValidationChanged(buffer, isStateValidated);
                }
            });
        }
    }

    protected void fireStateChanging(final IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            Platform.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.stateChanging(buffer);
                }
            });
        }
    }

    protected void fireStateChangeFailed(final IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            Platform.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.stateChangeFailed(buffer);
                }
            });
        }
    }

    protected void fireBufferCreated(final IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            Platform.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferCreated(buffer);
                }
            });
        }
    }

    protected void fireBufferDisposed(final IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            Platform.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferDisposed(buffer);
                }
            });
        }
    }

    public void validateState(final IFileBuffer[] fileBuffers, IProgressMonitor monitor, final Object computationContext) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor progressMonitor) throws CoreException {
                IFileBuffer[] toValidate = TextFileBufferManager.this.findFileBuffersToValidate(fileBuffers);
                TextFileBufferManager.this.validationStateAboutToBeChanged(toValidate);
                try {
                    IStatus status = TextFileBufferManager.this.validateEdit(toValidate, computationContext);
                    TextFileBufferManager.this.validationStateChanged(toValidate, true, status);
                }
                catch (RuntimeException runtimeException) {
                    TextFileBufferManager.this.validationStateChangedFailed(toValidate);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, this.computeValidateStateRule(fileBuffers), 1, monitor);
    }

    private IFileBuffer[] findFileBuffersToValidate(IFileBuffer[] fileBuffers) {
        ArrayList<IFileBuffer> list = new ArrayList<IFileBuffer>();
        int i = 0;
        while (i < fileBuffers.length) {
            if (!fileBuffers[i].isStateValidated()) {
                list.add(fileBuffers[i]);
            }
            ++i;
        }
        return list.toArray(new IFileBuffer[list.size()]);
    }

    private void validationStateAboutToBeChanged(IFileBuffer[] fileBuffers) {
        int i = 0;
        while (i < fileBuffers.length) {
            if (fileBuffers[i] instanceof IStateValidationSupport) {
                IStateValidationSupport support = (IStateValidationSupport)((Object)fileBuffers[i]);
                support.validationStateAboutToBeChanged();
            }
            ++i;
        }
    }

    private void validationStateChanged(IFileBuffer[] fileBuffers, boolean validationState, IStatus status) {
        int i = 0;
        while (i < fileBuffers.length) {
            if (fileBuffers[i] instanceof IStateValidationSupport) {
                IStateValidationSupport support = (IStateValidationSupport)((Object)fileBuffers[i]);
                support.validationStateChanged(validationState, status);
            }
            ++i;
        }
    }

    private void validationStateChangedFailed(IFileBuffer[] fileBuffers) {
        int i = 0;
        while (i < fileBuffers.length) {
            if (fileBuffers[i] instanceof IStateValidationSupport) {
                IStateValidationSupport support = (IStateValidationSupport)((Object)fileBuffers[i]);
                support.validationStateChangeFailed();
            }
            ++i;
        }
    }

    private IStatus validateEdit(IFileBuffer[] fileBuffers, Object computationContext) {
        ArrayList<IFile> list = new ArrayList<IFile>();
        int i = 0;
        while (i < fileBuffers.length) {
            IFile file = this.getWorkspaceFile(fileBuffers[i]);
            if (file != null) {
                list.add(file);
            }
            ++i;
        }
        IFile[] files = new IFile[list.size()];
        list.toArray(files);
        return ResourcesPlugin.getWorkspace().validateEdit(files, computationContext);
    }

    private ISchedulingRule computeValidateStateRule(IFileBuffer[] fileBuffers) {
        ArrayList<IFile> list = new ArrayList<IFile>();
        int i = 0;
        while (i < fileBuffers.length) {
            IFile resource = this.getWorkspaceFile(fileBuffers[i]);
            if (resource != null) {
                list.add(resource);
            }
            ++i;
        }
        IResource[] resources = new IResource[list.size()];
        list.toArray(resources);
        IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
        return factory.validateEditRule(resources);
    }

    private IFile getWorkspaceFile(IFileBuffer fileBuffer) {
        return FileBuffers.getWorkspaceFileAtLocation(fileBuffer.getLocation());
    }

    private String getLineDelimiterPreference(IPath location) {
        IScopeContext[] scopeContext;
        IFile file = FileBuffers.getWorkspaceFileAtLocation(location);
        if (file != null && file.getProject() != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(file.getProject())};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
    }

    private static abstract class SafeNotifier
    implements ISafeRunnable {
        SafeNotifier() {
        }

        public void handleException(Throwable ex) {
            Status status = new Status(4, "org.eclipse.core.filebuffers", 0, "TextFileBufferManager failed to notify an ITextFileBufferListener", ex);
            FileBuffersPlugin.getDefault().getLog().log((IStatus)status);
        }
    }
}

