/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;

public class GenerateDiffFileOperation
implements IRunnableWithProgress {
    private File outputFile;
    private IResource resource;
    private Shell shell;
    private Command.LocalOption[] options;

    GenerateDiffFileOperation(IResource resource, File file, Command.LocalOption[] options, Shell shell) {
        this.resource = resource;
        this.outputFile = file;
        this.shell = shell;
        this.options = options;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.resource.getProject(), (String)CVSProviderPlugin.getTypeId());
        monitor.beginTask("", 500);
        monitor.setTaskName(CVSUIMessages.GenerateCVSDiff_working);
        try {
            try {
                if (this.outputFile != null) {
                    this.generateDiffToFile(monitor, provider, this.outputFile);
                } else {
                    this.generateDiffToClipboard(monitor, provider);
                }
            }
            catch (TeamException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateDiffToFile(IProgressMonitor monitor, CVSTeamProvider provider, File file) throws TeamException {
        try {
            FileOutputStream os = new FileOutputStream(file);
            try {
                provider.diff(this.resource, this.options, new PrintStream(os), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                os.close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                os.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new TeamException(CVSUIMessages.GenerateDiffFileOperation_0, (Throwable)e);
        }
        catch (IOException e) {
            throw new TeamException(CVSUIMessages.GenerateDiffFileOperation_1, (Throwable)e);
        }
        if (file.length() == 0L) {
            this.outputFile.delete();
            this.reportEmptyDiff();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateDiffToClipboard(IProgressMonitor monitor, CVSTeamProvider provider) throws TeamException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            try {
                provider.diff(this.resource, this.options, new PrintStream(os), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                os.close();
                throw throwable;
            }
            {
                Object var4_6 = null;
                os.close();
            }
        }
        catch (IOException e) {
            throw new TeamException(CVSUIMessages.GenerateDiffFileOperation_2, (Throwable)e);
        }
        if (os.size() == 0) {
            this.reportEmptyDiff();
            return;
        }
        this.copyToClipboard(os);
    }

    private void copyToClipboard(final ByteArrayOutputStream baos) {
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                Clipboard clipboard = new Clipboard(GenerateDiffFileOperation.this.shell.getDisplay());
                clipboard.setContents((Object[])new String[]{baos.toString()}, new Transfer[]{plainTextTransfer});
                clipboard.dispose();
            }
        });
    }

    private void reportEmptyDiff() {
        CVSUIPlugin.openDialog(this.shell, new CVSUIPlugin.IOpenableInShell(){

            public void open(Shell shell) {
                MessageDialog.openInformation((Shell)shell, (String)CVSUIMessages.GenerateCVSDiff_noDiffsFoundTitle, (String)CVSUIMessages.GenerateCVSDiff_noDiffsFoundMsg);
            }
        }, 1);
    }
}

