/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;

public class ShareProjectOperation
extends CVSOperation {
    private ICVSRepositoryLocation location;
    private IProject project;
    private String moduleName;
    private Shell shell;

    public ShareProjectOperation(Shell shell, ICVSRepositoryLocation location, IProject project, String moduleName) {
        super(null);
        this.shell = shell;
        this.moduleName = moduleName;
        this.project = project;
        this.location = location;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        try {
            try {
                monitor.beginTask(this.getTaskName(), 100);
                final ICVSRemoteFolder remote = this.createRemoteFolder(Policy.subMonitorFor(monitor, 50));
                final TeamException[] exception = new TeamException[1];
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            ShareProjectOperation.this.mapProjectToRemoteFolder(remote, monitor);
                        }
                        catch (TeamException e) {
                            exception[0] = e;
                        }
                    }
                }, ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)this.project), 0, Policy.subMonitorFor(monitor, 100));
                if (exception[0] != null) {
                    throw exception[0];
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ICVSRemoteFolder createRemoteFolder(IProgressMonitor monitor) throws CVSException {
        ICVSRemoteFolder iCVSRemoteFolder;
        String projectName = this.project.getName();
        if (this.moduleName == null) {
            this.moduleName = projectName;
        }
        RemoteFolderTree root = new RemoteFolderTree(null, this.location, Path.EMPTY.toString(), null);
        Path path = new Path(null, this.moduleName);
        try {
            try {
                monitor.beginTask(this.getTaskName(), 100 * path.segmentCount());
                iCVSRemoteFolder = this.ensureTreeExists(root, (IPath)path, monitor);
                Object var6_6 = null;
            }
            catch (TeamException e) {
                throw CVSException.wrapException((CoreException)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return iCVSRemoteFolder;
    }

    protected void mapProjectToRemoteFolder(ICVSRemoteFolder remote, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, -1);
        this.purgeAnyCVSFolders(Policy.subMonitorFor(monitor, -1));
        monitor.subTask(NLS.bind((String)CVSUIMessages.ShareProjectOperation_3, (Object[])new String[]{this.project.getName(), remote.getRepositoryRelativePath()}));
        ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)this.project);
        folder.setFolderSyncInfo(remote.getFolderSyncInfo());
        RepositoryProvider.map((IProject)this.project, (String)CVSProviderPlugin.getTypeId());
        monitor.done();
    }

    private RemoteFolderTree createChild(RemoteFolderTree parent, String name, IProgressMonitor monitor) throws CVSException, TeamException {
        RemoteFolderTree child = new RemoteFolderTree((RemoteFolder)parent, name, this.location, new Path(null, parent.getRepositoryRelativePath()).append(name).toString(), null);
        parent.setChildren(new ICVSRemoteResource[]{child});
        if (child.exists(Policy.subMonitorFor(monitor, 50))) {
            return (RemoteFolderTree)parent.getFolder(name);
        }
        this.createFolder(child, Policy.subMonitorFor(monitor, 50));
        return child;
    }

    private ICVSRemoteFolder ensureTreeExists(RemoteFolderTree folder, IPath path, IProgressMonitor monitor) throws TeamException {
        if (path.isEmpty()) {
            return folder;
        }
        String name = path.segment(0);
        RemoteFolderTree child = this.createChild(folder, name, monitor);
        return this.ensureTreeExists(child, path.removeFirstSegments(1), monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createFolder(RemoteFolderTree folder, IProgressMonitor monitor) throws TeamException {
        Session s = new Session(this.location, folder.getParent());
        s.open(monitor, true);
        try {
            IStatus status = Command.ADD.execute(s, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, new String[]{folder.getName()}, null, monitor);
            if (status.getCode() == -10) throw new CVSServerException(status);
            if (!status.isOK()) {
                throw new CVSServerException(status);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            s.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        s.close();
    }

    protected String getTaskName() {
        return NLS.bind((String)CVSUIMessages.ShareProjectOperation_0, (Object[])new String[]{this.project.getName(), this.moduleName});
    }

    public IProject getProject() {
        return this.project;
    }

    protected Shell getShell() {
        return this.shell;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void purgeAnyCVSFolders(final IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask(null, -1);
                ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.project);
                folder.accept(new ICVSResourceVisitor(){

                    public void visitFile(ICVSFile file) throws CVSException {
                    }

                    public void visitFolder(ICVSFolder folder) throws CVSException {
                        monitor.subTask(NLS.bind((String)CVSUIMessages.ShareProjectOperation_2, (Object[])new String[]{folder.getIResource().getFullPath().toString()}));
                        if (folder.isCVSFolder()) {
                            folder.unmanage(null);
                        }
                    }
                }, true);
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        monitor.done();
    }
}

