/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.internal.resources.mapping.ResourceMappingContext;
import org.eclipse.core.internal.resources.mapping.ResourceTraversal;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.Policy;

public class SubscriberResourceMappingContext
extends RemoteResourceMappingContext {
    private final Subscriber subscriber;
    private final SyncInfoFilter contentDiffFilter;
    Set shallowRefresh = new HashSet();
    Set deepRefresh = new HashSet();

    public static ResourceMappingContext getReplaceContext(Subscriber subscriber) {
        return new SubscriberResourceMappingContext(subscriber, new SyncInfoFilter(){

            public boolean select(SyncInfo info, IProgressMonitor monitor) {
                if (info != null) {
                    int direction = info.getKind() & 0xC;
                    return direction != 0;
                }
                return false;
            }
        });
    }

    public static ResourceMappingContext getUpdateContext(Subscriber subscriber) {
        return new SubscriberResourceMappingContext(subscriber, new SyncInfoFilter(){

            public boolean select(SyncInfo info, IProgressMonitor monitor) {
                if (info != null) {
                    int direction = info.getKind() & 0xC;
                    return direction == 8 || direction == 12;
                }
                return false;
            }
        });
    }

    public static ResourceMappingContext getCheckInContext(Subscriber subscriber) {
        return new SubscriberResourceMappingContext(subscriber, new SyncInfoFilter(){

            public boolean select(SyncInfo info, IProgressMonitor monitor) {
                if (info != null) {
                    int direction = info.getKind() & 0xC;
                    return direction == 4 || direction == 12;
                }
                return false;
            }
        });
    }

    public static ResourceMappingContext getCompareContext(Subscriber subscriber) {
        return new SubscriberResourceMappingContext(subscriber, new SyncInfoFilter(){

            public boolean select(SyncInfo info, IProgressMonitor monitor) {
                if (info != null) {
                    return info.getKind() != 0;
                }
                return false;
            }
        });
    }

    public SubscriberResourceMappingContext(Subscriber subscriber, SyncInfoFilter contentDiffFilter) {
        this.subscriber = subscriber;
        this.contentDiffFilter = contentDiffFilter;
    }

    public final boolean contentDiffers(IFile file, IProgressMonitor monitor) throws CoreException {
        boolean bl;
        try {
            monitor.beginTask(null, 100);
            this.ensureRefreshed((IResource)file, 0, 0, Policy.subMonitorFor(monitor, 10));
            SyncInfo syncInfo = this.subscriber.getSyncInfo((IResource)file);
            this.validateRemote((IResource)file, syncInfo);
            bl = syncInfo != null && this.contentDiffFilter.select(syncInfo, Policy.subMonitorFor(monitor, 90));
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return bl;
    }

    public final IStorage fetchContents(IFile file, IProgressMonitor monitor) throws CoreException {
        IResourceVariant remote;
        block3: {
            IStorage iStorage;
            try {
                monitor.beginTask(null, 100);
                this.ensureRefreshed((IResource)file, 0, 1, Policy.subMonitorFor(monitor, 10));
                SyncInfo syncInfo = this.subscriber.getSyncInfo((IResource)file);
                remote = this.validateRemote((IResource)file, syncInfo);
                if (remote != null) break block3;
                iStorage = null;
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return iStorage;
        }
        IStorage iStorage = remote.getStorage(Policy.subMonitorFor(monitor, 90));
        Object var5_8 = null;
        monitor.done();
        return iStorage;
    }

    public final IResource[] fetchMembers(IContainer container, IProgressMonitor monitor) throws CoreException {
        block3: {
            IResource[] iResourceArray;
            try {
                monitor.beginTask(null, 100);
                this.ensureRefreshed((IResource)container, 1, 0, Policy.subMonitorFor(monitor, 100));
                SyncInfo syncInfo = this.subscriber.getSyncInfo((IResource)container);
                if (this.validateRemote((IResource)container, syncInfo) != null) break block3;
                iResourceArray = null;
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return iResourceArray;
        }
        IResource[] iResourceArray = this.subscriber.members((IResource)container);
        Object var4_7 = null;
        monitor.done();
        return iResourceArray;
    }

    public final void refresh(ResourceTraversal[] traversals, int flags, IProgressMonitor monitor) throws CoreException {
        HashSet<IResource> zero = new HashSet<IResource>();
        HashSet<IResource> one = new HashSet<IResource>();
        HashSet<IResource> infinite = new HashSet<IResource>();
        int i = 0;
        while (i < traversals.length) {
            ResourceTraversal traversal = traversals[i];
            switch (traversal.getDepth()) {
                case 2: {
                    infinite.addAll(Arrays.asList(traversal.getResources()));
                    break;
                }
                case 1: {
                    one.addAll(Arrays.asList(traversal.getResources()));
                    break;
                }
                case 0: {
                    zero.addAll(Arrays.asList(traversal.getResources()));
                }
            }
            ++i;
        }
        if (!zero.isEmpty()) {
            this.refresh(zero.toArray(new IResource[zero.size()]), 0, flags, monitor);
        }
        if (!one.isEmpty()) {
            this.refresh(one.toArray(new IResource[one.size()]), 1, flags, monitor);
        }
        if (!infinite.isEmpty()) {
            this.refresh(infinite.toArray(new IResource[infinite.size()]), 2, flags, monitor);
        }
    }

    protected void refresh(IResource[] resources, int depth, int flags, IProgressMonitor monitor) throws TeamException {
        this.subscriber.refresh(resources, depth, monitor);
        this.refreshed(resources, depth);
    }

    protected final void refreshed(IResource[] resources, int depth) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (depth == 1 || resource.getType() == 1) {
                this.shallowRefresh.add(resource);
            } else if (depth == 2) {
                this.deepRefresh.add(resource);
            }
            ++i;
        }
    }

    private void ensureRefreshed(IResource resource, int depth, int flags, IProgressMonitor monitor) throws TeamException {
        if (depth == 2) {
            if (this.wasRefreshedDeeply(resource)) {
                return;
            }
            if (resource.getType() == 1 && this.wasRefreshedShallow(resource)) {
                return;
            }
        } else if (this.wasRefreshedShallow(resource)) {
            return;
        }
        this.refresh(new IResource[]{resource}, depth, flags, monitor);
    }

    private boolean wasRefreshedShallow(IResource resource) {
        if (this.shallowRefresh.contains(resource)) {
            return true;
        }
        if (resource.getType() == 1 && this.shallowRefresh.contains(resource.getParent())) {
            return true;
        }
        return this.wasRefreshedDeeply(resource);
    }

    private boolean wasRefreshedDeeply(IResource resource) {
        if (resource.getType() == 8) {
            return false;
        }
        if (this.deepRefresh.contains(resource)) {
            return true;
        }
        return this.wasRefreshedDeeply((IResource)resource.getParent());
    }

    private IResourceVariant validateRemote(IResource resource, SyncInfo syncInfo) throws CoreException {
        boolean containerExpected;
        if (syncInfo == null) {
            return null;
        }
        IResourceVariant remote = syncInfo.getRemote();
        if (remote == null) {
            return null;
        }
        boolean bl = containerExpected = resource.getType() != 1;
        if (remote.isContainer() && !containerExpected) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.team.core", 366, String.valueOf(Messages.SubscriberResourceMappingContext_0) + resource.getFullPath().toString(), null));
        }
        if (!remote.isContainer() && containerExpected) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.team.core", 366, String.valueOf(Messages.SubscriberResourceMappingContext_1) + resource.getFullPath().toString(), null));
        }
        return remote;
    }
}

