/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.internal.ui.actions.JDTQuickMenuAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.actions.FindExceptionOccurrencesAction;
import org.eclipse.jdt.ui.actions.FindImplementOccurrencesAction;
import org.eclipse.jdt.ui.actions.FindOccurrencesInFileAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPageSite;

public class OccurrencesSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_occurrences;
    private Action fNoActionAvailable = new NoActionAvailable();
    private QuickAccessAction fQuickAccessAction;
    private IKeyBindingService fKeyBindingService;
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindOccurrencesInFileAction fOccurrencesInFileAction;
    private FindExceptionOccurrencesAction fExceptionOccurrencesAction;
    private FindImplementOccurrencesAction fFindImplementorOccurrencesAction;

    public OccurrencesSearchGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(site);
        this.fOccurrencesInFileAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file");
        this.fOccurrencesInFileAction.setText(SearchMessages.Search_FindOccurrencesInFile_shortLabel);
        this.fExceptionOccurrencesAction = new FindExceptionOccurrencesAction(site);
        this.fExceptionOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.exception.occurrences");
        this.fFindImplementorOccurrencesAction = new FindImplementOccurrencesAction(site);
        this.fFindImplementorOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.implement.occurrences");
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.fOccurrencesInFileAction, provider, selection);
        this.registerAction(this.fExceptionOccurrencesAction, provider, selection);
        this.registerAction(this.fFindImplementorOccurrencesAction, provider, selection);
        if (site instanceof IWorkbenchPartSite) {
            this.fQuickAccessAction = new QuickAccessAction(null);
            this.fKeyBindingService = ((IWorkbenchPartSite)site).getKeyBindingService();
            this.fKeyBindingService.registerAction((IAction)this.fQuickAccessAction);
        } else {
            boolean cfr_ignored_0 = site instanceof IPageSite;
        }
    }

    public OccurrencesSearchGroup(JavaEditor editor) {
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(this.fEditor);
        this.fOccurrencesInFileAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file");
        this.fOccurrencesInFileAction.setText(SearchMessages.Search_FindOccurrencesInFile_shortLabel);
        this.fEditor.setAction("SearchOccurrencesInFile", (IAction)this.fOccurrencesInFileAction);
        this.fExceptionOccurrencesAction = new FindExceptionOccurrencesAction(this.fEditor);
        this.fExceptionOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.exception.occurrences");
        this.fEditor.setAction("SearchExceptionOccurrences", (IAction)this.fExceptionOccurrencesAction);
        this.fFindImplementorOccurrencesAction = new FindImplementOccurrencesAction(this.fEditor);
        this.fFindImplementorOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.implement.occurrences");
        this.fEditor.setAction("SearchImplementOccurrences", (IAction)this.fFindImplementorOccurrencesAction);
        this.fQuickAccessAction = new QuickAccessAction(editor);
        this.fKeyBindingService = editor.getEditorSite().getKeyBindingService();
        this.fKeyBindingService.registerAction((IAction)this.fQuickAccessAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    private IAction[] getActions(ISelection sel) {
        IAction[] actions = new IAction[]{this.fOccurrencesInFileAction, this.fExceptionOccurrencesAction, this.fFindImplementorOccurrencesAction};
        return actions;
    }

    public void fillContextMenu(IMenuManager manager) {
        String menuText = MENU_TEXT;
        if (this.fQuickAccessAction != null) {
            menuText = this.fQuickAccessAction.addShortcut(menuText);
        }
        MenuManager javaSearchMM = new MenuManager(menuText, "group.search");
        IAction[] actions = this.getActions(this.getContext().getSelection());
        int i = 0;
        while (i < actions.length) {
            IAction action = actions[i];
            if (action.isEnabled()) {
                javaSearchMM.add(action);
            }
            ++i;
        }
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    private void fillQuickMenu(IMenuManager manager) {
        ISelection sel = null;
        ActionContext context = this.getContext();
        sel = context != null ? context.getSelection() : (this.fEditor != null ? this.fEditor.getSelectionProvider().getSelection() : this.fSite.getSelectionProvider().getSelection());
        IAction[] actions = this.getActions(sel);
        int i = 0;
        while (i < actions.length) {
            IAction action = actions[i];
            if (action.isEnabled()) {
                manager.add(action);
            }
            ++i;
        }
        if (manager.isEmpty()) {
            manager.add((IAction)this.fNoActionAvailable);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindImplementorOccurrencesAction, provider);
            this.disposeAction(this.fExceptionOccurrencesAction, provider);
            this.disposeAction(this.fOccurrencesInFileAction, provider);
        }
        super.dispose();
        this.fFindImplementorOccurrencesAction = null;
        this.fExceptionOccurrencesAction = null;
        this.fOccurrencesInFileAction = null;
        this.updateGlobalActionHandlers();
        if (this.fQuickAccessAction != null && this.fKeyBindingService != null) {
            this.fKeyBindingService.unregisterAction((IAction)this.fQuickAccessAction);
        }
        this.fKeyBindingService = null;
        this.fQuickAccessAction = null;
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OccurrencesInFile", (IAction)this.fOccurrencesInFileAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ExceptionOccurrences", (IAction)this.fExceptionOccurrencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ImplementOccurrences", (IAction)this.fFindImplementorOccurrencesAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private class QuickAccessAction
    extends JDTQuickMenuAction {
        public QuickAccessAction(JavaEditor editor) {
            super(editor, "org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file.quickMenu");
        }

        protected void fillMenu(IMenuManager menu) {
            OccurrencesSearchGroup.this.fillQuickMenu(menu);
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(false);
            this.setText(SearchMessages.group_occurrences_quickMenu_noEntriesAvailable);
        }
    }
}

