/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchPage;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.actions.FindReferencesAction;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class FindReferencesInWorkingSetAction
extends FindReferencesAction {
    private IWorkingSet[] fWorkingSets;

    public FindReferencesInWorkingSetAction(IWorkbenchSite site) {
        this(site, null);
    }

    public FindReferencesInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        super(site);
        this.fWorkingSets = workingSets;
    }

    public FindReferencesInWorkingSetAction(JavaEditor editor) {
        this(editor, null);
    }

    public FindReferencesInWorkingSetAction(JavaEditor editor, IWorkingSet[] workingSets) {
        super(editor);
        this.fWorkingSets = workingSets;
    }

    void init() {
        this.setText(SearchMessages.Search_FindReferencesInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindReferencesInWorkingSetAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_REF);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.find_references_in_working_set_action");
    }

    protected JavaSearchQuery createJob(IJavaElement element) throws JavaModelException {
        IWorkingSet[] workingSets = this.fWorkingSets;
        if (this.fWorkingSets == null && (workingSets = JavaSearchScopeFactory.getInstance().queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        return new JavaSearchQuery(new ElementQuerySpecification(element, this.getLimitTo(), this.getScope(workingSets), this.getScopeDescription(workingSets)));
    }

    private IJavaSearchScope getScope(IWorkingSet[] workingSets) {
        return JavaSearchScopeFactory.getInstance().createJavaSearchScope(workingSets, JavaSearchPage.getSearchJRE());
    }

    private String getScopeDescription(IWorkingSet[] workingSets) {
        return Messages.format(SearchMessages.WorkingSetScope, new String[]{SearchUtil.toString(workingSets)});
    }
}

