/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import java.text.Collator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaElementSorter
extends ViewerSorter {
    private static final int PROJECTS = 1;
    private static final int PACKAGEFRAGMENTROOTS = 2;
    private static final int PACKAGEFRAGMENT = 3;
    private static final int COMPILATIONUNITS = 4;
    private static final int CLASSFILES = 5;
    private static final int RESOURCEFOLDERS = 7;
    private static final int RESOURCES = 8;
    private static final int STORAGE = 9;
    private static final int PACKAGE_DECL = 10;
    private static final int IMPORT_CONTAINER = 11;
    private static final int IMPORT_DECLARATION = 12;
    private static final int MEMBERSOFFSET = 15;
    private static final int JAVAELEMENTS = 50;
    private static final int OTHERS = 51;
    private MembersOrderPreferenceCache fMemberOrderCache = JavaPlugin.getDefault().getMemberOrderPreferenceCache();
    static /* synthetic */ Class class$0;

    public JavaElementSorter() {
        super(null);
    }

    public boolean isSorterProperty(Object element, Object property) {
        return true;
    }

    public int category(Object element) {
        if (element instanceof IJavaElement) {
            block27: {
                try {
                    IJavaElement je = (IJavaElement)element;
                    switch (je.getElementType()) {
                        case 9: {
                            IMethod method = (IMethod)je;
                            if (method.isConstructor()) {
                                return this.getMemberCategory(1);
                            }
                            int flags = method.getFlags();
                            if (Flags.isStatic((int)flags)) {
                                return this.getMemberCategory(7);
                            }
                            return this.getMemberCategory(2);
                        }
                        case 8: {
                            int flags = ((IField)je).getFlags();
                            if (Flags.isEnum((int)flags)) {
                                return this.getMemberCategory(8);
                            }
                            if (Flags.isStatic((int)flags)) {
                                return this.getMemberCategory(5);
                            }
                            return this.getMemberCategory(3);
                        }
                        case 10: {
                            int flags = ((IInitializer)je).getFlags();
                            if (Flags.isStatic((int)flags)) {
                                return this.getMemberCategory(6);
                            }
                            return this.getMemberCategory(4);
                        }
                        case 7: {
                            return this.getMemberCategory(0);
                        }
                        case 11: {
                            return 10;
                        }
                        case 12: {
                            return 11;
                        }
                        case 13: {
                            return 12;
                        }
                        case 4: {
                            return 3;
                        }
                        case 3: {
                            return 2;
                        }
                        case 2: {
                            return 1;
                        }
                        case 6: {
                            return 5;
                        }
                        case 5: {
                            return 4;
                        }
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block27;
                    JavaPlugin.log(e);
                }
            }
            return 50;
        }
        if (element instanceof IFile) {
            return 8;
        }
        if (element instanceof IProject) {
            return 1;
        }
        if (element instanceof IContainer) {
            return 7;
        }
        if (element instanceof IStorage) {
            return 9;
        }
        if (element instanceof ClassPathContainer) {
            return 2;
        }
        return 51;
    }

    private int getMemberCategory(int kind) {
        int offset = this.fMemberOrderCache.getCategoryIndex(kind);
        return offset + 15;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cmp;
        String name2;
        String name1;
        int cat2;
        int cat1 = this.category(e1);
        if (this.needsClasspathComparision(e1, cat1, e2, cat2 = this.category(e2))) {
            int p2;
            int p1;
            IPackageFragmentRoot root1 = this.getPackageFragmentRoot(e1);
            IPackageFragmentRoot root2 = this.getPackageFragmentRoot(e2);
            if (root1 == null) {
                if (root2 == null) {
                    return 0;
                }
                return 1;
            }
            if (root2 == null) {
                return -1;
            }
            if (!root1.getPath().equals((Object)root2.getPath()) && (p1 = this.getClassPathIndex(root1)) != (p2 = this.getClassPathIndex(root2))) {
                return p1 - p2;
            }
        }
        if (cat1 != cat2) {
            return cat1 - cat2;
        }
        if (cat1 == 1 || cat1 == 8 || cat1 == 7 || cat1 == 9 || cat1 == 51) {
            name1 = this.getNonJavaElementLabel(viewer, e1);
            name2 = this.getNonJavaElementLabel(viewer, e2);
            if (name1 != null && name2 != null) {
                return this.getCollator().compare(name1, name2);
            }
            return 0;
        }
        if (e1 instanceof IMember && this.fMemberOrderCache.isSortByVisibility()) {
            try {
                int flags1 = JdtFlags.getVisibilityCode((IMember)e1);
                int flags2 = JdtFlags.getVisibilityCode((IMember)e2);
                int vis = this.fMemberOrderCache.getVisibilityIndex(flags1) - this.fMemberOrderCache.getVisibilityIndex(flags2);
                if (vis != 0) {
                    return vis;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        name1 = this.getElementName(e1);
        name2 = this.getElementName(e2);
        if (e1 instanceof IType) {
            if (name1.length() == 0) {
                if (name2.length() == 0) {
                    try {
                        return this.getCollator().compare(((IType)e1).getSuperclassName(), ((IType)e2).getSuperclassName());
                    }
                    catch (JavaModelException javaModelException) {
                        return 0;
                    }
                }
                return 1;
            }
            if (name2.length() == 0) {
                return -1;
            }
        }
        if ((cmp = this.getCollator().compare(name1, name2)) != 0) {
            return cmp;
        }
        if (e1 instanceof IMethod) {
            String[] params1 = ((IMethod)e1).getParameterTypes();
            String[] params2 = ((IMethod)e2).getParameterTypes();
            int len = Math.min(params1.length, params2.length);
            int i = 0;
            while (i < len) {
                cmp = this.getCollator().compare(Signature.toString((String)params1[i]), Signature.toString((String)params2[i]));
                if (cmp != 0) {
                    return cmp;
                }
                ++i;
            }
            return params1.length - params2.length;
        }
        return 0;
    }

    private IPackageFragmentRoot getPackageFragmentRoot(Object element) {
        if (element instanceof ClassPathContainer) {
            ClassPathContainer cp = (ClassPathContainer)element;
            Object[] roots = cp.getPackageFragmentRoots();
            if (roots.length > 0) {
                return (IPackageFragmentRoot)roots[0];
            }
            return null;
        }
        return JavaModelUtil.getPackageFragmentRoot((IJavaElement)element);
    }

    private String getNonJavaElementLabel(Viewer viewer, Object element) {
        IBaseLabelProvider prov;
        if (element instanceof IAdaptable) {
            IWorkbenchAdapter adapter;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return adapter.getLabel(element);
            }
        }
        if (viewer instanceof ContentViewer && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            return ((ILabelProvider)prov).getText(element);
        }
        return null;
    }

    private int getClassPathIndex(IPackageFragmentRoot root) {
        try {
            IPath rootPath = root.getPath();
            IPackageFragmentRoot[] roots = root.getJavaProject().getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getPath().equals((Object)rootPath)) {
                    return i;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return Integer.MAX_VALUE;
    }

    public final Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        return this.collator;
    }

    private boolean needsClasspathComparision(Object e1, int cat1, Object e2, int cat2) {
        if (cat1 == 2 && cat2 == 2 || cat1 == 3 && ((IPackageFragment)e1).getParent().getResource() instanceof IProject && cat2 == 2 || cat1 == 2 && cat2 == 3 && ((IPackageFragment)e2).getParent().getResource() instanceof IProject) {
            IJavaProject p1 = this.getJavaProject(e1);
            return p1 != null && p1.equals(this.getJavaProject(e2));
        }
        return false;
    }

    private IJavaProject getJavaProject(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getJavaProject();
        }
        if (element instanceof ClassPathContainer) {
            return ((ClassPathContainer)element).getJavaProject();
        }
        return null;
    }

    private String getElementName(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getElementName();
        }
        if (element instanceof ClassPathContainer) {
            return ((ClassPathContainer)element).getLabel(element);
        }
        return element.toString();
    }
}

