/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;

public class ExtendedNewFolderDialog
extends SelectionStatusDialog {
    private FolderNameField fFolderNameField;
    protected FolderTypeGroup fFolderTypeGroup;
    protected DependenciesGroup fDependenciesGroup;
    private boolean fJavaProjectSelected;
    private IContainer container;

    public ExtendedNewFolderDialog(Shell parentShell, IContainer container, boolean javaProjectSelected) {
        super(parentShell);
        this.container = container;
        this.fJavaProjectSelected = javaProjectSelected;
        this.setTitle(NewWizardMessages.NewFolderDialog_title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setStatusLineAboveButtons(true);
    }

    protected void computeResult() {
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(Messages.format(NewWizardMessages.NewFolderDialog_createIn, this.container.getFullPath().toString()));
        this.fFolderNameField = new FolderNameField(composite);
        this.fFolderTypeGroup = new FolderTypeGroup(composite);
        this.fDependenciesGroup = new DependenciesGroup(composite);
        Validator validator = new Validator();
        this.fDependenciesGroup.addObserver(validator);
        this.fFolderNameField.addObserver(validator);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private IFolder createFolderHandle(String folderName) {
        IWorkspaceRoot workspaceRoot = this.container.getWorkspace().getRoot();
        IPath folderPath = this.container.getFullPath().append(folderName);
        IFolder folderHandle = workspaceRoot.getFolder(folderPath);
        return folderHandle;
    }

    private IFolder createNewFolder(final String folderName, String linkTargetName) {
        final IFolder folderHandle = this.createFolderHandle(folderName);
        final boolean copyFromFolder = this.fDependenciesGroup.copyTargetSelected();
        final boolean linkToFolder = this.fDependenciesGroup.linkTargetSelected();
        final CopyFolder copyFactory = new CopyFolder();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    try {
                        monitor.beginTask(NewWizardMessages.NewFolderDialog_progress, 2000);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (copyFromFolder) {
                            folderHandle.create(false, true, monitor);
                            copyFactory.copy(ExtendedNewFolderDialog.this.fDependenciesGroup.getCopyTarget(), String.valueOf(ExtendedNewFolderDialog.this.container.getLocation().toOSString()) + "\\" + folderName, ExtendedNewFolderDialog.this.container.getWorkspace().getRoot(), String.valueOf(folderName) + "/");
                        } else if (linkToFolder) {
                            folderHandle.createLink((IPath)new Path(ExtendedNewFolderDialog.this.fDependenciesGroup.getLinkTarget()), 16, monitor);
                        } else {
                            folderHandle.create(false, true, monitor);
                        }
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException exception) {
            if (exception.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.NewFolderDialog_errorTitle, null, (IStatus)((CoreException)exception.getTargetException()).getStatus());
            } else {
                JavaPlugin.log(new Exception(MessageFormat.format("Exception in {0}.createNewFolder(): {1}", ((Object)((Object)this)).getClass().getName(), exception.getTargetException())));
                MessageDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.NewFolderDialog_errorTitle, (String)Messages.format(NewWizardMessages.NewFolderDialog_internalError, new Object[]{exception.getTargetException().getMessage()}));
            }
            return null;
        }
        return folderHandle;
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
    }

    private void updateStatus(int severity, String message) {
        this.updateStatus((IStatus)new Status(severity, JavaPlugin.getPluginId(), severity, message, null));
    }

    protected void okPressed() {
        String linkTarget = this.fDependenciesGroup.getLinkTarget();
        linkTarget = linkTarget.equals("") ? null : linkTarget;
        IFolder folder = this.createNewFolder(this.fFolderNameField.getText(), linkTarget);
        if (folder == null) {
            return;
        }
        Boolean isSourceFolderType = new Boolean(this.fFolderTypeGroup.isSourceFolderType());
        this.setSelectionResult(new Object[]{folder, isSourceFolderType});
        super.okPressed();
    }

    public IFolder getCreatedFolder() {
        Object[] result = this.getResult();
        if (result != null && result.length == 2) {
            return (IFolder)result[0];
        }
        return null;
    }

    public boolean isSourceFolder() {
        Object[] result = this.getResult();
        if (result != null && result.length == 2) {
            return (Boolean)result[1];
        }
        return false;
    }

    private final class FolderNameField
    extends Observable
    implements IDialogFieldListener {
        private StringDialogField fNameDialogField;

        public FolderNameField(Composite parent) {
            this.createControls(parent);
        }

        private void createControls(Composite parent) {
            Composite folderGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            folderGroup.setLayout((Layout)layout);
            GridData gridData = new GridData(768);
            this.fNameDialogField = new StringDialogField();
            this.fNameDialogField.setLabelText(NewWizardMessages.NewFolderDialog_folderNameGroup_label);
            this.fNameDialogField.doFillIntoGrid(folderGroup, layout.numColumns);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
            folderGroup.setLayoutData((Object)gridData);
            this.fNameDialogField.setDialogFieldListener(this);
        }

        public StringDialogField getNameDialogField() {
            return this.fNameDialogField;
        }

        public String getText() {
            return this.fNameDialogField.getText();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    private final class FolderTypeGroup {
        protected Button fSourceFolderRadio;

        public FolderTypeGroup(Composite parent) {
            this.createControls(parent);
        }

        private void createControls(Composite parent) {
            Group group = new Group(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            group.setText(NewWizardMessages.NewFolderDialog_TypeGroup_title);
            this.fSourceFolderRadio = new Button((Composite)group, 16);
            this.fSourceFolderRadio.setText(NewWizardMessages.NewFolderDialog_folderTypeGroup_source_desc);
            this.fSourceFolderRadio.setSelection(true);
            Button normalFolderRadio = new Button((Composite)group, 16);
            normalFolderRadio.setText(NewWizardMessages.NewFolderDialog_folderTypeGroup_normal_desc);
            normalFolderRadio.setSelection(this.fSourceFolderRadio == null);
        }

        public boolean isSourceFolderType() {
            return this.fSourceFolderRadio != null && this.fSourceFolderRadio.getSelection();
        }
    }

    private final class DependenciesGroup
    extends Observable
    implements IStringButtonAdapter,
    IDialogFieldListener {
        protected SelectionButtonDialogField fCopyFromButton;
        protected SelectionButtonDialogField fLinkToButton;
        protected StringButtonDialogField fCopyLocation;
        protected StringButtonDialogField fLinkLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";

        public DependenciesGroup(Composite parent) {
            this.createControls(parent);
        }

        private void createControls(Composite parent) {
            Group group = new Group(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            group.setLayout((Layout)layout);
            GridData gridData = new GridData(768);
            gridData.minimumWidth = 430;
            group.setLayoutData((Object)gridData);
            group.setText(NewWizardMessages.NewFolderDialog_DependencyGroup_title);
            SelectionButtonDialogField noneButton = new SelectionButtonDialogField(16);
            noneButton.setDialogFieldListener(this);
            noneButton.setLabelText(NewWizardMessages.NewFolderDialog_dependenciesGroup_none_desc);
            noneButton.setSelection(true);
            this.fCopyFromButton = new SelectionButtonDialogField(16);
            this.fCopyFromButton.setLabelText(NewWizardMessages.NewFolderDialog_dependenciesGroup_copy_desc);
            this.fCopyLocation = new StringButtonDialogField(this);
            this.fCopyLocation.setLabelText(NewWizardMessages.NewFolderDialog_dependenciesGroup_locationLabel_desc);
            this.fCopyLocation.setButtonLabel(NewWizardMessages.NewFolderDialog_dependenciesGroup_browseButton_desc);
            this.fCopyFromButton.attachDialogField(this.fCopyLocation);
            this.fCopyFromButton.setDialogFieldListener(this);
            this.fCopyLocation.setDialogFieldListener(this);
            this.fLinkToButton = new SelectionButtonDialogField(16);
            this.fLinkToButton.setLabelText(NewWizardMessages.NewFolderDialog_dependenciesGroup_link_desc);
            this.fLinkLocation = new StringButtonDialogField(this);
            this.fLinkLocation.setLabelText(NewWizardMessages.NewFolderDialog_dependenciesGroup_locationLabel_desc);
            this.fLinkLocation.setButtonLabel(NewWizardMessages.NewFolderDialog_dependenciesGroup_browseButton_desc);
            this.fLinkLocation.setDialogFieldListener(this);
            SelectionButtonDialogField variables = new SelectionButtonDialogField(8);
            variables.setLabelText(NewWizardMessages.NewFolderDialog_dependenciesGroup_variables_desc);
            variables.setDialogFieldListener(new IDialogFieldListener(this){
                final /* synthetic */ DependenciesGroup this$1;
                {
                    this.this$1 = dependenciesGroup;
                }

                public void dialogFieldChanged(DialogField field) {
                    DependenciesGroup.access$0(this.this$1);
                }
            });
            this.fLinkToButton.attachDialogFields(new DialogField[]{this.fLinkLocation, variables});
            this.fLinkToButton.setDialogFieldListener(this);
            noneButton.doFillIntoGrid((Composite)group, 4);
            this.fCopyFromButton.doFillIntoGrid((Composite)group, 4);
            this.fCopyLocation.doFillIntoGrid((Composite)group, 3);
            if (!ExtendedNewFolderDialog.this.fJavaProjectSelected) {
                this.fLinkToButton.setLabelText(NewWizardMessages.NewFolderDialog_dependenciesGroup_link_descDisabled);
                this.fLinkToButton.setEnabled(false);
            }
            this.fLinkToButton.doFillIntoGrid((Composite)group, 4);
            this.fLinkLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLinkLocation.getTextControl(null));
            variables.doFillIntoGrid((Composite)group, 1);
            LayoutUtil.setHorizontalGrabbing((Control)this.fCopyLocation.getTextControl(null));
        }

        public String getLinkTarget() {
            return this.fLinkLocation.getText();
        }

        public String getCopyTarget() {
            return this.fCopyLocation.getText();
        }

        public boolean linkTargetSelected() {
            return this.fLinkToButton.isSelected();
        }

        public boolean copyTargetSelected() {
            return this.fCopyFromButton.isSelected();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            StringButtonDialogField selectedField = field == this.fLinkLocation ? this.fLinkLocation : this.fCopyLocation;
            DirectoryDialog dialog = new DirectoryDialog(ExtendedNewFolderDialog.this.getShell());
            dialog.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_directory_message);
            String directoryName = this.getLinkTarget().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(new Path(directoryName).toOSString());
            }
            if ((selectedDirectory = dialog.open()) != null) {
                selectedField.setText(selectedDirectory);
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        private void handleVariablesButtonPressed() {
            String[] variableNames;
            int variableTypes = 2;
            PathVariableSelectionDialog dialog = new PathVariableSelectionDialog(ExtendedNewFolderDialog.this.getShell(), variableTypes);
            if (dialog.open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length == 1) {
                this.fLinkLocation.setText(variableNames[0]);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        static /* synthetic */ void access$0(DependenciesGroup dependenciesGroup) {
            dependenciesGroup.handleVariablesButtonPressed();
        }
    }

    private final class Validator
    implements Observer {
        Validator() {
        }

        public void update(Observable o, Object arg) {
            String name = ExtendedNewFolderDialog.this.fFolderNameField.getText();
            if (!this.validateFolderName(name)) {
                return;
            }
            if (ExtendedNewFolderDialog.this.fDependenciesGroup.linkTargetSelected()) {
                this.validateLinkedResource(ExtendedNewFolderDialog.this.fDependenciesGroup.getLinkTarget());
                return;
            }
            if (ExtendedNewFolderDialog.this.fDependenciesGroup.copyTargetSelected()) {
                this.validateLocation(ExtendedNewFolderDialog.this.fDependenciesGroup.getCopyTarget());
                return;
            }
            ExtendedNewFolderDialog.this.updateStatus(0, "");
        }

        private IStatus validateLinkLocation(IResource linkHandle) {
            Path path;
            IWorkspace workspace = JavaPlugin.getWorkspace();
            IStatus locationStatus = workspace.validateLinkLocation(linkHandle, (IPath)(path = new Path(ExtendedNewFolderDialog.this.fDependenciesGroup.getLinkTarget())));
            if (locationStatus.getMessage().equals(Messages.format(NewWizardMessages.NewFolderDialog_links_parentNotProject, linkHandle.getName())) && ExtendedNewFolderDialog.this.container.getType() == 4) {
                locationStatus = Status.OK_STATUS;
            } else if (locationStatus.getSeverity() == 4) {
                return locationStatus;
            }
            String resolvedLinkTarget = this.resolveVariable();
            path = new Path(resolvedLinkTarget);
            File linkTargetFile = new Path(resolvedLinkTarget).toFile();
            if (linkTargetFile.exists()) {
                IStatus fileTypeStatus = this.validateFileType(linkTargetFile);
                if (!fileTypeStatus.isOK()) {
                    return fileTypeStatus;
                }
            } else if (locationStatus.getSeverity() == 0) {
                return this.createStatus(2, NewWizardMessages.NewFolderDialog_linkTargetNonExistent);
            }
            return locationStatus;
        }

        private IStatus validateFileType(File linkTargetFile) {
            if (!linkTargetFile.isDirectory()) {
                return this.createStatus(4, NewWizardMessages.NewFolderDialog_linkTargetNotFolder);
            }
            return this.createStatus(0, "");
        }

        private IStatus createStatus(int severity, String message) {
            return new Status(severity, JavaPlugin.getPluginId(), severity, message, null);
        }

        private String resolveVariable() {
            IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
            Path path = new Path(ExtendedNewFolderDialog.this.fDependenciesGroup.getLinkTarget());
            IPath resolvedPath = pathVariableManager.resolvePath((IPath)path);
            return resolvedPath.toOSString();
        }

        private void validateLinkedResource(String text) {
            IFolder linkHandle = ExtendedNewFolderDialog.this.createFolderHandle(text);
            IStatus status = this.validateLinkLocation((IResource)linkHandle);
            if (status.getSeverity() != 4) {
                ExtendedNewFolderDialog.this.getOkButton().setEnabled(true);
            } else {
                ExtendedNewFolderDialog.this.getOkButton().setEnabled(false);
            }
            if (!status.isOK()) {
                ExtendedNewFolderDialog.this.updateStatus(status);
            }
        }

        private boolean validateLocation(String text) {
            Path path = new Path(text);
            if (!path.toFile().exists()) {
                ExtendedNewFolderDialog.this.updateStatus(4, Messages.format(NewWizardMessages.NewFolderDialog_notExists, new Object[]{text}));
                return false;
            }
            ExtendedNewFolderDialog.this.updateStatus(0, "");
            return true;
        }

        private boolean validateFolderName(String name) {
            IWorkspace workspace = ExtendedNewFolderDialog.this.container.getWorkspace();
            IStatus nameStatus = workspace.validateName(name, 2);
            if (name.length() == 0) {
                ExtendedNewFolderDialog.this.updateStatus(4, NewWizardMessages.NewFolderDialog_folderNameEmpty);
                return false;
            }
            if (!nameStatus.isOK()) {
                ExtendedNewFolderDialog.this.updateStatus(nameStatus);
                return false;
            }
            Path path = new Path(name);
            if (ExtendedNewFolderDialog.this.container.getFolder((IPath)path).exists() || ExtendedNewFolderDialog.this.container.getFile((IPath)path).exists()) {
                ExtendedNewFolderDialog.this.updateStatus(4, Messages.format(NewWizardMessages.NewFolderDialog_folderNameEmpty_alreadyExists, new Object[]{name}));
                return false;
            }
            ExtendedNewFolderDialog.this.updateStatus(0, "");
            return true;
        }
    }

    private final class CopyFolder {
        CopyFolder() {
        }

        public void copy(String sourceDir, String destDir, IWorkspaceRoot workspaceRoot, String name) throws IOException, StringIndexOutOfBoundsException {
            File source = new File(sourceDir);
            File dest = new File(destDir);
            if (!source.isDirectory() || !source.exists()) {
                throw new IOException();
            }
            if (!dest.exists()) {
                dest.mkdir();
            }
            this.copy(source.getPath(), name, source, workspaceRoot);
        }

        private void copy(String from, String folderName, File source, IWorkspaceRoot workspaceRoot) {
            File[] dir = new File(from).listFiles();
            int i = 0;
            while (i < dir.length) {
                if (dir[i].isDirectory()) {
                    this.createFolder(new Path(dir[i].getPath().substring(source.getPath().length())).makeRelative().toString(), folderName, workspaceRoot);
                    this.copy(dir[i].getPath(), folderName, source, workspaceRoot);
                } else {
                    File fileFrom = new File(dir[i].getPath());
                    try {
                        FileInputStream in = new FileInputStream(fileFrom);
                        this.createFile(new Path(dir[i].getPath().substring(source.getPath().length())).makeRelative().toString(), in, folderName, workspaceRoot);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }

        private void createFolder(String name, String folderName, IWorkspaceRoot workspaceRoot) {
            IPath path = ExtendedNewFolderDialog.this.container.getFullPath().append(String.valueOf(folderName) + name);
            IFolder folderHandle = workspaceRoot.getFolder(path);
            try {
                folderHandle.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }

        private void createFile(String name, FileInputStream stream, String folderName, IWorkspaceRoot workspaceRoot) {
            IPath path = ExtendedNewFolderDialog.this.container.getFullPath().append(String.valueOf(folderName) + name);
            IFile fileHandle = workspaceRoot.getFile(path);
            try {
                fileHandle.create((InputStream)stream, true, null);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }
}

