/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.java.JavaContextType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.text.JavaCodeReader;
import org.eclipse.jdt.internal.ui.text.java.ExperimentalResultCollector;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class JavaCompletionProcessor
implements IContentAssistProcessor {
    private static final String VISIBILITY = "org.eclipse.jdt.core.codeComplete.visibilityCheck";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    protected IWorkingCopyManager fManager;
    private IEditorPart fEditor;
    private IContextInformationValidator fValidator;
    private char[] fProposalAutoActivationSet;
    private CompletionProposalComparator fComparator;
    private TemplateEngine fTemplateEngine;
    private int fNumberOfComputedResults = 0;
    private String fErrorMsg;

    public JavaCompletionProcessor(IEditorPart editor) {
        this.fEditor = editor;
        this.fManager = JavaPlugin.getDefault().getWorkingCopyManager();
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        if (contextType == null) {
            contextType = new JavaContextType();
            JavaPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fComparator = new CompletionProposalComparator();
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public void restrictProposalsToVisibility(boolean restrict) {
        Hashtable options = JavaCore.getOptions();
        Object value = options.get(VISIBILITY);
        if (value instanceof String) {
            String newValue;
            String string = newValue = restrict ? ENABLED : DISABLED;
            if (!newValue.equals(value)) {
                options.put(VISIBILITY, newValue);
                JavaCore.setOptions((Hashtable)options);
            }
        }
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    public String getErrorMessage() {
        if (this.fNumberOfComputedResults == 0 && (this.fErrorMsg == null || this.fErrorMsg.trim().length() == 0)) {
            return JavaUIMessages.JavaEditor_codeassist_noCompletions;
        }
        return this.fErrorMsg;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    private boolean looksLikeMethod(JavaCodeReader reader) throws IOException {
        int curr = reader.read();
        while (curr != -1 && Character.isWhitespace((char)curr)) {
            curr = reader.read();
        }
        if (curr == -1) {
            return false;
        }
        return Character.isJavaIdentifierPart((char)curr) || Character.isJavaIdentifierStart((char)curr);
    }

    private int guessContextInformationPosition(ITextViewer viewer, int offset) {
        int contextPosition = offset;
        IDocument document = viewer.getDocument();
        try {
            JavaCodeReader reader = new JavaCodeReader();
            reader.configureBackwardReader(document, offset, true, true);
            int nestingLevel = 0;
            int curr = reader.read();
            while (curr != -1) {
                if (')' == (char)curr) {
                    ++nestingLevel;
                } else if ('(' == (char)curr && --nestingLevel < 0) {
                    int start = reader.getOffset();
                    if (this.looksLikeMethod(reader)) {
                        return start + 1;
                    }
                }
                curr = reader.read();
            }
        }
        catch (IOException iOException) {}
        return contextPosition;
    }

    private List addContextInformations(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals = this.internalComputeCompletionProposals(viewer, offset);
        ArrayList<ContextInformationWrapper> result = new ArrayList<ContextInformationWrapper>();
        int i = 0;
        while (i < proposals.length) {
            IContextInformation contextInformation = proposals[i].getContextInformation();
            if (contextInformation != null) {
                ContextInformationWrapper wrapper = new ContextInformationWrapper(contextInformation);
                wrapper.setContextInformationPosition(offset);
                result.add(wrapper);
            }
            ++i;
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        int contextInformationPosition = this.guessContextInformationPosition(viewer, offset);
        List result = this.addContextInformations(viewer, contextInformationPosition);
        return result.toArray(new IContextInformation[result.size()]);
    }

    private ICompletionProposal[] order(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.internalComputeCompletionProposals(viewer, offset);
    }

    private ICompletionProposal[] internalComputeCompletionProposals(ITextViewer viewer, int offset) {
        ICompilationUnit unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        if (unit == null) {
            return new ICompletionProposal[0];
        }
        CompletionProposalCollector collector = PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments") ? new ExperimentalResultCollector(unit) : new CompletionProposalCollector(unit);
        try {
            Point selection = viewer.getSelectedRange();
            if (selection.y > 0) {
                collector.setReplacementLength(selection.y);
            }
            unit.codeComplete(offset, (CompletionRequestor)collector);
        }
        catch (JavaModelException x) {
            Shell shell = viewer.getTextWidget().getShell();
            if (x.isDoesNotExist() && !unit.getJavaProject().isOnClasspath((IJavaElement)unit)) {
                MessageDialog.openInformation((Shell)shell, (String)JavaTextMessages.CompletionProcessor_error_notOnBuildPath_title, (String)JavaTextMessages.CompletionProcessor_error_notOnBuildPath_message);
            }
            ErrorDialog.openError((Shell)shell, (String)JavaTextMessages.CompletionProcessor_error_accessing_title, (String)JavaTextMessages.CompletionProcessor_error_accessing_message, (IStatus)x.getStatus());
        }
        ICompletionProposal[] results = collector.getJavaCompletionProposals();
        int contextInformationOffset = this.guessContextInformationPosition(viewer, offset);
        if (contextInformationOffset != offset) {
            int i = 0;
            while (i < results.length) {
                if (results[i] instanceof JavaMethodCompletionProposal) {
                    JavaMethodCompletionProposal jmcp = (JavaMethodCompletionProposal)results[i];
                    jmcp.setContextInformationPosition(contextInformationOffset);
                }
                ++i;
            }
        }
        this.fErrorMsg = collector.getErrorMessage();
        if (this.fTemplateEngine != null) {
            this.fTemplateEngine.reset();
            this.fTemplateEngine.complete(viewer, offset, unit);
            TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
            IJavaCompletionProposal[] keyWordResults = collector.getKeywordCompletionProposals();
            int i = 0;
            while (i < keyWordResults.length) {
                String keyword = keyWordResults[i].getDisplayString();
                int k = 0;
                while (k < templateResults.length) {
                    TemplateProposal curr = templateResults[k];
                    if (curr.getTemplate().getName().startsWith(keyword)) {
                        curr.setRelevance(keyWordResults[i].getRelevance() + 1);
                    }
                    ++k;
                }
                ++i;
            }
            ICompletionProposal[] total = new ICompletionProposal[results.length + templateResults.length];
            System.arraycopy(templateResults, 0, total, 0, templateResults.length);
            System.arraycopy(results, 0, total, templateResults.length, results.length);
            results = total;
        }
        this.fNumberOfComputedResults = results == null ? 0 : results.length;
        return this.order(results);
    }

    private static class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }

        public boolean equals(Object object) {
            if (object instanceof ContextInformationWrapper) {
                return this.fContextInformation.equals((Object)((ContextInformationWrapper)object).fContextInformation);
            }
            return this.fContextInformation.equals(object);
        }
    }
}

