/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.jdt.internal.ui.search.MatchFilter;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class FiltersDialog
extends SelectionStatusDialog {
    private CheckboxTableViewer listViewer;
    private JavaSearchResultPage fPage;
    private Button fLimitElementsCheckbox;
    private Text fLimitElementsField;
    private int fLimitElementCount = 1000;
    private boolean fLimitElements = false;

    public FiltersDialog(JavaSearchResultPage page) {
        super(page.getSite().getShell());
        this.setTitle(SearchMessages.FiltersDialog_title);
        this.setStatusLineAboveButtons(true);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fPage = page;
    }

    public MatchFilter[] getEnabledFilters() {
        Object[] result = this.getResult();
        MatchFilter[] filters = new MatchFilter[result.length];
        System.arraycopy(result, 0, filters, 0, filters.length);
        return filters;
    }

    public boolean isLimitEnabled() {
        return this.fLimitElements;
    }

    public int getElementLimit() {
        return this.fLimitElementCount;
    }

    protected Control createDialogArea(Composite composite) {
        Composite parent = (Composite)super.createDialogArea(composite);
        this.initializeDialogUnits((Control)composite);
        this.createTableLimit(parent);
        Label l = new Label(parent, 0);
        l.setFont(parent.getFont());
        l.setText(SearchMessages.FiltersDialog_filters_label);
        Table table = new Table(parent, 2080);
        table.setFont(parent.getFont());
        this.listViewer = new CheckboxTableViewer(table);
        GridData data = new GridData(1808);
        data.minimumHeight = this.convertHeightInCharsToPixels(8);
        table.setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MatchFilter)element).getName();
            }
        });
        ArrayContentProvider cp = new ArrayContentProvider();
        this.listViewer.setContentProvider((IContentProvider)cp);
        this.listViewer.setInput((Object)MatchFilter.allFilters());
        this.listViewer.setCheckedElements((Object[])this.fPage.getMatchFilters());
        l = new Label(parent, 0);
        l.setFont(parent.getFont());
        l.setText(SearchMessages.FiltersDialog_description_label);
        final Text description = new Text(parent, 19018);
        description.setFont(parent.getFont());
        data = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(3);
        description.setLayoutData((Object)data);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selectedElement != null) {
                    description.setText(((MatchFilter)selectedElement).getDescription());
                } else {
                    description.setText("");
                }
            }
        });
        return parent;
    }

    private void createTableLimit(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        parent.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        parent.setLayoutData((Object)gd);
        this.fLimitElementsCheckbox = new Button(parent, 32);
        this.fLimitElementsCheckbox.setText(SearchMessages.FiltersDialog_limit_label);
        this.fLimitElementsCheckbox.setLayoutData((Object)new GridData());
        this.fLimitElementsField = new Text(parent, 2048);
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(6);
        this.fLimitElementsField.setLayoutData((Object)gd);
        FiltersDialog.applyDialogFont((Control)parent);
        this.fLimitElementsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersDialog.this.updateLimitValueEnablement();
            }
        });
        this.fLimitElementsField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FiltersDialog.this.validateText();
            }
        });
        this.initLimit();
    }

    private void initLimit() {
        boolean limit = this.fPage.limitElements();
        int count = this.fPage.getElementLimit();
        this.fLimitElementsCheckbox.setSelection(limit);
        this.fLimitElementsField.setText(String.valueOf(count));
        this.updateLimitValueEnablement();
    }

    private void updateLimitValueEnablement() {
        this.fLimitElementsField.setEnabled(this.fLimitElementsCheckbox.getSelection());
    }

    protected void validateText() {
        String text = this.fLimitElementsField.getText();
        int value = -1;
        try {
            value = Integer.valueOf(text);
        }
        catch (NumberFormatException numberFormatException) {}
        if (this.fLimitElementsCheckbox.getSelection() && value <= 0) {
            this.updateStatus((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, SearchMessages.FiltersDialog_limit_error, null));
        } else {
            this.updateStatus((IStatus)new Status(0, JavaPlugin.getPluginId(), 0, "", null));
        }
    }

    protected void computeResult() {
        this.fLimitElementCount = Integer.valueOf(this.fLimitElementsField.getText());
        this.fLimitElements = this.fLimitElementsCheckbox.getSelection();
        this.setResult(Arrays.asList(this.listViewer.getCheckedElements()));
    }
}

