/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.FileEntry;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.LineReader;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchResult;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.Properties;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.text.Position;
import org.eclipse.search.ui.text.Match;

class NLSSearchResultRequestor
extends SearchRequestor {
    private static final StringMatcher fgGetClassNameMatcher = new StringMatcher("*.class.getName()*", false, false);
    private NLSSearchResult fResult;
    private IFile fPropertiesFile;
    private Properties fProperties;
    private HashSet fUsedPropertyNames;

    public NLSSearchResultRequestor(IFile propertiesFile, NLSSearchResult result) {
        this.fPropertiesFile = propertiesFile;
        this.fResult = result;
    }

    public void beginReporting() {
        this.loadProperties();
        this.fUsedPropertyNames = new HashSet(this.fProperties.size());
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        IField field;
        String source;
        int offset = match.getOffset();
        int length = match.getLength();
        if (offset == -1 || length == -1) {
            return;
        }
        if (!(match.getElement() instanceof IJavaElement)) {
            return;
        }
        IJavaElement javaElement = (IJavaElement)match.getElement();
        if (javaElement.getElementType() == 13) {
            return;
        }
        if (javaElement.getElementType() == 6) {
            return;
        }
        if (javaElement.getElementType() == 7) {
            return;
        }
        if (javaElement.getElementType() == 8 && (source = (field = (IField)javaElement).getSource()) != null && fgGetClassNameMatcher.match(source)) {
            return;
        }
        Position mutableKeyPosition = new Position(offset, length);
        String key = this.findKey(mutableKeyPosition, offset, javaElement);
        if (key != null && this.isKeyDefined(key)) {
            return;
        }
        this.fResult.addMatch(new Match((Object)javaElement, mutableKeyPosition.getOffset(), mutableKeyPosition.getLength()));
    }

    public void reportUnusedPropertyNames(IProgressMonitor pm) {
        pm.beginTask("", this.fProperties.size());
        boolean hasUnused = false;
        pm.setTaskName(NLSSearchMessages.NLSSearchResultRequestor_searching);
        String message = Messages.format(NLSSearchMessages.NLSSearchResultCollector_unusedKeys, this.fPropertiesFile.getName());
        FileEntry groupElement = new FileEntry(this.fPropertiesFile, message);
        Enumeration<?> enumeration = this.fProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (!this.fUsedPropertyNames.contains(propertyName)) {
                this.addMatch(groupElement, propertyName);
                hasUnused = true;
            }
            pm.worked(1);
        }
        if (hasUnused) {
            this.fResult.setUnusedGroup(groupElement);
        }
        pm.done();
    }

    private void addMatch(FileEntry groupElement, String propertyName) {
        int length;
        String escapedPropertyName = PropertyFileDocumentModel.unwindEscapeChars(propertyName);
        int start = this.findPropertyNameStartPosition(escapedPropertyName);
        if (start == -1) {
            start = 0;
            length = 0;
        } else {
            length = escapedPropertyName.length();
        }
        this.fResult.addMatch(new Match((Object)groupElement, start, length));
    }

    private boolean isKeyDefined(String key) {
        if (key == null) {
            return true;
        }
        if (key != null && this.fProperties.getProperty(key) != null) {
            this.fUsedPropertyNames.add(key);
            return true;
        }
        return false;
    }

    private String findKey(Position keyPositionResult, int typeNameStart, IJavaElement enclosingElement) throws CoreException {
        if (enclosingElement instanceof ISourceReference) {
            int sourceRangeOffset = ((ISourceReference)enclosingElement).getSourceRange().getOffset();
            String source = ((ISourceReference)enclosingElement).getSource();
            if (source == null) {
                return null;
            }
            source = source.substring(typeNameStart - sourceRangeOffset);
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(source.toCharArray());
            try {
                int tok = scanner.getNextToken();
                while (tok != 158 && (tok == 5 || tok == 6)) {
                    tok = scanner.getNextToken();
                }
                if (tok == 158 || tok != 7) {
                    return null;
                }
                tok = scanner.getNextToken();
                if (tok == 158 || tok != 45) {
                    return null;
                }
                int keyStart = scanner.getCurrentTokenStartPosition() + 1;
                int keyEnd = scanner.getCurrentTokenEndPosition();
                keyPositionResult.setOffset(typeNameStart + keyStart);
                keyPositionResult.setLength(keyEnd - keyStart);
                return source.substring(keyStart, keyEnd);
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findPropertyNameStartPosition(String propertyName) {
        stream = null;
        lineReader = null;
        try {
            encoding = this.fPropertiesFile.getCharset();
        }
        catch (CoreException v0) {
            encoding = "ISO-8859-1";
        }
        try {
            stream = this.fPropertiesFile.getContents();
            lineReader = new LineReader(stream, encoding);
        }
        catch (CoreException cex) {
            JavaPlugin.log(cex);
            return -1;
        }
        catch (IOException v1) {
            if (stream == null) return -1;
            try {
                stream.close();
                return -1;
            }
            catch (IOException ce) {
                JavaPlugin.log(ce);
            }
            return -1;
        }
        start = 0;
        try {
            try {
                buf = new StringBuffer(80);
                eols = lineReader.readLine(buf);
                keyLength = propertyName.length();
                while (true) {
                    block20: {
                        if (eols > 0) break block20;
                        if (eols != -17) {
                            start = -1;
                        }
                        break;
                    }
                    line = buf.toString();
                    i = line.indexOf(propertyName);
                    charPos = i + keyLength;
                    terminatorChar = '\u0000';
                    v2 = hasNoValue = charPos >= line.length();
                    if (i > -1 && !hasNoValue) {
                        terminatorChar = line.charAt(charPos);
                    }
                    if (line.trim().startsWith(propertyName) && (hasNoValue || Character.isWhitespace(terminatorChar) || terminatorChar == '=')) {
                        start += line.indexOf(propertyName);
                        eols = -17;
                        continue;
                    }
                    start += line.length() + eols;
                    buf.setLength(0);
                    eols = lineReader.readLine(buf);
                }
            }
            catch (IOException ex) {
                JavaPlugin.log(ex);
                var14_17 = null;
                try {
                    lineReader.close();
                    return -1;
                }
                catch (IOException ex) {
                    JavaPlugin.log(ex);
                }
                return -1;
            }
        }
        catch (Throwable var15_23) {
            var14_18 = null;
            ** try [egrp 5[TRYBLOCK] [7 : 288->295)] { 
lbl64:
            // 1 sources

            lineReader.close();
            throw var15_23;
lbl66:
            // 1 sources

            catch (IOException ex) {
                JavaPlugin.log(ex);
            }
            throw var15_23;
        }
        {
            var14_19 = null;
        }
        try {}
        catch (IOException ex) {
            JavaPlugin.log(ex);
            return start;
        }
        lineReader.close();
        return start;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadProperties() {
        BufferedInputStream stream;
        HashSet duplicateKeys = new HashSet();
        this.fProperties = new Properties(duplicateKeys);
        try {
            stream = new BufferedInputStream(this.fPropertiesFile.getContents());
        }
        catch (CoreException coreException) {
            this.fProperties = new Properties();
            return;
        }
        try {
            try {
                this.fProperties.load(stream);
            }
            catch (IOException iOException) {
                this.fProperties = new Properties();
                Object var3_3 = null;
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException2) {}
                this.reportDuplicateKeys(duplicateKeys);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {}
            catch (IOException iOException) {}
            ((InputStream)stream).close();
            this.reportDuplicateKeys(duplicateKeys);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)stream).close();
        this.reportDuplicateKeys(duplicateKeys);
    }

    private void reportDuplicateKeys(Set duplicateKeys) {
        if (duplicateKeys.size() == 0) {
            return;
        }
        String message = Messages.format(NLSSearchMessages.NLSSearchResultCollector_duplicateKeys, this.fPropertiesFile.getName());
        FileEntry groupElement = new FileEntry(this.fPropertiesFile, message);
        Iterator iter = duplicateKeys.iterator();
        while (iter.hasNext()) {
            String propertyName = (String)iter.next();
            this.addMatch(groupElement, propertyName);
        }
        this.fResult.setDuplicatesGroup(groupElement);
    }
}

