/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;

public class WorkbenchRunnableAdapter
implements IRunnableWithProgress,
IThreadListener {
    private boolean fTransfer = false;
    private IWorkspaceRunnable fWorkspaceRunnable;
    private ISchedulingRule fRule;

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable) {
        this(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule) {
        this.fWorkspaceRunnable = runnable;
        this.fRule = rule;
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule, boolean transfer) {
        this.fWorkspaceRunnable = runnable;
        this.fRule = rule;
        this.fTransfer = transfer;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.fRule;
    }

    public void threadChange(Thread thread) {
        if (this.fTransfer) {
            Platform.getJobManager().transferRule(this.fRule, thread);
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            JavaCore.run((IWorkspaceRunnable)this.fWorkspaceRunnable, (ISchedulingRule)this.fRule, (IProgressMonitor)monitor);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void runAsUserJob(String name, final Object jobFamiliy) {
        Job buildJob = new Job(name){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        WorkbenchRunnableAdapter.this.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof CoreException) {
                            IStatus iStatus = ((CoreException)cause).getStatus();
                            Object var4_7 = null;
                            monitor.done();
                            return iStatus;
                        }
                        IStatus iStatus = JavaUIStatus.createError(4, cause);
                        Object var4_8 = null;
                        monitor.done();
                        return iStatus;
                    }
                    catch (InterruptedException interruptedException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        Object var4_9 = null;
                        monitor.done();
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_10 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_11 = null;
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return jobFamiliy == family;
            }
        };
        buildJob.setRule(this.fRule);
        buildJob.setUser(true);
        buildJob.schedule();
    }
}

