/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.structure.MovedMemberAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public final class MoveStaticMembersProcessor
extends MoveProcessor {
    private static final String TRACKED_POSITION_PROPERTY = "MoveStaticMembersProcessor.trackedPosition";
    private IMember[] fMembersToMove;
    private IType fDestinationType;
    private String fDestinationTypeName;
    private CodeGenerationSettings fPreferences;
    private CompositeChange fChange;
    private CompilationUnitRewrite fSource;
    private ITypeBinding fSourceBinding;
    private CompilationUnitRewrite fTarget;
    private IBinding[] fMemberBindings;
    private BodyDeclaration[] fMemberDeclarations;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private MoveStaticMembersProcessor(IMember[] elements, CodeGenerationSettings preferenceSettings) {
        Assert.isNotNull(elements);
        Assert.isNotNull(preferenceSettings);
        this.fMembersToMove = elements;
        this.fPreferences = preferenceSettings;
    }

    public static MoveStaticMembersProcessor create(IMember[] elements, CodeGenerationSettings preferenceSettings) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isMoveStaticMembersAvailable(elements)) {
            return null;
        }
        return new MoveStaticMembersProcessor(elements, preferenceSettings);
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isMoveStaticMembersAvailable(this.fMembersToMove);
    }

    public Object[] getElements() {
        Object[] result = new Object[this.fMembersToMove.length];
        System.arraycopy(this.fMembersToMove, 0, result, 0, this.fMembersToMove.length);
        return result;
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.MoveStaticMemberProcessor";
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<MoveParticipant> result = new ArrayList<MoveParticipant>();
        MoveArguments args = new MoveArguments((Object)this.fDestinationType, true);
        String[] natures = JavaProcessors.computeAffectedNaturs((IJavaElement[])this.fMembersToMove);
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[i];
            result.addAll(Arrays.asList(ParticipantManager.loadMoveParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)member, (MoveArguments)args, (String[])natures, (SharableParticipants)sharedParticipants)));
            ++i;
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.MoveMembersRefactoring_Move_Members;
    }

    public IType getDestinationType() {
        return this.fDestinationType;
    }

    public void setDestinationTypeFullyQualifiedName(String fullyQualifiedTypeName) throws JavaModelException {
        Assert.isNotNull(fullyQualifiedTypeName);
        this.fDestinationType = this.resolveType(fullyQualifiedTypeName);
        this.fDestinationTypeName = fullyQualifiedTypeName;
    }

    public IMember[] getMembersToMove() {
        return this.fMembersToMove;
    }

    public IType getDeclaringType() {
        return this.fMembersToMove[0].getDeclaringType();
    }

    private IType resolveType(String qualifiedTypeName) throws JavaModelException {
        IType type = this.getDeclaringType().getJavaProject().findType(qualifiedTypeName);
        if (type == null) {
            type = this.getDeclaringType().getJavaProject().findType(this.getDeclaringType().getPackageFragment().getElementName(), qualifiedTypeName);
        }
        return type;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        block4: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, 1);
                result = new RefactoringStatus();
                result.merge(this.checkDeclaringType());
                pm.worked(1);
                if (!result.hasFatalError()) break block4;
                refactoringStatus = result;
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        this.fSource = new CompilationUnitRewrite(this.fMembersToMove[0].getCompilationUnit());
        this.fSourceBinding = (ITypeBinding)((SimpleName)NodeFinder.perform((ASTNode)this.fSource.getRoot(), this.fMembersToMove[0].getDeclaringType().getNameRange())).resolveBinding();
        this.fMemberBindings = this.getMemberBindings();
        if (this.fSourceBinding == null || this.hasUnresolvedMemberBinding()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_compile_errors, this.fSource.getCu().getElementName()));
        }
        this.fMemberDeclarations = this.getASTMembers(result);
        RefactoringStatus refactoringStatus = result;
        Object var3_6 = null;
        pm.done();
        return refactoringStatus;
    }

    private boolean hasUnresolvedMemberBinding() {
        int i = 0;
        while (i < this.fMemberBindings.length) {
            if (this.fMemberBindings[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private RefactoringStatus checkDeclaringType() {
        IType declaringType = this.getDeclaringType();
        if (JavaModelUtil.getFullyQualifiedName(declaringType).equals("java.lang.Object")) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveMembersRefactoring_Object);
        }
        if (declaringType.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveMembersRefactoring_binary);
        }
        if (declaringType.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveMembersRefactoring_read_only);
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        RefactoringStatus result;
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                RefactoringStatus refactoringStatus;
                                this.fTarget = null;
                                try {
                                    pm.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, 10);
                                    result = new RefactoringStatus();
                                    this.fSource.clearASTAndImportRewrites();
                                    result.merge(this.checkDestinationType());
                                    if (!result.hasFatalError()) break block11;
                                    refactoringStatus = result;
                                    Object var6_11 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var6_18 = null;
                                    pm.done();
                                    throw throwable;
                                }
                                pm.done();
                                return refactoringStatus;
                            }
                            result.merge(this.checkDestinationInsideTypeToMove());
                            if (!result.hasFatalError()) break block12;
                            RefactoringStatus refactoringStatus = result;
                            Object var6_12 = null;
                            pm.done();
                            return refactoringStatus;
                        }
                        result.merge(MemberCheckUtil.checkMembersInDestinationType(this.fMembersToMove, this.fDestinationType));
                        if (!result.hasFatalError()) break block13;
                        RefactoringStatus refactoringStatus = result;
                        Object var6_13 = null;
                        pm.done();
                        return refactoringStatus;
                    }
                    result.merge(this.checkAccessedMembersAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                    if (!result.hasFatalError()) break block14;
                    RefactoringStatus refactoringStatus = result;
                    Object var6_14 = null;
                    pm.done();
                    return refactoringStatus;
                }
                result.merge(this.checkMovedMembersAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                if (!result.hasFatalError()) break block15;
                RefactoringStatus refactoringStatus = result;
                Object var6_15 = null;
                pm.done();
                return refactoringStatus;
            }
            result.merge(this.checkNativeMovedMethods((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            if (!result.hasFatalError()) break block16;
            RefactoringStatus refactoringStatus = result;
            Object var6_16 = null;
            pm.done();
            return refactoringStatus;
        }
        ArrayList modifiedCus = new ArrayList();
        this.createChange(modifiedCus, result, (IProgressMonitor)new SubProgressMonitor(pm, 7));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValidateEditChecker checker = (ValidateEditChecker)context.getChecker((Class)clazz);
        checker.addFiles(this.getAllFilesToModify(modifiedCus));
        RefactoringStatus refactoringStatus = result;
        Object var6_17 = null;
        pm.done();
        return refactoringStatus;
    }

    private IFile[] getAllFilesToModify(List modifiedCus) {
        HashSet<IResource> result = new HashSet<IResource>();
        IResource resource = this.fDestinationType.getCompilationUnit().getResource();
        result.add(resource);
        int i = 0;
        while (i < this.fMembersToMove.length) {
            resource = this.fMembersToMove[i].getCompilationUnit().getResource();
            if (resource != null) {
                result.add(resource);
            }
            ++i;
        }
        Iterator iter = modifiedCus.iterator();
        while (iter.hasNext()) {
            ICompilationUnit unit = (ICompilationUnit)iter.next();
            if (unit.getResource() == null) continue;
            result.add(unit.getResource());
        }
        return result.toArray(new IFile[result.size()]);
    }

    private RefactoringStatus checkDestinationType() throws JavaModelException {
        if (this.fDestinationType == null) {
            String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_not_found, this.fDestinationTypeName);
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        if (this.fDestinationType.equals(this.getDeclaringType())) {
            String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_same, JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        if (!this.fDestinationType.exists()) {
            String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_not_exist, JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        if (this.fDestinationType.isBinary()) {
            String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_dest_binary, JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        RefactoringStatus result = new RefactoringStatus();
        if (this.fDestinationType.isInterface() && !this.getDeclaringType().isInterface()) {
            result.merge(this.checkFieldsForInterface());
        }
        if (result.hasFatalError()) {
            return result;
        }
        if (!JdtFlags.isStatic((IMember)this.fDestinationType) && this.fDestinationType.getDeclaringType() != null) {
            String message = RefactoringCoreMessages.MoveMembersRefactoring_static_declaration;
            result.addError(message);
        }
        return result;
    }

    private RefactoringStatus checkDestinationInsideTypeToMove() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IType type;
            if (this.fMembersToMove[i] instanceof IType && (this.fDestinationType.equals(type = (IType)this.fMembersToMove[i]) || JavaElementUtil.isAncestorOf((IJavaElement)type, (IJavaElement)this.fDestinationType))) {
                String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_inside, new String[]{JavaModelUtil.getFullyQualifiedName(type), JavaModelUtil.getFullyQualifiedName(this.fDestinationType)});
                RefactoringStatusContext context = JavaStatusContext.create(this.fDestinationType.getCompilationUnit(), this.fDestinationType.getNameRange());
                result.addFatalError(message, context);
                return result;
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkFieldsForInterface() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            if (!this.canMoveToInterface(this.fMembersToMove[i])) {
                String message = RefactoringCoreMessages.MoveMembersRefactoring_only_public_static;
                result.addError(message, JavaStatusContext.create(this.fMembersToMove[i]));
            }
            ++i;
        }
        return result;
    }

    private boolean canMoveToInterface(IMember member) throws JavaModelException {
        int flags = member.getFlags();
        switch (member.getElementType()) {
            case 8: {
                if (!(Flags.isPublic((int)flags) && Flags.isStatic((int)flags) && Flags.isFinal((int)flags))) {
                    return false;
                }
                if (Flags.isEnum((int)flags)) {
                    return false;
                }
                VariableDeclarationFragment declaration = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, this.fSource.getRoot());
                if (declaration != null) {
                    return declaration.getInitializer() != null;
                }
            }
            case 7: {
                return Flags.isPublic((int)flags) && Flags.isStatic((int)flags);
            }
        }
        return false;
    }

    private RefactoringStatus checkAccessedMembersAvailability(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, 3);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkAccessedMethodsAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedFieldsAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedTypesAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethodsAvailability(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMethod[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])this.fMembersToMove, pm);
        List<IMember> movedElementList = Arrays.asList(this.fMembersToMove);
        int i = 0;
        while (i < accessedMethods.length) {
            if (!this.containsAncestorOf(movedElementList, (IMember)accessedMethods[i]) && JdtFlags.isStatic((IMember)accessedMethods[i]) && !MoveStaticMembersProcessor.isVisibleFrom((IMember)accessedMethods[i], accessedMethods[i].getDeclaringType(), this.fDestinationType)) {
                String msg = this.createNonAccessibleMemberMessage((IMember)accessedMethods[i], this.fDestinationType, false);
                result.addError(msg, JavaStatusContext.create((IMember)accessedMethods[i]));
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkAccessedTypesAvailability(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] accessedTypes = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])this.fMembersToMove, pm);
        List<IMember> movedElementList = Arrays.asList(this.fMembersToMove);
        int i = 0;
        while (i < accessedTypes.length) {
            if (!this.containsAncestorOf(movedElementList, (IMember)accessedTypes[i]) && JdtFlags.isStatic((IMember)accessedTypes[i]) && !MoveStaticMembersProcessor.isVisibleFrom((IMember)accessedTypes[i], accessedTypes[i].getDeclaringType(), this.fDestinationType)) {
                String msg = this.createNonAccessibleMemberMessage((IMember)accessedTypes[i], this.fDestinationType, false);
                result.addError(msg, JavaStatusContext.create((IMember)accessedTypes[i]));
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkAccessedFieldsAvailability(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])this.fMembersToMove, pm);
        List<IMember> movedElementList = Arrays.asList(this.fMembersToMove);
        int i = 0;
        while (i < accessedFields.length) {
            if (!this.containsAncestorOf(movedElementList, (IMember)accessedFields[i]) && JdtFlags.isStatic((IMember)accessedFields[i]) && !MoveStaticMembersProcessor.isVisibleFrom((IMember)accessedFields[i], accessedFields[i].getDeclaringType(), this.fDestinationType)) {
                String msg = this.createNonAccessibleMemberMessage((IMember)accessedFields[i], this.fDestinationType, false);
                result.addError(msg, JavaStatusContext.create((IMember)accessedFields[i]));
            }
            ++i;
        }
        return result;
    }

    private boolean containsAncestorOf(List movedElementList, IMember accessedMember) {
        IMember element = accessedMember;
        do {
            if (!movedElementList.contains(element)) continue;
            return true;
        } while ((element = element.getParent()) instanceof IMember);
        return false;
    }

    private RefactoringStatus checkMovedMembersAvailability(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", this.fMembersToMove.length);
        pm.setTaskName(RefactoringCoreMessages.MoveMembersRefactoring_check_availability);
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            result.merge(this.checkMovedMemberAvailability(this.fMembersToMove[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkMovedMemberAvailability(IMember memberToMove, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (memberToMove instanceof IType) {
            IJavaElement[] typeMembers = ((IType)memberToMove).getChildren();
            pm.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, typeMembers.length + 1);
            int i = 0;
            while (i < typeMembers.length) {
                if (typeMembers[i] instanceof IInitializer) {
                    pm.worked(1);
                } else {
                    result.merge(this.checkMovedMemberAvailability((IMember)typeMembers[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                }
                ++i;
            }
        } else {
            pm.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, 1);
        }
        IType[] blindAccessorTypes = this.getTypesNotSeeingMovedMember(memberToMove, (IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        int k = 0;
        while (k < blindAccessorTypes.length) {
            String message = this.createNonAccessibleMemberMessage(memberToMove, blindAccessorTypes[k], true);
            result.addError(message, JavaStatusContext.create(memberToMove));
            ++k;
        }
        pm.done();
        return result;
    }

    private IType[] getTypesNotSeeingMovedMember(IMember member, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        if (JdtFlags.isPublic(member) && JdtFlags.isPublic((IMember)this.fDestinationType)) {
            return new IType[0];
        }
        HashSet<IType> blindAccessorTypes = new HashSet<IType>();
        SearchResultGroup[] references = MoveStaticMembersProcessor.getReferences(member, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
        int i = 0;
        while (i < references.length) {
            SearchMatch[] searchResults = references[i].getSearchResults();
            int k = 0;
            while (k < searchResults.length) {
                SearchMatch searchResult = searchResults[k];
                IJavaElement element = SearchUtils.getEnclosingJavaElement(searchResult);
                IType type = (IType)element.getAncestor(7);
                if (!(type == null || blindAccessorTypes.contains(type) || this.isWithinMemberToMove(searchResult) || MoveStaticMembersProcessor.isVisibleFrom(member, this.getDestinationType(), type))) {
                    blindAccessorTypes.add(type);
                }
                ++k;
            }
            ++i;
        }
        return blindAccessorTypes.toArray(new IType[blindAccessorTypes.size()]);
    }

    private String createNonAccessibleMemberMessage(IMember member, IType accessingType, boolean moved) {
        IType declaringType = moved ? this.getDestinationType() : this.getDeclaringType();
        switch (member.getElementType()) {
            case 8: {
                String message = moved ? Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_moved_field, new String[]{JavaElementUtil.createFieldSignature((IField)member), JavaModelUtil.getFullyQualifiedName(accessingType), JavaModelUtil.getFullyQualifiedName(declaringType)}) : Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_accessed_field, new String[]{JavaElementUtil.createFieldSignature((IField)member), JavaModelUtil.getFullyQualifiedName(accessingType)});
                return message;
            }
            case 9: {
                String message = moved ? Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_moved_method, new String[]{JavaElementUtil.createMethodSignature((IMethod)member), JavaModelUtil.getFullyQualifiedName(accessingType), JavaModelUtil.getFullyQualifiedName(declaringType)}) : Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_accessed_method, new String[]{JavaElementUtil.createMethodSignature((IMethod)member), JavaModelUtil.getFullyQualifiedName(accessingType)});
                return message;
            }
            case 7: {
                String message = moved ? Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_moved_type, new String[]{JavaModelUtil.getFullyQualifiedName((IType)member), JavaModelUtil.getFullyQualifiedName(accessingType), JavaModelUtil.getFullyQualifiedName(declaringType)}) : Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_accessed_type, new String[]{JavaModelUtil.getFullyQualifiedName((IType)member), JavaModelUtil.getFullyQualifiedName(accessingType)});
                return message;
            }
        }
        Assert.isTrue(false);
        return null;
    }

    private static SearchResultGroup[] getReferences(IMember member, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)member, (int)2, (int)24));
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaElement)member));
        engine.setStatus(status);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return (SearchResultGroup[])engine.getResults();
    }

    private static boolean isVisibleFrom(IMember member, IType newMemberDeclaringType, IType accessingType) throws JavaModelException {
        int memberVisibility = JdtFlags.getLowerVisibility(JdtFlags.getVisibilityCode(member), JdtFlags.getVisibilityCode((IMember)newMemberDeclaringType));
        IType declaringType = newMemberDeclaringType.getDeclaringType();
        while (declaringType != null) {
            memberVisibility = JdtFlags.getLowerVisibility(memberVisibility, JdtFlags.getVisibilityCode((IMember)declaringType));
            declaringType = declaringType.getDeclaringType();
        }
        switch (memberVisibility) {
            case 2: {
                return MoveStaticMembersProcessor.isEqualOrEnclosedType(accessingType, newMemberDeclaringType);
            }
            case 0: {
                return JavaModelUtil.isSamePackage(accessingType.getPackageFragment(), newMemberDeclaringType.getPackageFragment());
            }
            case 4: {
                return JavaModelUtil.isSamePackage(accessingType.getPackageFragment(), newMemberDeclaringType.getPackageFragment()) || accessingType.newSupertypeHierarchy(null).contains(newMemberDeclaringType);
            }
            case 1: {
                return true;
            }
        }
        Assert.isTrue(false);
        return false;
    }

    private static boolean isEqualOrEnclosedType(IType inner, IType outer) {
        while (inner != null) {
            if (inner.equals(outer)) {
                return true;
            }
            inner = inner.getDeclaringType();
        }
        return false;
    }

    private boolean isWithinMemberToMove(SearchMatch result) throws JavaModelException {
        ICompilationUnit referenceCU = SearchUtils.getCompilationUnit(result);
        if (!referenceCU.equals(this.fSource.getCu())) {
            return false;
        }
        int referenceStart = result.getOffset();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            ISourceRange range = this.fMembersToMove[i].getSourceRange();
            if (range.getOffset() <= referenceStart && range.getOffset() + range.getLength() >= referenceStart) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private RefactoringStatus checkNativeMovedMethods(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, this.fMembersToMove.length);
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            if (this.fMembersToMove[i].getElementType() == 9 && JdtFlags.isNative(this.fMembersToMove[i])) {
                String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_native, JavaElementUtil.createMethodSignature((IMethod)this.fMembersToMove[i]));
                result.addWarning(message, JavaStatusContext.create(this.fMembersToMove[i]));
                pm.worked(1);
            }
            ++i;
        }
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.done();
        return this.fChange;
    }

    private void createChange(List modifiedCus, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_creating, 5);
        this.fChange = new DynamicValidationStateChange(RefactoringCoreMessages.MoveMembersRefactoring_move_members);
        this.fTarget = this.getCuRewrite(this.fDestinationType.getCompilationUnit());
        ITypeBinding targetBinding = this.getDestinationBinding();
        if (targetBinding == null) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_compile_errors, this.fTarget.getCu().getElementName()));
            monitor.done();
            return;
        }
        try {
            String[] memberSources = this.getUpdatedMemberSource(status, this.fMemberDeclarations, targetBinding);
            monitor.worked(1);
            if (status.hasFatalError()) {
                return;
            }
            HashMap adjustments = new HashMap();
            IMember member = null;
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 1, 2);
            sub.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_creating, this.fMembersToMove.length);
            int index = 0;
            while (index < this.fMembersToMove.length) {
                member = this.fMembersToMove[index];
                MemberVisibilityAdjustor adjustor = new MemberVisibilityAdjustor((IJavaElement)this.fDestinationType, member);
                adjustor.setAdjustments(adjustments);
                adjustor.setStatus(status);
                adjustor.setGetters(true);
                adjustor.setSetters(true);
                adjustor.setVisibilitySeverity(2);
                adjustor.setFailureSeverity(2);
                adjustor.adjustVisibility((IProgressMonitor)new NullProgressMonitor());
                ++index;
            }
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2();
            engine.setPattern((IJavaElement[])this.fMembersToMove, 2);
            engine.setGranularity(2);
            engine.setFiltering(true, true);
            engine.setScope(RefactoringScopeFactory.create(this.fMembersToMove));
            engine.setStatus(status);
            engine.searchPattern((IProgressMonitor)new NullProgressMonitor());
            ICompilationUnit[] units = engine.getAffectedCompilationUnits();
            modifiedCus.addAll(Arrays.asList(units));
            MemberVisibilityAdjustor adjustor = new MemberVisibilityAdjustor((IJavaElement)this.fDestinationType, (IMember)this.fDestinationType);
            sub = new SubProgressMonitor(monitor, 1);
            sub.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_creating, units.length);
            int index2 = 0;
            while (index2 < units.length) {
                ICompilationUnit unit = units[index2];
                CompilationUnitRewrite rewrite = this.getCuRewrite(unit);
                adjustor.setRewrites(Collections.singletonMap(unit, rewrite));
                adjustor.setAdjustments(adjustments);
                adjustor.rewriteVisibility(unit, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1));
                ReferenceAnalyzer analyzer = new ReferenceAnalyzer(rewrite, this.fMemberBindings, targetBinding, this.fSourceBinding);
                rewrite.getRoot().accept((ASTVisitor)analyzer);
                status.merge(analyzer.getStatus());
                if (status.hasFatalError()) {
                    this.fChange = null;
                    return;
                }
                if (analyzer.needsTargetImport()) {
                    rewrite.getImportRewrite().addImport(targetBinding);
                }
                if (!this.fSource.getCu().equals(unit) && !this.fTarget.getCu().equals(unit)) {
                    this.fChange.add((Change)rewrite.createChange());
                }
                ++index2;
            }
            status.merge(this.moveMembers(this.fMemberDeclarations, memberSources));
            this.fChange.add((Change)this.fSource.createChange());
            modifiedCus.add(this.fSource.getCu());
            if (!this.fSource.getCu().equals(this.fTarget.getCu())) {
                this.fChange.add((Change)this.fTarget.createChange());
                modifiedCus.add(this.fTarget.getCu());
            }
            monitor.worked(1);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
    }

    private CompilationUnitRewrite getCuRewrite(ICompilationUnit unit) {
        if (this.fSource.getCu().equals(unit)) {
            return this.fSource;
        }
        if (this.fTarget != null && this.fTarget.getCu().equals(unit)) {
            return this.fTarget;
        }
        return new CompilationUnitRewrite(unit);
    }

    private ITypeBinding getDestinationBinding() throws JavaModelException {
        ASTNode node = NodeFinder.perform((ASTNode)this.fTarget.getRoot(), this.fDestinationType.getNameRange());
        if (!(node instanceof SimpleName)) {
            return null;
        }
        IBinding binding = ((SimpleName)node).resolveBinding();
        if (!(binding instanceof ITypeBinding)) {
            return null;
        }
        return (ITypeBinding)binding;
    }

    private IBinding[] getMemberBindings() throws JavaModelException {
        IBinding[] result = new IBinding[this.fMembersToMove.length];
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[i];
            SimpleName name = (SimpleName)NodeFinder.perform((ASTNode)this.fSource.getRoot(), member.getNameRange());
            result[i] = name.resolveBinding();
            ++i;
        }
        return result;
    }

    private String[] getUpdatedMemberSource(RefactoringStatus status, BodyDeclaration[] members, ITypeBinding target) throws CoreException, BadLocationException {
        BodyDeclaration declaration;
        ArrayList typeRefs = new ArrayList();
        boolean targetNeedsSourceImport = false;
        boolean isSourceNotTarget = this.fSource != this.fTarget;
        HashSet<Object> exclude = new HashSet<Object>();
        int i = 0;
        while (i < members.length) {
            ITypeBinding binding;
            declaration = members[i];
            if (declaration instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration type = (AbstractTypeDeclaration)declaration;
                binding = type.resolveBinding();
                if (binding != null) {
                    exclude.add(binding);
                }
            } else if (declaration instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)declaration;
                binding = method.resolveBinding();
                if (binding != null) {
                    exclude.add(binding);
                }
            } else if (declaration instanceof FieldDeclaration) {
                FieldDeclaration field = (FieldDeclaration)declaration;
                Iterator iterator = field.fragments().iterator();
                while (iterator.hasNext()) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)iterator.next();
                    IVariableBinding binding2 = fragment.resolveBinding();
                    if (binding2 == null) continue;
                    exclude.add(binding2);
                }
            }
            ++i;
        }
        i = 0;
        while (i < members.length) {
            declaration = members[i];
            if (isSourceNotTarget) {
                typeRefs.addAll(TypeReferenceFinder.perform((ASTNode)declaration));
            }
            MovedMemberAnalyzer analyzer = new MovedMemberAnalyzer(this.fSource, this.fMemberBindings, this.fSourceBinding, target);
            declaration.accept((ASTVisitor)analyzer);
            ImportRewriteUtil.addImports(this.fTarget, (ASTNode)declaration, new HashMap(), new HashMap(), exclude, false);
            if (this.getDeclaringType().isInterface() && !this.fDestinationType.isInterface()) {
                if (declaration instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)declaration;
                    int psfModifiers = 25;
                    if ((fieldDecl.getModifiers() & psfModifiers) != psfModifiers) {
                        ModifierRewrite.create(this.fSource.getASTRewrite(), (ASTNode)fieldDecl).setModifiers(psfModifiers, null);
                    }
                } else if (declaration instanceof AbstractTypeDeclaration) {
                    AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)declaration;
                    int psModifiers = 9;
                    if ((typeDecl.getModifiers() & psModifiers) != psModifiers) {
                        ModifierRewrite.create(this.fSource.getASTRewrite(), (ASTNode)typeDecl).setModifiers(typeDecl.getModifiers() | psModifiers, null);
                    }
                }
            }
            ITrackedNodePosition trackedPosition = this.fSource.getASTRewrite().track((ASTNode)declaration);
            declaration.setProperty(TRACKED_POSITION_PROPERTY, (Object)trackedPosition);
            targetNeedsSourceImport |= analyzer.targetNeedsSourceImport();
            status.merge(analyzer.getStatus());
            ++i;
        }
        if (targetNeedsSourceImport && isSourceNotTarget) {
            this.fTarget.getImportRewrite().addImport(this.fSourceBinding);
        }
        if (isSourceNotTarget) {
            Iterator iter = typeRefs.iterator();
            while (iter.hasNext()) {
                ITypeBinding binding = (ITypeBinding)iter.next();
                this.fTarget.getImportRewrite().addImport(binding);
            }
        }
        String[] updatedMemberSources = new String[members.length];
        Document document = new Document(this.fSource.getCu().getBuffer().getContents());
        TextEdit edit = this.fSource.getASTRewrite().rewriteAST((IDocument)document, this.fSource.getCu().getJavaProject().getOptions(true));
        edit.apply((IDocument)document, 2);
        int i2 = 0;
        while (i2 < members.length) {
            updatedMemberSources[i2] = this.getUpdatedMember((IDocument)document, members[i2]);
            ++i2;
        }
        this.fSource.clearASTRewrite();
        return updatedMemberSources;
    }

    private String getUpdatedMember(IDocument document, BodyDeclaration declaration) throws BadLocationException {
        ITrackedNodePosition trackedPosition = (ITrackedNodePosition)declaration.getProperty(TRACKED_POSITION_PROPERTY);
        return Strings.trimIndentation(document.get(trackedPosition.getStartPosition(), trackedPosition.getLength()), this.fPreferences.tabWidth, this.fPreferences.indentWidth, false);
    }

    private RefactoringStatus moveMembers(BodyDeclaration[] members, String[] sources) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fTarget.getRoot(), this.fDestinationType.getNameRange());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AbstractTypeDeclaration destination = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
        ListRewrite containerRewrite = this.fTarget.getASTRewrite().getListRewrite((ASTNode)destination, destination.getBodyDeclarationsProperty());
        TextEditGroup delete = this.fSource.createGroupDescription(RefactoringCoreMessages.MoveMembersRefactoring_deleteMembers);
        TextEditGroup add = this.fTarget.createGroupDescription(RefactoringCoreMessages.MoveMembersRefactoring_addMembers);
        int i = 0;
        while (i < members.length) {
            BodyDeclaration declaration = members[i];
            this.fSource.getASTRewrite().remove((ASTNode)declaration, delete);
            if (this.fSource != this.fTarget) {
                this.fSource.getImportRemover().registerRemovedNode((ASTNode)declaration);
            }
            ASTNode node = this.fTarget.getASTRewrite().createStringPlaceholder(sources[i], declaration.getNodeType());
            List container = containerRewrite.getRewrittenList();
            int insertionIndex = ASTNodes.getInsertionIndex((BodyDeclaration)node, container);
            containerRewrite.insertAt(node, insertionIndex, add);
            ++i;
        }
        return result;
    }

    private BodyDeclaration[] getASTMembers(RefactoringStatus status) throws JavaModelException {
        BodyDeclaration[] result = new BodyDeclaration[this.fMembersToMove.length];
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[i];
            ASTNode node = NodeFinder.perform((ASTNode)this.fSource.getRoot(), member.getNameRange());
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jdt.core.dom.BodyDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result[i] = (BodyDeclaration)ASTNodes.getParent(node, clazz);
            if (result[i] instanceof FieldDeclaration && ((FieldDeclaration)result[i]).fragments().size() != 1) {
                status.addFatalError(RefactoringCoreMessages.MoveMembersRefactoring_multi_var_fields);
                return result;
            }
            ++i;
        }
        Arrays.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((BodyDeclaration)o1).getStartPosition() - ((BodyDeclaration)o2).getStartPosition();
            }
        });
        return result;
    }

    private static class TypeReferenceFinder
    extends ASTVisitor {
        List fResult = new ArrayList();
        Set fDefined = new HashSet();

        TypeReferenceFinder() {
        }

        public static List perform(ASTNode root) {
            TypeReferenceFinder visitor = new TypeReferenceFinder();
            root.accept((ASTVisitor)visitor);
            return visitor.fResult;
        }

        public boolean visit(TypeDeclaration node) {
            this.fDefined.add(node.resolveBinding());
            return true;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (!(binding instanceof ITypeBinding)) {
                return true;
            }
            if (!this.fDefined.contains(binding)) {
                this.fResult.add(binding);
            }
            return true;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            this.fDefined.add(node.resolveBinding());
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            this.fDefined.add(node.resolveBinding());
            return true;
        }
    }
}

