/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenamePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.Changes;
import org.eclipse.jdt.internal.corext.refactoring.util.CommentAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenamePackageProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating {
    private IPackageFragment fPackage;
    private SearchResultGroup[] fOccurrences;
    private List fReferencesToTypesInNamesakes;
    private List fReferencesToTypesInPackage;
    private TextChangeManager fChangeManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateTextualMatches;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renamePackageProcessor";
    static /* synthetic */ Class class$0;

    public RenamePackageProcessor(IPackageFragment fragment) {
        this.fPackage = fragment;
        this.setNewElementName(this.fPackage.getElementName());
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fPackage);
    }

    public String getProcessorName() {
        return Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_name, new String[]{this.fPackage.getElementName(), this.getNewElementName()});
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fPackage);
    }

    public Object[] getElements() {
        return new Object[]{this.fPackage};
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
        this.loadDerivedParticipants(status, result, null, null, this.computeResourceModifications(), natures, shared);
    }

    private ResourceModifications computeResourceModifications() throws CoreException {
        ResourceModifications result = new ResourceModifications();
        IContainer container = (IContainer)this.fPackage.getResource();
        if (container == null) {
            return null;
        }
        IPath path = this.fPackage.getParent().getPath();
        path = path.append(this.getNewElementName().replace('.', '/'));
        IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        if (!target.exists()) {
            result.addCreate((IResource)target);
        }
        MoveArguments arguments = new MoveArguments((Object)target, this.getUpdateReferences());
        IResource[] members = container.members();
        int files = 0;
        int i = 0;
        while (i < members.length) {
            IResource member = members[i];
            if (member instanceof IFile) {
                ++files;
                IFile file = (IFile)member;
                if (!"class".equals(file.getFileExtension()) || !file.isDerived()) {
                    result.addMove(member, arguments);
                }
            }
            ++i;
        }
        if (files == members.length) {
            result.addDelete((IResource)container);
        }
        return result;
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    public void setUpdateTextualMatches(boolean update) {
        this.fUpdateTextualMatches = update;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return !this.fPackage.isDefaultPackage();
    }

    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    public void setFilePatterns(String patterns) {
        Assert.isNotNull(patterns);
        this.fFilePatterns = patterns;
    }

    public final String getCurrentElementName() {
        return this.fPackage.getElementName();
    }

    public String getCurrentElementQualifier() {
        return "";
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkPackageName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.fPackage, newName)) {
            result.addFatalError(RefactoringCoreMessages.RenamePackageRefactoring_another_name);
        }
        result.merge(this.checkPackageInCurrentRoot(newName));
        return result;
    }

    public Object getNewElement() {
        IJavaElement parent = this.fPackage.getParent();
        if (!(parent instanceof IPackageFragmentRoot)) {
            return this.fPackage;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
        return root.getPackageFragment(this.getNewElementName());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        Class<?> clazz;
        RefactoringStatus result;
        block13: {
            RefactoringStatus refactoringStatus;
            try {
                String message;
                pm.beginTask("", 20);
                pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_checking);
                result = new RefactoringStatus();
                result.merge(this.checkNewElementName(this.getNewElementName()));
                pm.worked(1);
                result.merge(this.checkForNativeMethods());
                pm.worked(1);
                result.merge(this.checkForMainMethods());
                pm.worked(1);
                if (this.fPackage.isReadOnly()) {
                    message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_Packagered_only, this.fPackage.getElementName());
                    result.addFatalError(message);
                } else if (Resources.isReadOnly(this.fPackage.getResource())) {
                    message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_resource_read_only, this.fPackage.getElementName());
                    result.addError(message);
                }
                if (this.fUpdateReferences) {
                    pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_searching);
                    this.fOccurrences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 4), result);
                    this.fReferencesToTypesInNamesakes = this.getReferencesToTypesInNamesakes((IProgressMonitor)new SubProgressMonitor(pm, 4), result);
                    this.fReferencesToTypesInPackage = this.getReferencesToTypesInPackage((IProgressMonitor)new SubProgressMonitor(pm, 4), result);
                    pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_checking);
                    result.merge(this.analyzeAffectedCompilationUnits());
                    pm.worked(1);
                } else {
                    this.fOccurrences = new SearchResultGroup[0];
                    pm.worked(13);
                }
                result.merge(this.checkPackageName(this.getNewElementName()));
                if (!result.hasFatalError()) break block13;
                refactoringStatus = result;
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 3));
        if (this.fUpdateQualifiedNames) {
            this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else {
            pm.worked(1);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValidateEditChecker checker = (ValidateEditChecker)context.getChecker((Class)clazz);
        checker.addFiles(this.getAllFilesToModify());
        RefactoringStatus refactoringStatus = result;
        Object var5_8 = null;
        pm.done();
        return refactoringStatus;
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fPackage);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fPackage, (int)2);
        return RefactoringSearchEngine.search(pattern, scope, pm, status);
    }

    private List getReferencesToTypesInNamesakes(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 2);
        IJavaElement[] elements = new IJavaElement[this.fOccurrences.length + 1];
        int i = 0;
        while (i < this.fOccurrences.length) {
            elements[i] = this.fOccurrences[i].getCompilationUnit();
            ++i;
        }
        elements[this.fOccurrences.length] = this.fPackage;
        IJavaSearchScope namesakePackagesScope = RefactoringScopeFactory.createReferencedScope(elements);
        IPackageFragment[] namesakePackages = this.getNamesakePackages(namesakePackagesScope, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (namesakePackages.length == 0) {
            pm.done();
            return new ArrayList(0);
        }
        IType[] typesToSearch = this.getTypesInPackages(namesakePackages);
        if (typesToSearch.length == 0) {
            pm.done();
            return new ArrayList(0);
        }
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])typesToSearch, 2);
        IJavaSearchScope scope = this.getPackageAndOccurrencesWithoutNamesakesScope();
        SearchResultGroup[] results = RefactoringSearchEngine.search(pattern, scope, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
        pm.done();
        return new ArrayList<SearchResultGroup>(Arrays.asList(results));
    }

    private IPackageFragment[] getNamesakePackages(IJavaSearchScope scope, IProgressMonitor pm) throws CoreException {
        SearchPattern pattern = SearchPattern.createPattern((String)this.fPackage.getElementName(), (int)2, (int)0, (int)8);
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, (SearchRequestor)requestor, pm);
        List results = requestor.getResults();
        ArrayList<IPackageFragment> packageFragments = new ArrayList<IPackageFragment>();
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            IPackageFragment pack;
            SearchMatch result = (SearchMatch)iter.next();
            IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(result);
            if (!(enclosingElement instanceof IPackageFragment) || this.fPackage.equals(pack = (IPackageFragment)enclosingElement)) continue;
            packageFragments.add(pack);
        }
        return packageFragments.toArray(new IPackageFragment[packageFragments.size()]);
    }

    private IType[] getTypesInPackages(IPackageFragment[] packageFragments) throws JavaModelException {
        ArrayList types = new ArrayList();
        int i = 0;
        while (i < packageFragments.length) {
            IPackageFragment pack = packageFragments[i];
            this.addContainedTypes(pack, types);
            ++i;
        }
        return types.toArray(new IType[types.size()]);
    }

    private IType[] getTypesInPackage(IPackageFragment packageFragment) throws JavaModelException {
        ArrayList types = new ArrayList();
        this.addContainedTypes(packageFragment, types);
        return types.toArray(new IType[types.size()]);
    }

    private void addContainedTypes(IPackageFragment pack, List typesCollector) throws JavaModelException {
        IJavaElement[] children = pack.getChildren();
        int c = 0;
        while (c < children.length) {
            IJavaElement child = children[c];
            if (child instanceof ICompilationUnit) {
                typesCollector.addAll(Arrays.asList(((ICompilationUnit)child).getTypes()));
            }
            ++c;
        }
    }

    private IJavaSearchScope getPackageAndOccurrencesWithoutNamesakesScope() {
        ArrayList<Object> scopeList = new ArrayList<Object>();
        scopeList.add(this.fPackage);
        int i = 0;
        while (i < this.fOccurrences.length) {
            IPackageFragment pack;
            ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
            if (cu != null && !(pack = (IPackageFragment)cu.getParent()).getElementName().equals(this.fPackage.getElementName())) {
                scopeList.add(cu);
            }
            ++i;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])scopeList.toArray(new IJavaElement[scopeList.size()]));
    }

    private List getReferencesToTypesInPackage(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 2);
        IJavaSearchScope referencedFromNamesakesScope = RefactoringScopeFactory.create((IJavaElement)this.fPackage);
        IPackageFragment[] namesakePackages = this.getNamesakePackages(referencedFromNamesakesScope, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (namesakePackages.length == 0) {
            pm.done();
            return new ArrayList(0);
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])namesakePackages);
        IType[] typesToSearch = this.getTypesInPackage(this.fPackage);
        if (typesToSearch.length == 0) {
            pm.done();
            return new ArrayList(0);
        }
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])typesToSearch, 2);
        SearchResultGroup[] results = RefactoringSearchEngine.search(pattern, scope, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
        pm.done();
        return new ArrayList<SearchResultGroup>(Arrays.asList(results));
    }

    private RefactoringStatus checkForMainMethods() throws CoreException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(Checks.checkForMainMethods(cus[i]));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkForNativeMethods() throws CoreException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(Checks.checkForNativeMethods(cus[i]));
            ++i;
        }
        return result;
    }

    public static boolean isPackageNameOkInRoot(String newName, IPackageFragmentRoot root) throws CoreException {
        IPackageFragment pack = root.getPackageFragment(newName);
        if (!pack.exists()) {
            return true;
        }
        if (!pack.hasSubpackages()) {
            return false;
        }
        if (pack.containsJavaResources()) {
            return false;
        }
        return pack.getNonJavaResources().length == 0;
    }

    private RefactoringStatus checkPackageInCurrentRoot(String newName) throws CoreException {
        if (RenamePackageProcessor.isPackageNameOkInRoot(newName, this.getPackageFragmentRoot())) {
            return null;
        }
        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenamePackageRefactoring_package_exists);
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        return (IPackageFragmentRoot)this.fPackage.getParent();
    }

    private RefactoringStatus checkPackageName(String newName) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        IPackageFragmentRoot[] roots = this.fPackage.getJavaProject().getPackageFragmentRoots();
        Set topLevelTypeNames = this.getTopLevelTypeNames();
        int i = 0;
        while (i < roots.length) {
            if (!RenamePackageProcessor.isPackageNameOkInRoot(newName, roots[i])) {
                String message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_aleady_exists, new Object[]{this.getNewElementName(), roots[i].getElementName()});
                status.merge(RefactoringStatus.createWarningStatus((String)message));
                status.merge(this.checkTypeNameConflicts(roots[i], newName, topLevelTypeNames));
            }
            ++i;
        }
        return status;
    }

    private Set getTopLevelTypeNames() throws CoreException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        HashSet result = new HashSet(2 * cus.length);
        int i = 0;
        while (i < cus.length) {
            result.addAll(RenamePackageProcessor.getTopLevelTypeNames(cus[i]));
            ++i;
        }
        return result;
    }

    private static Collection getTopLevelTypeNames(ICompilationUnit iCompilationUnit) throws CoreException {
        IType[] types = iCompilationUnit.getTypes();
        ArrayList<String> result = new ArrayList<String>(types.length);
        int i = 0;
        while (i < types.length) {
            result.add(types[i].getElementName());
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(IPackageFragmentRoot root, String newName, Set topLevelTypeNames) throws CoreException {
        IPackageFragment otherPack = root.getPackageFragment(newName);
        if (this.fPackage.equals(otherPack)) {
            return null;
        }
        ICompilationUnit[] cus = otherPack.getCompilationUnits();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(this.checkTypeNameConflicts(cus[i], topLevelTypeNames));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(ICompilationUnit iCompilationUnit, Set topLevelTypeNames) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] types = iCompilationUnit.getTypes();
        String packageName = iCompilationUnit.getParent().getElementName();
        int i = 0;
        while (i < types.length) {
            String name = types[i].getElementName();
            if (topLevelTypeNames.contains(name)) {
                Object[] keys = new String[]{packageName, name};
                String msg = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_contains_type, keys);
                RefactoringStatusContext context = JavaStatusContext.create((IMember)types[i]);
                result.addError(msg, context);
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus analyzeAffectedCompilationUnits() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
        return result;
    }

    private IFile[] getAllCusInPackageAsFiles() throws CoreException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        ArrayList<IResource> files = new ArrayList<IResource>(cus.length);
        int i = 0;
        while (i < cus.length) {
            IResource res = ResourceUtil.getResource(cus[i]);
            if (res != null && res.getType() == 1) {
                files.add(res);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        ArrayList<IFile> combined = new ArrayList<IFile>();
        combined.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        combined.addAll(Arrays.asList(this.getAllCusInPackageAsFiles()));
        if (this.fQualifiedNameSearchResult != null) {
            combined.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        return combined.toArray(new IFile[combined.size()]);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        try {
            pm.beginTask(RefactoringCoreMessages.RenamePackageRefactoring_creating_change, 1);
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.Change_javaChanges);
            result.addAll((Change[])this.fChangeManager.getAllChanges());
            result.add(new RenamePackageChange(this.fPackage, this.getNewElementName()));
            pm.worked(1);
            dynamicValidationStateChange = result;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fQualifiedNameSearchResult != null) {
            return this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(participantChanges));
        }
        return null;
    }

    private void addTextMatches(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        TextMatchUpdater.perform(pm, RefactoringScopeFactory.create((IJavaElement)this.fPackage), this, manager, this.fOccurrences);
    }

    private TextEdit createTextChange(SearchMatch searchResult) {
        return new ReplaceEdit(searchResult.getOffset(), searchResult.getLength(), this.getNewElementName());
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        TextChangeManager manager = new TextChangeManager();
        if (this.fUpdateReferences) {
            this.addReferenceUpdates(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        if (this.fUpdateTextualMatches) {
            pm.subTask(RefactoringCoreMessages.RenamePackageRefactoring_searching_text);
            this.addTextMatches(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        pm.done();
        return manager;
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        ImportRewrite importRewrite;
        pm.beginTask("", this.fOccurrences.length + this.fReferencesToTypesInPackage.size() + this.fReferencesToTypesInNamesakes.size());
        int i = 0;
        while (i < this.fOccurrences.length) {
            ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
            if (cu != null) {
                SearchResultGroup typeRefsRequiringNewNameImport;
                SearchResultGroup typeRefsRequiringOldNameImport;
                String name = RefactoringCoreMessages.RenamePackageRefactoring_update_reference;
                ImportRewrite importRewrite2 = null;
                SearchMatch[] results = this.fOccurrences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    SearchMatch result = results[j];
                    if (RenamePackageProcessor.isImport(result)) {
                        if (importRewrite2 == null) {
                            importRewrite2 = this.newImportRewrite(cu);
                        }
                        IImportDeclaration importDeclaration = (IImportDeclaration)SearchUtils.getEnclosingJavaElement(result);
                        String updatedImport = this.getUpdatedImport(importDeclaration);
                        RenamePackageProcessor.updateImport(importRewrite2, importDeclaration, updatedImport);
                    } else {
                        TextChangeCompatibility.addTextEdit(manager.get(cu), name, this.createTextChange(result));
                    }
                    ++j;
                }
                if (this.fReferencesToTypesInNamesakes.size() != 0 && (typeRefsRequiringOldNameImport = RenamePackageProcessor.extractGroupFor(cu, this.fReferencesToTypesInNamesakes)) != null) {
                    importRewrite2 = this.addTypeImports(importRewrite2, typeRefsRequiringOldNameImport);
                }
                if (this.fReferencesToTypesInPackage.size() != 0 && (typeRefsRequiringNewNameImport = RenamePackageProcessor.extractGroupFor(cu, this.fReferencesToTypesInPackage)) != null) {
                    importRewrite2 = this.updateTypeImports(importRewrite2, typeRefsRequiringNewNameImport);
                }
                if (importRewrite2 != null) {
                    this.addImportEdits(manager, importRewrite2);
                }
                pm.worked(1);
            }
            ++i;
        }
        if (this.fReferencesToTypesInNamesakes.size() != 0) {
            Iterator iter = this.fReferencesToTypesInNamesakes.iterator();
            while (iter.hasNext()) {
                SearchResultGroup referencesToTypesInNamesakes = (SearchResultGroup)iter.next();
                importRewrite = this.addTypeImports(null, referencesToTypesInNamesakes);
                if (importRewrite != null) {
                    this.addImportEdits(manager, importRewrite);
                }
                pm.worked(1);
            }
        }
        if (this.fReferencesToTypesInPackage.size() != 0) {
            Iterator iter = this.fReferencesToTypesInPackage.iterator();
            while (iter.hasNext()) {
                SearchResultGroup namesakeReferencesToPackage = (SearchResultGroup)iter.next();
                importRewrite = this.updateTypeImports(null, namesakeReferencesToPackage);
                if (importRewrite != null) {
                    this.addImportEdits(manager, importRewrite);
                }
                pm.worked(1);
            }
        }
        pm.done();
    }

    private static void updateImport(ImportRewrite importRewrite, IImportDeclaration importDeclaration, String updatedImport) throws JavaModelException {
        if (Flags.isStatic((int)importDeclaration.getFlags())) {
            importRewrite.removeStaticImport(importDeclaration.getElementName());
            importRewrite.addStaticImport(Signature.getQualifier((String)updatedImport), Signature.getSimpleName((String)updatedImport), true);
        } else {
            importRewrite.removeImport(importDeclaration.getElementName());
            importRewrite.addImport(updatedImport);
        }
    }

    private ImportRewrite newImportRewrite(ICompilationUnit cu) throws CoreException {
        ImportRewrite rewrite = new ImportRewrite(cu);
        rewrite.setFilterImplicitImports(false);
        return rewrite;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addImportEdits(TextChangeManager manager, ImportRewrite importRewrite) throws CoreException {
        if (importRewrite.isEmpty()) return;
        ICompilationUnit cu = importRewrite.getCompilationUnit();
        try {
            ITextFileBuffer buffer = RefactoringFileBuffers.acquire(cu);
            TextEdit importEdit = importRewrite.createEdit(buffer.getDocument(), null);
            String name = RefactoringCoreMessages.RenamePackageRefactoring_update_imports;
            TextChangeCompatibility.addTextEdit(manager.get(cu), name, importEdit);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            RefactoringFileBuffers.release(cu);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        RefactoringFileBuffers.release(cu);
    }

    private ImportRewrite addTypeImports(ImportRewrite importRewrite, SearchResultGroup typeReferences) throws CoreException {
        SearchMatch[] searchResults = typeReferences.getSearchResults();
        int i = 0;
        while (i < searchResults.length) {
            String reference;
            SearchMatch result = searchResults[i];
            IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(result);
            if (!(enclosingElement instanceof IImportDeclaration) && !(reference = RenamePackageProcessor.getNormalizedTypeReference(result)).startsWith(this.fPackage.getElementName())) {
                reference = RenamePackageProcessor.cutOffInnerTypes(reference);
                if (importRewrite == null) {
                    importRewrite = this.newImportRewrite(typeReferences.getCompilationUnit());
                }
                importRewrite.addImport(String.valueOf(this.fPackage.getElementName()) + '.' + reference);
            }
            ++i;
        }
        return importRewrite;
    }

    private ImportRewrite updateTypeImports(ImportRewrite importRewrite, SearchResultGroup typeReferences) throws CoreException {
        SearchMatch[] searchResults = typeReferences.getSearchResults();
        int i = 0;
        while (i < searchResults.length) {
            SearchMatch result = searchResults[i];
            IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(result);
            if (enclosingElement instanceof IImportDeclaration) {
                IImportDeclaration importDeclaration = (IImportDeclaration)enclosingElement;
                if (importRewrite == null) {
                    importRewrite = this.newImportRewrite(typeReferences.getCompilationUnit());
                }
                RenamePackageProcessor.updateImport(importRewrite, importDeclaration, this.getUpdatedImport(importDeclaration));
            } else {
                String reference = RenamePackageProcessor.getNormalizedTypeReference(result);
                if (!reference.startsWith(this.fPackage.getElementName())) {
                    reference = RenamePackageProcessor.cutOffInnerTypes(reference);
                    if (importRewrite == null) {
                        importRewrite = this.newImportRewrite(typeReferences.getCompilationUnit());
                    }
                    importRewrite.removeImport(String.valueOf(this.fPackage.getElementName()) + '.' + reference);
                    importRewrite.addImport(String.valueOf(this.getNewElementName()) + '.' + reference);
                }
            }
            ++i;
        }
        return importRewrite;
    }

    private static String getNormalizedTypeReference(SearchMatch searchResult) throws JavaModelException {
        ICompilationUnit cu = SearchUtils.getCompilationUnit(searchResult);
        String reference = cu.getBuffer().getText(searchResult.getOffset(), searchResult.getLength());
        return CommentAnalyzer.normalizeReference(reference);
    }

    private static String cutOffInnerTypes(String reference) {
        int dotPos = reference.indexOf(46);
        if (dotPos != -1) {
            reference = reference.substring(0, dotPos);
        }
        return reference;
    }

    private String getUpdatedImport(IImportDeclaration importDeclaration) {
        String fullyQualifiedImportType = importDeclaration.getElementName();
        int offsetOfDotBeforeTypeName = this.fPackage.getElementName().length();
        String result = String.valueOf(this.getNewElementName()) + fullyQualifiedImportType.substring(offsetOfDotBeforeTypeName);
        return result;
    }

    private static boolean isImport(SearchMatch searchResult) {
        return SearchUtils.getEnclosingJavaElement(searchResult) instanceof IImportDeclaration;
    }

    private static SearchResultGroup extractGroupFor(ICompilationUnit cu, List searchResultGroups) {
        Iterator iter = searchResultGroups.iterator();
        while (iter.hasNext()) {
            SearchResultGroup group = (SearchResultGroup)iter.next();
            if (!cu.equals(group.getCompilationUnit())) continue;
            iter.remove();
            return group;
        }
        return null;
    }

    private void computeQualifiedNameMatches(IProgressMonitor pm) throws CoreException {
        if (this.fQualifiedNameSearchResult == null) {
            this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        }
        QualifiedNameFinder.process(this.fQualifiedNameSearchResult, this.fPackage.getElementName(), this.getNewElementName(), this.fFilePatterns, this.fPackage.getJavaProject().getProject(), pm);
    }
}

