/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaRefactorings;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class RenameLocalVariableProcessor
extends JavaRenameProcessor
implements INameUpdating,
IReferenceUpdating {
    private final ILocalVariable fLocalVariable;
    private final ICompilationUnit fCu;
    private boolean fUpdateReferences;
    private String fCurrentName;
    private String fNewName;
    private CompilationUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    private TextChange fChange;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameTypeParameterProcessor";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public RenameLocalVariableProcessor(ILocalVariable localVariable) {
        Assert.isNotNull(localVariable);
        this.fLocalVariable = localVariable;
        this.fUpdateReferences = true;
        this.fCu = (ICompilationUnit)localVariable.getAncestor(5);
        this.fNewName = "";
    }

    public boolean needsSavedEditors() {
        return false;
    }

    protected final void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
    }

    protected final String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fLocalVariable);
    }

    public Object[] getElements() {
        return new Object[]{this.fLocalVariable};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameTempRefactoring_rename;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fLocalVariable);
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public String getCurrentElementName() {
        return this.fCurrentName;
    }

    public String getNewElementName() {
        return this.fNewName;
    }

    public void setNewElementName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public Object getNewElement() {
        return null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        this.initAST();
        if (this.fTempDeclarationNode == null || this.fTempDeclarationNode.resolveBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameTempRefactoring_must_select_local);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz)) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.Initializer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz2)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameTempRefactoring_only_in_methods_and_initializers);
            }
        }
        this.initNames();
        return new RefactoringStatus();
    }

    private void initAST() throws JavaModelException {
        this.fCompilationUnitNode = new RefactoringASTParser(3).parse(this.fCu, true);
        ISourceRange sourceRange = this.fLocalVariable.getNameRange();
        ASTNode name = NodeFinder.perform((ASTNode)this.fCompilationUnitNode, sourceRange);
        if (name == null) {
            return;
        }
        if (name.getParent() instanceof VariableDeclaration) {
            this.fTempDeclarationNode = (VariableDeclaration)name.getParent();
        }
    }

    private void initNames() {
        this.fCurrentName = this.fTempDeclarationNode.getName().getIdentifier();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result;
        block7: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask("", 1);
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ValidateEditChecker checker = (ValidateEditChecker)context.getChecker((Class)clazz);
                checker.addFile(ResourceUtil.getFile(this.fCu));
                result = this.checkNewElementName(this.fNewName);
                if (!result.hasFatalError()) break block7;
                refactoringStatus = result;
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        result.merge(this.analyzeAST());
        RefactoringStatus refactoringStatus = result;
        Object var5_8 = null;
        pm.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkNewElementName(String newName) throws JavaModelException {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (!Checks.startsWithLowerCase(newName)) {
            result.addWarning(RefactoringCoreMessages.RenameTempRefactoring_lowercase);
        }
        return result;
    }

    private RefactoringStatus analyzeAST() throws CoreException {
        TextEdit declarationEdit = this.createRenameEdit(this.fTempDeclarationNode.getName().getStartPosition());
        TextEdit[] allRenameEdits = this.getAllRenameEdits(declarationEdit);
        this.fChange = new CompilationUnitChange(RefactoringCoreMessages.RenameTempRefactoring_rename, this.fCu);
        MultiTextEdit rootEdit = new MultiTextEdit();
        this.fChange.setEdit((TextEdit)rootEdit);
        this.fChange.setKeepPreviewEdits(true);
        String changeName = Messages.format(RefactoringCoreMessages.RenameTempRefactoring_changeName, new String[]{this.fCurrentName, this.fNewName});
        int i = 0;
        while (i < allRenameEdits.length) {
            rootEdit.addChild(allRenameEdits[i]);
            this.fChange.addTextEditGroup(new TextEditGroup(changeName, allRenameEdits[i]));
            ++i;
        }
        String newCuSource = this.fChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        ASTParser p = ASTParser.newParser((int)3);
        p.setSource(newCuSource.toCharArray());
        p.setUnitName(this.fCu.getElementName());
        p.setProject(this.fCu.getJavaProject());
        p.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)this.fCu));
        CompilationUnit newCUNode = (CompilationUnit)p.createAST(null);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.analyzeCompileErrors(newCuSource, newCUNode));
        if (result.hasError()) {
            return result;
        }
        String fullKey = RefactoringAnalyzeUtil.getFullBindingKey(this.fTempDeclarationNode);
        ASTNode enclosing = this.getEnclosingBlockOrMethod(declarationEdit, this.fChange, newCUNode);
        SimpleName[] problemNodes = ProblemNodeFinder.getProblemNodes(enclosing, allRenameEdits, this.fChange, fullKey);
        result.merge(RefactoringAnalyzeUtil.reportProblemNodes(newCuSource, problemNodes));
        return result;
    }

    private TextEdit[] getAllRenameEdits(TextEdit declarationEdit) {
        if (!this.fUpdateReferences) {
            return new TextEdit[]{declarationEdit};
        }
        TempOccurrenceAnalyzer fTempAnalyzer = new TempOccurrenceAnalyzer(this.fTempDeclarationNode, true);
        fTempAnalyzer.perform();
        int[] referenceOffsets = fTempAnalyzer.getReferenceAndJavadocOffsets();
        TextEdit[] allRenameEdits = new TextEdit[referenceOffsets.length + 1];
        int i = 0;
        while (i < referenceOffsets.length) {
            allRenameEdits[i] = this.createRenameEdit(referenceOffsets[i]);
            ++i;
        }
        allRenameEdits[referenceOffsets.length] = declarationEdit;
        return allRenameEdits;
    }

    private TextEdit createRenameEdit(int offset) {
        return new ReplaceEdit(offset, this.fCurrentName.length(), this.fNewName);
    }

    private ASTNode getEnclosingBlockOrMethod(TextEdit declarationEdit, TextChange change, CompilationUnit newCUNode) {
        Block enclosing = RefactoringAnalyzeUtil.getBlock(declarationEdit, change, newCUNode);
        if (enclosing == null) {
            enclosing = RefactoringAnalyzeUtil.getMethodDeclaration(declarationEdit, change, newCUNode);
        }
        return enclosing;
    }

    private RefactoringStatus analyzeCompileErrors(String newCuSource, CompilationUnit newCUNode) {
        RefactoringStatus result = new RefactoringStatus();
        IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fCompilationUnitNode);
        int i = 0;
        while (i < newProblems.length) {
            IProblem problem = newProblems[i];
            if (problem.isError()) {
                result.addEntry(JavaRefactorings.createStatusEntry(problem, newCuSource));
            }
            ++i;
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.done();
        return this.fChange;
    }

    private static class ProblemNodeFinder {
        ProblemNodeFinder() {
        }

        public static SimpleName[] getProblemNodes(ASTNode methodNode, TextEdit[] edits, TextChange change, String key) {
            NameNodeVisitor visitor = new NameNodeVisitor(edits, change, key);
            methodNode.accept((ASTVisitor)visitor);
            return visitor.getProblemNodes();
        }

        private static class NameNodeVisitor
        extends ASTVisitor {
            private Collection fRanges;
            private Collection fProblemNodes;
            private String fKey;
            static /* synthetic */ Class class$0;

            public NameNodeVisitor(TextEdit[] edits, TextChange change, String key) {
                Assert.isNotNull(edits);
                Assert.isNotNull(key);
                this.fRanges = new HashSet<IRegion>(Arrays.asList(RefactoringAnalyzeUtil.getNewRanges(edits, change)));
                this.fProblemNodes = new ArrayList(0);
                this.fKey = key;
            }

            public SimpleName[] getProblemNodes() {
                return this.fProblemNodes.toArray(new SimpleName[this.fProblemNodes.size()]);
            }

            private static VariableDeclaration getVariableDeclaration(Name node) {
                IBinding binding = node.resolveBinding();
                if (binding == null && node.getParent() instanceof VariableDeclaration) {
                    return (VariableDeclaration)node.getParent();
                }
                if (binding != null && binding.getKind() == 3) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    CompilationUnit cu = (CompilationUnit)ASTNodes.getParent((ASTNode)node, clazz);
                    return ASTNodes.findVariableDeclaration((IVariableBinding)binding, (ASTNode)cu);
                }
                return null;
            }

            public boolean visit(SimpleName node) {
                VariableDeclaration decl = NameNodeVisitor.getVariableDeclaration((Name)node);
                if (decl == null) {
                    return super.visit(node);
                }
                boolean keysEqual = this.fKey.equals(RefactoringAnalyzeUtil.getFullBindingKey(decl));
                boolean rangeInSet = this.fRanges.contains(new Region(node.getStartPosition(), node.getLength()));
                if (keysEqual && !rangeInSet) {
                    this.fProblemNodes.add(node);
                }
                if (!keysEqual && rangeInSet) {
                    this.fProblemNodes.add(node);
                }
                return super.visit(node);
            }
        }
    }
}

