/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.Utils;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DeleteFileChange
extends AbstractDeleteChange {
    private final IPath fPath;
    private final boolean fIsExecuteChange;

    public DeleteFileChange(IFile file, boolean executeChange) {
        Assert.isNotNull(file, "file");
        this.fPath = Utils.getResourcePath((IResource)file);
        this.fIsExecuteChange = executeChange;
    }

    private IFile getFile() {
        return Utils.getFile(this.fPath);
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.DeleteFileChange_1, this.fPath.lastSegment());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (this.fIsExecuteChange) {
            return super.isValid(pm, 0);
        }
        return super.isValid(pm, 3);
    }

    public Object getModifiedElement() {
        return this.getFile();
    }

    protected void doDelete(IProgressMonitor pm) throws CoreException {
        IFile file = this.getFile();
        Assert.isNotNull(file);
        Assert.isTrue(file.exists());
        pm.beginTask("", 2);
        DeleteFileChange.saveFileIfNeeded(file, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        file.delete(false, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.done();
    }
}

