/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    Point getIMCaretPos() {
        if (this.caret == null) {
            return super.getIMCaretPos();
        }
        return new Point(this.caret.x, this.caret.y);
    }

    int gtk_expose_event(int widget, int event) {
        boolean isFocus;
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.gtk_expose_event(widget, event);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    int gtk_focus_in_event(int widget, int event) {
        int result = super.gtk_focus_in_event(widget, event);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return result;
    }

    int gtk_focus_out_event(int widget, int event) {
        int result = super.gtk_focus_out_event(widget, event);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return result;
    }

    void redrawWidget(int x, int y, int width, int height, boolean all) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redrawWidget(x, y, width, height, all);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    void releaseWidget() {
        if (this.caret != null) {
            this.caret.releaseResources();
        }
        this.caret = null;
        super.releaseWidget();
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        GdkRectangle rect;
        boolean disjoint;
        boolean isFocus;
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int window = this.paintWindow();
        int visibleRegion = OS.gdk_drawable_get_visible_region(window);
        GdkRectangle srcRect = new GdkRectangle();
        srcRect.x = x;
        srcRect.y = y;
        srcRect.width = width;
        srcRect.height = height;
        int copyRegion = OS.gdk_region_rectangle(srcRect);
        OS.gdk_region_intersect(copyRegion, visibleRegion);
        int invalidateRegion = OS.gdk_region_rectangle(srcRect);
        OS.gdk_region_subtract(invalidateRegion, visibleRegion);
        OS.gdk_region_offset(invalidateRegion, deltaX, deltaY);
        GdkRectangle copyRect = new GdkRectangle();
        OS.gdk_region_get_clipbox(copyRegion, copyRect);
        if (copyRect.width != 0 && copyRect.height != 0) {
            this.update();
        }
        int gdkGC = OS.gdk_gc_new(window);
        OS.gdk_gc_set_exposures(gdkGC, true);
        OS.gdk_draw_drawable(window, gdkGC, window, copyRect.x, copyRect.y, copyRect.x + deltaX, copyRect.y + deltaY, copyRect.width, copyRect.height);
        OS.g_object_unref(gdkGC);
        boolean bl2 = disjoint = destX + width < x || x + width < destX || destY + height < y || y + height < destY;
        if (disjoint) {
            rect = new GdkRectangle();
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
            OS.gdk_region_union_with_rect(invalidateRegion, rect);
        } else {
            rect = new GdkRectangle();
            if (deltaX != 0) {
                int newX = destX - deltaX;
                if (deltaX < 0) {
                    newX = destX + width;
                }
                rect.x = newX;
                rect.y = y;
                rect.width = Math.abs(deltaX);
                rect.height = height;
                OS.gdk_region_union_with_rect(invalidateRegion, rect);
            }
            if (deltaY != 0) {
                int newY = destY - deltaY;
                if (deltaY < 0) {
                    newY = destY + height;
                }
                rect.x = x;
                rect.y = newY;
                rect.width = width;
                rect.height = Math.abs(deltaY);
                OS.gdk_region_union_with_rect(invalidateRegion, rect);
            }
        }
        OS.gdk_window_invalidate_region(window, invalidateRegion, all);
        OS.gdk_region_destroy(visibleRegion);
        OS.gdk_region_destroy(copyRegion);
        OS.gdk_region_destroy(invalidateRegion);
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                Rectangle rect2 = child.getBounds();
                if (Math.min(x + width, rect2.x + rect2.width) >= Math.max(x, rect2.x) && Math.min(y + height, rect2.y + rect2.height) >= Math.max(y, rect2.y)) {
                    child.setLocation(rect2.x + deltaX, rect2.y + deltaY);
                }
                ++i;
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.setBounds(x, y, width, height, move, resize);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.hasFocus()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    void updateCaret() {
        int imHandle = this.imHandle();
        if (imHandle == 0) {
            return;
        }
        GdkRectangle rect = new GdkRectangle();
        rect.x = this.caret.x;
        rect.y = this.caret.y;
        rect.width = this.caret.width;
        rect.height = this.caret.height;
        OS.gtk_im_context_set_cursor_location(imHandle, rect);
    }
}

