/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_font_extents_t;

public class Path
extends Resource {
    public int handle;
    boolean move;

    public Path(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        device.checkCairo();
        this.handle = Cairo.cairo_create();
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.move = true;
        int matrix = Cairo.cairo_matrix_create();
        Cairo.cairo_current_matrix(this.handle, matrix);
        double lineWidth = Cairo.cairo_current_line_width(this.handle);
        Cairo.cairo_translate(this.handle, x + width / 2.0f, y + height / 2.0f);
        Cairo.cairo_scale(this.handle, width / 2.0f, height / 2.0f);
        Cairo.cairo_set_line_width(this.handle, lineWidth / (double)(width / 2.0f));
        Cairo.cairo_arc_negative(this.handle, 0.0, 0.0, 1.0, -startAngle * (float)Compatibility.PI / 180.0f, -(startAngle + arcAngle) * (float)Compatibility.PI / 180.0f);
        Cairo.cairo_set_line_width(this.handle, lineWidth);
        Cairo.cairo_set_matrix(this.handle, matrix);
        Cairo.cairo_destroy(matrix);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        this.move = false;
        Cairo.cairo_add_path(this.handle, path.handle);
    }

    public void addRectangle(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.move = false;
        Cairo.cairo_rectangle(this.handle, x, y, width, height);
    }

    public void addString(String string, float x, float y, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        this.move = false;
        GC.setCairoFont(this.handle, font);
        cairo_font_extents_t extents = new cairo_font_extents_t();
        Cairo.cairo_current_font_extents(this.handle, extents);
        double baseline = y + extents.ascent;
        Cairo.cairo_move_to(this.handle, x, baseline);
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        Cairo.cairo_text_path(this.handle, buffer);
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_close_path(this.handle);
        this.move = false;
    }

    public boolean contains(float x, float y, GC gc, boolean outline) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        gc.initCairo();
        boolean result = false;
        int cairo = gc.data.cairo;
        Cairo.cairo_add_path(cairo, this.handle);
        result = outline ? Cairo.cairo_in_stroke(cairo, x, y) != 0 : Cairo.cairo_in_fill(cairo, x, y) != 0;
        Cairo.cairo_new_path(cairo);
        return result;
    }

    public void cubicTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (!this.move) {
            double[] currentX = new double[1];
            double[] currentY = new double[1];
            Cairo.cairo_current_point(this.handle, currentX, currentY);
            Cairo.cairo_move_to(this.handle, currentX[0], currentY[0]);
        }
        this.move = true;
        Cairo.cairo_curve_to(this.handle, cx1, cy1, cx2, cy2, x, y);
    }

    public void getBounds(float[] bounds) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (bounds.length < 4) {
            SWT.error(5);
        }
        double[] extents = new double[4];
        Cairo.cairo_extents(this.handle, extents);
        bounds[0] = (float)extents[0];
        bounds[1] = (float)extents[1];
        bounds[2] = (float)(extents[2] - extents[0]);
        bounds[3] = (float)(extents[3] - extents[1]);
    }

    public void getCurrentPoint(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        double[] x = new double[1];
        double[] y = new double[1];
        Cairo.cairo_current_point(this.handle, x, y);
        point[0] = (float)x[0];
        point[1] = (float)y[0];
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int[] n_types = new int[1];
        int[] n_points = new int[1];
        Cairo.cairo_points(this.handle, n_types, n_points, null, null);
        byte[] types = new byte[n_types[0]];
        float[] points = new float[n_points[0] * 2];
        Cairo.cairo_points(this.handle, n_types, n_points, types, points);
        PathData result = new PathData();
        result.types = types;
        result.points = points;
        return result;
    }

    public void lineTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (!this.move) {
            double[] currentX = new double[1];
            double[] currentY = new double[1];
            Cairo.cairo_current_point(this.handle, currentX, currentY);
            Cairo.cairo_move_to(this.handle, currentX[0], currentY[0]);
        }
        this.move = true;
        Cairo.cairo_line_to(this.handle, x, y);
    }

    public void moveTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.move = true;
        Cairo.cairo_move_to(this.handle, x, y);
    }

    public void quadTo(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        double[] currentX = new double[1];
        double[] currentY = new double[1];
        Cairo.cairo_current_point(this.handle, currentX, currentY);
        if (!this.move) {
            Cairo.cairo_move_to(this.handle, currentX[0], currentY[0]);
        }
        this.move = true;
        float x0 = (float)currentX[0];
        float y0 = (float)currentY[0];
        float cx1 = x0 + 2.0f * (cx - x0) / 3.0f;
        float cy1 = y0 + 2.0f * (cy - y0) / 3.0f;
        float cx2 = cx1 + (x - x0) / 3.0f;
        float cy2 = cy1 + (y - y0) / 3.0f;
        Cairo.cairo_curve_to(this.handle, cx1, cy1, cx2, cy2, x, y);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        Cairo.cairo_destroy(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

