/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class SeeAlsoPart
extends AbstractFormPart
implements IHelpPart {
    private Composite container;
    private Composite linkContainer;
    private ReusableHelpPart helpPart;
    private String id;

    public SeeAlsoPart(Composite parent, FormToolkit toolkit) {
        this.container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.container.setLayout((Layout)layout);
        Composite sep = toolkit.createCompositeSeparator(this.container);
        GridData gd = new GridData(256);
        gd.heightHint = 1;
        sep.setLayoutData((Object)gd);
        Composite innerContainer = toolkit.createComposite(this.container);
        innerContainer.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        innerContainer.setLayout((Layout)layout);
        Label label = toolkit.createLabel(innerContainer, Messages.SeeAlsoPart_goto);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.linkContainer = toolkit.createComposite(innerContainer);
        this.linkContainer.setLayoutData((Object)new GridData(1808));
        RowLayout rlayout = new RowLayout();
        rlayout.marginBottom = 0;
        rlayout.marginTop = 0;
        rlayout.marginLeft = 0;
        rlayout.marginRight = 0;
        rlayout.justify = false;
        rlayout.wrap = true;
        this.linkContainer.setLayout((Layout)rlayout);
    }

    private void updateLinks(String href) {
        Control[] children = this.linkContainer.getChildren();
        int i = 0;
        while (i < children.length) {
            ImageHyperlink link = (ImageHyperlink)children[i];
            RowData data = (RowData)link.getLayoutData();
            data.exclude = link.getHref().equals(href);
            link.setVisible(!data.exclude);
            ++i;
        }
        this.linkContainer.layout();
        this.helpPart.reflow();
    }

    private void addLinks(final Composite container, FormToolkit toolkit) {
        HyperlinkAdapter listener = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                container.getDisplay().asyncExec(new Runnable(this, e){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ HyperlinkEvent val$e;
                    {
                        this.this$1 = var1_1;
                        this.val$e = hyperlinkEvent;
                    }

                    public void run() {
                        SeeAlsoPart.access$0(1.access$0(this.this$1)).showPage((String)this.val$e.getHref(), true);
                    }
                });
            }

            static /* synthetic */ SeeAlsoPart access$0(1 var0) {
                return var0.SeeAlsoPart.this;
            }
        };
        if ((this.helpPart.getStyle() & 2) != 0) {
            this.addPageLink(container, toolkit, Messages.SeeAlsoPart_allTopics, "all-topics-page", "etool16/alltopics_co.gif", (IHyperlinkListener)listener);
        }
        if ((this.helpPart.getStyle() & 8) != 0) {
            this.addPageLink(container, toolkit, Messages.SeeAlsoPart_search, "fsearch-page", "etool16/helpsearch_co.gif", (IHyperlinkListener)listener);
        }
        if ((this.helpPart.getStyle() & 4) != 0) {
            this.addPageLink(container, toolkit, Messages.SeeAlsoPart_contextHelp, "context-help-page", "etool16/reltopics_co.gif", (IHyperlinkListener)listener);
        }
        if ((this.helpPart.getStyle() & 0x10) != 0) {
            this.addPageLink(container, toolkit, Messages.SeeAlsoPart_bookmarks, "bookmarks-page", "obj16/bookmarks_view.gif", (IHyperlinkListener)listener);
        }
    }

    private void addPageLink(Composite container, FormToolkit toolkit, String text, String id, String imgRef, IHyperlinkListener listener) {
        String cid = this.helpPart.getCurrentPageId();
        if (cid != null && cid.equals(id)) {
            return;
        }
        ImageHyperlink link = toolkit.createImageHyperlink(container, 64);
        link.setImage(HelpUIResources.getImage(imgRef));
        link.setText(text);
        link.setHref((Object)id);
        link.addHyperlinkListener(listener);
        RowData data = new RowData();
        data.exclude = false;
        link.setLayoutData((Object)data);
    }

    public Control getControl() {
        return this.container;
    }

    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.helpPart = parent;
        this.id = id;
        this.addLinks(this.linkContainer, this.helpPart.getForm().getToolkit());
    }

    public String getId() {
        return this.id;
    }

    public void setVisible(boolean visible) {
        this.container.setVisible(visible);
        if (visible) {
            this.markStale();
        }
    }

    public boolean fillContextMenu(IMenuManager manager) {
        return false;
    }

    public boolean hasFocusControl(Control control) {
        return control.getParent() == this.linkContainer;
    }

    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.COPY.getId())) {
            return this.helpPart.getCopyAction();
        }
        return null;
    }

    public void stop() {
    }

    public void refresh() {
        if (this.linkContainer != null && this.helpPart.getCurrentPageId() != null) {
            this.updateLinks(this.helpPart.getCurrentPageId());
        }
        super.refresh();
    }

    public void toggleRoleFilter() {
    }

    public void refilter() {
    }

    public void saveState(IMemento memento) {
    }

    public void setFocus() {
        if (this.linkContainer != null) {
            this.linkContainer.setFocus();
        }
    }

    static /* synthetic */ ReusableHelpPart access$0(SeeAlsoPart seeAlsoPart) {
        return seeAlsoPart.helpPart;
    }
}

