/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.scheduler;

import java.lang.reflect.Constructor;
import java.util.Calendar;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IStartup;
import org.eclipse.update.internal.scheduler.UpdateSchedulerMessages;
import org.eclipse.update.internal.scheduler.UpdateSchedulerPlugin;

public class SchedulerStartup
implements IStartup {
    public static final String P_ENABLED = "enabled";
    public static final String P_SCHEDULE = "schedule";
    public static final String VALUE_ON_STARTUP = "on-startup";
    public static final String VALUE_ON_SCHEDULE = "on-schedule";
    public static final String P_DOWNLOAD = "download";
    public static final String P_DAY = "day";
    public static final String P_HOUR = "hour";
    private Job job;
    static final Object automaticJobFamily = new Object();
    private IJobChangeListener jobListener;
    public static final String[] DAYS = new String[]{UpdateSchedulerMessages.SchedulerStartup_day, UpdateSchedulerMessages.SchedulerStartup_Monday, UpdateSchedulerMessages.SchedulerStartup_Tuesday, UpdateSchedulerMessages.SchedulerStartup_Wednesday, UpdateSchedulerMessages.SchedulerStartup_Thursday, UpdateSchedulerMessages.SchedulerStartup_Friday, UpdateSchedulerMessages.SchedulerStartup_Saturday, UpdateSchedulerMessages.SchedulerStartup_Sunday};
    public static final String[] HOURS = new String[]{UpdateSchedulerMessages.SchedulerStartup_1AM, UpdateSchedulerMessages.SchedulerStartup_2AM, UpdateSchedulerMessages.SchedulerStartup_3AM, UpdateSchedulerMessages.SchedulerStartup_4AM, UpdateSchedulerMessages.SchedulerStartup_5AM, UpdateSchedulerMessages.SchedulerStartup_6AM, UpdateSchedulerMessages.SchedulerStartup_7AM, UpdateSchedulerMessages.SchedulerStartup_8AM, UpdateSchedulerMessages.SchedulerStartup_9AM, UpdateSchedulerMessages.SchedulerStartup_10AM, UpdateSchedulerMessages.SchedulerStartup_11AM, UpdateSchedulerMessages.SchedulerStartup_12PM, UpdateSchedulerMessages.SchedulerStartup_1PM, UpdateSchedulerMessages.SchedulerStartup_2PM, UpdateSchedulerMessages.SchedulerStartup_3PM, UpdateSchedulerMessages.SchedulerStartup_4PM, UpdateSchedulerMessages.SchedulerStartup_5PM, UpdateSchedulerMessages.SchedulerStartup_6PM, UpdateSchedulerMessages.SchedulerStartup_7PM, UpdateSchedulerMessages.SchedulerStartup_8PM, UpdateSchedulerMessages.SchedulerStartup_9PM, UpdateSchedulerMessages.SchedulerStartup_10PM, UpdateSchedulerMessages.SchedulerStartup_11PM, UpdateSchedulerMessages.SchedulerStartup_12AM};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SchedulerStartup() {
        UpdateSchedulerPlugin.setScheduler(this);
    }

    public void earlyStartup() {
        this.scheduleUpdateJob();
    }

    public void scheduleUpdateJob() {
        Preferences pref = UpdateSchedulerPlugin.getDefault().getPluginPreferences();
        if (!pref.getBoolean(P_ENABLED)) {
            return;
        }
        String schedule = pref.getString(P_SCHEDULE);
        long delay = -1L;
        delay = schedule.equals(VALUE_ON_STARTUP) ? (this.job == null ? 0L : -1L) : this.computeDelay(pref);
        if (delay == -1L) {
            return;
        }
        this.startSearch(delay);
    }

    private int getDay(Preferences pref) {
        String day = pref.getString(P_DAY);
        int d = 0;
        while (d < DAYS.length) {
            if (DAYS[d].equals(day)) {
                switch (d) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 5;
                    }
                    case 5: {
                        return 6;
                    }
                    case 6: {
                        return 7;
                    }
                    case 7: {
                        return 1;
                    }
                }
            }
            ++d;
        }
        return -1;
    }

    private int getHour(Preferences pref) {
        String hour = pref.getString(P_HOUR);
        int h = 0;
        while (h < HOURS.length) {
            if (HOURS[h].equals(hour)) {
                return h + 1;
            }
            ++h;
        }
        return 1;
    }

    private long computeDelay(Preferences pref) {
        int target_d = this.getDay(pref);
        int target_h = this.getHour(pref);
        Calendar calendar = Calendar.getInstance();
        int current_d = calendar.get(7);
        int current_h = calendar.get(11);
        int current_m = calendar.get(12);
        int current_s = calendar.get(13);
        int current_ms = calendar.get(14);
        long delay = 0L;
        if (target_d == -1) {
            if (target_h == current_h && current_m == 0 && current_s == 0) {
                return delay;
            }
            int delta_h = target_h - current_h;
            if (target_h <= current_h) {
                delta_h += 24;
            }
            delay = ((delta_h * 60 - current_m) * 60 - current_s) * 1000 - current_ms;
            return delay;
        }
        if (target_d == current_d && target_h == current_h && current_m == 0 && current_s == 0) {
            return delay;
        }
        int delta_d = target_d - current_d;
        if (target_d < current_d || target_d == current_d && (target_h < current_h || target_h == current_h && current_m > 0)) {
            delta_d += 7;
        }
        delay = (((delta_d * 24 + target_h - current_h) * 60 - current_m) * 60 - current_s) * 1000 - current_ms;
        return delay;
    }

    private void startSearch(long delay) {
        if (this.job != null) {
            if (this.jobListener != null) {
                Platform.getJobManager().removeJobChangeListener(this.jobListener);
            }
            Platform.getJobManager().cancel((Object)this.job);
        }
        if (this.jobListener == null) {
            this.jobListener = this.createJobChangeAdapter();
            if (this.jobListener == null) {
                return;
            }
        }
        Platform.getJobManager().addJobChangeListener(this.jobListener);
        String jobName = UpdateSchedulerMessages.AutomaticUpdatesJob_AutomaticUpdateSearch;
        boolean download = UpdateSchedulerPlugin.getDefault().getPluginPreferences().getBoolean(P_DOWNLOAD);
        this.job = this.createUpdateJob(jobName, download);
        if (this.job != null) {
            this.job.schedule(delay);
        }
    }

    private Job createUpdateJob(String name, boolean download) {
        try {
            Class<?> theClass = Class.forName("org.eclipse.update.internal.scheduler.AutomaticUpdateJob");
            Class[] classArray = new Class[3];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            classArray[1] = Boolean.TYPE;
            classArray[2] = Boolean.TYPE;
            Constructor<?> constructor = theClass.getConstructor(classArray);
            return (Job)constructor.newInstance(name, Boolean.TRUE, new Boolean(download));
        }
        catch (Exception e) {
            UpdateSchedulerPlugin.logException(e, false);
            return null;
        }
    }

    private IJobChangeListener createJobChangeAdapter() {
        try {
            Class<?> theClass = Class.forName("org.eclipse.update.internal.scheduler.UpdateJobChangeAdapter");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.update.internal.scheduler.SchedulerStartup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor<?> constructor = theClass.getConstructor(classArray);
            return (IJobChangeListener)constructor.newInstance(this);
        }
        catch (Exception e) {
            UpdateSchedulerPlugin.logException(e, false);
            return null;
        }
    }

    Job getJob() {
        return this.job;
    }
}

