/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.text.DateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public final class Util {
    public static String getString(ResourceBundle resourceBundle, String key) throws IllegalArgumentException {
        if (resourceBundle == null || key == null) {
            throw new IllegalArgumentException();
        }
        String value = key;
        try {
            value = resourceBundle.getString(key);
        }
        catch (MissingResourceException eMissingResource) {
            System.err.println(eMissingResource);
        }
        return value != null ? value.trim() : null;
    }

    public static String getProperty(String property, IMarker marker) {
        if (marker == null) {
            return "";
        }
        try {
            Object obj = marker.getAttribute(property);
            if (obj != null) {
                return obj.toString();
            }
            return "";
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public static String getCreationTime(long timestamp) {
        return DateFormat.getDateTimeInstance(1, 2).format(new Date(timestamp));
    }

    public static String getCreationTime(IMarker marker) {
        try {
            return Util.getCreationTime(marker.getCreationTime());
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public static String getContainerName(IMarker marker) {
        IPath path = marker.getResource().getFullPath();
        int n = path.segmentCount() - 1;
        if (n <= 0) {
            return "";
        }
        int len = 0;
        int i = 0;
        while (i < n) {
            len += path.segment(i).length();
            ++i;
        }
        if (n > 1) {
            len += n - 1;
        }
        StringBuffer sb = new StringBuffer(len);
        int i2 = 0;
        while (i2 < n) {
            if (i2 != 0) {
                sb.append('/');
            }
            sb.append(path.segment(i2));
            ++i2;
        }
        return sb.toString();
    }

    public static String getResourceName(IMarker marker) {
        return marker.getResource().getName();
    }

    public static boolean isEditable(IMarker marker) {
        if (marker == null) {
            return false;
        }
        try {
            return marker.isSubtypeOf("org.eclipse.core.resources.bookmark") || marker.isSubtypeOf("org.eclipse.core.resources.taskmarker") && marker.getAttribute("userEditable", true);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private Util() {
    }
}

