/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class TextEditor
extends AbstractDecoratedTextEditor {
    protected DefaultEncodingSupport fEncodingSupport;
    static /* synthetic */ Class class$0;

    public TextEditor() {
        if (this.getSourceViewerConfiguration() == null) {
            this.setSourceViewerConfiguration(new TextSourceViewerConfiguration(this.getPreferenceStore()));
        }
    }

    protected void initializeEditor() {
        this.setEditorContextMenuId("#TextEditorContext");
        this.setRulerContextMenuId("#TextRulerContext");
        this.setHelpContextId("org.eclipse.ui.text_editor_context");
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
        this.configureInsertMode(SMART_INSERT, false);
        this.setInsertMode(INSERT);
    }

    public void dispose() {
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.dispose();
            this.fEncodingSupport = null;
        }
        super.dispose();
    }

    protected void installEncodingSupport() {
        this.fEncodingSupport = new DefaultEncodingSupport();
        this.fEncodingSupport.initialize(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performSaveAs(IProgressMonitor progressMonitor) {
        IFile original;
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        dialog.create();
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        if (provider.isDeleted((Object)input) && original != null) {
            String message = MessageFormat.format(TextEditorMessages.Editor_warning_save_delete, original.getName());
            dialog.setErrorMessage(null);
            dialog.setMessage(message, 2);
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        FileEditorInput newInput = new FileEditorInput(file);
        boolean success = false;
        try {
            block20: {
                try {
                    provider.aboutToChange((Object)newInput);
                    provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status != null && status.getSeverity() == 8) break block20;
                    String title = TextEditorMessages.Editor_error_save_title;
                    String msg = MessageFormat.format(TextEditorMessages.Editor_error_save_message, x.getMessage());
                    if (status != null) {
                        switch (status.getSeverity()) {
                            case 1: {
                                MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            case 2: {
                                MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            default: {
                                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                        }
                        break block20;
                    }
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
            throw throwable;
        }
        provider.changed((Object)newInput);
        if (success) {
            this.setInput((IEditorInput)newInput);
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createActions() {
        this.installEncodingSupport();
        super.createActions();
    }

    protected String getStatusHeader(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusHeader(status)) != null) {
            return message;
        }
        return super.getStatusHeader(status);
    }

    protected String getStatusBanner(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusBanner(status)) != null) {
            return message;
        }
        return super.getStatusBanner(status);
    }

    protected String getStatusMessage(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusMessage(status)) != null) {
            return message;
        }
        return super.getStatusMessage(status);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.IEncodingSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.fEncodingSupport;
        }
        return super.getAdapter(adapter);
    }

    protected void updatePropertyDependentActions() {
        super.updatePropertyDependentActions();
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "ShiftRight");
        this.addAction(menu, "group.edit", "ShiftLeft");
    }
}

