/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.BaseFeatureFactory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.internal.core.FeatureExecutableContentConsumer;
import org.eclipse.update.internal.core.FeatureExecutableContentProvider;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.TargetFeature;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;

public class FeatureExecutableFactory
extends BaseFeatureFactory {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFeature createFeature(URL url, ISite site, IProgressMonitor monitor) throws CoreException {
        TargetFeature feature = null;
        InputStream featureStream = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (url == null) {
            return this.createFeature(site);
        }
        url = this.validate(url);
        try {
            try {
                FeatureExecutableContentProvider contentProvider = new FeatureExecutableContentProvider(url);
                FeatureExecutableContentConsumer contentConsumer = new FeatureExecutableContentConsumer();
                URL nonResolvedURL = contentProvider.getFeatureManifestReference(null).asURL();
                URL resolvedURL = URLEncoder.encode(nonResolvedURL);
                featureStream = UpdateCore.getPlugin().get(resolvedURL).getInputStream();
                feature = (TargetFeature)this.parseFeature(featureStream, resolvedURL.toExternalForm());
                monitor.worked(1);
                feature.setSite(site);
                feature.setFeatureContentProvider(contentProvider);
                feature.setContentConsumer(contentConsumer);
                feature.resolve(url, url);
                feature.markReadOnly();
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureFactory_CreatingError, (Object[])new String[]{url.toExternalForm()}), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (featureStream == null) throw throwable;
                featureStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        try {}
        catch (IOException iOException) {
            return feature;
        }
        if (featureStream == null) return feature;
        featureStream.close();
        return feature;
    }

    public FeatureModel createFeatureModel() {
        return new TargetFeature();
    }

    private IFeature createFeature(ISite site) throws CoreException {
        TargetFeature feature = null;
        FeatureExecutableContentProvider contentProvider = new FeatureExecutableContentProvider(null);
        FeatureExecutableContentConsumer contentConsumer = new FeatureExecutableContentConsumer();
        feature = (TargetFeature)this.createFeatureModel();
        feature.setSite(site);
        feature.setFeatureContentProvider(contentProvider);
        feature.setContentConsumer(contentConsumer);
        return feature;
    }

    private URL validate(URL url) throws CoreException {
        if (url == null) {
            throw Utilities.newCoreException(Messages.FeatureExecutableFactory_NullURL, null);
        }
        if (!(url.getFile().endsWith("/") || url.getFile().endsWith(File.separator) || url.getFile().endsWith("feature.xml"))) {
            try {
                String path = String.valueOf(url.getFile()) + "/";
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureExecutableFactory_CannotCreateURL, (Object[])new String[]{url.toExternalForm()}), e);
            }
        }
        return url;
    }
}

