/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionSet;
import org.eclipse.osgi.framework.internal.core.FrameworkSecurityManager;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;

public class ConditionalPermissions
extends PermissionCollection {
    private static final long serialVersionUID = 3907215965749000496L;
    AbstractBundle bundle;
    Vector satisfiedCPIs = new Vector();
    ConditionalPermissionSet satisfiedCPS = new ConditionalPermissionSet(new ConditionalPermissionInfoImpl[0], new Condition[0]);
    Vector satisfiableCPSs = new Vector();
    boolean empty;

    public ConditionalPermissions(AbstractBundle bundle, ConditionalPermissionAdmin cpa) {
        this.bundle = bundle;
        Enumeration en = cpa.getConditionalPermissionInfos();
        while (en.hasMoreElements()) {
            ConditionalPermissionInfoImpl cpi = (ConditionalPermissionInfoImpl)en.nextElement();
            this.checkConditionalPermissionInfo(cpi);
        }
    }

    void checkConditionalPermissionInfo(ConditionalPermissionInfoImpl cpi) {
        try {
            Condition[] conds = cpi.getConditions(this.bundle);
            if (conds == null) {
                return;
            }
            boolean satisfied = true;
            int i = 0;
            while (i < conds.length) {
                Condition cond = conds[i];
                if (cond.isMutable()) {
                    satisfied = false;
                } else {
                    if (!cond.isSatisfied()) {
                        return;
                    }
                    conds[i] = null;
                }
                ++i;
            }
            if (satisfied) {
                this.satisfiedCPIs.add(cpi);
            } else {
                this.satisfiableCPSs.add(new ConditionalPermissionSet(new ConditionalPermissionInfoImpl[]{cpi}, conds));
            }
        }
        catch (Exception e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
    }

    public void add(Permission perm) {
    }

    public boolean implies(Permission perm) {
        this.processPending();
        if (this.satisfiedCPS.implies(perm)) {
            this.empty = false;
            return true;
        }
        boolean newEmpty = !this.satisfiedCPS.isNonEmpty();
        boolean satisfied = false;
        Vector<Condition[]> unevalCondsSets = null;
        SecurityManager sm = System.getSecurityManager();
        FrameworkSecurityManager fsm = null;
        if (sm instanceof FrameworkSecurityManager) {
            fsm = (FrameworkSecurityManager)sm;
        }
        ConditionalPermissionSet[] cpsArray = this.satisfiableCPSs.toArray(new ConditionalPermissionSet[0]);
        int i = 0;
        while (i < cpsArray.length) {
            block16: {
                if (cpsArray[i].isNonEmpty()) {
                    newEmpty = false;
                    if (cpsArray[i].implies(perm)) {
                        Condition[] conds = cpsArray[i].getNeededConditions();
                        Vector<Condition> unevaluatedConds = null;
                        int j = 0;
                        while (j < conds.length) {
                            if (conds[j] != null) {
                                if (!conds[j].isPostponed() && !conds[j].isSatisfied()) break block16;
                                if (conds[j].isPostponed()) {
                                    if (fsm == null) {
                                        if (!conds[j].isSatisfied()) {
                                            break block16;
                                        }
                                    } else {
                                        if (unevaluatedConds == null) {
                                            unevaluatedConds = new Vector<Condition>();
                                        }
                                        unevaluatedConds.add(conds[j]);
                                    }
                                }
                            }
                            ++j;
                        }
                        if (unevaluatedConds == null) {
                            this.empty = false;
                            return true;
                        }
                        if (unevalCondsSets == null) {
                            unevalCondsSets = new Vector<Condition[]>(2);
                        }
                        unevalCondsSets.add(unevaluatedConds.toArray(new Condition[0]));
                        satisfied = true;
                    }
                } else {
                    this.satisfiedCPIs.remove(cpsArray[i]);
                }
            }
            ++i;
        }
        this.empty = newEmpty;
        if (satisfied && fsm != null) {
            Condition[][] condArray = (Condition[][])unevalCondsSets.toArray((T[])new Condition[0][]);
            satisfied = fsm.addConditionsForDomain(condArray);
        }
        return satisfied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPending() {
        if (this.satisfiedCPIs.size() > 0) {
            Vector vector = this.satisfiedCPIs;
            synchronized (vector) {
                int i = 0;
                while (i < this.satisfiedCPIs.size()) {
                    ConditionalPermissionInfoImpl cpi = (ConditionalPermissionInfoImpl)this.satisfiedCPIs.get(i);
                    this.satisfiedCPS.addConditionalPermissionInfo(cpi);
                    ++i;
                }
                this.satisfiableCPSs.clear();
            }
        }
    }

    public Enumeration elements() {
        return null;
    }

    boolean isEmpty() {
        return this.empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unresolvePermissions(AbstractBundle[] refreshedBundles) {
        this.satisfiedCPS.unresolvePermissions(refreshedBundles);
        Vector vector = this.satisfiableCPSs;
        synchronized (vector) {
            Enumeration en = this.satisfiableCPSs.elements();
            while (en.hasMoreElements()) {
                ConditionalPermissionSet cs = (ConditionalPermissionSet)en.nextElement();
                cs.unresolvePermissions(refreshedBundles);
            }
        }
    }
}

