/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.PermissionsHash;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionSet
extends PermissionCollection {
    private static final long serialVersionUID = 3258411750729920566L;
    ConditionalPermissionInfoImpl[] cpis = new ConditionalPermissionInfoImpl[0];
    HashMap cachedPermissionCollections = new HashMap();
    private boolean hasAllPermission = false;
    Condition[] neededConditions;
    static /* synthetic */ Class class$0;

    public ConditionalPermissionSet(ConditionalPermissionInfoImpl[] cpis, Condition[] neededConditions) {
        this.cpis = cpis;
        this.neededConditions = neededConditions;
        this.checkForAllPermission();
    }

    void addConditionalPermissionInfo(ConditionalPermissionInfoImpl cpi) {
        if (this.neededConditions.length > 0) {
            throw new RuntimeException("Cannot add ConditionalPermissionInfoImpl to a non satisfied set");
        }
        ConditionalPermissionInfoImpl[] newcpis = new ConditionalPermissionInfoImpl[this.cpis.length + 1];
        System.arraycopy(this.cpis, 0, newcpis, 0, this.cpis.length);
        newcpis[this.cpis.length] = cpi;
        this.cpis = newcpis;
        this.cachedPermissionCollections.clear();
        this.checkForAllPermission();
    }

    private void checkForAllPermission() {
        if (this.hasAllPermission) {
            return;
        }
        int i = 0;
        block2: while (i < this.cpis.length) {
            PermissionInfo[] perms = this.cpis[i].perms;
            int j = 0;
            while (j < perms.length) {
                String string = perms[j].getType();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.security.AllPermission");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (string.equals(clazz.getName())) {
                    this.hasAllPermission = true;
                    break block2;
                }
                ++j;
            }
            ++i;
        }
    }

    boolean isNonEmpty() {
        boolean nonEmpty = false;
        int i = 0;
        while (i < this.cpis.length) {
            if (this.cpis[i] != null) {
                if (this.cpis[i].isDeleted()) {
                    this.cpis[i] = null;
                    this.cachedPermissionCollections.clear();
                } else {
                    nonEmpty = true;
                }
            }
            ++i;
        }
        if (!nonEmpty) {
            this.cpis = new ConditionalPermissionInfoImpl[0];
        }
        return nonEmpty;
    }

    /*
     * Enabled aggressive block sorting
     */
    Condition[] getNeededConditions() {
        if (this.neededConditions == null || this.neededConditions.length == 0) {
            return this.neededConditions;
        }
        boolean foundNonNullCondition = false;
        int i = 0;
        while (i < this.neededConditions.length) {
            block7: {
                Condition cond = this.neededConditions[i];
                if (cond != null) {
                    if (!cond.isMutable()) {
                        if (cond.isSatisfied()) {
                            this.neededConditions[i] = null;
                            break block7;
                        } else {
                            this.neededConditions = null;
                            break;
                        }
                    }
                    foundNonNullCondition = true;
                }
            }
            ++i;
        }
        if (this.neededConditions != null && !foundNonNullCondition) {
            this.neededConditions = new Condition[0];
        }
        return this.neededConditions;
    }

    public void add(Permission perm) {
    }

    public boolean implies(Permission perm) {
        if (this.hasAllPermission) {
            return true;
        }
        Class<?> permClass = perm.getClass();
        PermissionCollection collection = (PermissionCollection)this.cachedPermissionCollections.get(permClass);
        if (collection == null) {
            collection = perm.newPermissionCollection();
            if (collection == null) {
                collection = new PermissionsHash();
            }
            int i = 0;
            while (i < this.cpis.length) {
                try {
                    ConditionalPermissionInfoImpl cpi = this.cpis[i];
                    if (cpi != null) {
                        cpi.addPermissions(collection, permClass);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.cachedPermissionCollections.put(permClass, collection);
        }
        return collection.implies(perm);
    }

    public Enumeration elements() {
        return null;
    }

    void unresolvePermissions(AbstractBundle[] refreshedBundles) {
        this.cachedPermissionCollections.clear();
    }
}

