/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.GuideLayer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.MarqueeDragTracker;

public class ScalableRootEditPart
extends AbstractGraphicalEditPart
implements RootEditPart,
LayerConstants,
LayerManager {
    protected EditPart contents;
    private LayeredPane innerLayers;
    private LayeredPane printableLayers;
    private ScalableLayeredPane scaledLayers;
    private PropertyChangeListener gridListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("SnapToGrid.GridOrigin") || property.equals("SnapToGrid.GridSpacing") || property.equals("SnapToGrid.isVisible")) {
                ScalableRootEditPart.this.refreshGridLayer();
            }
        }
    };
    protected EditPartViewer viewer;
    private ZoomManager zoomManager = new ZoomManager((ScalableFigure)((ScalableLayeredPane)this.getScaledLayers()), (Viewport)this.getFigure());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void createEditPolicies() {
    }

    protected IFigure createFigure() {
        Viewport viewport = this.createViewport();
        this.innerLayers = new LayeredPane();
        this.createLayers(this.innerLayers);
        viewport.setContents((IFigure)this.innerLayers);
        return viewport;
    }

    protected GridLayer createGridLayer() {
        return new GridLayer();
    }

    protected void createLayers(LayeredPane layeredPane) {
        layeredPane.add((IFigure)this.getScaledLayers(), (Object)"Scalable Layers");
        layeredPane.add((IFigure)new Layer(){

            public Dimension getPreferredSize(int wHint, int hHint) {
                return new Dimension();
            }
        }, (Object)"Handle Layer");
        layeredPane.add((IFigure)new FeedbackLayer(), (Object)"Feedback Layer");
        layeredPane.add((IFigure)new GuideLayer(), (Object)"Guide Layer");
    }

    protected LayeredPane createPrintableLayers() {
        LayeredPane pane = new LayeredPane();
        Layer layer = new Layer();
        layer.setLayoutManager((LayoutManager)new StackLayout());
        pane.add((IFigure)layer, (Object)"Primary Layer");
        layer = new ConnectionLayer();
        layer.setPreferredSize(new Dimension(5, 5));
        pane.add((IFigure)layer, (Object)"Connection Layer");
        return pane;
    }

    protected ScalableLayeredPane createScaledLayers() {
        ScalableLayeredPane layers = new ScalableLayeredPane();
        layers.add((IFigure)this.createGridLayer(), (Object)"Grid Layer");
        layers.add((IFigure)this.getPrintableLayers(), (Object)"Printable Layers");
        layers.add((IFigure)new FeedbackLayer(), (Object)"Scaled Feedback Layer");
        return layers;
    }

    protected Viewport createViewport() {
        return new Viewport(true);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.AutoexposeHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return new ViewportAutoexposeHelper(this);
        }
        return super.getAdapter(key);
    }

    public Command getCommand(Request req) {
        return UnexecutableCommand.INSTANCE;
    }

    public IFigure getContentPane() {
        return this.getLayer("Primary Layer");
    }

    public EditPart getContents() {
        return this.contents;
    }

    public DragTracker getDragTracker(Request req) {
        return new MarqueeDragTracker();
    }

    public IFigure getLayer(Object key) {
        if (this.innerLayers == null) {
            return null;
        }
        Layer layer = this.scaledLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        layer = this.printableLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        return this.innerLayers.getLayer(key);
    }

    public Object getModel() {
        return LayerManager.ID;
    }

    protected LayeredPane getPrintableLayers() {
        if (this.printableLayers == null) {
            this.printableLayers = this.createPrintableLayers();
        }
        return this.printableLayers;
    }

    public RootEditPart getRoot() {
        return this;
    }

    protected LayeredPane getScaledLayers() {
        if (this.scaledLayers == null) {
            this.scaledLayers = this.createScaledLayers();
        }
        return this.scaledLayers;
    }

    public EditPartViewer getViewer() {
        return this.viewer;
    }

    public ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    protected void refreshChildren() {
    }

    protected void refreshGridLayer() {
        boolean visible = false;
        GridLayer grid = (GridLayer)this.getLayer("Grid Layer");
        Boolean val = (Boolean)this.getViewer().getProperty("SnapToGrid.isVisible");
        if (val != null) {
            visible = val;
        }
        grid.setOrigin((Point)this.getViewer().getProperty("SnapToGrid.GridOrigin"));
        grid.setSpacing((Dimension)this.getViewer().getProperty("SnapToGrid.GridSpacing"));
        grid.setVisible(visible);
    }

    protected void register() {
        super.register();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.viewer.setProperty(clazz.toString(), this.getZoomManager());
        if (this.getLayer("Grid Layer") != null) {
            this.getViewer().addPropertyChangeListener(this.gridListener);
            this.refreshGridLayer();
        }
    }

    public void setContents(EditPart editpart) {
        if (this.contents != null) {
            this.removeChild(this.contents);
        }
        this.contents = editpart;
        if (this.contents != null) {
            this.addChild(this.contents, 0);
        }
    }

    public void setViewer(EditPartViewer newViewer) {
        if (this.viewer == newViewer) {
            return;
        }
        if (this.viewer != null) {
            this.unregister();
        }
        this.viewer = newViewer;
        if (this.viewer != null) {
            this.register();
        }
    }

    protected void unregister() {
        this.getViewer().removePropertyChangeListener(this.gridListener);
        super.unregister();
        EditPartViewer editPartViewer = this.getViewer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        editPartViewer.setProperty(clazz.toString(), null);
    }

    class FeedbackLayer
    extends Layer {
        FeedbackLayer() {
            this.setEnabled(false);
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            Rectangle rect = new Rectangle();
            int i = 0;
            while (i < this.getChildren().size()) {
                rect.union(((IFigure)this.getChildren().get(i)).getBounds());
                ++i;
            }
            return rect.getSize();
        }
    }
}

