/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;

public class EditingDomainActionBarContributor
extends MultiPageEditorActionBarContributor
implements IMenuListener,
IPropertyListener {
    protected IEditorPart activeEditor;
    protected DeleteAction deleteAction;
    protected CutAction cutAction;
    protected CopyAction copyAction;
    protected PasteAction pasteAction;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected LoadResourceAction loadResourceAction;
    protected ValidateAction validateAction;

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.deleteAction = new DeleteAction();
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.cutAction = new CutAction();
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        this.copyAction = new CopyAction();
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.pasteAction = new PasteAction();
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.undoAction = new UndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new RedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
    }

    public void shareGlobalActions(IPage page, IActionBars actionBars) {
        if (!(page instanceof IPropertySheetPage)) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        }
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void setActiveView(IViewPart part) {
        IActionBars actionBars = part.getViewSite().getActionBars();
        if (!(part instanceof PropertySheet)) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        }
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        actionBars.updateActionBars();
    }

    public IEditorPart getActiveEditor() {
        return this.activeEditor;
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part != this.activeEditor) {
            if (this.activeEditor != null) {
                this.deactivate();
            }
            if (part instanceof IEditingDomainProvider) {
                this.activeEditor = part;
                this.activate();
            }
        }
    }

    public void setActivePage(IEditorPart part) {
    }

    public void deactivate() {
        this.activeEditor.removePropertyListener((IPropertyListener)this);
        this.deleteAction.setActiveWorkbenchPart(null);
        this.cutAction.setActiveWorkbenchPart(null);
        this.copyAction.setActiveWorkbenchPart(null);
        this.pasteAction.setActiveWorkbenchPart(null);
        this.undoAction.setActiveWorkbenchPart(null);
        this.redoAction.setActiveWorkbenchPart(null);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setActiveWorkbenchPart(null);
        }
        ISelectionProvider selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cutAction);
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        if (this.validateAction != null) {
            this.validateAction.setActiveWorkbenchPart(null);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.validateAction);
        }
    }

    public void activate() {
        this.activeEditor.addPropertyListener((IPropertyListener)this);
        this.deleteAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.cutAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.copyAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.pasteAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.undoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.redoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        ISelectionProvider selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.cutAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        if (this.validateAction != null) {
            this.validateAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.validateAction);
        }
        this.update();
    }

    public void update() {
        ISelectionProvider selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        ISelection selection = selectionProvider.getSelection();
        StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
        this.deleteAction.updateSelection((IStructuredSelection)structuredSelection);
        this.cutAction.updateSelection((IStructuredSelection)structuredSelection);
        this.copyAction.updateSelection((IStructuredSelection)structuredSelection);
        this.pasteAction.updateSelection((IStructuredSelection)structuredSelection);
        this.undoAction.update();
        this.redoAction.update();
        if (this.loadResourceAction != null) {
            this.loadResourceAction.update();
        }
        if (this.validateAction != null) {
            this.validateAction.updateSelection((IStructuredSelection)structuredSelection);
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("edit"));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.undoAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.redoAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.cutAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions-end"));
        this.addGlobalActions(menuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        if (this.validateAction != null) {
            menuManager.insertBefore("additions-end", (IContributionItem)new ActionContributionItem((IAction)this.validateAction));
            menuManager.insertBefore("additions-end", (IContributionItem)new Separator());
        }
        if (this.loadResourceAction != null) {
            menuManager.insertBefore("additions-end", (IContributionItem)new ActionContributionItem((IAction)this.loadResourceAction));
            menuManager.insertBefore("additions-end", (IContributionItem)new Separator());
        }
    }

    public void propertyChanged(Object source, int id) {
        this.update();
    }
}

