require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ARM_CPU_H_)) {
    eval 'sub _ARM_CPU_H_ () {1;}' unless defined(&_ARM_CPU_H_);
    eval 'sub CPU_DEBUG () {1;}' unless defined(&CPU_DEBUG);
    eval 'sub CPU_BOOTED_DEVICE () {2;}' unless defined(&CPU_BOOTED_DEVICE);
    eval 'sub CPU_BOOTED_KERNEL () {3;}' unless defined(&CPU_BOOTED_KERNEL);
    eval 'sub CPU_CONSDEV () {4;}' unless defined(&CPU_CONSDEV);
    eval 'sub CPU_POWERSAVE () {5;}' unless defined(&CPU_POWERSAVE);
    eval 'sub CPU_ALLOWAPERTURE () {6;}' unless defined(&CPU_ALLOWAPERTURE);
    eval 'sub CPU_APMWARN () {7;}' unless defined(&CPU_APMWARN);
    eval 'sub CPU_KBDRESET () {8;}' unless defined(&CPU_KBDRESET);
    eval 'sub CPU_ZTSRAWMODE () {9;}' unless defined(&CPU_ZTSRAWMODE);
    eval 'sub CPU_ZTSSCALE () {10;}' unless defined(&CPU_ZTSSCALE);
    eval 'sub CPU_MAXSPEED () {11;}' unless defined(&CPU_MAXSPEED);
    eval 'sub CPU_LIDSUSPEND () {12;}' unless defined(&CPU_LIDSUSPEND);
    eval 'sub CPU_MAXID () {13;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "debug",  &CTLTYPE_INT }, { "booted_device",  &CTLTYPE_STRING }, { "booted_kernel",  &CTLTYPE_STRING }, { "console_device",  &CTLTYPE_STRUCT }, { "powersave",  &CTLTYPE_INT }, { "allowaperture",  &CTLTYPE_INT }, { "apmwarn",  &CTLTYPE_INT }, { "kbdreset",  &CTLTYPE_INT }, { "ztsrawmode",  &CTLTYPE_INT }, { "ztsscale",  &CTLTYPE_STRUCT }, { "maxspeed",  &CTLTYPE_INT }, { "lidsuspend",  &CTLTYPE_INT } };}' unless defined(&CTL_MACHDEP_NAMES);
    if(defined(&_KERNEL)) {
	require 'arm/cpuconf.ph';
	require 'machine/intr.ph';
	unless(defined(&_LOCORE)) {
	    if(0) {
		require 'sys/user.ph';
	    }
	    require 'machine/frame.ph';
	    require 'machine/pcb.ph';
	}
	require 'arm/armreg.ph';
	unless(defined(&_LOCORE)) {
	}
	if(defined(&__PROG32)) {
	    if(defined(&_LOCORE)) {
		eval 'sub IRQdisable () { &stmfd  &sp!, { &r0} ;  &mrs  &r0,  &cpsr ;  &orr  &r0,  &r0, ( &I32_bit) ;  &msr  &cpsr_c,  &r0 ;  &ldmfd  &sp!, { &r0};}' unless defined(&IRQdisable);
		eval 'sub IRQenable () { &stmfd  &sp!, { &r0} ;  &mrs  &r0,  &cpsr ;  &bic  &r0,  &r0, ( &I32_bit) ;  &msr  &cpsr_c,  &r0 ;  &ldmfd  &sp!, { &r0};}' unless defined(&IRQenable);
	    } else {
		eval 'sub IRQdisable () { &__set_cpsr_c( &I32_bit,  &I32_bit);;}' unless defined(&IRQdisable);
		eval 'sub IRQenable () { &__set_cpsr_c( &I32_bit, 0);;}' unless defined(&IRQenable);
	    }
	}
	unless(defined(&_LOCORE)) {
	    if(defined(&__PROG32)) {
		eval 'sub CLKF_USERMODE {
		    local($frame) = @_;
    		    eval q((( ($frame->{if_spsr}) &  &PSR_MODE) ==  &PSR_USR32_MODE));
		}' unless defined(&CLKF_USERMODE);
	    } else {
		eval 'sub CLKF_USERMODE {
		    local($frame) = @_;
    		    eval q((( ($frame->{if_r15}) &  &R15_MODE) ==  &R15_MODE_USR));
		}' unless defined(&CLKF_USERMODE);
	    }
	    if(defined(&__PROG32)) {
		eval 'sub CLKF_INTR {
		    local($frame) = @_;
    		    eval q((( &current_intr_depth > 1) || ( ($frame->{if_spsr}) &  &PSR_MODE) ==  &PSR_UND32_MODE));
		}' unless defined(&CLKF_INTR);
	    } else {
		eval 'sub CLKF_INTR {
		    local($frame) = @_;
    		    eval q(( &current_intr_depth > 1));
		}' unless defined(&CLKF_INTR);
	    }
	    if(defined(&__PROG32)) {
		eval 'sub CLKF_PC {
		    local($frame) = @_;
    		    eval q(( ($frame->{if_pc})));
		}' unless defined(&CLKF_PC);
	    } else {
		eval 'sub CLKF_PC {
		    local($frame) = @_;
    		    eval q(( ($frame->{if_r15}) &  &R15_PC));
		}' unless defined(&CLKF_PC);
	    }
	    if(defined(&__PROG32)) {
		eval 'sub PROC_PC {
		    local($p) = @_;
    		    eval q((($p)-> ($p_addr->{u_pcb}->{pcb_tf}->{tf_pc})));
		}' unless defined(&PROC_PC);
	    } else {
		eval 'sub PROC_PC {
		    local($p) = @_;
    		    eval q((($p)-> ($p_addr->{u_pcb}->{pcb_tf}->{tf_r15}) &  &R15_PC));
		}' unless defined(&PROC_PC);
	    }
	    if(defined(&__PROG32)) {
		eval 'sub ARM_VEC_RESET () {(1<< 0);}' unless defined(&ARM_VEC_RESET);
		eval 'sub ARM_VEC_UNDEFINED () {(1<< 1);}' unless defined(&ARM_VEC_UNDEFINED);
		eval 'sub ARM_VEC_SWI () {(1<< 2);}' unless defined(&ARM_VEC_SWI);
		eval 'sub ARM_VEC_PREFETCH_ABORT () {(1<< 3);}' unless defined(&ARM_VEC_PREFETCH_ABORT);
		eval 'sub ARM_VEC_DATA_ABORT () {(1<< 4);}' unless defined(&ARM_VEC_DATA_ABORT);
		eval 'sub ARM_VEC_ADDRESS_EXCEPTION () {(1<< 5);}' unless defined(&ARM_VEC_ADDRESS_EXCEPTION);
		eval 'sub ARM_VEC_IRQ () {(1<< 6);}' unless defined(&ARM_VEC_IRQ);
		eval 'sub ARM_VEC_FIQ () {(1<< 7);}' unless defined(&ARM_VEC_FIQ);
		eval 'sub ARM_NVEC () {8;}' unless defined(&ARM_NVEC);
		eval 'sub ARM_VEC_ALL () {0xffffffff;}' unless defined(&ARM_VEC_ALL);
	    }
	    require 'sys/device.ph';
	    if(0) {
	    }
	    if(defined( &DIAGNOSTIC) || defined( &LOCKDEBUG)) {
	    }
	    if(defined(&MULTIPROCESSOR)) {
	    }
	    unless(defined(&MULTIPROCESSOR)) {
		eval 'sub curcpu () {
		    eval q(( &cpu_info_store));
		}' unless defined(&curcpu);
		eval 'sub cpu_number () {
		    eval q(0);
		}' unless defined(&cpu_number);
	    }
	    if(defined(&__PROG32)) {
	    } else {
		eval 'sub cpu_proc_fork {
		    local($p1, $p2) = @_;
    		    eval q();
		}' unless defined(&cpu_proc_fork);
	    }
	    eval 'sub setsoftast () {
	        eval q(( &astpending = 1));
	    }' unless defined(&setsoftast);
	    eval 'sub signotify {
	        local($p) = @_;
    		eval q( &setsoftast());
	    }' unless defined(&signotify);
	    eval 'sub cpu_wait {
	        local($p) = @_;
    		eval q();
	    }' unless defined(&cpu_wait);
	    eval 'sub need_resched {
	        local($ci) = @_;
    		eval q(( &want_resched = 1,  &setsoftast()));
	    }' unless defined(&need_resched);
	    eval 'sub need_proftick {
	        local($p) = @_;
    		eval q((($p)-> &p_flag |=  &P_OWEUPC,  &setsoftast()));
	    }' unless defined(&need_proftick);
	    unless(defined(&acorn26)) {
	    }
	}
    }
}
1;
