require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_EMMINTRIN_H_INCLUDED)) {
    eval 'sub _EMMINTRIN_H_INCLUDED () {1;}' unless defined(&_EMMINTRIN_H_INCLUDED);
    if(defined(&__SSE2__)) {
	require 'xmmintrin.ph';
	eval 'sub _MM_SHUFFLE2 {
	    local($fp1,$fp0) = @_;
    	    eval q(((($fp1) << 1) | ($fp0)));
	}' unless defined(&_MM_SHUFFLE2);
	eval 'sub __m128i () { &__v2di;}' unless defined(&__m128i);
	eval 'sub __m128d () { &__v2df;}' unless defined(&__m128d);
	eval 'sub _mm_load_pd1 {
	    local($__P) = @_;
    	    eval q({  &_mm_load1_pd ($__P); });
	}' unless defined(&_mm_load_pd1);
	eval 'sub _mm_set_pd1 {
	    local($__F) = @_;
    	    eval q({  &_mm_set1_pd ($__F); });
	}' unless defined(&_mm_set_pd1);
	eval 'sub _mm_store_pd1 {
	    local($__P,$__A) = @_;
    	    eval q({  &_mm_store1_pd ($__P, $__A); });
	}' unless defined(&_mm_store_pd1);
	eval 'sub _mm_add_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_addpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_add_pd);
	eval 'sub _mm_add_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_addsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_add_sd);
	eval 'sub _mm_sub_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_subpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_sub_pd);
	eval 'sub _mm_sub_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_subsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_sub_sd);
	eval 'sub _mm_mul_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_mulpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_mul_pd);
	eval 'sub _mm_mul_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_mulsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_mul_sd);
	eval 'sub _mm_div_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_divpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_div_pd);
	eval 'sub _mm_div_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_divsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_div_sd);
	eval 'sub _mm_sqrt_pd {
	    local($__A) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_sqrtpd (( &__v2df)$__A); });
	}' unless defined(&_mm_sqrt_pd);
	eval 'sub _mm_min_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_minpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_min_pd);
	eval 'sub _mm_min_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_minsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_min_sd);
	eval 'sub _mm_max_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_maxpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_max_pd);
	eval 'sub _mm_max_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_maxsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_max_sd);
	eval 'sub _mm_and_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_andpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_and_pd);
	eval 'sub _mm_andnot_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_andnpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_andnot_pd);
	eval 'sub _mm_or_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_orpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_or_pd);
	eval 'sub _mm_xor_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_xorpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_xor_pd);
	eval 'sub _mm_cmpeq_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpeqpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpeq_pd);
	eval 'sub _mm_cmplt_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpltpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmplt_pd);
	eval 'sub _mm_cmple_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmplepd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmple_pd);
	eval 'sub _mm_cmpgt_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpgtpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpgt_pd);
	eval 'sub _mm_cmpge_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpgepd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpge_pd);
	eval 'sub _mm_cmpneq_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpneqpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpneq_pd);
	eval 'sub _mm_cmpnlt_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpnltpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpnlt_pd);
	eval 'sub _mm_cmpnle_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpnlepd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpnle_pd);
	eval 'sub _mm_cmpngt_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpngtpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpngt_pd);
	eval 'sub _mm_cmpnge_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpngepd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpnge_pd);
	eval 'sub _mm_cmpord_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpordpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpord_pd);
	eval 'sub _mm_cmpunord_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpunordpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpunord_pd);
	eval 'sub _mm_cmpeq_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpeqsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpeq_sd);
	eval 'sub _mm_cmplt_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpltsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmplt_sd);
	eval 'sub _mm_cmple_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmplesd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmple_sd);
	eval 'sub _mm_cmpgt_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d)  &__builtin_ia32_movsd (( &__v2df) $__A, ( &__v2df)  &__builtin_ia32_cmpltsd (( &__v2df) $__B, ( &__v2df) $__A)); });
	}' unless defined(&_mm_cmpgt_sd);
	eval 'sub _mm_cmpge_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d)  &__builtin_ia32_movsd (( &__v2df) $__A, ( &__v2df)  &__builtin_ia32_cmplesd (( &__v2df) $__B, ( &__v2df) $__A)); });
	}' unless defined(&_mm_cmpge_sd);
	eval 'sub _mm_cmpneq_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpneqsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpneq_sd);
	eval 'sub _mm_cmpnlt_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpnltsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpnlt_sd);
	eval 'sub _mm_cmpnle_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpnlesd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpnle_sd);
	eval 'sub _mm_cmpngt_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d)  &__builtin_ia32_movsd (( &__v2df) $__A, ( &__v2df)  &__builtin_ia32_cmpnltsd (( &__v2df) $__B, ( &__v2df) $__A)); });
	}' unless defined(&_mm_cmpngt_sd);
	eval 'sub _mm_cmpnge_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d)  &__builtin_ia32_movsd (( &__v2df) $__A, ( &__v2df)  &__builtin_ia32_cmpnlesd (( &__v2df) $__B, ( &__v2df) $__A)); });
	}' unless defined(&_mm_cmpnge_sd);
	eval 'sub _mm_cmpord_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpordsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpord_sd);
	eval 'sub _mm_cmpunord_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cmpunordsd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_cmpunord_sd);
	eval 'sub _mm_comieq_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_comisdeq (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_comieq_sd);
	eval 'sub _mm_comilt_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_comisdlt (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_comilt_sd);
	eval 'sub _mm_comile_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_comisdle (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_comile_sd);
	eval 'sub _mm_comigt_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_comisdgt (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_comigt_sd);
	eval 'sub _mm_comige_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_comisdge (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_comige_sd);
	eval 'sub _mm_comineq_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_comisdneq (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_comineq_sd);
	eval 'sub _mm_ucomieq_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomisdeq (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_ucomieq_sd);
	eval 'sub _mm_ucomilt_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomisdlt (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_ucomilt_sd);
	eval 'sub _mm_ucomile_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomisdle (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_ucomile_sd);
	eval 'sub _mm_ucomigt_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomisdgt (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_ucomigt_sd);
	eval 'sub _mm_ucomige_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomisdge (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_ucomige_sd);
	eval 'sub _mm_ucomineq_sd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_ucomisdneq (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_ucomineq_sd);
	eval 'sub _mm_loadu_si128 {
	    local($__P) = @_;
    	    eval q({ ( &__m128i)  &__builtin_ia32_loaddqu ((\'char\'  &const *)$__P); });
	}' unless defined(&_mm_loadu_si128);
	eval 'sub _mm_loadl_epi64 {
	    local($__P) = @_;
    	    eval q({ ( &__m128i)  &__builtin_ia32_movq2dq (*$__P); });
	}' unless defined(&_mm_loadl_epi64);
	eval 'sub _mm_store_si128 {
	    local($__P,$__B) = @_;
    	    eval q({  &__builtin_ia32_storedqa ($__P, ( &__v16qi)$__B); });
	}' unless defined(&_mm_store_si128);
	eval 'sub _mm_storeu_si128 {
	    local($__P,$__B) = @_;
    	    eval q({  &__builtin_ia32_storedqu ($__P, ( &__v16qi)$__B); });
	}' unless defined(&_mm_storeu_si128);
	eval 'sub _mm_storel_epi64 {
	    local($__P,$__B) = @_;
    	    eval q({ *$__P =  &__builtin_ia32_movdq2q (( &__v2di)$__B); });
	}' unless defined(&_mm_storel_epi64);
	eval 'sub _mm_movepi64_pi64 {
	    local($__B) = @_;
    	    eval q({ ( &__m64)  &__builtin_ia32_movdq2q (( &__v2di)$__B); });
	}' unless defined(&_mm_movepi64_pi64);
	eval 'sub _mm_move_epi64 {
	    local($__A) = @_;
    	    eval q({ ( &__m128i)  &__builtin_ia32_movq (( &__v2di)$__A); });
	}' unless defined(&_mm_move_epi64);
	eval 'sub _mm_set_epi64 {
	    local($__A,$__B) = @_;
    	    eval q({  &__v2di  &__tmp = ( &__v2di) &__builtin_ia32_movq2dq ($__A);  &__v2di  &__tmp2 = ( &__v2di) &__builtin_ia32_movq2dq ($__B); ( &__m128i) &__builtin_ia32_punpcklqdq128 ( &__tmp2,  &__tmp); });
	}' unless defined(&_mm_set_epi64);
	if(defined(&__x86_64__)) {
	}
	eval 'sub _mm_set1_epi64 {
	    local($__A) = @_;
    	    eval q({  &__v2di  &__tmp = ( &__v2di) &__builtin_ia32_movq2dq ($__A); ( &__m128i) &__builtin_ia32_punpcklqdq128 ( &__tmp,  &__tmp); });
	}' unless defined(&_mm_set1_epi64);
	eval 'sub _mm_set1_epi32 {
	    local($__A) = @_;
    	    eval q({  &__v4si  &__tmp = ( &__v4si) &__builtin_ia32_loadd (&$__A); ( &__m128i)  &__builtin_ia32_pshufd (( &__v4si) &__tmp,  &_MM_SHUFFLE (0,0,0,0)); });
	}' unless defined(&_mm_set1_epi32);
	if(defined(&__x86_64__)) {
	    eval 'sub _mm_set1_epi64x {
	        local($__A) = @_;
    		eval q({  &__v2di  &__tmp = ( &__v2di) &__builtin_ia32_movq2dq ($__A); ( &__m128i)  &__builtin_ia32_shufpd (( &__v2df) &__tmp, ( &__v2df) &__tmp,  &_MM_SHUFFLE2 (0,0)); });
	    }' unless defined(&_mm_set1_epi64x);
	}
	eval 'sub _mm_set1_epi16 {
	    local($__A) = @_;
    	    eval q({ \'int\'  &__Acopy = $__A;  &__v4si  &__tmp = ( &__v4si) &__builtin_ia32_loadd (& &__Acopy);  &__tmp = ( &__v4si) &__builtin_ia32_punpcklwd128 (( &__v8hi) &__tmp, ( &__v8hi) &__tmp); ( &__m128i)  &__builtin_ia32_pshufd (( &__v4si) &__tmp,  &_MM_SHUFFLE (0,0,0,0)); });
	}' unless defined(&_mm_set1_epi16);
	eval 'sub _mm_set1_epi8 {
	    local($__A) = @_;
    	    eval q({ \'int\'  &__Acopy = $__A;  &__v4si  &__tmp = ( &__v4si) &__builtin_ia32_loadd (& &__Acopy);  &__tmp = ( &__v4si) &__builtin_ia32_punpcklbw128 (( &__v16qi) &__tmp, ( &__v16qi) &__tmp);  &__tmp = ( &__v4si) &__builtin_ia32_punpcklbw128 (( &__v16qi) &__tmp, ( &__v16qi) &__tmp); ( &__m128i)  &__builtin_ia32_pshufd (( &__v4si) &__tmp,  &_MM_SHUFFLE (0,0,0,0)); });
	}' unless defined(&_mm_set1_epi8);
	eval 'sub _mm_setr_epi64 {
	    local($__A,$__B) = @_;
    	    eval q({  &__v2di  &__tmp = ( &__v2di) &__builtin_ia32_movq2dq ($__A);  &__v2di  &__tmp2 = ( &__v2di) &__builtin_ia32_movq2dq ($__B); ( &__m128i) &__builtin_ia32_punpcklqdq128 ( &__tmp,  &__tmp2); });
	}' unless defined(&_mm_setr_epi64);
	eval 'sub _mm_cvtepi32_pd {
	    local($__A) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cvtdq2pd (( &__v4si) $__A); });
	}' unless defined(&_mm_cvtepi32_pd);
	eval 'sub _mm_cvtepi32_ps {
	    local($__A) = @_;
    	    eval q({ ( &__m128) &__builtin_ia32_cvtdq2ps (( &__v4si) $__A); });
	}' unless defined(&_mm_cvtepi32_ps);
	eval 'sub _mm_cvtpd_epi32 {
	    local($__A) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_cvtpd2dq (( &__v2df) $__A); });
	}' unless defined(&_mm_cvtpd_epi32);
	eval 'sub _mm_cvtpd_pi32 {
	    local($__A) = @_;
    	    eval q({ ( &__m64) &__builtin_ia32_cvtpd2pi (( &__v2df) $__A); });
	}' unless defined(&_mm_cvtpd_pi32);
	eval 'sub _mm_cvtpd_ps {
	    local($__A) = @_;
    	    eval q({ ( &__m128) &__builtin_ia32_cvtpd2ps (( &__v2df) $__A); });
	}' unless defined(&_mm_cvtpd_ps);
	eval 'sub _mm_cvttpd_epi32 {
	    local($__A) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_cvttpd2dq (( &__v2df) $__A); });
	}' unless defined(&_mm_cvttpd_epi32);
	eval 'sub _mm_cvttpd_pi32 {
	    local($__A) = @_;
    	    eval q({ ( &__m64) &__builtin_ia32_cvttpd2pi (( &__v2df) $__A); });
	}' unless defined(&_mm_cvttpd_pi32);
	eval 'sub _mm_cvtpi32_pd {
	    local($__A) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cvtpi2pd (( &__v2si) $__A); });
	}' unless defined(&_mm_cvtpi32_pd);
	eval 'sub _mm_cvtps_epi32 {
	    local($__A) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_cvtps2dq (( &__v4sf) $__A); });
	}' unless defined(&_mm_cvtps_epi32);
	eval 'sub _mm_cvttps_epi32 {
	    local($__A) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_cvttps2dq (( &__v4sf) $__A); });
	}' unless defined(&_mm_cvttps_epi32);
	eval 'sub _mm_cvtps_pd {
	    local($__A) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cvtps2pd (( &__v4sf) $__A); });
	}' unless defined(&_mm_cvtps_pd);
	eval 'sub _mm_cvtsd_si32 {
	    local($__A) = @_;
    	    eval q({  &__builtin_ia32_cvtsd2si (( &__v2df) $__A); });
	}' unless defined(&_mm_cvtsd_si32);
	if(defined(&__x86_64__)) {
	    eval 'sub _mm_cvtsd_si64x {
	        local($__A) = @_;
    		eval q({  &__builtin_ia32_cvtsd2si64 (( &__v2df) $__A); });
	    }' unless defined(&_mm_cvtsd_si64x);
	}
	eval 'sub _mm_cvttsd_si32 {
	    local($__A) = @_;
    	    eval q({  &__builtin_ia32_cvttsd2si (( &__v2df) $__A); });
	}' unless defined(&_mm_cvttsd_si32);
	if(defined(&__x86_64__)) {
	    eval 'sub _mm_cvttsd_si64x {
	        local($__A) = @_;
    		eval q({  &__builtin_ia32_cvttsd2si64 (( &__v2df) $__A); });
	    }' unless defined(&_mm_cvttsd_si64x);
	}
	eval 'sub _mm_cvtsd_ss {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128) &__builtin_ia32_cvtsd2ss (( &__v4sf) $__A, ( &__v2df) $__B); });
	}' unless defined(&_mm_cvtsd_ss);
	eval 'sub _mm_cvtsi32_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cvtsi2sd (( &__v2df) $__A, $__B); });
	}' unless defined(&_mm_cvtsi32_sd);
	if(defined(&__x86_64__)) {
	    eval 'sub _mm_cvtsi64x_sd {
	        local($__A,$__B) = @_;
    		eval q({ ( &__m128d) &__builtin_ia32_cvtsi642sd (( &__v2df) $__A, $__B); });
	    }' unless defined(&_mm_cvtsi64x_sd);
	}
	eval 'sub _mm_cvtss_sd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_cvtss2sd (( &__v2df) $__A, ( &__v4sf)$__B); });
	}' unless defined(&_mm_cvtss_sd);
	eval 'sub _mm_shuffle_pd {
	    local($__A, $__B, $__C) = @_;
    	    eval q((( &__m128d) &__builtin_ia32_shufpd (( &__v2df)$__A, ( &__v2df)$__B, ($__C))));
	}' unless defined(&_mm_shuffle_pd);
	eval 'sub _mm_unpackhi_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_unpckhpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_unpackhi_pd);
	eval 'sub _mm_unpacklo_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_unpcklpd (( &__v2df)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_unpacklo_pd);
	eval 'sub _mm_loadh_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_loadhpd (( &__v2df)$__A, ( &__v2si *)$__B); });
	}' unless defined(&_mm_loadh_pd);
	eval 'sub _mm_storeh_pd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_storehpd (( &__v2si *)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_storeh_pd);
	eval 'sub _mm_loadl_pd {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128d) &__builtin_ia32_loadlpd (( &__v2df)$__A, ( &__v2si *)$__B); });
	}' unless defined(&_mm_loadl_pd);
	eval 'sub _mm_storel_pd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_storelpd (( &__v2si *)$__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_storel_pd);
	eval 'sub _mm_movemask_pd {
	    local($__A) = @_;
    	    eval q({  &__builtin_ia32_movmskpd (( &__v2df)$__A); });
	}' unless defined(&_mm_movemask_pd);
	eval 'sub _mm_packs_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_packsswb128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_packs_epi16);
	eval 'sub _mm_packs_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_packssdw128 (( &__v4si)$__A, ( &__v4si)$__B); });
	}' unless defined(&_mm_packs_epi32);
	eval 'sub _mm_packus_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_packuswb128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_packus_epi16);
	eval 'sub _mm_unpackhi_epi8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_punpckhbw128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_unpackhi_epi8);
	eval 'sub _mm_unpackhi_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_punpckhwd128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_unpackhi_epi16);
	eval 'sub _mm_unpackhi_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_punpckhdq128 (( &__v4si)$__A, ( &__v4si)$__B); });
	}' unless defined(&_mm_unpackhi_epi32);
	eval 'sub _mm_unpackhi_epi64 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_punpckhqdq128 (( &__v2di)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_unpackhi_epi64);
	eval 'sub _mm_unpacklo_epi8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_punpcklbw128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_unpacklo_epi8);
	eval 'sub _mm_unpacklo_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_punpcklwd128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_unpacklo_epi16);
	eval 'sub _mm_unpacklo_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_punpckldq128 (( &__v4si)$__A, ( &__v4si)$__B); });
	}' unless defined(&_mm_unpacklo_epi32);
	eval 'sub _mm_unpacklo_epi64 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_punpcklqdq128 (( &__v2di)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_unpacklo_epi64);
	eval 'sub _mm_add_epi8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_paddb128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_add_epi8);
	eval 'sub _mm_add_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_paddw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_add_epi16);
	eval 'sub _mm_add_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_paddd128 (( &__v4si)$__A, ( &__v4si)$__B); });
	}' unless defined(&_mm_add_epi32);
	eval 'sub _mm_add_epi64 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_paddq128 (( &__v2di)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_add_epi64);
	eval 'sub _mm_adds_epi8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_paddsb128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_adds_epi8);
	eval 'sub _mm_adds_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_paddsw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_adds_epi16);
	eval 'sub _mm_adds_epu8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_paddusb128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_adds_epu8);
	eval 'sub _mm_adds_epu16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_paddusw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_adds_epu16);
	eval 'sub _mm_sub_epi8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psubb128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_sub_epi8);
	eval 'sub _mm_sub_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psubw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_sub_epi16);
	eval 'sub _mm_sub_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psubd128 (( &__v4si)$__A, ( &__v4si)$__B); });
	}' unless defined(&_mm_sub_epi32);
	eval 'sub _mm_sub_epi64 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psubq128 (( &__v2di)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_sub_epi64);
	eval 'sub _mm_subs_epi8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psubsb128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_subs_epi8);
	eval 'sub _mm_subs_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psubsw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_subs_epi16);
	eval 'sub _mm_subs_epu8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psubusb128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_subs_epu8);
	eval 'sub _mm_subs_epu16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psubusw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_subs_epu16);
	eval 'sub _mm_madd_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pmaddwd128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_madd_epi16);
	eval 'sub _mm_mulhi_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pmulhw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_mulhi_epi16);
	eval 'sub _mm_mullo_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pmullw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_mullo_epi16);
	eval 'sub _mm_mul_su32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m64) &__builtin_ia32_pmuludq (( &__v2si)$__A, ( &__v2si)$__B); });
	}' unless defined(&_mm_mul_su32);
	eval 'sub _mm_mul_epu32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pmuludq128 (( &__v4si)$__A, ( &__v4si)$__B); });
	}' unless defined(&_mm_mul_epu32);
	eval 'sub _mm_sll_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psllw128 (( &__v8hi)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_sll_epi16);
	eval 'sub _mm_sll_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pslld128 (( &__v4si)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_sll_epi32);
	eval 'sub _mm_sll_epi64 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psllq128 (( &__v2di)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_sll_epi64);
	eval 'sub _mm_sra_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psraw128 (( &__v8hi)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_sra_epi16);
	eval 'sub _mm_sra_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psrad128 (( &__v4si)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_sra_epi32);
	eval 'sub _mm_srl_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psrlw128 (( &__v8hi)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_srl_epi16);
	eval 'sub _mm_srl_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psrld128 (( &__v4si)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_srl_epi32);
	eval 'sub _mm_srl_epi64 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psrlq128 (( &__v2di)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_srl_epi64);
	eval 'sub _mm_slli_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psllwi128 (( &__v8hi)$__A, $__B); });
	}' unless defined(&_mm_slli_epi16);
	eval 'sub _mm_slli_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pslldi128 (( &__v4si)$__A, $__B); });
	}' unless defined(&_mm_slli_epi32);
	eval 'sub _mm_slli_epi64 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psllqi128 (( &__v2di)$__A, $__B); });
	}' unless defined(&_mm_slli_epi64);
	eval 'sub _mm_srai_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psrawi128 (( &__v8hi)$__A, $__B); });
	}' unless defined(&_mm_srai_epi16);
	eval 'sub _mm_srai_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psradi128 (( &__v4si)$__A, $__B); });
	}' unless defined(&_mm_srai_epi32);
	if(0) {
	}
	eval 'sub _mm_srli_si128 {
	    local($__A, $__B) = @_;
    	    eval q((( &__m128i) &__builtin_ia32_psrldqi128 ($__A, $__B)));
	}' unless defined(&_mm_srli_si128);
	eval 'sub _mm_slli_si128 {
	    local($__A, $__B) = @_;
    	    eval q((( &__m128i) &__builtin_ia32_pslldqi128 ($__A, $__B)));
	}' unless defined(&_mm_slli_si128);
	eval 'sub _mm_srli_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psrlwi128 (( &__v8hi)$__A, $__B); });
	}' unless defined(&_mm_srli_epi16);
	eval 'sub _mm_srli_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psrldi128 (( &__v4si)$__A, $__B); });
	}' unless defined(&_mm_srli_epi32);
	eval 'sub _mm_srli_epi64 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psrlqi128 (( &__v2di)$__A, $__B); });
	}' unless defined(&_mm_srli_epi64);
	eval 'sub _mm_and_si128 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pand128 (( &__v2di)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_and_si128);
	eval 'sub _mm_andnot_si128 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pandn128 (( &__v2di)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_andnot_si128);
	eval 'sub _mm_or_si128 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_por128 (( &__v2di)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_or_si128);
	eval 'sub _mm_xor_si128 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pxor128 (( &__v2di)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_xor_si128);
	eval 'sub _mm_cmpeq_epi8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pcmpeqb128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_cmpeq_epi8);
	eval 'sub _mm_cmpeq_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pcmpeqw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_cmpeq_epi16);
	eval 'sub _mm_cmpeq_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pcmpeqd128 (( &__v4si)$__A, ( &__v4si)$__B); });
	}' unless defined(&_mm_cmpeq_epi32);
	eval 'sub _mm_cmplt_epi8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pcmpgtb128 (( &__v16qi)$__B, ( &__v16qi)$__A); });
	}' unless defined(&_mm_cmplt_epi8);
	eval 'sub _mm_cmplt_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pcmpgtw128 (( &__v8hi)$__B, ( &__v8hi)$__A); });
	}' unless defined(&_mm_cmplt_epi16);
	eval 'sub _mm_cmplt_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pcmpgtd128 (( &__v4si)$__B, ( &__v4si)$__A); });
	}' unless defined(&_mm_cmplt_epi32);
	eval 'sub _mm_cmpgt_epi8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pcmpgtb128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_cmpgt_epi8);
	eval 'sub _mm_cmpgt_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pcmpgtw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_cmpgt_epi16);
	eval 'sub _mm_cmpgt_epi32 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pcmpgtd128 (( &__v4si)$__A, ( &__v4si)$__B); });
	}' unless defined(&_mm_cmpgt_epi32);
	eval 'sub _mm_extract_epi16 {
	    local($__A, $__B) = @_;
    	    eval q( &__builtin_ia32_pextrw128 (( &__v8hi)$__A, $__B));
	}' unless defined(&_mm_extract_epi16);
	eval 'sub _mm_insert_epi16 {
	    local($__A, $__B, $__C) = @_;
    	    eval q((( &__m128i) &__builtin_ia32_pinsrw128 (( &__v8hi)$__A, $__B, $__C)));
	}' unless defined(&_mm_insert_epi16);
	eval 'sub _mm_max_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pmaxsw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_max_epi16);
	eval 'sub _mm_max_epu8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pmaxub128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_max_epu8);
	eval 'sub _mm_min_epi16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pminsw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_min_epi16);
	eval 'sub _mm_min_epu8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pminub128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_min_epu8);
	eval 'sub _mm_movemask_epi8 {
	    local($__A) = @_;
    	    eval q({  &__builtin_ia32_pmovmskb128 (( &__v16qi)$__A); });
	}' unless defined(&_mm_movemask_epi8);
	eval 'sub _mm_mulhi_epu16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pmulhuw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_mulhi_epu16);
	eval 'sub _mm_shufflehi_epi16 {
	    local($__A, $__B) = @_;
    	    eval q((( &__m128i) &__builtin_ia32_pshufhw (( &__v8hi)$__A, $__B)));
	}' unless defined(&_mm_shufflehi_epi16);
	eval 'sub _mm_shufflelo_epi16 {
	    local($__A, $__B) = @_;
    	    eval q((( &__m128i) &__builtin_ia32_pshuflw (( &__v8hi)$__A, $__B)));
	}' unless defined(&_mm_shufflelo_epi16);
	eval 'sub _mm_shuffle_epi32 {
	    local($__A, $__B) = @_;
    	    eval q((( &__m128i) &__builtin_ia32_pshufd (( &__v4si)$__A, $__B)));
	}' unless defined(&_mm_shuffle_epi32);
	eval 'sub _mm_maskmoveu_si128 {
	    local($__A,$__B,$__C) = @_;
    	    eval q({  &__builtin_ia32_maskmovdqu (( &__v16qi)$__A, ( &__v16qi)$__B, $__C); });
	}' unless defined(&_mm_maskmoveu_si128);
	eval 'sub _mm_avg_epu8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pavgb128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_avg_epu8);
	eval 'sub _mm_avg_epu16 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_pavgw128 (( &__v8hi)$__A, ( &__v8hi)$__B); });
	}' unless defined(&_mm_avg_epu16);
	eval 'sub _mm_sad_epu8 {
	    local($__A,$__B) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_psadbw128 (( &__v16qi)$__A, ( &__v16qi)$__B); });
	}' unless defined(&_mm_sad_epu8);
	eval 'sub _mm_stream_si32 {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_movnti ($__A, $__B); });
	}' unless defined(&_mm_stream_si32);
	eval 'sub _mm_stream_si128 {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_movntdq (( &__v2di *)$__A, ( &__v2di)$__B); });
	}' unless defined(&_mm_stream_si128);
	eval 'sub _mm_stream_pd {
	    local($__A,$__B) = @_;
    	    eval q({  &__builtin_ia32_movntpd ($__A, ( &__v2df)$__B); });
	}' unless defined(&_mm_stream_pd);
	eval 'sub _mm_movpi64_epi64 {
	    local($__A) = @_;
    	    eval q({ ( &__m128i) &__builtin_ia32_movq2dq ($__A); });
	}' unless defined(&_mm_movpi64_epi64);
	eval 'sub _mm_clflush {
	    local($__A) = @_;
    	    eval q({  &__builtin_ia32_clflush ($__A); });
	}' unless defined(&_mm_clflush);
	eval 'sub _mm_lfence {
	    local($void) = @_;
    	    eval q({  &__builtin_ia32_lfence (); });
	}' unless defined(&_mm_lfence);
	eval 'sub _mm_mfence {
	    local($void) = @_;
    	    eval q({  &__builtin_ia32_mfence (); });
	}' unless defined(&_mm_mfence);
	eval 'sub _mm_cvtsi32_si128 {
	    local($__A) = @_;
    	    eval q({ ( &__m128i)  &__builtin_ia32_loadd (&$__A); });
	}' unless defined(&_mm_cvtsi32_si128);
	if(defined(&__x86_64__)) {
	    eval 'sub _mm_cvtsi64x_si128 {
	        local($__A) = @_;
    		eval q({ ( &__m128i)  &__builtin_ia32_movq2dq ($__A); });
	    }' unless defined(&_mm_cvtsi64x_si128);
	}
	eval 'sub _mm_cvtsi128_si32 {
	    local($__A) = @_;
    	    eval q({ \'int\'  &__tmp;  &__builtin_ia32_stored (& &__tmp, ( &__v4si)$__A);  &__tmp; });
	}' unless defined(&_mm_cvtsi128_si32);
	if(defined(&__x86_64__)) {
	    eval 'sub _mm_cvtsi128_si64x {
	        local($__A) = @_;
    		eval q({  &__builtin_ia32_movdq2q (( &__v2di)$__A); });
	    }' unless defined(&_mm_cvtsi128_si64x);
	}
    }
}
1;
