require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&RT2560_TX_RING_COUNT)) {
    sub RT2560_TX_RING_COUNT () {	48;}
}
unless(defined(&RT2560_ATIM_RING_COUNT)) {
    sub RT2560_ATIM_RING_COUNT () {	4;}
}
unless(defined(&RT2560_PRIO_RING_COUNT)) {
    sub RT2560_PRIO_RING_COUNT () {	16;}
}
unless(defined(&RT2560_BEACON_RING_COUNT)) {
    sub RT2560_BEACON_RING_COUNT () {	1;}
}
unless(defined(&RT2560_RX_RING_COUNT)) {
    sub RT2560_RX_RING_COUNT () {	32;}
}
unless(defined(&RT2560_TX_DESC_SIZE)) {
    sub RT2560_TX_DESC_SIZE () {	($sizeof{'struct rt2560_tx_desc'});}
}
unless(defined(&RT2560_RX_DESC_SIZE)) {
    sub RT2560_RX_DESC_SIZE () {	($sizeof{'struct rt2560_rx_desc'});}
}
unless(defined(&RT2560_MAX_SCATTER)) {
    sub RT2560_MAX_SCATTER () {	1;}
}
unless(defined(&RT2560_CSR0)) {
    sub RT2560_CSR0 () {	0x;}
}
unless(defined(&RT2560_CSR1)) {
    sub RT2560_CSR1 () {	0x4;}
}
unless(defined(&RT2560_CSR3)) {
    sub RT2560_CSR3 () {	0xc;}
}
unless(defined(&RT2560_CSR4)) {
    sub RT2560_CSR4 () {	0x10;}
}
unless(defined(&RT2560_CSR5)) {
    sub RT2560_CSR5 () {	0x14;}
}
unless(defined(&RT2560_CSR6)) {
    sub RT2560_CSR6 () {	0x18;}
}
unless(defined(&RT2560_CSR7)) {
    sub RT2560_CSR7 () {	0x1c;}
}
unless(defined(&RT2560_CSR8)) {
    sub RT2560_CSR8 () {	0x20;}
}
unless(defined(&RT2560_CSR9)) {
    sub RT2560_CSR9 () {	0x24;}
}
unless(defined(&RT2560_SECCSR0)) {
    sub RT2560_SECCSR0 () {	0x28;}
}
unless(defined(&RT2560_CSR11)) {
    sub RT2560_CSR11 () {	0x2c;}
}
unless(defined(&RT2560_CSR12)) {
    sub RT2560_CSR12 () {	0x30;}
}
unless(defined(&RT2560_CSR13)) {
    sub RT2560_CSR13 () {	0x34;}
}
unless(defined(&RT2560_CSR14)) {
    sub RT2560_CSR14 () {	0x38;}
}
unless(defined(&RT2560_CSR15)) {
    sub RT2560_CSR15 () {	0x3c;}
}
unless(defined(&RT2560_CSR16)) {
    sub RT2560_CSR16 () {	0x40;}
}
unless(defined(&RT2560_CSR17)) {
    sub RT2560_CSR17 () {	0x44;}
}
unless(defined(&RT2560_CSR18)) {
    sub RT2560_CSR18 () {	0x48;}
}
unless(defined(&RT2560_CSR19)) {
    sub RT2560_CSR19 () {	0x4c;}
}
unless(defined(&RT2560_CSR20)) {
    sub RT2560_CSR20 () {	0x50;}
}
unless(defined(&RT2560_CSR21)) {
    sub RT2560_CSR21 () {	0x54;}
}
unless(defined(&RT2560_CSR22)) {
    sub RT2560_CSR22 () {	0x58;}
}
unless(defined(&RT2560_TXCSR0)) {
    sub RT2560_TXCSR0 () {	0x60;}
}
unless(defined(&RT2560_TXCSR1)) {
    sub RT2560_TXCSR1 () {	0x64;}
}
unless(defined(&RT2560_TXCSR2)) {
    sub RT2560_TXCSR2 () {	0x68;}
}
unless(defined(&RT2560_TXCSR3)) {
    sub RT2560_TXCSR3 () {	0x6c;}
}
unless(defined(&RT2560_TXCSR4)) {
    sub RT2560_TXCSR4 () {	0x70;}
}
unless(defined(&RT2560_TXCSR5)) {
    sub RT2560_TXCSR5 () {	0x74;}
}
unless(defined(&RT2560_TXCSR6)) {
    sub RT2560_TXCSR6 () {	0x78;}
}
unless(defined(&RT2560_TXCSR7)) {
    sub RT2560_TXCSR7 () {	0x7c;}
}
unless(defined(&RT2560_RXCSR0)) {
    sub RT2560_RXCSR0 () {	0x80;}
}
unless(defined(&RT2560_RXCSR1)) {
    sub RT2560_RXCSR1 () {	0x84;}
}
unless(defined(&RT2560_RXCSR2)) {
    sub RT2560_RXCSR2 () {	0x88;}
}
unless(defined(&RT2560_PCICSR)) {
    sub RT2560_PCICSR () {	0x8c;}
}
unless(defined(&RT2560_RXCSR3)) {
    sub RT2560_RXCSR3 () {	0x90;}
}
unless(defined(&RT2560_TXCSR9)) {
    sub RT2560_TXCSR9 () {	0x94;}
}
unless(defined(&RT2560_ARSP_PLCP_0)) {
    sub RT2560_ARSP_PLCP_0 () {	0x98;}
}
unless(defined(&RT2560_ARSP_PLCP_1)) {
    sub RT2560_ARSP_PLCP_1 () {	0x9c;}
}
unless(defined(&RT2560_CNT0)) {
    sub RT2560_CNT0 () {	0xa0;}
}
unless(defined(&RT2560_CNT1)) {
    sub RT2560_CNT1 () {	0xac;}
}
unless(defined(&RT2560_CNT2)) {
    sub RT2560_CNT2 () {	0xb0;}
}
unless(defined(&RT2560_CNT3)) {
    sub RT2560_CNT3 () {	0xb8;}
}
unless(defined(&RT2560_CNT4)) {
    sub RT2560_CNT4 () {	0xbc;}
}
unless(defined(&RT2560_CNT5)) {
    sub RT2560_CNT5 () {	0xc0;}
}
unless(defined(&RT2560_PWRCSR0)) {
    sub RT2560_PWRCSR0 () {	0xc4;}
}
unless(defined(&RT2560_PSCSR0)) {
    sub RT2560_PSCSR0 () {	0xc8;}
}
unless(defined(&RT2560_PSCSR1)) {
    sub RT2560_PSCSR1 () {	0xcc;}
}
unless(defined(&RT2560_PSCSR2)) {
    sub RT2560_PSCSR2 () {	0xd0;}
}
unless(defined(&RT2560_PSCSR3)) {
    sub RT2560_PSCSR3 () {	0xd4;}
}
unless(defined(&RT2560_PWRCSR1)) {
    sub RT2560_PWRCSR1 () {	0xd8;}
}
unless(defined(&RT2560_TIMECSR)) {
    sub RT2560_TIMECSR () {	0xdc;}
}
unless(defined(&RT2560_MACCSR0)) {
    sub RT2560_MACCSR0 () {	0xe0;}
}
unless(defined(&RT2560_MACCSR1)) {
    sub RT2560_MACCSR1 () {	0xe4;}
}
unless(defined(&RT2560_RALINKCSR)) {
    sub RT2560_RALINKCSR () {	0xe8;}
}
unless(defined(&RT2560_BCNCSR)) {
    sub RT2560_BCNCSR () {	0xec;}
}
unless(defined(&RT2560_BBPCSR)) {
    sub RT2560_BBPCSR () {	0xf0;}
}
unless(defined(&RT2560_RFCSR)) {
    sub RT2560_RFCSR () {	0xf4;}
}
unless(defined(&RT2560_LEDCSR)) {
    sub RT2560_LEDCSR () {	0xf8;}
}
unless(defined(&RT2560_SECCSR3)) {
    sub RT2560_SECCSR3 () {	0xfc;}
}
unless(defined(&RT2560_DMACSR0)) {
    sub RT2560_DMACSR0 () {	0x100;}
}
unless(defined(&RT2560_DMACSR1)) {
    sub RT2560_DMACSR1 () {	0x104;}
}
unless(defined(&RT2560_DMACSR2)) {
    sub RT2560_DMACSR2 () {	0x104;}
}
unless(defined(&RT2560_DMACSR3)) {
    sub RT2560_DMACSR3 () {	0x104;}
}
unless(defined(&RT2560_TXACKCSR0)) {
    sub RT2560_TXACKCSR0 () {	0x110;}
}
unless(defined(&RT2560_GPIOCSR)) {
    sub RT2560_GPIOCSR () {	0x120;}
}
unless(defined(&RT2560_BBBPPCSR)) {
    sub RT2560_BBBPPCSR () {	0x124;}
}
unless(defined(&RT2560_FIFOCSR0)) {
    sub RT2560_FIFOCSR0 () {	0x128;}
}
unless(defined(&RT2560_FIFOCSR1)) {
    sub RT2560_FIFOCSR1 () {	0x12c;}
}
unless(defined(&RT2560_BCNOCSR)) {
    sub RT2560_BCNOCSR () {	0x130;}
}
unless(defined(&RT2560_RLPWCSR)) {
    sub RT2560_RLPWCSR () {	0x134;}
}
unless(defined(&RT2560_TESTCSR)) {
    sub RT2560_TESTCSR () {	0x138;}
}
unless(defined(&RT2560_PLCP1MCSR)) {
    sub RT2560_PLCP1MCSR () {	0x13c;}
}
unless(defined(&RT2560_PLCP2MCSR)) {
    sub RT2560_PLCP2MCSR () {	0x140;}
}
unless(defined(&RT2560_PLCP5p5MCSR)) {
    sub RT2560_PLCP5p5MCSR () {	0x144;}
}
unless(defined(&RT2560_PLCP11MCSR)) {
    sub RT2560_PLCP11MCSR () {	0x148;}
}
unless(defined(&RT2560_ACKPCTCSR)) {
    sub RT2560_ACKPCTCSR () {	0x14c;}
}
unless(defined(&RT2560_ARTCSR1)) {
    sub RT2560_ARTCSR1 () {	0x150;}
}
unless(defined(&RT2560_ARTCSR2)) {
    sub RT2560_ARTCSR2 () {	0x154;}
}
unless(defined(&RT2560_SECCSR1)) {
    sub RT2560_SECCSR1 () {	0x158;}
}
unless(defined(&RT2560_BBPCSR1)) {
    sub RT2560_BBPCSR1 () {	0x15c;}
}
unless(defined(&RT2560_DISABLE_RX)) {
    sub RT2560_DISABLE_RX () {	(1<< 0);}
}
unless(defined(&RT2560_DROP_CRC_ERROR)) {
    sub RT2560_DROP_CRC_ERROR () {	(1<< 1);}
}
unless(defined(&RT2560_DROP_PHY_ERROR)) {
    sub RT2560_DROP_PHY_ERROR () {	(1<< 2);}
}
unless(defined(&RT2560_DROP_CTL)) {
    sub RT2560_DROP_CTL () {	(1<< 3);}
}
unless(defined(&RT2560_DROP_NOT_TO_ME)) {
    sub RT2560_DROP_NOT_TO_ME () {	(1<< 4);}
}
unless(defined(&RT2560_DROP_TODS)) {
    sub RT2560_DROP_TODS () {	(1<< 5);}
}
unless(defined(&RT2560_DROP_VERSION_ERROR)) {
    sub RT2560_DROP_VERSION_ERROR () {	(1<< 6);}
}
unless(defined(&RT2560_RESET_ASIC)) {
    sub RT2560_RESET_ASIC () {	(1<< 0);}
}
unless(defined(&RT2560_RESET_BBP)) {
    sub RT2560_RESET_BBP () {	(1<< 1);}
}
unless(defined(&RT2560_HOST_READY)) {
    sub RT2560_HOST_READY () {	(1<< 2);}
}
unless(defined(&RT2560_ENABLE_TSF)) {
    sub RT2560_ENABLE_TSF () {	(1<< 0);}
}
unless(defined(&RT2560_ENABLE_TSF_SYNC)) {
    sub RT2560_ENABLE_TSF_SYNC {
	local($x) = @_;
	eval q(((($x) & 0x3) << 1));
    }
}
unless(defined(&RT2560_ENABLE_TBCN)) {
    sub RT2560_ENABLE_TBCN () {	(1<< 3);}
}
unless(defined(&RT2560_ENABLE_BEACON_GENERATOR)) {
    sub RT2560_ENABLE_BEACON_GENERATOR () {	(1<< 6);}
}
unless(defined(&RT2560_C)) {
    sub RT2560_C () {	(1<< 1);}
}
unless(defined(&RT2560_S)) {
    sub RT2560_S () {	(1<< 2);}
}
unless(defined(&RT2560_D)) {
    sub RT2560_D () {	(1<< 3);}
}
unless(defined(&RT2560_Q)) {
    sub RT2560_Q () {	(1<< 4);}
}
unless(defined(&RT2560_93C46)) {
    sub RT2560_93C46 () {	(1<< 5);}
}
unless(defined(&RT2560_SHIFT_D)) {
    sub RT2560_SHIFT_D () {	3;}
}
unless(defined(&RT2560_SHIFT_Q)) {
    sub RT2560_SHIFT_Q () {	4;}
}
unless(defined(&RT2560_KICK_TX)) {
    sub RT2560_KICK_TX () {	(1<< 0);}
}
unless(defined(&RT2560_KICK_ATIM)) {
    sub RT2560_KICK_ATIM () {	(1<< 1);}
}
unless(defined(&RT2560_KICK_PRIO)) {
    sub RT2560_KICK_PRIO () {	(1<< 2);}
}
unless(defined(&RT2560_ABORT_TX)) {
    sub RT2560_ABORT_TX () {	(1<< 3);}
}
unless(defined(&RT2560_KICK_DECRYPT)) {
    sub RT2560_KICK_DECRYPT () {	(1<< 0);}
}
unless(defined(&RT2560_KICK_ENCRYPT)) {
    sub RT2560_KICK_ENCRYPT () {	(1<< 0);}
}
unless(defined(&RT2560_BEACON_EXPIRE)) {
    sub RT2560_BEACON_EXPIRE () {	0x1;}
}
unless(defined(&RT2560_WAKEUP_EXPIRE)) {
    sub RT2560_WAKEUP_EXPIRE () {	0x2;}
}
unless(defined(&RT2560_ATIM_EXPIRE)) {
    sub RT2560_ATIM_EXPIRE () {	0x4;}
}
unless(defined(&RT2560_TX_DONE)) {
    sub RT2560_TX_DONE () {	0x8;}
}
unless(defined(&RT2560_ATIM_DONE)) {
    sub RT2560_ATIM_DONE () {	0x10;}
}
unless(defined(&RT2560_PRIO_DONE)) {
    sub RT2560_PRIO_DONE () {	0x20;}
}
unless(defined(&RT2560_RX_DONE)) {
    sub RT2560_RX_DONE () {	0x40;}
}
unless(defined(&RT2560_DECRYPTION_DONE)) {
    sub RT2560_DECRYPTION_DONE () {	0x80;}
}
unless(defined(&RT2560_ENCRYPTION_DONE)) {
    sub RT2560_ENCRYPTION_DONE () {	0x100;}
}
unless(defined(&RT2560_INTR_MASK)) {
    sub RT2560_INTR_MASK () {	(~( &RT2560_BEACON_EXPIRE |  &RT2560_WAKEUP_EXPIRE |  &RT2560_TX_DONE |  &RT2560_PRIO_DONE |  &RT2560_RX_DONE |  &RT2560_DECRYPTION_DONE |  &RT2560_ENCRYPTION_DONE));}
}
unless(defined(&RT2560_TX_BUSY)) {
    sub RT2560_TX_BUSY () {	(1<< 0);}
}
unless(defined(&RT2560_TX_VALID)) {
    sub RT2560_TX_VALID () {	(1<< 1);}
}
unless(defined(&RT2560_TX_RESULT_MASK)) {
    sub RT2560_TX_RESULT_MASK () {	0x1c;}
}
unless(defined(&RT2560_TX_SUCCESS)) {
    sub RT2560_TX_SUCCESS () {	(0<< 2);}
}
unless(defined(&RT2560_TX_SUCCESS_RETRY)) {
    sub RT2560_TX_SUCCESS_RETRY () {	(1<< 2);}
}
unless(defined(&RT2560_TX_FAIL_RETRY)) {
    sub RT2560_TX_FAIL_RETRY () {	(2<< 2);}
}
unless(defined(&RT2560_TX_FAIL_INVALID)) {
    sub RT2560_TX_FAIL_INVALID () {	(3<< 2);}
}
unless(defined(&RT2560_TX_FAIL_OTHER)) {
    sub RT2560_TX_FAIL_OTHER () {	(4<< 2);}
}
unless(defined(&RT2560_TX_MORE_FRAG)) {
    sub RT2560_TX_MORE_FRAG () {	(1<< 8);}
}
unless(defined(&RT2560_TX_ACK)) {
    sub RT2560_TX_ACK () {	(1<< 9);}
}
unless(defined(&RT2560_TX_TIMESTAMP)) {
    sub RT2560_TX_TIMESTAMP () {	(1<< 10);}
}
unless(defined(&RT2560_TX_OFDM)) {
    sub RT2560_TX_OFDM () {	(1<< 11);}
}
unless(defined(&RT2560_TX_CIPHER_BUSY)) {
    sub RT2560_TX_CIPHER_BUSY () {	(1<< 12);}
}
unless(defined(&RT2560_TX_IFS_MASK)) {
    sub RT2560_TX_IFS_MASK () {	0x6000;}
}
unless(defined(&RT2560_TX_IFS_BACKOFF)) {
    sub RT2560_TX_IFS_BACKOFF () {	(0<< 13);}
}
unless(defined(&RT2560_TX_IFS_SIFS)) {
    sub RT2560_TX_IFS_SIFS () {	(1<< 13);}
}
unless(defined(&RT2560_TX_IFS_NEWBACKOFF)) {
    sub RT2560_TX_IFS_NEWBACKOFF () {	(2<< 13);}
}
unless(defined(&RT2560_TX_IFS_NONE)) {
    sub RT2560_TX_IFS_NONE () {	(3<< 13);}
}
unless(defined(&RT2560_TX_LONG_RETRY)) {
    sub RT2560_TX_LONG_RETRY () {	(1<< 15);}
}
unless(defined(&RT2560_TX_CIPHER_MASK)) {
    sub RT2560_TX_CIPHER_MASK () {	0xe0000000;}
}
unless(defined(&RT2560_TX_CIPHER_NONE)) {
    sub RT2560_TX_CIPHER_NONE () {	(0<< 29);}
}
unless(defined(&RT2560_TX_CIPHER_WEP40)) {
    sub RT2560_TX_CIPHER_WEP40 () {	(1<< 29);}
}
unless(defined(&RT2560_TX_CIPHER_WEP104)) {
    sub RT2560_TX_CIPHER_WEP104 () {	(2<< 29);}
}
unless(defined(&RT2560_TX_CIPHER_TKIP)) {
    sub RT2560_TX_CIPHER_TKIP () {	(3<< 29);}
}
unless(defined(&RT2560_TX_CIPHER_AES)) {
    sub RT2560_TX_CIPHER_AES () {	(4<< 29);}
}
unless(defined(&RT2560_LOGCWMAX)) {
    sub RT2560_LOGCWMAX {
	local($x) = @_;
	eval q(((($x) & 0xf) << 12));
    }
}
unless(defined(&RT2560_LOGCWMIN)) {
    sub RT2560_LOGCWMIN {
	local($x) = @_;
	eval q(((($x) & 0xf) << 8));
    }
}
unless(defined(&RT2560_AIFSN)) {
    sub RT2560_AIFSN {
	local($x) = @_;
	eval q(((($x) & 0x3) << 6));
    }
}
unless(defined(&RT2560_IVOFFSET)) {
    sub RT2560_IVOFFSET {
	local($x) = @_;
	eval q(((($x) & 0x3f)));
    }
}
unless(defined(&RT2560_PLCP_LENGEXT)) {
    sub RT2560_PLCP_LENGEXT () {	0x80;}
}
unless(defined(&RT2560_RX_BUSY)) {
    sub RT2560_RX_BUSY () {	(1<< 0);}
}
unless(defined(&RT2560_RX_CRC_ERROR)) {
    sub RT2560_RX_CRC_ERROR () {	(1<< 5);}
}
unless(defined(&RT2560_RX_OFDM)) {
    sub RT2560_RX_OFDM () {	(1<< 6);}
}
unless(defined(&RT2560_RX_PHY_ERROR)) {
    sub RT2560_RX_PHY_ERROR () {	(1<< 7);}
}
unless(defined(&RT2560_RX_CIPHER_BUSY)) {
    sub RT2560_RX_CIPHER_BUSY () {	(1<< 8);}
}
unless(defined(&RT2560_RX_ICV_ERROR)) {
    sub RT2560_RX_ICV_ERROR () {	(1<< 9);}
}
unless(defined(&RT2560_RX_CIPHER_MASK)) {
    sub RT2560_RX_CIPHER_MASK () {	0xe0000000;}
}
unless(defined(&RT2560_RX_CIPHER_NONE)) {
    sub RT2560_RX_CIPHER_NONE () {	(0<< 29);}
}
unless(defined(&RT2560_RX_CIPHER_WEP40)) {
    sub RT2560_RX_CIPHER_WEP40 () {	(1<< 29);}
}
unless(defined(&RT2560_RX_CIPHER_WEP104)) {
    sub RT2560_RX_CIPHER_WEP104 () {	(2<< 29);}
}
unless(defined(&RT2560_RX_CIPHER_TKIP)) {
    sub RT2560_RX_CIPHER_TKIP () {	(3<< 29);}
}
unless(defined(&RT2560_RX_CIPHER_AES)) {
    sub RT2560_RX_CIPHER_AES () {	(4<< 29);}
}
unless(defined(&RT2560_RF1)) {
    sub RT2560_RF1 () {	0;}
}
unless(defined(&RT2560_RF2)) {
    sub RT2560_RF2 () {	2;}
}
unless(defined(&RT2560_RF3)) {
    sub RT2560_RF3 () {	1;}
}
unless(defined(&RT2560_RF4)) {
    sub RT2560_RF4 () {	3;}
}
unless(defined(&RT2560_RF1_AUTOTUNE)) {
    sub RT2560_RF1_AUTOTUNE () {	0x8000;}
}
unless(defined(&RT2560_RF3_AUTOTUNE)) {
    sub RT2560_RF3_AUTOTUNE () {	0x40;}
}
unless(defined(&RT2560_BBP_BUSY)) {
    sub RT2560_BBP_BUSY () {	(1<< 15);}
}
unless(defined(&RT2560_BBP_WRITE)) {
    sub RT2560_BBP_WRITE () {	(1<< 16);}
}
unless(defined(&RT2560_RF_20BIT)) {
    sub RT2560_RF_20BIT () {	(20<< 24);}
}
unless(defined(&RT2560_RF_BUSY)) {
    sub RT2560_RF_BUSY () {	(1<< 31);}
}
unless(defined(&RT2560_RF_2522)) {
    sub RT2560_RF_2522 () {	0x;}
}
unless(defined(&RT2560_RF_2523)) {
    sub RT2560_RF_2523 () {	0x1;}
}
unless(defined(&RT2560_RF_2524)) {
    sub RT2560_RF_2524 () {	0x2;}
}
unless(defined(&RT2560_RF_2525)) {
    sub RT2560_RF_2525 () {	0x3;}
}
unless(defined(&RT2560_RF_2525E)) {
    sub RT2560_RF_2525E () {	0x4;}
}
unless(defined(&RT2560_RF_2526)) {
    sub RT2560_RF_2526 () {	0x5;}
}
unless(defined(&RT2560_RF_5222)) {
    sub RT2560_RF_5222 () {	0x10;}
}
unless(defined(&RT2560_BBP_VERSION)) {
    sub RT2560_BBP_VERSION () {	0;}
}
unless(defined(&RT2560_BBP_TX)) {
    sub RT2560_BBP_TX () {	2;}
}
unless(defined(&RT2560_BBP_RX)) {
    sub RT2560_BBP_RX () {	14;}
}
unless(defined(&RT2560_BBP_ANTA)) {
    sub RT2560_BBP_ANTA () {	0x;}
}
unless(defined(&RT2560_BBP_DIVERSITY)) {
    sub RT2560_BBP_DIVERSITY () {	0x1;}
}
unless(defined(&RT2560_BBP_ANTB)) {
    sub RT2560_BBP_ANTB () {	0x2;}
}
unless(defined(&RT2560_BBP_ANTMASK)) {
    sub RT2560_BBP_ANTMASK () {	0x3;}
}
unless(defined(&RT2560_BBP_FLIPIQ)) {
    sub RT2560_BBP_FLIPIQ () {	0x4;}
}
unless(defined(&RT2560_LED_MODE_DEFAULT)) {
    sub RT2560_LED_MODE_DEFAULT () {	0;}
}
unless(defined(&RT2560_LED_MODE_TXRX_ACTIVITY)) {
    sub RT2560_LED_MODE_TXRX_ACTIVITY () {	1;}
}
unless(defined(&RT2560_LED_MODE_SINGLE)) {
    sub RT2560_LED_MODE_SINGLE () {	2;}
}
unless(defined(&RT2560_LED_MODE_ASUS)) {
    sub RT2560_LED_MODE_ASUS () {	3;}
}
unless(defined(&RT2560_JAPAN_FILTER)) {
    sub RT2560_JAPAN_FILTER () {	0x8;}
}
unless(defined(&RT2560_EEPROM_CONFIG0)) {
    sub RT2560_EEPROM_CONFIG0 () {	16;}
}
unless(defined(&RT2560_EEPROM_BBP_BASE)) {
    sub RT2560_EEPROM_BBP_BASE () {	19;}
}
unless(defined(&RT2560_EEPROM_TXPOWER)) {
    sub RT2560_EEPROM_TXPOWER () {	35;}
}
unless(defined(&RT2560_EEPROM_DELAY)) {
    sub RT2560_EEPROM_DELAY () {	1;}
}
unless(defined(&RAL_READ)) {
    sub RAL_READ {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&RAL_WRITE)) {
    sub RAL_WRITE {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&RT2560_EEPROM_CTL)) {
    sub RT2560_EEPROM_CTL {
	local($sc, $val) = @_;
	eval q( &do {  &RAL_WRITE(($sc),  &RT2560_CSR21, ($val));  &DELAY( &RT2560_EEPROM_DELAY); }  &while ( 0));
    }
}
1;
