require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SYS_MUTEX_H_)) {
    eval 'sub _SYS_MUTEX_H_ () {1;}' unless defined(&_SYS_MUTEX_H_);
    if(defined(&__HAVE_MUTEX)) {
	require 'machine/mutex.ph';
    } else {
	eval 'sub MUTEX_IPL {
	    local($ipl) = @_;
    	    eval q( &MUTEX_$ipl);
	}' unless defined(&MUTEX_IPL);
	eval 'sub MUTEX_IPL_NONE () {0;}' unless defined(&MUTEX_IPL_NONE);
	eval 'sub MUTEX_IPL_SOFTSERIAL () {1;}' unless defined(&MUTEX_IPL_SOFTSERIAL);
	eval 'sub MUTEX_IPL_SOFTCLOCK () {2;}' unless defined(&MUTEX_IPL_SOFTCLOCK);
	eval 'sub MUTEX_IPL_SOFTNET () {3;}' unless defined(&MUTEX_IPL_SOFTNET);
	eval 'sub MUTEX_IPL_NET () {4;}' unless defined(&MUTEX_IPL_NET);
	eval 'sub MUTEX_IPL_BIO () {5;}' unless defined(&MUTEX_IPL_BIO);
	eval 'sub MUTEX_IPL_VM () {6;}' unless defined(&MUTEX_IPL_VM);
	eval 'sub MUTEX_IPL_TTY () {7;}' unless defined(&MUTEX_IPL_TTY);
	eval 'sub MUTEX_IPL_SERIAL () {8;}' unless defined(&MUTEX_IPL_SERIAL);
	eval 'sub MUTEX_IPL_AUDIO () {9;}' unless defined(&MUTEX_IPL_AUDIO);
	eval 'sub MUTEX_IPL_CLOCK () {10;}' unless defined(&MUTEX_IPL_CLOCK);
	eval 'sub MUTEX_IPL_STATCLOCK () {11;}' unless defined(&MUTEX_IPL_STATCLOCK);
	eval 'sub MUTEX_IPL_SCHED () {12;}' unless defined(&MUTEX_IPL_SCHED);
	eval 'sub MUTEX_IPL_HIGH () {13;}' unless defined(&MUTEX_IPL_HIGH);
	eval 'sub mtx_init {
	    local($mtx, $ipl) = @_;
    	    eval q( &mtx_init1($mtx,  &MUTEX_$ipl));
	}' unless defined(&mtx_init);
	eval 'sub MUTEX_INITIALIZER {
	    local($ipl) = @_;
    	    eval q({ 0,  &MUTEX_$ipl, 0});
	}' unless defined(&MUTEX_INITIALIZER);
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub MUTEX_ASSERT_LOCKED {
	        local($mtx) = @_;
    		eval q( &do {  &if (($mtx)-> &mtx_lock == 0)  &panic(\\"mutex %p not held in %s\\", ($mtx),  &__func__); }  &while (0));
	    }' unless defined(&MUTEX_ASSERT_LOCKED);
	    eval 'sub MUTEX_ASSERT_UNLOCKED {
	        local($mtx) = @_;
    		eval q( &do {  &if (($mtx)-> &mtx_lock != 0)  &panic(\\"mutex %p held in %s\\", ($mtx),  &__func__); }  &while (0));
	    }' unless defined(&MUTEX_ASSERT_UNLOCKED);
	} else {
	    eval 'sub MUTEX_ASSERT_LOCKED {
	        local($mtx) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&MUTEX_ASSERT_LOCKED);
	    eval 'sub MUTEX_ASSERT_UNLOCKED {
	        local($mtx) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&MUTEX_ASSERT_UNLOCKED);
	}
	eval 'sub MUTEX_OLDIPL {
	    local($mtx) = @_;
    	    eval q(($mtx)-> &mtx_oldipl);
	}' unless defined(&MUTEX_OLDIPL);
    }
    unless(defined(&mtx_init)) {
    }
}
1;
