require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SYS_ENDIAN_H_)) {
    eval 'sub _SYS_ENDIAN_H_ () {1;}' unless defined(&_SYS_ENDIAN_H_);
    unless(defined(&_POSIX_SOURCE)) {
	require 'sys/cdefs.ph';
	eval 'sub LITTLE_ENDIAN () {1234;}' unless defined(&LITTLE_ENDIAN);
	eval 'sub BIG_ENDIAN () {4321;}' unless defined(&BIG_ENDIAN);
	eval 'sub PDP_ENDIAN () {3412;}' unless defined(&PDP_ENDIAN);
	if(defined(&__GNUC__)) {
	    eval 'sub __swap16gen {
	        local($x) = @_;
    		eval q( &__extension__({  &u_int16_t  &__swap16gen_x = ($x); ( &u_int16_t)(( &__swap16gen_x & 0xff) << 8| ( &__swap16gen_x & 0xff00) >> 8); }));
	    }' unless defined(&__swap16gen);
	    eval 'sub __swap32gen {
	        local($x) = @_;
    		eval q( &__extension__({  &u_int32_t  &__swap32gen_x = ($x); ( &u_int32_t)(( &__swap32gen_x & 0xff) << 24| ( &__swap32gen_x & 0xff00) << 8| ( &__swap32gen_x & 0xff0000) >> 8| ( &__swap32gen_x & 0xff000000) >> 24); }));
	    }' unless defined(&__swap32gen);
	    eval 'sub __swap64gen {
	        local($x) = @_;
    		eval q( &__extension__({  &u_int64_t  &__swap64gen_x = ($x); ( &u_int64_t)(( &__swap64gen_x & 0xff) << 56| ( &__swap64gen_x & 0xff00) << 40| ( &__swap64gen_x & 0xff0000) << 24| ( &__swap64gen_x & 0xff000000) << 8| ( &__swap64gen_x & 1095216660480) >> 8| ( &__swap64gen_x & 280375465082880) >> 24| ( &__swap64gen_x & 7.177611906121728e+16) >> 40| ( &__swap64gen_x & 1.837468647967162e+19) >> 56); }));
	    }' unless defined(&__swap64gen);
	} else {
	    eval 'sub __swap16gen {
	        local($x) = @_;
    		eval q(( &u_int16_t)((( &u_int16_t)($x) & 0xff) << 8| (( &u_int16_t)($x) & 0xff00) >> 8));
	    }' unless defined(&__swap16gen);
	    eval 'sub __swap32gen {
	        local($x) = @_;
    		eval q(( &u_int32_t)((( &u_int32_t)($x) & 0xff) << 24| (( &u_int32_t)($x) & 0xff00) << 8| (( &u_int32_t)($x) & 0xff0000) >> 8| (( &u_int32_t)($x) & 0xff000000) >> 24));
	    }' unless defined(&__swap32gen);
	    eval 'sub __swap64gen {
	        local($x) = @_;
    		eval q(( &u_int64_t)(((( &u_int64_t)($x) & 0xff) << 56) | (( &u_int64_t)($x) & 0xff00) << 40| (( &u_int64_t)($x) & 0xff0000) << 24| (( &u_int64_t)($x) & 0xff000000) << 8| (( &u_int64_t)($x) & 1095216660480) >> 8| (( &u_int64_t)($x) & 280375465082880) >> 24| (( &u_int64_t)($x) & 7.177611906121728e+16) >> 40| (( &u_int64_t)($x) & 1.837468647967162e+19) >> 56));
	    }' unless defined(&__swap64gen);
	}
	if(defined(&MD_SWAP)) {
	    if((defined(&__GNUC__) ? &__GNUC__ : 0)) {
		eval 'sub swap16 {
		    local($x) = @_;
    		    eval q( &__extension__({  &u_int16_t  &__swap16_x = ($x);  &__builtin_constant_p($x) ?  &__swap16gen( &__swap16_x) :  &__swap16md( &__swap16_x); }));
		}' unless defined(&swap16);
		eval 'sub swap32 {
		    local($x) = @_;
    		    eval q( &__extension__({  &u_int32_t  &__swap32_x = ($x);  &__builtin_constant_p($x) ?  &__swap32gen( &__swap32_x) :  &__swap32md( &__swap32_x); }));
		}' unless defined(&swap32);
		eval 'sub swap64 {
		    local($x) = @_;
    		    eval q( &__extension__({  &u_int64_t  &__swap64_x = ($x);  &__builtin_constant_p($x) ?  &__swap64gen( &__swap64_x) :  &__swap64md( &__swap64_x); }));
		}' unless defined(&swap64);
	    }
	} else {
	    eval 'sub swap16 () { &__swap16gen;}' unless defined(&swap16);
	    eval 'sub swap32 () { &__swap32gen;}' unless defined(&swap32);
	    eval 'sub swap64 () { &__swap64gen;}' unless defined(&swap64);
	}
	eval 'sub swap16_multi {
	    local($v, $n) = @_;
    	    eval q( &do { \'size_t\'  &__swap16_multi_n = ($n);  &u_int16_t * &__swap16_multi_v = ($v);  &while ( &__swap16_multi_n) { * &__swap16_multi_v =  &swap16(* &__swap16_multi_v);  &__swap16_multi_v++;  &__swap16_multi_n--; } }  &while (0));
	}' unless defined(&swap16_multi);
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : 0)) {
	    unless(defined(&_QUAD_HIGHWORD)) {
		eval 'sub _QUAD_HIGHWORD () {1;}' unless defined(&_QUAD_HIGHWORD);
	    }
	    unless(defined(&_QUAD_LOWWORD)) {
		eval 'sub _QUAD_LOWWORD () {0;}' unless defined(&_QUAD_LOWWORD);
	    }
	    eval 'sub htobe16 () { &swap16;}' unless defined(&htobe16);
	    eval 'sub htobe32 () { &swap32;}' unless defined(&htobe32);
	    eval 'sub htobe64 () { &swap64;}' unless defined(&htobe64);
	    eval 'sub betoh16 () { &swap16;}' unless defined(&betoh16);
	    eval 'sub betoh32 () { &swap32;}' unless defined(&betoh32);
	    eval 'sub betoh64 () { &swap64;}' unless defined(&betoh64);
	    eval 'sub htole16 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&htole16);
	    eval 'sub htole32 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&htole32);
	    eval 'sub htole64 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&htole64);
	    eval 'sub letoh16 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&letoh16);
	    eval 'sub letoh32 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&letoh32);
	    eval 'sub letoh64 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&letoh64);
	}
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
	    unless(defined(&_QUAD_HIGHWORD)) {
		eval 'sub _QUAD_HIGHWORD () {0;}' unless defined(&_QUAD_HIGHWORD);
	    }
	    unless(defined(&_QUAD_LOWWORD)) {
		eval 'sub _QUAD_LOWWORD () {1;}' unless defined(&_QUAD_LOWWORD);
	    }
	    eval 'sub htole16 () { &swap16;}' unless defined(&htole16);
	    eval 'sub htole32 () { &swap32;}' unless defined(&htole32);
	    eval 'sub htole64 () { &swap64;}' unless defined(&htole64);
	    eval 'sub letoh16 () { &swap16;}' unless defined(&letoh16);
	    eval 'sub letoh32 () { &swap32;}' unless defined(&letoh32);
	    eval 'sub letoh64 () { &swap64;}' unless defined(&letoh64);
	    eval 'sub htobe16 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&htobe16);
	    eval 'sub htobe32 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&htobe32);
	    eval 'sub htobe64 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&htobe64);
	    eval 'sub betoh16 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&betoh16);
	    eval 'sub betoh32 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&betoh32);
	    eval 'sub betoh64 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&betoh64);
	}
	eval 'sub htons () { &htobe16;}' unless defined(&htons);
	eval 'sub htonl () { &htobe32;}' unless defined(&htonl);
	eval 'sub ntohs () { &betoh16;}' unless defined(&ntohs);
	eval 'sub ntohl () { &betoh32;}' unless defined(&ntohl);
	eval 'sub NTOHL {
	    local($x) = @_;
    	    eval q(($x) =  &ntohl(( &u_int32_t)($x)));
	}' unless defined(&NTOHL);
	eval 'sub NTOHS {
	    local($x) = @_;
    	    eval q(($x) =  &ntohs(( &u_int16_t)($x)));
	}' unless defined(&NTOHS);
	eval 'sub HTONL {
	    local($x) = @_;
    	    eval q(($x) =  &htonl(( &u_int32_t)($x)));
	}' unless defined(&HTONL);
	eval 'sub HTONS {
	    local($x) = @_;
    	    eval q(($x) =  &htons(( &u_int16_t)($x)));
	}' unless defined(&HTONS);
    }
}
1;
