require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DEV_IC_MPT_H_)) {
    eval 'sub _DEV_IC_MPT_H_ () {1;}' unless defined(&_DEV_IC_MPT_H_);
    require 'dev/ic/mpt_openbsd.ph';
    eval 'sub MPT_OK () {(0);}' unless defined(&MPT_OK);
    eval 'sub MPT_FAIL () {(0x10000);}' unless defined(&MPT_FAIL);
    eval 'sub MPT_OFFSET_DOORBELL () {0x;}' unless defined(&MPT_OFFSET_DOORBELL);
    eval 'sub MPT_OFFSET_SEQUENCE () {0x4;}' unless defined(&MPT_OFFSET_SEQUENCE);
    eval 'sub MPT_OFFSET_DIAGNOSTIC () {0x8;}' unless defined(&MPT_OFFSET_DIAGNOSTIC);
    eval 'sub MPT_OFFSET_TEST () {0xc;}' unless defined(&MPT_OFFSET_TEST);
    eval 'sub MPT_OFFSET_RWDATA () {0x10;}' unless defined(&MPT_OFFSET_RWDATA);
    eval 'sub MPT_OFFSET_RWADDR () {0x14;}' unless defined(&MPT_OFFSET_RWADDR);
    eval 'sub MPT_OFFSET_INTR_STATUS () {0x30;}' unless defined(&MPT_OFFSET_INTR_STATUS);
    eval 'sub MPT_OFFSET_INTR_MASK () {0x34;}' unless defined(&MPT_OFFSET_INTR_MASK);
    eval 'sub MPT_OFFSET_REQUEST_Q () {0x40;}' unless defined(&MPT_OFFSET_REQUEST_Q);
    eval 'sub MPT_OFFSET_REPLY_Q () {0x44;}' unless defined(&MPT_OFFSET_REPLY_Q);
    eval 'sub MPT_OFFSET_HOST_INDEX () {0x50;}' unless defined(&MPT_OFFSET_HOST_INDEX);
    eval 'sub MPT_OFFSET_FUBAR () {0x90;}' unless defined(&MPT_OFFSET_FUBAR);
    eval 'sub MPT_DIAG_SEQUENCE_1 () {0x4;}' unless defined(&MPT_DIAG_SEQUENCE_1);
    eval 'sub MPT_DIAG_SEQUENCE_2 () {0xb;}' unless defined(&MPT_DIAG_SEQUENCE_2);
    eval 'sub MPT_DIAG_SEQUENCE_3 () {0x2;}' unless defined(&MPT_DIAG_SEQUENCE_3);
    eval 'sub MPT_DIAG_SEQUENCE_4 () {0x7;}' unless defined(&MPT_DIAG_SEQUENCE_4);
    eval 'sub MPT_DIAG_SEQUENCE_5 () {0xd;}' unless defined(&MPT_DIAG_SEQUENCE_5);
    eval("sub MPT_DB_STATE_RESET () { 0x00000000; }") unless defined(&MPT_DB_STATE_RESET);
    eval("sub MPT_DB_STATE_READY () { 0x10000000; }") unless defined(&MPT_DB_STATE_READY);
    eval("sub MPT_DB_STATE_RUNNING () { 0x20000000; }") unless defined(&MPT_DB_STATE_RUNNING);
    eval("sub MPT_DB_STATE_FAULT () { 0x40000000; }") unless defined(&MPT_DB_STATE_FAULT);
    eval("sub MPT_DB_STATE_MASK () { 0xf0000000; }") unless defined(&MPT_DB_STATE_MASK);
    eval 'sub MPT_STATE {
        local($v) = @_;
	    eval q((( &enum  &DB_STATE_BITS)(($v) &  &MPT_DB_STATE_MASK)));
    }' unless defined(&MPT_STATE);
    eval 'sub MPT_DB_LENGTH_SHIFT () {(16);}' unless defined(&MPT_DB_LENGTH_SHIFT);
    eval 'sub MPT_DB_DATA_MASK () {(0xffff);}' unless defined(&MPT_DB_DATA_MASK);
    eval 'sub MPT_DB_DB_USED () {0x8000000;}' unless defined(&MPT_DB_DB_USED);
    eval 'sub MPT_DB_IS_IN_USE {
        local($v) = @_;
	    eval q(((($v) &  &MPT_DB_DB_USED) != 0));
    }' unless defined(&MPT_DB_IS_IN_USE);
    eval 'sub MPT_DB_INIT_NOONE () {0x;}' unless defined(&MPT_DB_INIT_NOONE);
    eval 'sub MPT_DB_INIT_BIOS () {0x1;}' unless defined(&MPT_DB_INIT_BIOS);
    eval 'sub MPT_DB_INIT_ROMBIOS () {0x2;}' unless defined(&MPT_DB_INIT_ROMBIOS);
    eval 'sub MPT_DB_INIT_PCIPEER () {0x3;}' unless defined(&MPT_DB_INIT_PCIPEER);
    eval 'sub MPT_DB_INIT_HOST () {0x4;}' unless defined(&MPT_DB_INIT_HOST);
    eval 'sub MPT_DB_INIT_MANUFACTURE () {0x5;}' unless defined(&MPT_DB_INIT_MANUFACTURE);
    eval 'sub MPT_WHO {
        local($v) = @_;
	    eval q((($v &  &MPI_DOORBELL_WHO_INIT_MASK) >>  &MPI_DOORBELL_WHO_INIT_SHIFT));
    }' unless defined(&MPT_WHO);
    eval("sub MPT_FUNC_IOC_RESET () { 0x40000000; }") unless defined(&MPT_FUNC_IOC_RESET);
    eval("sub MPT_FUNC_UNIT_RESET () { 0x41000000; }") unless defined(&MPT_FUNC_UNIT_RESET);
    eval("sub MPT_FUNC_HANDSHAKE () { 0x42000000; }") unless defined(&MPT_FUNC_HANDSHAKE);
    eval("sub MPT_FUNC_REPLY_REMOVE () { 0x43000000; }") unless defined(&MPT_FUNC_REPLY_REMOVE);
    eval("sub MPT_FUNC_MASK () { 0xff000000; }") unless defined(&MPT_FUNC_MASK);
    eval("sub MPT_INTR_DB_BUSY () { 0x80000000; }") unless defined(&MPT_INTR_DB_BUSY);
    eval("sub MPT_INTR_REPLY_READY () { 0x00000008; }") unless defined(&MPT_INTR_REPLY_READY);
    eval("sub MPT_INTR_DB_READY () { 0x00000001; }") unless defined(&MPT_INTR_DB_READY);
    eval 'sub MPT_DB_IS_BUSY {
        local($v) = @_;
	    eval q(((($v) &  &MPT_INTR_DB_BUSY) != 0));
    }' unless defined(&MPT_DB_IS_BUSY);
    eval 'sub MPT_DB_INTR {
        local($v) = @_;
	    eval q(((($v) &  &MPT_INTR_DB_READY) != 0));
    }' unless defined(&MPT_DB_INTR);
    eval 'sub MPT_REPLY_INTR {
        local($v) = @_;
	    eval q(((($v) &  &MPT_INTR_REPLY_READY) != 0));
    }' unless defined(&MPT_REPLY_INTR);
    eval("sub MPT_INTR_REPLY_MASK () { 0x00000008; }") unless defined(&MPT_INTR_REPLY_MASK);
    eval("sub MPT_INTR_DB_MASK () { 0x00000001; }") unless defined(&MPT_INTR_DB_MASK);
    eval("sub MPT_DIAG_ENABLED () { 0x00000080; }") unless defined(&MPT_DIAG_ENABLED);
    eval("sub MPT_DIAG_FLASHBAD () { 0x00000040; }") unless defined(&MPT_DIAG_FLASHBAD);
    eval("sub MPT_DIAG_RESET_HIST () { 0x00000020; }") unless defined(&MPT_DIAG_RESET_HIST);
    eval("sub MPT_DIAG_TTLI () { 0x00000008; }") unless defined(&MPT_DIAG_TTLI);
    eval("sub MPT_DIAG_RESET_IOC () { 0x00000004; }") unless defined(&MPT_DIAG_RESET_IOC);
    eval("sub MPT_DIAG_ARM_DISABLE () { 0x00000002; }") unless defined(&MPT_DIAG_ARM_DISABLE);
    eval("sub MPT_DIAG_DME () { 0x00000001; }") unless defined(&MPT_DIAG_DME);
    eval 'sub MPT_DIAG_IOP_BASE () {(0x);}' unless defined(&MPT_DIAG_IOP_BASE);
    eval 'sub MPT_DIAG_IOP_SIZE () {(0x2000);}' unless defined(&MPT_DIAG_IOP_SIZE);
    eval 'sub MPT_DIAG_GPIO () {(0x30010);}' unless defined(&MPT_DIAG_GPIO);
    eval 'sub MPT_DIAG_IOPQ_REG_BASE0 () {(0x50004);}' unless defined(&MPT_DIAG_IOPQ_REG_BASE0);
    eval 'sub MPT_DIAG_IOPQ_REG_BASE1 () {(0x51004);}' unless defined(&MPT_DIAG_IOPQ_REG_BASE1);
    eval 'sub MPT_DIAG_MEM_CFG_BASE () {(0x40000);}' unless defined(&MPT_DIAG_MEM_CFG_BASE);
    eval 'sub MPT_DIAG_CTX0_BASE () {(0xe0000);}' unless defined(&MPT_DIAG_CTX0_BASE);
    eval 'sub MPT_DIAG_CTX0_SIZE () {(0x2000);}' unless defined(&MPT_DIAG_CTX0_SIZE);
    eval 'sub MPT_DIAG_CTX1_BASE () {(0x1e0000);}' unless defined(&MPT_DIAG_CTX1_BASE);
    eval 'sub MPT_DIAG_CTX1_SIZE () {(0x2000);}' unless defined(&MPT_DIAG_CTX1_SIZE);
    eval 'sub MPT_DIAG_FLASH_BASE () {(0x800000);}' unless defined(&MPT_DIAG_FLASH_BASE);
    eval 'sub MPT_DIAG_RAM_BASE () {(0x1000000);}' unless defined(&MPT_DIAG_RAM_BASE);
    eval 'sub MPT_DIAG_RAM_SIZE () {(0x400000);}' unless defined(&MPT_DIAG_RAM_SIZE);
    eval 'sub MPT_DIAG_GPIO_SCL () {(0x10000);}' unless defined(&MPT_DIAG_GPIO_SCL);
    eval 'sub MPT_DIAG_GPIO_SDA_OUT () {(0x8000);}' unless defined(&MPT_DIAG_GPIO_SDA_OUT);
    eval 'sub MPT_DIAG_GPIO_SDA_IN () {(0x4000);}' unless defined(&MPT_DIAG_GPIO_SDA_IN);
    eval 'sub MPT_REPLY_EMPTY () {(0xffffffff);}' unless defined(&MPT_REPLY_EMPTY);
    eval 'sub MPT_CONTEXT_REPLY () {(0x80000000);}' unless defined(&MPT_CONTEXT_REPLY);
    eval 'sub MPT_CONTEXT_MASK () {(~0xe0000000);}' unless defined(&MPT_CONTEXT_MASK);
    if(defined(&_KERNEL)) {
    }
}
1;
