require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_CPU_H_)) {
    eval 'sub _CPU_H_ () {1;}' unless defined(&_CPU_H_);
    eval 'sub CPU_BOOTED_KERNEL () {1;}' unless defined(&CPU_BOOTED_KERNEL);
    eval 'sub CPU_LED_BLINK () {2;}' unless defined(&CPU_LED_BLINK);
    eval 'sub CPU_ALLOWAPERTURE () {3;}' unless defined(&CPU_ALLOWAPERTURE);
    eval 'sub CPU_CPUTYPE () {4;}' unless defined(&CPU_CPUTYPE);
    eval 'sub CPU_CECCERRORS () {5;}' unless defined(&CPU_CECCERRORS);
    eval 'sub CPU_CECCLAST () {6;}' unless defined(&CPU_CECCLAST);
    eval 'sub CPU_MAXID () {7;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "booted_kernel",  &CTLTYPE_STRING }, { "led_blink",  &CTLTYPE_INT }, { "allowaperture",  &CTLTYPE_INT }, { "cputype",  &CTLTYPE_INT }, { "ceccerrs",  &CTLTYPE_INT }, { "cecclast",  &CTLTYPE_QUAD }, };}' unless defined(&CTL_MACHDEP_NAMES);
    if(defined(&_KERNEL)) {
	require 'machine/ctlreg.ph';
	require 'machine/psl.ph';
	require 'machine/reg.ph';
	require 'machine/intr.ph';
	require 'sys/sched.ph';
	if(1) {
	    eval 'sub curcpu () {
	        eval q(( &cpu_info_store));
	    }' unless defined(&curcpu);
	} else {
	    eval 'sub curcpu () {
	        eval q(( &CPUINFO_VA));
	    }' unless defined(&curcpu);
	}
	eval 'sub cpu_swapin {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_swapin);
	eval 'sub cpu_swapout {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_swapout);
	eval 'sub cpu_wait {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_wait);
	if(1) {
	    eval 'sub cpu_number () {
	        eval q(0);
	    }' unless defined(&cpu_number);
	} else {
	    eval 'sub cpu_number () {
	        eval q(( &curcpu()-> &ci_number));
	    }' unless defined(&cpu_number);
	}
	eval 'sub CLKF_USERMODE {
	    local($framep) = @_;
    	    eval q(((($framep)-> ($t->{tf_tstate}) &  &TSTATE_PRIV) == 0));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    local($framep) = @_;
    	    eval q((($framep)-> ($t->{tf_pc})));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    local($framep) = @_;
    	    eval q(((! &CLKF_USERMODE($framep)) && ((($framep)-> ($t->{tf_kstack}) < ( &vaddr_t) &EINTSTACK) && (($framep)-> ($t->{tf_kstack}) > ( &vaddr_t) &INTSTACK))));
	}' unless defined(&CLKF_INTR);
	eval 'sub need_resched {
	    local($ci) = @_;
    	    eval q(( &want_resched = 1,  &want_ast = 1));
	}' unless defined(&need_resched);
	eval 'sub need_proftick {
	    local($p) = @_;
    	    eval q((($p)-> &p_flag |=  &P_OWEUPC,  &want_ast = 1));
	}' unless defined(&need_proftick);
	eval 'sub signotify {
	    local($p) = @_;
    	    eval q(( &want_ast = 1));
	}' unless defined(&signotify);
	eval 'sub write_all_windows () {
	    eval q( &__asm  &__volatile(\\"flushw\\" : : ));
	}' unless defined(&write_all_windows);
	eval 'sub write_user_windows () {
	    eval q( &__asm  &__volatile(\\"flushw\\" : : ));
	}' unless defined(&write_user_windows);
	if(defined(&KGDB)) {
	}
	if(defined(&KGDB)) {
	}
    }
}
1;
