require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__M88K_CPU_H__)) {
    eval 'sub __M88K_CPU_H__ () {1;}' unless defined(&__M88K_CPU_H__);
    eval 'sub CPU_CONSDEV () {1;}' unless defined(&CPU_CONSDEV);
    eval 'sub CPU_MAXID () {2;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "console_device",  &CTLTYPE_STRUCT }, };}' unless defined(&CTL_MACHDEP_NAMES);
    if(defined(&_KERNEL)) {
	unless(defined(&MAX_CPUS)) {
	    eval 'sub MAX_CPUS () {4;}' unless defined(&MAX_CPUS);
	}
	require 'machine/pcb.ph';
	require 'machine/psl.ph';
	eval 'sub cpu_exec {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_exec);
	eval 'sub cpu_wait {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_wait);
	eval 'sub cpu_swapout {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_swapout);
	eval 'sub CLKF_USERMODE {
	    local($framep) = @_;
    	    eval q((((($framep))-> &tf_epsr &  &PSR_MODE) == 0));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    local($framep) = @_;
    	    eval q(((($framep))-> &tf_sxip &  &XIP_ADDR));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    local($framep) = @_;
    	    eval q(((($framep))-> $tf_r[31] >=  &UADDR));
	}' unless defined(&CLKF_INTR);
	require 'machine/intr.ph';
	eval 'sub SIR_NET () {1;}' unless defined(&SIR_NET);
	eval 'sub SIR_CLOCK () {2;}' unless defined(&SIR_CLOCK);
	eval 'sub setsoftint {
	    local($x) = @_;
    	    eval q(( &ssir |= ($x)));
	}' unless defined(&setsoftint);
	eval 'sub setsoftnet () {
	    eval q(( &ssir |=  &SIR_NET));
	}' unless defined(&setsoftnet);
	eval 'sub setsoftclock () {
	    eval q(( &ssir |=  &SIR_CLOCK));
	}' unless defined(&setsoftclock);
	eval 'sub siroff {
	    local($x) = @_;
    	    eval q(( &ssir &= ~$x));
	}' unless defined(&siroff);
	eval 'sub need_resched {
	    local($ci) = @_;
    	    eval q(( &want_resched = 1,  &want_ast = 1));
	}' unless defined(&need_resched);
	eval 'sub need_proftick {
	    local($p) = @_;
    	    eval q((($p)-> &p_flag |=  &P_OWEUPC,  &want_ast = 1));
	}' unless defined(&need_proftick);
	eval 'sub signotify {
	    local($p) = @_;
    	    eval q(( &want_ast = 1));
	}' unless defined(&signotify);
    }
}
1;
