require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__IF_SAN_XILINX_H)) {
    eval 'sub __IF_SAN_XILINX_H () {1;}' unless defined(&__IF_SAN_XILINX_H);
    eval 'sub XILINX_CHIP_CFG_REG () {0x40;}' unless defined(&XILINX_CHIP_CFG_REG);
    eval 'sub XILINX_MCPU_INTERFACE () {0x44;}' unless defined(&XILINX_MCPU_INTERFACE);
    eval 'sub XILINX_MCPU_INTERFACE_ADDR () {0x46;}' unless defined(&XILINX_MCPU_INTERFACE_ADDR);
    eval 'sub XILINX_GLOBAL_INTER_MASK () {0x4c;}' unless defined(&XILINX_GLOBAL_INTER_MASK);
    eval 'sub XILINX_HDLC_TX_INTR_PENDING_REG () {0x50;}' unless defined(&XILINX_HDLC_TX_INTR_PENDING_REG);
    eval 'sub XILINX_HDLC_RX_INTR_PENDING_REG () {0x54;}' unless defined(&XILINX_HDLC_RX_INTR_PENDING_REG);
    eval("sub WP_FIFO_ERROR_BIT () { 0; }") unless defined(&WP_FIFO_ERROR_BIT);
    eval("sub WP_CRC_ERROR_BIT () { 1; }") unless defined(&WP_CRC_ERROR_BIT);
    eval("sub WP_ABORT_ERROR_BIT () { 2; }") unless defined(&WP_ABORT_ERROR_BIT);
    eval 'sub WP_MAX_FIFO_FRAMES () {7;}' unless defined(&WP_MAX_FIFO_FRAMES);
    eval 'sub XILINX_DMA_TX_INTR_PENDING_REG () {0x58;}' unless defined(&XILINX_DMA_TX_INTR_PENDING_REG);
    eval 'sub XILINX_DMA_RX_INTR_PENDING_REG () {0x5c;}' unless defined(&XILINX_DMA_RX_INTR_PENDING_REG);
    eval 'sub XILINX_TIMESLOT_HDLC_CHAN_REG () {0x60;}' unless defined(&XILINX_TIMESLOT_HDLC_CHAN_REG);
    eval 'sub AFT_T3_RXTX_ADDR_SELECT_REG () {0x60;}' unless defined(&AFT_T3_RXTX_ADDR_SELECT_REG);
    eval 'sub XILINX_CURRENT_TIMESLOT_MASK () {0x1f00;}' unless defined(&XILINX_CURRENT_TIMESLOT_MASK);
    eval 'sub XILINX_CURRENT_TIMESLOT_SHIFT () {8;}' unless defined(&XILINX_CURRENT_TIMESLOT_SHIFT);
    eval 'sub XILINX_HDLC_CONTROL_REG () {0x64;}' unless defined(&XILINX_HDLC_CONTROL_REG);
    eval 'sub XILINX_HDLC_ADDR_REG () {0x68;}' unless defined(&XILINX_HDLC_ADDR_REG);
    eval 'sub XILINX_CONTROL_RAM_ACCESS_BUF () {0x6c;}' unless defined(&XILINX_CONTROL_RAM_ACCESS_BUF);
    eval 'sub XILINX_DMA_CONTROL_REG () {0x70;}' unless defined(&XILINX_DMA_CONTROL_REG);
    eval 'sub XILINX_DMA_TX_STATUS_REG () {0x74;}' unless defined(&XILINX_DMA_TX_STATUS_REG);
    eval 'sub AFT_TE3_TX_WDT_CTRL_REG () {0x74;}' unless defined(&AFT_TE3_TX_WDT_CTRL_REG);
    eval 'sub XILINX_DMA_RX_STATUS_REG () {0x78;}' unless defined(&XILINX_DMA_RX_STATUS_REG);
    eval 'sub AFT_TE3_RX_WDT_CTRL_REG () {0x78;}' unless defined(&AFT_TE3_RX_WDT_CTRL_REG);
    eval 'sub XILINX_DMA_DATA_REG () {0x7c;}' unless defined(&XILINX_DMA_DATA_REG);
    eval 'sub AFT_TE3_CRNT_DMA_DESC_ADDR_REG () {0x80;}' unless defined(&AFT_TE3_CRNT_DMA_DESC_ADDR_REG);
    eval 'sub XILINX_TxDMA_DESCRIPTOR_LO () {0x100;}' unless defined(&XILINX_TxDMA_DESCRIPTOR_LO);
    eval 'sub XILINX_TxDMA_DESCRIPTOR_HI () {0x104;}' unless defined(&XILINX_TxDMA_DESCRIPTOR_HI);
    eval 'sub XILINX_RxDMA_DESCRIPTOR_LO () {0x108;}' unless defined(&XILINX_RxDMA_DESCRIPTOR_LO);
    eval 'sub XILINX_RxDMA_DESCRIPTOR_HI () {0x10c;}' unless defined(&XILINX_RxDMA_DESCRIPTOR_HI);
    eval 'sub INTERFACE_TYPE_T1_E1_BIT () {0;}' unless defined(&INTERFACE_TYPE_T1_E1_BIT);
    eval 'sub INTERFACE_TYPE_T3_E3_BIT () {0;}' unless defined(&INTERFACE_TYPE_T3_E3_BIT);
    eval 'sub XILINX_RED_LED () {1;}' unless defined(&XILINX_RED_LED);
    eval 'sub AFT_T3_HDLC_TRANS_MODE () {1;}' unless defined(&AFT_T3_HDLC_TRANS_MODE);
    eval 'sub FRONT_END_FRAME_FLAG_ENABLE_BIT () {2;}' unless defined(&FRONT_END_FRAME_FLAG_ENABLE_BIT);
    eval 'sub AFT_T3_CLOCK_MODE () {2;}' unless defined(&AFT_T3_CLOCK_MODE);
    eval 'sub SIGNALLING_ENABLE_BIT () {3;}' unless defined(&SIGNALLING_ENABLE_BIT);
    eval 'sub FRONT_END_RESET_BIT () {4;}' unless defined(&FRONT_END_RESET_BIT);
    eval 'sub CHIP_RESET_BIT () {5;}' unless defined(&CHIP_RESET_BIT);
    eval 'sub HDLC_CORE_RESET_BIT () {6;}' unless defined(&HDLC_CORE_RESET_BIT);
    eval 'sub HDLC_CORE_READY_FLAG_BIT () {7;}' unless defined(&HDLC_CORE_READY_FLAG_BIT);
    eval 'sub GLOBAL_INTR_ENABLE_BIT () {8;}' unless defined(&GLOBAL_INTR_ENABLE_BIT);
    eval 'sub ERROR_INTR_ENABLE_BIT () {9;}' unless defined(&ERROR_INTR_ENABLE_BIT);
    eval 'sub FRONT_END_INTR_ENABLE_BIT () {10;}' unless defined(&FRONT_END_INTR_ENABLE_BIT);
    eval 'sub CHIP_ERROR_MASK () {0xff0000;}' unless defined(&CHIP_ERROR_MASK);
    eval 'sub AFT_TE3_TX_WDT_INTR_PND () {26;}' unless defined(&AFT_TE3_TX_WDT_INTR_PND);
    eval 'sub AFT_TE3_RX_WDT_INTR_PND () {27;}' unless defined(&AFT_TE3_RX_WDT_INTR_PND);
    eval 'sub FRONT_END_INTR_FLAG () {28;}' unless defined(&FRONT_END_INTR_FLAG);
    eval 'sub SECURITY_STATUS_FLAG () {29;}' unless defined(&SECURITY_STATUS_FLAG);
    eval 'sub ERROR_INTR_FLAG () {30;}' unless defined(&ERROR_INTR_FLAG);
    eval 'sub DMA_INTR_FLAG () {31;}' unless defined(&DMA_INTR_FLAG);
    eval 'sub XILINX_GLOBAL_INTER_STATUS () {0xd0000000;}' unless defined(&XILINX_GLOBAL_INTER_STATUS);
    eval 'sub TIMESLOT_BIT_SHIFT () {16;}' unless defined(&TIMESLOT_BIT_SHIFT);
    eval 'sub TIMESLOT_BIT_MASK () {0x1f0000;}' unless defined(&TIMESLOT_BIT_MASK);
    eval 'sub HDLC_LOGIC_CH_BIT_MASK () {0x1f;}' unless defined(&HDLC_LOGIC_CH_BIT_MASK);
    eval 'sub HDLC_LCH_TIMESLOT_MASK () {0x1f001f;}' unless defined(&HDLC_LCH_TIMESLOT_MASK);
    eval 'sub HDLC_RX_CHAN_ENABLE_BIT () {0;}' unless defined(&HDLC_RX_CHAN_ENABLE_BIT);
    eval 'sub HDLC_RX_FRAME_DATA_BIT () {1;}' unless defined(&HDLC_RX_FRAME_DATA_BIT);
    eval 'sub HDLC_RC_CHAN_ACTIVE_BIT () {2;}' unless defined(&HDLC_RC_CHAN_ACTIVE_BIT);
    eval 'sub HDLC_RX_FRAME_ERROR_BIT () {3;}' unless defined(&HDLC_RX_FRAME_ERROR_BIT);
    eval 'sub HDLC_RX_FRAME_ABORT_BIT () {4;}' unless defined(&HDLC_RX_FRAME_ABORT_BIT);
    eval 'sub HDLC_RX_PROT_DISABLE_BIT () {16;}' unless defined(&HDLC_RX_PROT_DISABLE_BIT);
    eval 'sub HDLC_RX_ADDR_RECOGN_DIS_BIT () {17;}' unless defined(&HDLC_RX_ADDR_RECOGN_DIS_BIT);
    eval 'sub HDLC_RX_ADDR_FIELD_DISC_BIT () {18;}' unless defined(&HDLC_RX_ADDR_FIELD_DISC_BIT);
    eval 'sub HDLC_RX_ADDR_SIZE_BIT () {19;}' unless defined(&HDLC_RX_ADDR_SIZE_BIT);
    eval 'sub HDLC_RX_BRD_ADDR_MATCH_BIT () {20;}' unless defined(&HDLC_RX_BRD_ADDR_MATCH_BIT);
    eval 'sub HDLC_RX_FCS_SIZE_BIT () {21;}' unless defined(&HDLC_RX_FCS_SIZE_BIT);
    eval 'sub HDLC_CORE_RX_IDLE_LINE_BIT () {22;}' unless defined(&HDLC_CORE_RX_IDLE_LINE_BIT);
    eval 'sub HDLC_CODE_RX_ABORT_LINE_BIT () {23;}' unless defined(&HDLC_CODE_RX_ABORT_LINE_BIT);
    eval 'sub HDLC_TX_CHAN_ENABLE_BIT () {24;}' unless defined(&HDLC_TX_CHAN_ENABLE_BIT);
    eval 'sub HDLC_TX_PROT_DISABLE_BIT () {25;}' unless defined(&HDLC_TX_PROT_DISABLE_BIT);
    eval 'sub HDLC_TX_ADDR_INSERTION_BIT () {26;}' unless defined(&HDLC_TX_ADDR_INSERTION_BIT);
    eval 'sub HDLC_TX_ADDR_SIZE_BIT () {27;}' unless defined(&HDLC_TX_ADDR_SIZE_BIT);
    eval 'sub HDLC_TX_FCS_SIZE_BIT () {28;}' unless defined(&HDLC_TX_FCS_SIZE_BIT);
    eval 'sub HDLC_TX_FRAME_ABORT_BIT () {29;}' unless defined(&HDLC_TX_FRAME_ABORT_BIT);
    eval 'sub HDLC_TX_STOP_TX_ON_ABORT_BIT () {30;}' unless defined(&HDLC_TX_STOP_TX_ON_ABORT_BIT);
    eval 'sub HDLC_TX_CHANNEL_ACTIVE_BIT () {31;}' unless defined(&HDLC_TX_CHANNEL_ACTIVE_BIT);
    eval 'sub CONTROL_RAM_DATA_MASK () {0x1f;}' unless defined(&CONTROL_RAM_DATA_MASK);
    eval 'sub HDLC_FIFO_BASE_ADDR_SHIFT () {16;}' unless defined(&HDLC_FIFO_BASE_ADDR_SHIFT);
    eval 'sub HDLC_FIFO_BASE_ADDR_MASK () {0x1f;}' unless defined(&HDLC_FIFO_BASE_ADDR_MASK);
    eval 'sub HDLC_FIFO_SIZE_SHIFT () {8;}' unless defined(&HDLC_FIFO_SIZE_SHIFT);
    eval 'sub HDLC_FIFO_SIZE_MASK () {0x1f;}' unless defined(&HDLC_FIFO_SIZE_MASK);
    eval 'sub HDLC_FREE_LOGIC_CH () {31;}' unless defined(&HDLC_FREE_LOGIC_CH);
    eval 'sub TRANSPARENT_MODE_BIT () {31;}' unless defined(&TRANSPARENT_MODE_BIT);
    eval 'sub DMA_SIZE_BIT_SHIFT () {0;}' unless defined(&DMA_SIZE_BIT_SHIFT);
    eval 'sub DMA_FIFO_HI_MARK_BIT_SHIFT () {4;}' unless defined(&DMA_FIFO_HI_MARK_BIT_SHIFT);
    eval 'sub DMA_FIFO_LO_MARK_BIT_SHIFT () {8;}' unless defined(&DMA_FIFO_LO_MARK_BIT_SHIFT);
    eval 'sub DMA_FIFO_T3_MARK_BIT_SHIFT () {8;}' unless defined(&DMA_FIFO_T3_MARK_BIT_SHIFT);
    eval 'sub DMA_ACTIVE_CHANNEL_BIT_SHIFT () {16;}' unless defined(&DMA_ACTIVE_CHANNEL_BIT_SHIFT);
    eval 'sub DMA_ACTIVE_CHANNEL_BIT_MASK () {0xffe0ffff;}' unless defined(&DMA_ACTIVE_CHANNEL_BIT_MASK);
    eval 'sub DMA_ENGINE_ENABLE_BIT () {31;}' unless defined(&DMA_ENGINE_ENABLE_BIT);
    eval 'sub DMA_CHAIN_TE3_MASK () {0xf;}' unless defined(&DMA_CHAIN_TE3_MASK);
    eval 'sub TxDMA_LO_PC_ADDR_PTR_BIT_MASK () {0xfffffffc;}' unless defined(&TxDMA_LO_PC_ADDR_PTR_BIT_MASK);
    eval 'sub TxDMA_LO_ALIGNMENT_BIT_MASK () {0x3;}' unless defined(&TxDMA_LO_ALIGNMENT_BIT_MASK);
    eval 'sub TxDMA_HI_DMA_DATA_LENGTH_MASK () {0x7ff;}' unless defined(&TxDMA_HI_DMA_DATA_LENGTH_MASK);
    eval 'sub TxDMA_HI_DMA_PCI_ERROR_MASK () {0x7800;}' unless defined(&TxDMA_HI_DMA_PCI_ERROR_MASK);
    eval 'sub TxDMA_HI_DMA_PCI_ERROR_M_ABRT () {0x800;}' unless defined(&TxDMA_HI_DMA_PCI_ERROR_M_ABRT);
    eval 'sub TxDMA_HI_DMA_PCI_ERROR_T_ABRT () {0x1000;}' unless defined(&TxDMA_HI_DMA_PCI_ERROR_T_ABRT);
    eval 'sub TxDMA_HI_DMA_PCI_ERROR_DS_TOUT () {0x2000;}' unless defined(&TxDMA_HI_DMA_PCI_ERROR_DS_TOUT);
    eval 'sub TxDMA_HI_DMA_PCI_ERROR_RETRY_TOUT () {0x4000;}' unless defined(&TxDMA_HI_DMA_PCI_ERROR_RETRY_TOUT);
    eval 'sub INIT_DMA_FIFO_CMD_BIT () {28;}' unless defined(&INIT_DMA_FIFO_CMD_BIT);
    eval 'sub TxDMA_HI_DMA_FRAME_START_BIT () {30;}' unless defined(&TxDMA_HI_DMA_FRAME_START_BIT);
    eval 'sub TxDMA_HI_DMA_FRAME_END_BIT () {29;}' unless defined(&TxDMA_HI_DMA_FRAME_END_BIT);
    eval 'sub TxDMA_HI_DMA_GO_READY_BIT () {31;}' unless defined(&TxDMA_HI_DMA_GO_READY_BIT);
    eval 'sub DMA_FIFO_BASE_ADDR_SHIFT () {20;}' unless defined(&DMA_FIFO_BASE_ADDR_SHIFT);
    eval 'sub DMA_FIFO_BASE_ADDR_MASK () {0x1f;}' unless defined(&DMA_FIFO_BASE_ADDR_MASK);
    eval 'sub DMA_FIFO_SIZE_SHIFT () {15;}' unless defined(&DMA_FIFO_SIZE_SHIFT);
    eval 'sub DMA_FIFO_SIZE_MASK () {0x1f;}' unless defined(&DMA_FIFO_SIZE_MASK);
    eval 'sub DMA_FIFO_PARAM_CLEAR_MASK () {0xfe007fff;}' unless defined(&DMA_FIFO_PARAM_CLEAR_MASK);
    eval 'sub FIFO_32B () {0x;}' unless defined(&FIFO_32B);
    eval 'sub FIFO_64B () {0x1;}' unless defined(&FIFO_64B);
    eval 'sub FIFO_128B () {0x3;}' unless defined(&FIFO_128B);
    eval 'sub FIFO_256B () {0x7;}' unless defined(&FIFO_256B);
    eval 'sub FIFO_512B () {0xf;}' unless defined(&FIFO_512B);
    eval 'sub FIFO_1024B () {0x1f;}' unless defined(&FIFO_1024B);
    eval 'sub RxDMA_LO_PC_ADDR_PTR_BIT_MASK () {0xfffffffc;}' unless defined(&RxDMA_LO_PC_ADDR_PTR_BIT_MASK);
    eval 'sub RxDMA_LO_ALIGNMENT_BIT_MASK () {0x3;}' unless defined(&RxDMA_LO_ALIGNMENT_BIT_MASK);
    eval 'sub RxDMA_HI_DMA_DATA_LENGTH_MASK () {0x7ff;}' unless defined(&RxDMA_HI_DMA_DATA_LENGTH_MASK);
    eval 'sub RxDMA_HI_DMA_PCI_ERROR_MASK () {0x7800;}' unless defined(&RxDMA_HI_DMA_PCI_ERROR_MASK);
    eval 'sub RxDMA_HI_DMA_PCI_ERROR_M_ABRT () {0x800;}' unless defined(&RxDMA_HI_DMA_PCI_ERROR_M_ABRT);
    eval 'sub RxDMA_HI_DMA_PCI_ERROR_T_ABRT () {0x1000;}' unless defined(&RxDMA_HI_DMA_PCI_ERROR_T_ABRT);
    eval 'sub RxDMA_HI_DMA_PCI_ERROR_DS_TOUT () {0x2000;}' unless defined(&RxDMA_HI_DMA_PCI_ERROR_DS_TOUT);
    eval 'sub RxDMA_HI_DMA_PCI_ERROR_RETRY_TOUT () {0x4000;}' unless defined(&RxDMA_HI_DMA_PCI_ERROR_RETRY_TOUT);
    eval 'sub RxDMA_HI_DMA_COMMAND_BIT_SHIFT () {28;}' unless defined(&RxDMA_HI_DMA_COMMAND_BIT_SHIFT);
    eval 'sub RxDMA_HI_DMA_FRAME_START_BIT () {30;}' unless defined(&RxDMA_HI_DMA_FRAME_START_BIT);
    eval 'sub RxDMA_HI_DMA_CRC_ERROR_BIT () {25;}' unless defined(&RxDMA_HI_DMA_CRC_ERROR_BIT);
    eval 'sub RxDMA_HI_DMA_FRAME_ABORT_BIT () {26;}' unless defined(&RxDMA_HI_DMA_FRAME_ABORT_BIT);
    eval 'sub RxDMA_HI_DMA_FRAME_END_BIT () {29;}' unless defined(&RxDMA_HI_DMA_FRAME_END_BIT);
    eval 'sub RxDMA_HI_DMA_GO_READY_BIT () {31;}' unless defined(&RxDMA_HI_DMA_GO_READY_BIT);
    eval 'sub DMA_HI_TE3_INTR_DISABLE_BIT () {27;}' unless defined(&DMA_HI_TE3_INTR_DISABLE_BIT);
    eval 'sub DMA_HI_TE3_NOT_LAST_FRAME_BIT () {24;}' unless defined(&DMA_HI_TE3_NOT_LAST_FRAME_BIT);
    eval 'sub AFT_TE3_CRNT_TX_DMA_MASK () {0xf;}' unless defined(&AFT_TE3_CRNT_TX_DMA_MASK);
    eval 'sub AFT_TE3_CRNT_RX_DMA_MASK () {0xf0;}' unless defined(&AFT_TE3_CRNT_RX_DMA_MASK);
    eval 'sub AFT_TE3_CRNT_RX_DMA_SHIFT () {4;}' unless defined(&AFT_TE3_CRNT_RX_DMA_SHIFT);
    eval 'sub XILINX_DMA_SIZE () {10;}' unless defined(&XILINX_DMA_SIZE);
    eval 'sub XILINX_DMA_FIFO_UP () {8;}' unless defined(&XILINX_DMA_FIFO_UP);
    eval 'sub XILINX_DMA_FIFO_LO () {8;}' unless defined(&XILINX_DMA_FIFO_LO);
    eval 'sub AFT_T3_DMA_FIFO_MARK () {8;}' unless defined(&AFT_T3_DMA_FIFO_MARK);
    eval 'sub XILINX_DEFLT_ACTIVE_CH () {0;}' unless defined(&XILINX_DEFLT_ACTIVE_CH);
    eval 'sub MAX_XILINX_TX_DMA_SIZE () {0xffff;}' unless defined(&MAX_XILINX_TX_DMA_SIZE);
    eval 'sub MIN_WP_PRI_MTU () {128;}' unless defined(&MIN_WP_PRI_MTU);
    eval 'sub DEFAULT_WP_PRI_MTU () {1500;}' unless defined(&DEFAULT_WP_PRI_MTU);
    eval 'sub MAX_WP_PRI_MTU () {8188;}' unless defined(&MAX_WP_PRI_MTU);
    eval 'sub MAX_DATA_SIZE () {2000;}' unless defined(&MAX_DATA_SIZE);
    undef(&wan_udphdr_data) if defined(&wan_udphdr_data);
    eval 'sub wan_udphdr_data () { ($wan_udphdr_u->{aft}->{data});}' unless defined(&wan_udphdr_data);
    eval 'sub PMC_CONTROL_REG () {0x;}' unless defined(&PMC_CONTROL_REG);
    eval 'sub PMC_RESET_BIT () {0;}' unless defined(&PMC_RESET_BIT);
    eval 'sub PMC_CLOCK_SELECT () {1;}' unless defined(&PMC_CLOCK_SELECT);
    eval 'sub LED_CONTROL_REG () {0x1;}' unless defined(&LED_CONTROL_REG);
    eval 'sub JP8_VALUE () {0x2;}' unless defined(&JP8_VALUE);
    eval 'sub JP7_VALUE () {0x1;}' unless defined(&JP7_VALUE);
    eval 'sub SW0_VALUE () {0x4;}' unless defined(&SW0_VALUE);
    eval 'sub SW1_VALUE () {0x8;}' unless defined(&SW1_VALUE);
    eval 'sub SECURITY_CPLD_REG () {0x9;}' unless defined(&SECURITY_CPLD_REG);
    eval 'sub SECURITY_CPLD_MASK () {0x3;}' unless defined(&SECURITY_CPLD_MASK);
    eval 'sub SECURITY_CPLD_SHIFT () {0x2;}' unless defined(&SECURITY_CPLD_SHIFT);
    eval 'sub SECURITY_1LINE_UNCH () {0x;}' unless defined(&SECURITY_1LINE_UNCH);
    eval 'sub SECURITY_1LINE_CH () {0x1;}' unless defined(&SECURITY_1LINE_CH);
    eval 'sub SECURITY_2LINE_UNCH () {0x2;}' unless defined(&SECURITY_2LINE_UNCH);
    eval 'sub SECURITY_2LINE_CH () {0x3;}' unless defined(&SECURITY_2LINE_CH);
    eval 'sub WRITE_DEF_SECTOR_DSBL () {0x1;}' unless defined(&WRITE_DEF_SECTOR_DSBL);
    eval 'sub FRONT_END_TYPE_MASK () {0x38;}' unless defined(&FRONT_END_TYPE_MASK);
    eval 'sub BIT_DEV_ADDR_CLEAR () {0x600;}' unless defined(&BIT_DEV_ADDR_CLEAR);
    eval 'sub BIT_DEV_ADDR_CPLD () {0x200;}' unless defined(&BIT_DEV_ADDR_CPLD);
    eval 'sub MEMORY_TYPE_SRAM () {0x;}' unless defined(&MEMORY_TYPE_SRAM);
    eval 'sub MEMORY_TYPE_FLASH () {0x1;}' unless defined(&MEMORY_TYPE_FLASH);
    eval 'sub MASK_MEMORY_TYPE_SRAM () {0x10;}' unless defined(&MASK_MEMORY_TYPE_SRAM);
    eval 'sub MASK_MEMORY_TYPE_FLASH () {0x20;}' unless defined(&MASK_MEMORY_TYPE_FLASH);
    eval 'sub BIT_A18_SECTOR_SA4_SA7 () {0x20;}' unless defined(&BIT_A18_SECTOR_SA4_SA7);
    eval 'sub USER_SECTOR_START_ADDR () {0x40000;}' unless defined(&USER_SECTOR_START_ADDR);
    eval 'sub MAX_TRACE_QUEUE () {100;}' unless defined(&MAX_TRACE_QUEUE);
    eval 'sub TX_DMA_BUF_INIT () {0;}' unless defined(&TX_DMA_BUF_INIT);
    eval 'sub MAX_TRACE_BUFFER () {( &MAX_LGTH_UDP_MGNT_PKT - $sizeof{ &iphdr_t} - $sizeof{ &udphdr_t} - $sizeof{ &wan_mgmt_t} - $sizeof{ &wan_trace_info_t} - $sizeof{ &wan_cmd_t});}' unless defined(&MAX_TRACE_BUFFER);
    eval("sub ROUTER_UP_TIME () { 0x50; }") unless defined(&ROUTER_UP_TIME);
    eval("sub ENABLE_TRACING () { 1; }") unless defined(&ENABLE_TRACING);
    eval("sub DISABLE_TRACING () { 2; }") unless defined(&DISABLE_TRACING);
    eval("sub GET_TRACE_INFO () { 3; }") unless defined(&GET_TRACE_INFO);
    eval("sub READ_CODE_VERSION () { 4; }") unless defined(&READ_CODE_VERSION);
    eval("sub FLUSH_OPERATIONAL_STATS () { 5; }") unless defined(&FLUSH_OPERATIONAL_STATS);
    eval("sub OPERATIONAL_STATS () { 6; }") unless defined(&OPERATIONAL_STATS);
    eval("sub READ_OPERATIONAL_STATS () { 7; }") unless defined(&READ_OPERATIONAL_STATS);
    eval("sub READ_CONFIGURATION () { 8; }") unless defined(&READ_CONFIGURATION);
    eval("sub COMMS_ERROR_STATS_STRUCT () { 9; }") unless defined(&COMMS_ERROR_STATS_STRUCT);
    eval("sub AFT_LINK_STATUS () { 10; }") unless defined(&AFT_LINK_STATUS);
    eval 'sub UDPMGMT_SIGNATURE () {"AFTPIPEA";}' unless defined(&UDPMGMT_SIGNATURE);
    if(defined( &_KERNEL)) {
	eval 'sub xilinx_valid_mtu {
	    local($mtu) = @_;
    	    eval q({  &if ($mtu <= 128) { 128; }  &else  &if ($mtu <= 256) { 256; }  &else  &if ($mtu <= 512) { 512; }  &else  &if ($mtu <= 1024) { 1024; }  &else  &if ($mtu <= 2048) { 2048; }  &else  &if ($mtu <= 4096) { 4096; }  &else  &if ($mtu <= 8188) { 8188; }  &else { 0; } });
	}' unless defined(&xilinx_valid_mtu);
	eval 'sub xilinx_dma_buf_bits {
	    local($dma_bufs) = @_;
    	    eval q({  &if ($dma_bufs < 2) { 0; }  &else  &if ($dma_bufs < 3) { 1; }  &else  &if ($dma_bufs < 5) { 2; }  &else  &if ($dma_bufs < 9) { 3; }  &else  &if ($dma_bufs < 17) { 4; }  &else { 0; } });
	}' unless defined(&xilinx_dma_buf_bits);
	eval 'sub AFT_TX_TIMEOUT () {25;}' unless defined(&AFT_TX_TIMEOUT);
	eval 'sub AFT_RX_TIMEOUT () {10;}' unless defined(&AFT_RX_TIMEOUT);
	eval 'sub AFT_MAX_WTD_TIMEOUT () {250;}' unless defined(&AFT_MAX_WTD_TIMEOUT);
	eval 'sub aft_reset_rx_watchdog {
	    local($card) = @_;
    	    eval q({  &sdla_bus_write_4( ($card->{hw}), &AFT_TE3_RX_WDT_CTRL_REG,0); });
	}' unless defined(&aft_reset_rx_watchdog);
	eval 'sub aft_enable_rx_watchdog {
	    local($card,$timeout) = @_;
    	    eval q({  &aft_reset_rx_watchdog($card);  &sdla_bus_write_4( ($card->{hw}), &AFT_TE3_RX_WDT_CTRL_REG,$timeout); });
	}' unless defined(&aft_enable_rx_watchdog);
	eval 'sub aft_reset_tx_watchdog {
	    local($card) = @_;
    	    eval q({  &sdla_bus_write_4( ($card->{hw}), &AFT_TE3_TX_WDT_CTRL_REG,0); });
	}' unless defined(&aft_reset_tx_watchdog);
	eval 'sub aft_enable_tx_watchdog {
	    local($card,$timeout) = @_;
    	    eval q({  &aft_reset_tx_watchdog($card);  &sdla_bus_write_4( ($card->{hw}), &AFT_TE3_TX_WDT_CTRL_REG,$timeout); });
	}' unless defined(&aft_enable_tx_watchdog);
    }
}
1;
