require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&IWI_TX_RING_SIZE)) {
    sub IWI_TX_RING_SIZE () {	64;}
}
unless(defined(&IWI_CMD_RING_SIZE)) {
    sub IWI_CMD_RING_SIZE () {	16;}
}
unless(defined(&IWI_RX_RING_SIZE)) {
    sub IWI_RX_RING_SIZE () {	32;}
}
unless(defined(&IWI_CSR_INTR)) {
    sub IWI_CSR_INTR () {	0x8;}
}
unless(defined(&IWI_CSR_INTR_MASK)) {
    sub IWI_CSR_INTR_MASK () {	0xc;}
}
unless(defined(&IWI_CSR_INDIRECT_ADDR)) {
    sub IWI_CSR_INDIRECT_ADDR () {	0x10;}
}
unless(defined(&IWI_CSR_INDIRECT_DATA)) {
    sub IWI_CSR_INDIRECT_DATA () {	0x14;}
}
unless(defined(&IWI_CSR_AUTOINC_ADDR)) {
    sub IWI_CSR_AUTOINC_ADDR () {	0x18;}
}
unless(defined(&IWI_CSR_AUTOINC_DATA)) {
    sub IWI_CSR_AUTOINC_DATA () {	0x1c;}
}
unless(defined(&IWI_CSR_RST)) {
    sub IWI_CSR_RST () {	0x20;}
}
unless(defined(&IWI_CSR_CTL)) {
    sub IWI_CSR_CTL () {	0x24;}
}
unless(defined(&IWI_CSR_IO)) {
    sub IWI_CSR_IO () {	0x30;}
}
unless(defined(&IWI_CSR_CMD_BASE)) {
    sub IWI_CSR_CMD_BASE () {	0x200;}
}
unless(defined(&IWI_CSR_CMD_SIZE)) {
    sub IWI_CSR_CMD_SIZE () {	0x204;}
}
unless(defined(&IWI_CSR_TX1_BASE)) {
    sub IWI_CSR_TX1_BASE () {	0x208;}
}
unless(defined(&IWI_CSR_TX1_SIZE)) {
    sub IWI_CSR_TX1_SIZE () {	0x20c;}
}
unless(defined(&IWI_CSR_TX2_BASE)) {
    sub IWI_CSR_TX2_BASE () {	0x210;}
}
unless(defined(&IWI_CSR_TX2_SIZE)) {
    sub IWI_CSR_TX2_SIZE () {	0x214;}
}
unless(defined(&IWI_CSR_TX3_BASE)) {
    sub IWI_CSR_TX3_BASE () {	0x218;}
}
unless(defined(&IWI_CSR_TX3_SIZE)) {
    sub IWI_CSR_TX3_SIZE () {	0x21c;}
}
unless(defined(&IWI_CSR_TX4_BASE)) {
    sub IWI_CSR_TX4_BASE () {	0x220;}
}
unless(defined(&IWI_CSR_TX4_SIZE)) {
    sub IWI_CSR_TX4_SIZE () {	0x224;}
}
unless(defined(&IWI_CSR_CMD_READ_INDEX)) {
    sub IWI_CSR_CMD_READ_INDEX () {	0x280;}
}
unless(defined(&IWI_CSR_TX1_READ_INDEX)) {
    sub IWI_CSR_TX1_READ_INDEX () {	0x284;}
}
unless(defined(&IWI_CSR_TX2_READ_INDEX)) {
    sub IWI_CSR_TX2_READ_INDEX () {	0x288;}
}
unless(defined(&IWI_CSR_TX3_READ_INDEX)) {
    sub IWI_CSR_TX3_READ_INDEX () {	0x28c;}
}
unless(defined(&IWI_CSR_TX4_READ_INDEX)) {
    sub IWI_CSR_TX4_READ_INDEX () {	0x290;}
}
unless(defined(&IWI_CSR_RX_READ_INDEX)) {
    sub IWI_CSR_RX_READ_INDEX () {	0x2a0;}
}
unless(defined(&IWI_CSR_RX_BASE)) {
    sub IWI_CSR_RX_BASE () {	0x500;}
}
unless(defined(&IWI_CSR_TABLE0_SIZE)) {
    sub IWI_CSR_TABLE0_SIZE () {	0x700;}
}
unless(defined(&IWI_CSR_TABLE0_BASE)) {
    sub IWI_CSR_TABLE0_BASE () {	0x704;}
}
unless(defined(&IWI_CSR_CURRENT_TX_RATE)) {
    sub IWI_CSR_CURRENT_TX_RATE () {	 &IWI_CSR_TABLE0_BASE;}
}
unless(defined(&IWI_CSR_CMD_WRITE_INDEX)) {
    sub IWI_CSR_CMD_WRITE_INDEX () {	0xf80;}
}
unless(defined(&IWI_CSR_TX1_WRITE_INDEX)) {
    sub IWI_CSR_TX1_WRITE_INDEX () {	0xf84;}
}
unless(defined(&IWI_CSR_TX2_WRITE_INDEX)) {
    sub IWI_CSR_TX2_WRITE_INDEX () {	0xf88;}
}
unless(defined(&IWI_CSR_TX3_WRITE_INDEX)) {
    sub IWI_CSR_TX3_WRITE_INDEX () {	0xf8c;}
}
unless(defined(&IWI_CSR_TX4_WRITE_INDEX)) {
    sub IWI_CSR_TX4_WRITE_INDEX () {	0xf90;}
}
unless(defined(&IWI_CSR_RX_WRITE_INDEX)) {
    sub IWI_CSR_RX_WRITE_INDEX () {	0xfa0;}
}
unless(defined(&IWI_CSR_READ_INT)) {
    sub IWI_CSR_READ_INT () {	0xff4;}
}
unless(defined(&IWI_INTR_RX_TRANSFER)) {
    sub IWI_INTR_RX_TRANSFER () {	0x2;}
}
unless(defined(&IWI_INTR_CMD_TRANSFER)) {
    sub IWI_INTR_CMD_TRANSFER () {	0x800;}
}
unless(defined(&IWI_INTR_TX1_TRANSFER)) {
    sub IWI_INTR_TX1_TRANSFER () {	0x1000;}
}
unless(defined(&IWI_INTR_TX2_TRANSFER)) {
    sub IWI_INTR_TX2_TRANSFER () {	0x2000;}
}
unless(defined(&IWI_INTR_TX3_TRANSFER)) {
    sub IWI_INTR_TX3_TRANSFER () {	0x4000;}
}
unless(defined(&IWI_INTR_TX4_TRANSFER)) {
    sub IWI_INTR_TX4_TRANSFER () {	0x8000;}
}
unless(defined(&IWI_INTR_FW_INITED)) {
    sub IWI_INTR_FW_INITED () {	0x1000000;}
}
unless(defined(&IWI_INTR_RADIO_OFF)) {
    sub IWI_INTR_RADIO_OFF () {	0x4000000;}
}
unless(defined(&IWI_INTR_FATAL_ERROR)) {
    sub IWI_INTR_FATAL_ERROR () {	0x40000000;}
}
unless(defined(&IWI_INTR_PARITY_ERROR)) {
    sub IWI_INTR_PARITY_ERROR () {	0x80000000;}
}
unless(defined(&IWI_INTR_MASK)) {
    sub IWI_INTR_MASK () {	( &IWI_INTR_RX_TRANSFER |  &IWI_INTR_CMD_TRANSFER |  &IWI_INTR_TX1_TRANSFER |  &IWI_INTR_TX2_TRANSFER |  &IWI_INTR_TX3_TRANSFER |  &IWI_INTR_TX4_TRANSFER |  &IWI_INTR_FW_INITED |  &IWI_INTR_RADIO_OFF |  &IWI_INTR_FATAL_ERROR |  &IWI_INTR_PARITY_ERROR);}
}
unless(defined(&IWI_RST_PRINCETON_RESET)) {
    sub IWI_RST_PRINCETON_RESET () {	0x1;}
}
unless(defined(&IWI_RST_SW_RESET)) {
    sub IWI_RST_SW_RESET () {	0x80;}
}
unless(defined(&IWI_RST_MASTER_DISABLED)) {
    sub IWI_RST_MASTER_DISABLED () {	0x100;}
}
unless(defined(&IWI_RST_STOP_MASTER)) {
    sub IWI_RST_STOP_MASTER () {	0x200;}
}
unless(defined(&IWI_CTL_CLOCK_READY)) {
    sub IWI_CTL_CLOCK_READY () {	0x1;}
}
unless(defined(&IWI_CTL_ALLOW_STANDBY)) {
    sub IWI_CTL_ALLOW_STANDBY () {	0x2;}
}
unless(defined(&IWI_CTL_INIT)) {
    sub IWI_CTL_INIT () {	0x4;}
}
unless(defined(&IWI_IO_RADIO_ENABLED)) {
    sub IWI_IO_RADIO_ENABLED () {	0x10000;}
}
unless(defined(&IWI_READ_INT_INIT_HOST)) {
    sub IWI_READ_INT_INIT_HOST () {	0x20000000;}
}
unless(defined(&IWI_INFO_ADAPTER_MAC)) {
    sub IWI_INFO_ADAPTER_MAC () {	40;}
}
unless(defined(&IWI_CB_DEFAULT_CTL)) {
    sub IWI_CB_DEFAULT_CTL () {	0x8cea0000;}
}
unless(defined(&IWI_CB_MAXDATALEN)) {
    sub IWI_CB_MAXDATALEN () {	8191;}
}
unless(defined(&IWI_RATE_DS1)) {
    sub IWI_RATE_DS1 () {	10;}
}
unless(defined(&IWI_RATE_DS2)) {
    sub IWI_RATE_DS2 () {	20;}
}
unless(defined(&IWI_RATE_DS5)) {
    sub IWI_RATE_DS5 () {	55;}
}
unless(defined(&IWI_RATE_DS11)) {
    sub IWI_RATE_DS11 () {	110;}
}
unless(defined(&IWI_RATE_OFDM6)) {
    sub IWI_RATE_OFDM6 () {	13;}
}
unless(defined(&IWI_RATE_OFDM9)) {
    sub IWI_RATE_OFDM9 () {	15;}
}
unless(defined(&IWI_RATE_OFDM12)) {
    sub IWI_RATE_OFDM12 () {	5;}
}
unless(defined(&IWI_RATE_OFDM18)) {
    sub IWI_RATE_OFDM18 () {	7;}
}
unless(defined(&IWI_RATE_OFDM24)) {
    sub IWI_RATE_OFDM24 () {	9;}
}
unless(defined(&IWI_RATE_OFDM36)) {
    sub IWI_RATE_OFDM36 () {	11;}
}
unless(defined(&IWI_RATE_OFDM48)) {
    sub IWI_RATE_OFDM48 () {	1;}
}
unless(defined(&IWI_RATE_OFDM54)) {
    sub IWI_RATE_OFDM54 () {	3;}
}
unless(defined(&IWI_HDR_TYPE_DATA)) {
    sub IWI_HDR_TYPE_DATA () {	0;}
}
unless(defined(&IWI_HDR_TYPE_COMMAND)) {
    sub IWI_HDR_TYPE_COMMAND () {	1;}
}
unless(defined(&IWI_HDR_TYPE_NOTIF)) {
    sub IWI_HDR_TYPE_NOTIF () {	3;}
}
unless(defined(&IWI_HDR_TYPE_FRAME)) {
    sub IWI_HDR_TYPE_FRAME () {	9;}
}
unless(defined(&IWI_HDR_FLAG_IRQ)) {
    sub IWI_HDR_FLAG_IRQ () {	0x4;}
}
unless(defined(&IWI_NOTIF_TYPE_ASSOCIATION)) {
    sub IWI_NOTIF_TYPE_ASSOCIATION () {	10;}
}
unless(defined(&IWI_NOTIF_TYPE_AUTHENTICATION)) {
    sub IWI_NOTIF_TYPE_AUTHENTICATION () {	11;}
}
unless(defined(&IWI_NOTIF_TYPE_SCAN_CHANNEL)) {
    sub IWI_NOTIF_TYPE_SCAN_CHANNEL () {	12;}
}
unless(defined(&IWI_NOTIF_TYPE_SCAN_COMPLETE)) {
    sub IWI_NOTIF_TYPE_SCAN_COMPLETE () {	13;}
}
unless(defined(&IWI_NOTIF_TYPE_BEACON)) {
    sub IWI_NOTIF_TYPE_BEACON () {	17;}
}
unless(defined(&IWI_NOTIF_TYPE_CALIBRATION)) {
    sub IWI_NOTIF_TYPE_CALIBRATION () {	20;}
}
unless(defined(&IWI_NOTIF_TYPE_NOISE)) {
    sub IWI_NOTIF_TYPE_NOISE () {	25;}
}
unless(defined(&IWI_DEAUTHENTICATED)) {
    sub IWI_DEAUTHENTICATED () {	0;}
}
unless(defined(&IWI_AUTHENTICATED)) {
    sub IWI_AUTHENTICATED () {	9;}
}
unless(defined(&IWI_DEASSOCIATED)) {
    sub IWI_DEASSOCIATED () {	0;}
}
unless(defined(&IWI_ASSOCIATED)) {
    sub IWI_ASSOCIATED () {	12;}
}
unless(defined(&IWI_DATA_CMD_TX)) {
    sub IWI_DATA_CMD_TX () {	0xb;}
}
unless(defined(&IWI_DATA_FLAG_SHPREAMBLE)) {
    sub IWI_DATA_FLAG_SHPREAMBLE () {	0x4;}
}
unless(defined(&IWI_DATA_FLAG_NO_WEP)) {
    sub IWI_DATA_FLAG_NO_WEP () {	0x20;}
}
unless(defined(&IWI_DATA_FLAG_NEED_ACK)) {
    sub IWI_DATA_FLAG_NEED_ACK () {	0x80;}
}
unless(defined(&IWI_MAX_NSEG)) {
    sub IWI_MAX_NSEG () {	6;}
}
unless(defined(&IWI_CMD_ENABLE)) {
    sub IWI_CMD_ENABLE () {	2;}
}
unless(defined(&IWI_CMD_SET_CONFIGURATION)) {
    sub IWI_CMD_SET_CONFIGURATION () {	6;}
}
unless(defined(&IWI_CMD_SET_ESSID)) {
    sub IWI_CMD_SET_ESSID () {	8;}
}
unless(defined(&IWI_CMD_SET_MAC_ADDRESS)) {
    sub IWI_CMD_SET_MAC_ADDRESS () {	11;}
}
unless(defined(&IWI_CMD_SET_RTS_THRESHOLD)) {
    sub IWI_CMD_SET_RTS_THRESHOLD () {	15;}
}
unless(defined(&IWI_CMD_SET_FRAG_THRESHOLD)) {
    sub IWI_CMD_SET_FRAG_THRESHOLD () {	16;}
}
unless(defined(&IWI_CMD_SET_POWER_MODE)) {
    sub IWI_CMD_SET_POWER_MODE () {	17;}
}
unless(defined(&IWI_CMD_SET_WEP_KEY)) {
    sub IWI_CMD_SET_WEP_KEY () {	18;}
}
unless(defined(&IWI_CMD_SCAN)) {
    sub IWI_CMD_SCAN () {	20;}
}
unless(defined(&IWI_CMD_ASSOCIATE)) {
    sub IWI_CMD_ASSOCIATE () {	21;}
}
unless(defined(&IWI_CMD_SET_RATES)) {
    sub IWI_CMD_SET_RATES () {	22;}
}
unless(defined(&IWI_CMD_DISABLE)) {
    sub IWI_CMD_DISABLE () {	33;}
}
unless(defined(&IWI_CMD_SET_IV)) {
    sub IWI_CMD_SET_IV () {	34;}
}
unless(defined(&IWI_CMD_SET_TX_POWER)) {
    sub IWI_CMD_SET_TX_POWER () {	35;}
}
unless(defined(&IWI_CMD_SET_SENSITIVITY)) {
    sub IWI_CMD_SET_SENSITIVITY () {	42;}
}
unless(defined(&IWI_MODE_11A)) {
    sub IWI_MODE_11A () {	0;}
}
unless(defined(&IWI_MODE_11B)) {
    sub IWI_MODE_11B () {	1;}
}
unless(defined(&IWI_MODE_11G)) {
    sub IWI_MODE_11G () {	2;}
}
unless(defined(&IWI_RSSIDBM2RAW)) {
    sub IWI_RSSIDBM2RAW {
	local($rssi) = @_;
	eval q((($rssi) - 112));
    }
}
unless(defined(&IWI_POWER_MODE_CAM)) {
    sub IWI_POWER_MODE_CAM () {	0;}
}
unless(defined(&IWI_RATESET_TYPE_NEGOCIATED)) {
    sub IWI_RATESET_TYPE_NEGOCIATED () {	0;}
}
unless(defined(&IWI_RATESET_TYPE_SUPPORTED)) {
    sub IWI_RATESET_TYPE_SUPPORTED () {	1;}
}
unless(defined(&IWI_TXPOWER_MAX)) {
    sub IWI_TXPOWER_MAX () {	20;}
}
unless(defined(&IWI_TXPOWER_RATIO)) {
    sub IWI_TXPOWER_RATIO () {	( &IEEE80211_TXPOWER_MAX /  &IWI_TXPOWER_MAX);}
}
unless(defined(&IWI_AUTH_OPEN)) {
    sub IWI_AUTH_OPEN () {	0;}
}
unless(defined(&IWI_AUTH_SHARED)) {
    sub IWI_AUTH_SHARED () {	1;}
}
unless(defined(&IWI_AUTH_NONE)) {
    sub IWI_AUTH_NONE () {	3;}
}
unless(defined(&IWI_SCAN_TYPE_PASSIVE)) {
    sub IWI_SCAN_TYPE_PASSIVE () {	1;}
}
unless(defined(&IWI_SCAN_TYPE_BROADCAST)) {
    sub IWI_SCAN_TYPE_BROADCAST () {	3;}
}
unless(defined(&IWI_CHAN_5GHZ)) {
    sub IWI_CHAN_5GHZ () {	(0<< 6);}
}
unless(defined(&IWI_CHAN_2GHZ)) {
    sub IWI_CHAN_2GHZ () {	(1<< 6);}
}
unless(defined(&IWI_WEP_KEY_CMD_SETKEY)) {
    sub IWI_WEP_KEY_CMD_SETKEY () {	0x8;}
}
unless(defined(&IWI_MEM_EEPROM_CTL)) {
    sub IWI_MEM_EEPROM_CTL () {	0x300040;}
}
unless(defined(&IWI_EEPROM_MAC)) {
    sub IWI_EEPROM_MAC () {	0x21;}
}
unless(defined(&IWI_EEPROM_DELAY)) {
    sub IWI_EEPROM_DELAY () {	1;}
}
unless(defined(&IWI_EEPROM_C)) {
    sub IWI_EEPROM_C () {	(1<< 0);}
}
unless(defined(&IWI_EEPROM_S)) {
    sub IWI_EEPROM_S () {	(1<< 1);}
}
unless(defined(&IWI_EEPROM_D)) {
    sub IWI_EEPROM_D () {	(1<< 2);}
}
unless(defined(&IWI_EEPROM_Q)) {
    sub IWI_EEPROM_Q () {	(1<< 4);}
}
unless(defined(&IWI_EEPROM_SHIFT_D)) {
    sub IWI_EEPROM_SHIFT_D () {	2;}
}
unless(defined(&IWI_EEPROM_SHIFT_Q)) {
    sub IWI_EEPROM_SHIFT_Q () {	4;}
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_REGION_4)) {
    sub CSR_READ_REGION_4 {
	local($sc, $offset, $datap, $count) = @_;
	eval q( &bus_space_read_region_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($datap), ($count)));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&MEM_WRITE_1)) {
    sub MEM_WRITE_1 {
	local($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_1(($sc),  &IWI_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_2)) {
    sub MEM_WRITE_2 {
	local($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_2(($sc),  &IWI_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_4)) {
    sub MEM_WRITE_4 {
	local($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_MULTI_1)) {
    sub MEM_WRITE_MULTI_1 {
	local($sc, $addr, $buf, $len) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_MULTI_1(($sc),  &IWI_CSR_INDIRECT_DATA, ($buf), ($len)); }  &while ( 0));
    }
}
unless(defined(&IWI_EEPROM_CTL)) {
    sub IWI_EEPROM_CTL {
	local($sc, $val) = @_;
	eval q( &do {  &MEM_WRITE_4(($sc),  &IWI_MEM_EEPROM_CTL, ($val));  &DELAY( &IWI_EEPROM_DELAY); }  &while ( 0));
    }
}
1;
