require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_AIC79XX_H_)) {
    eval 'sub _AIC79XX_H_ () {1;}' unless defined(&_AIC79XX_H_);
    require 'dev/microcode/aic7xxx/aic79xx_reg.ph';
    require 'dev/ic/aic7xxx_cam.ph';
    unless(defined(&MAX)) {
	eval 'sub MAX {
	    local($a,$b) = @_;
    	    eval q(((($a) > ($b)) ? ($a) : ($b)));
	}' unless defined(&MAX);
    }
    unless(defined(&MIN)) {
	eval 'sub MIN {
	    local($a,$b) = @_;
    	    eval q(((($a) < ($b)) ? ($a) : ($b)));
	}' unless defined(&MIN);
    }
    unless(defined(&TRUE)) {
	eval 'sub TRUE () {1;}' unless defined(&TRUE);
    }
    unless(defined(&FALSE)) {
	eval 'sub FALSE () {0;}' unless defined(&FALSE);
    }
    eval 'sub NUM_ELEMENTS {
        local($array) = @_;
	    eval q(($sizeof{$array} / $sizeof{$array}));
    }' unless defined(&NUM_ELEMENTS);
    eval 'sub ALL_CHANNELS () {ord(\'\\0\');}' unless defined(&ALL_CHANNELS);
    eval 'sub ALL_TARGETS_MASK () {0xffff;}' unless defined(&ALL_TARGETS_MASK);
    eval 'sub INITIATOR_WILDCARD () {(~0);}' unless defined(&INITIATOR_WILDCARD);
    eval 'sub SCB_LIST_NULL () {0xff00;}' unless defined(&SCB_LIST_NULL);
    eval 'sub SCB_LIST_NULL_LE () {( &aic_htole16( &SCB_LIST_NULL));}' unless defined(&SCB_LIST_NULL_LE);
    eval 'sub QOUTFIFO_ENTRY_VALID () {0x80;}' unless defined(&QOUTFIFO_ENTRY_VALID);
    eval 'sub SCBID_IS_NULL {
        local($scbid) = @_;
	    eval q(((($scbid) & 0xff00 ) ==  &SCB_LIST_NULL));
    }' unless defined(&SCBID_IS_NULL);
    eval 'sub SCSIID_TARGET {
        local($ahd, $scsiid) = @_;
	    eval q(((($scsiid) &  &TID) >>  &TID_SHIFT));
    }' unless defined(&SCSIID_TARGET);
    eval 'sub SCSIID_OUR_ID {
        local($scsiid) = @_;
	    eval q((($scsiid) &  &OID));
    }' unless defined(&SCSIID_OUR_ID);
    eval 'sub SCSIID_CHANNEL {
        local($ahd, $scsiid) = @_;
	    eval q((ord(\'A\')));
    }' unless defined(&SCSIID_CHANNEL);
    eval 'sub SCB_IS_SCSIBUS_B {
        local($ahd, $scb) = @_;
	    eval q((0));
    }' unless defined(&SCB_IS_SCSIBUS_B);
    eval 'sub SCB_GET_OUR_ID {
        local($scb) = @_;
	    eval q( &SCSIID_OUR_ID(($scb)-> ($h$scb->{scsiid})));
    }' unless defined(&SCB_GET_OUR_ID);
    eval 'sub SCB_GET_TARGET {
        local($ahd, $scb) = @_;
	    eval q( &SCSIID_TARGET(($ahd), ($scb)-> ($h$scb->{scsiid})));
    }' unless defined(&SCB_GET_TARGET);
    eval 'sub SCB_GET_CHANNEL {
        local($ahd, $scb) = @_;
	    eval q( &SCSIID_CHANNEL($ahd, ($scb)-> ($h$scb->{scsiid})));
    }' unless defined(&SCB_GET_CHANNEL);
    eval 'sub SCB_GET_LUN {
        local($scb) = @_;
	    eval q((($scb)-> ($h$scb->{lun})));
    }' unless defined(&SCB_GET_LUN);
    eval 'sub SCB_GET_TARGET_OFFSET {
        local($ahd, $scb) = @_;
	    eval q( &SCB_GET_TARGET($ahd, $scb));
    }' unless defined(&SCB_GET_TARGET_OFFSET);
    eval 'sub SCB_GET_TARGET_MASK {
        local($ahd, $scb) = @_;
	    eval q((0x1 << ( &SCB_GET_TARGET_OFFSET($ahd, $scb))));
    }' unless defined(&SCB_GET_TARGET_MASK);
    if(defined(&AHD_DEBUG)) {
	eval 'sub SCB_IS_SILENT {
	    local($scb) = @_;
    	    eval q((( &ahd_debug &  &AHD_SHOW_MASKED_ERRORS) == 0 && ((($scb)-> &flags &  &SCB_SILENT) != 0)));
	}' unless defined(&SCB_IS_SILENT);
    } else {
	eval 'sub SCB_IS_SILENT {
	    local($scb) = @_;
    	    eval q(((($scb)-> &flags &  &SCB_SILENT) != 0));
	}' unless defined(&SCB_IS_SILENT);
    }
    eval 'sub TCL_TARGET_OFFSET {
        local($tcl) = @_;
	    eval q((((($tcl) >> 4) &  &TID) >> 4));
    }' unless defined(&TCL_TARGET_OFFSET);
    eval 'sub TCL_LUN {
        local($tcl) = @_;
	    eval q(($tcl & ( &AHD_NUM_LUNS - 1)));
    }' unless defined(&TCL_LUN);
    eval 'sub BUILD_TCL {
        local($scsiid, $lun) = @_;
	    eval q((($lun) | ((($scsiid) &  &TID) << 4)));
    }' unless defined(&BUILD_TCL);
    eval 'sub BUILD_TCL_RAW {
        local($target, $channel, $lun) = @_;
	    eval q((($lun) | (($target) << 8)));
    }' unless defined(&BUILD_TCL_RAW);
    eval 'sub SCB_GET_TAG {
        local($scb) = @_;
	    eval q( &aic_le16toh( ($scb->{h$scb}->{tag})));
    }' unless defined(&SCB_GET_TAG);
    unless(defined(&AHD_TARGET_MODE)) {
	undef(&AHD_TMODE_ENABLE) if defined(&AHD_TMODE_ENABLE);
	eval 'sub AHD_TMODE_ENABLE () {0;}' unless defined(&AHD_TMODE_ENABLE);
    }
    eval 'sub AHD_BUILD_COL_IDX {
        local($target, $lun) = @_;
	    eval q(((($lun) << 4) | $target));
    }' unless defined(&AHD_BUILD_COL_IDX);
    eval 'sub AHD_GET_SCB_COL_IDX {
        local($ahd, $scb) = @_;
	    eval q((( &SCB_GET_LUN($scb) << 4) |  &SCB_GET_TARGET($ahd, $scb)));
    }' unless defined(&AHD_GET_SCB_COL_IDX);
    eval 'sub AHD_SET_SCB_COL_IDX {
        local($scb, $col_idx) = @_;
	    eval q( &do { ($scb)-> ($h$scb->{scsiid}) = (($col_idx) <<  &TID_SHIFT) &  &TID; ($scb)-> ($h$scb->{lun}) = (($col_idx) >> 4) & ( &AHD_NUM_LUNS_NONPKT-1); }  &while (0));
    }' unless defined(&AHD_SET_SCB_COL_IDX);
    eval 'sub AHD_COPY_SCB_COL_IDX {
        local($dst, $src) = @_;
	    eval q( &do {  ($dst->{hscb}->{scsiid}) =  ($src->{hscb}->{scsiid});  ($dst->{hscb}->{lun}) =  ($src->{hscb}->{lun}); }  &while (0));
    }' unless defined(&AHD_COPY_SCB_COL_IDX);
    eval 'sub AHD_NEVER_COL_IDX () {0xffff;}' unless defined(&AHD_NEVER_COL_IDX);
    eval 'sub AHD_NUM_TARGETS () {16;}' unless defined(&AHD_NUM_TARGETS);
    eval 'sub AHD_NUM_LUNS_NONPKT () {64;}' unless defined(&AHD_NUM_LUNS_NONPKT);
    eval 'sub AHD_NUM_LUNS () {256;}' unless defined(&AHD_NUM_LUNS);
    eval 'sub AHD_MAXTRANSFER_SIZE () {0xffffff;}' unless defined(&AHD_MAXTRANSFER_SIZE);
    eval 'sub AHD_SCB_MAX () {512;}' unless defined(&AHD_SCB_MAX);
    eval 'sub AHD_MAX_QUEUE () { &AHD_SCB_MAX;}' unless defined(&AHD_MAX_QUEUE);
    eval 'sub AHD_QIN_SIZE () { &AHD_MAX_QUEUE;}' unless defined(&AHD_QIN_SIZE);
    eval 'sub AHD_QOUT_SIZE () { &AHD_MAX_QUEUE;}' unless defined(&AHD_QOUT_SIZE);
    eval 'sub AHD_QIN_WRAP {
        local($x) = @_;
	    eval q((($x) & ( &AHD_QIN_SIZE-1)));
    }' unless defined(&AHD_QIN_WRAP);
    eval 'sub AHD_SCB_MAX_ALLOC () { &AHD_MAX_QUEUE;}' unless defined(&AHD_SCB_MAX_ALLOC);
    eval 'sub AHD_TMODE_CMDS () {256;}' unless defined(&AHD_TMODE_CMDS);
    eval 'sub AHD_BUSRESET_DELAY () {25;}' unless defined(&AHD_BUSRESET_DELAY);
    eval("sub AHD_NONE () { 0x0000; }") unless defined(&AHD_NONE);
    eval("sub AHD_CHIPID_MASK () { 0x00FF; }") unless defined(&AHD_CHIPID_MASK);
    eval("sub AHD_AIC7901 () { 0x0001; }") unless defined(&AHD_AIC7901);
    eval("sub AHD_AIC7902 () { 0x0002; }") unless defined(&AHD_AIC7902);
    eval("sub AHD_AIC7901A () { 0x0003; }") unless defined(&AHD_AIC7901A);
    eval("sub AHD_PCI () { 0x0100; }") unless defined(&AHD_PCI);
    eval("sub AHD_PCIX () { 0x0200; }") unless defined(&AHD_PCIX);
    eval("sub AHD_BUS_MASK () { 0x0F00; }") unless defined(&AHD_BUS_MASK);
    eval("sub AHD_FENONE () { 0x00000; }") unless defined(&AHD_FENONE);
    eval("sub AHD_WIDE () { 0x00001; }") unless defined(&AHD_WIDE);
    eval("sub AHD_MULTI_FUNC () { 0x00100; }") unless defined(&AHD_MULTI_FUNC);
    eval("sub AHD_TARGETMODE () { 0x01000; }") unless defined(&AHD_TARGETMODE);
    eval("sub AHD_MULTIROLE () { 0x02000; }") unless defined(&AHD_MULTIROLE);
    eval("sub AHD_RTI () { 0x04000; }") unless defined(&AHD_RTI);
    eval("sub AHD_NEW_IOCELL_OPTS () { 0x08000; }") unless defined(&AHD_NEW_IOCELL_OPTS);
    eval("sub AHD_NEW_DFCNTRL_OPTS () { 0x10000; }") unless defined(&AHD_NEW_DFCNTRL_OPTS);
    eval("sub AHD_FAST_CDB_DELIVERY () { 0x20000; }") unless defined(&AHD_FAST_CDB_DELIVERY);
    eval("sub AHD_REMOVABLE () { 0x00000; }") unless defined(&AHD_REMOVABLE);
    eval("sub AHD_AIC7901_FE () { AHD_FENONE; }") unless defined(&AHD_AIC7901_FE);
    eval("sub AHD_AIC7901A_FE () { AHD_FENONE; }") unless defined(&AHD_AIC7901A_FE);
    eval("sub AHD_AIC7902_FE () { AHD_MULTI_FUNC; }") unless defined(&AHD_AIC7902_FE);
    eval("sub AHD_BUGNONE () { 0x0000; }") unless defined(&AHD_BUGNONE);
    eval("sub AHD_SENT_SCB_UPDATE_BUG () { 0x0001; }") unless defined(&AHD_SENT_SCB_UPDATE_BUG);
    eval("sub AHD_ABORT_LQI_BUG () { 0x0002; }") unless defined(&AHD_ABORT_LQI_BUG);
    eval("sub AHD_PKT_BITBUCKET_BUG () { 0x0004; }") unless defined(&AHD_PKT_BITBUCKET_BUG);
    eval("sub AHD_LONG_SETIMO_BUG () { 0x0008; }") unless defined(&AHD_LONG_SETIMO_BUG);
    eval("sub AHD_NLQICRC_DELAYED_BUG () { 0x0010; }") unless defined(&AHD_NLQICRC_DELAYED_BUG);
    eval("sub AHD_SCSIRST_BUG () { 0x0020; }") unless defined(&AHD_SCSIRST_BUG);
    eval("sub AHD_PCIX_CHIPRST_BUG () { 0x0040; }") unless defined(&AHD_PCIX_CHIPRST_BUG);
    eval("sub AHD_PCIX_MMAPIO_BUG () { 0x0080; }") unless defined(&AHD_PCIX_MMAPIO_BUG);
    eval("sub AHD_PCIX_SCBRAM_RD_BUG () { 0x0100; }") unless defined(&AHD_PCIX_SCBRAM_RD_BUG);
    eval("sub AHD_PCIX_BUG_MASK () { AHD_PCIX_CHIPRST_BUG|AHD_PCIX_MMAPIO_BUG|AHD_PCIX_SCBRAM_RD_BUG; }") unless defined(&AHD_PCIX_BUG_MASK);
    eval("sub AHD_LQO_ATNO_BUG () { 0x0200; }") unless defined(&AHD_LQO_ATNO_BUG);
    eval("sub AHD_AUTOFLUSH_BUG () { 0x0400; }") unless defined(&AHD_AUTOFLUSH_BUG);
    eval("sub AHD_CLRLQO_AUTOCLR_BUG () { 0x0800; }") unless defined(&AHD_CLRLQO_AUTOCLR_BUG);
    eval("sub AHD_PKTIZED_STATUS_BUG () { 0x1000; }") unless defined(&AHD_PKTIZED_STATUS_BUG);
    eval("sub AHD_PKT_LUN_BUG () { 0x2000; }") unless defined(&AHD_PKT_LUN_BUG);
    eval("sub AHD_NONPACKFIFO_BUG () { 0x4000; }") unless defined(&AHD_NONPACKFIFO_BUG);
    eval("sub AHD_MDFF_WSCBPTR_BUG () { 0x8000; }") unless defined(&AHD_MDFF_WSCBPTR_BUG);
    eval("sub AHD_REG_SLOW_SETTLE_BUG () { 0x10000; }") unless defined(&AHD_REG_SLOW_SETTLE_BUG);
    eval("sub AHD_SET_MODE_BUG () { 0x20000; }") unless defined(&AHD_SET_MODE_BUG);
    eval("sub AHD_BUSFREEREV_BUG () { 0x40000; }") unless defined(&AHD_BUSFREEREV_BUG);
    eval("sub AHD_PACED_NEGTABLE_BUG () { 0x80000; }") unless defined(&AHD_PACED_NEGTABLE_BUG);
    eval("sub AHD_LQOOVERRUN_BUG () { 0x100000; }") unless defined(&AHD_LQOOVERRUN_BUG);
    eval("sub AHD_INTCOLLISION_BUG () { 0x200000; }") unless defined(&AHD_INTCOLLISION_BUG);
    eval("sub AHD_EARLY_REQ_BUG () { 0x400000; }") unless defined(&AHD_EARLY_REQ_BUG);
    eval("sub AHD_FAINT_LED_BUG () { 0x800000; }") unless defined(&AHD_FAINT_LED_BUG);
    eval("sub AHD_FNONE () { 0x00000; }") unless defined(&AHD_FNONE);
    eval("sub AHD_BOOT_CHANNEL () { 0x00001; }") unless defined(&AHD_BOOT_CHANNEL);
    eval("sub AHD_USEDEFAULTS () { 0x00004; }") unless defined(&AHD_USEDEFAULTS);
    eval("sub AHD_SEQUENCER_DEBUG () { 0x00008; }") unless defined(&AHD_SEQUENCER_DEBUG);
    eval("sub AHD_RESET_BUS_A () { 0x00010; }") unless defined(&AHD_RESET_BUS_A);
    eval("sub AHD_EXTENDED_TRANS_A () { 0x00020; }") unless defined(&AHD_EXTENDED_TRANS_A);
    eval("sub AHD_TERM_ENB_A () { 0x00040; }") unless defined(&AHD_TERM_ENB_A);
    eval("sub AHD_SPCHK_ENB_A () { 0x00080; }") unless defined(&AHD_SPCHK_ENB_A);
    eval("sub AHD_STPWLEVEL_A () { 0x00100; }") unless defined(&AHD_STPWLEVEL_A);
    eval("sub AHD_INITIATORROLE () { 0x00200; }") unless defined(&AHD_INITIATORROLE);
    eval("sub AHD_TARGETROLE () { 0x00400; }") unless defined(&AHD_TARGETROLE);
    eval("sub AHD_RESOURCE_SHORTAGE () { 0x00800; }") unless defined(&AHD_RESOURCE_SHORTAGE);
    eval("sub AHD_TQINFIFO_BLOCKED () { 0x01000; }") unless defined(&AHD_TQINFIFO_BLOCKED);
    eval("sub AHD_INT50_SPEEDFLEX () { 0x02000; }") unless defined(&AHD_INT50_SPEEDFLEX);
    eval("sub AHD_BIOS_ENABLED () { 0x04000; }") unless defined(&AHD_BIOS_ENABLED);
    eval("sub AHD_ALL_INTERRUPTS () { 0x08000; }") unless defined(&AHD_ALL_INTERRUPTS);
    eval("sub AHD_39BIT_ADDRESSING () { 0x10000; }") unless defined(&AHD_39BIT_ADDRESSING);
    eval("sub AHD_64BIT_ADDRESSING () { 0x20000; }") unless defined(&AHD_64BIT_ADDRESSING);
    eval("sub AHD_CURRENT_SENSING () { 0x40000; }") unless defined(&AHD_CURRENT_SENSING);
    eval("sub AHD_SCB_CONFIG_USED () { 0x80000; }") unless defined(&AHD_SCB_CONFIG_USED);
    eval("sub AHD_HP_BOARD () { 0x100000; }") unless defined(&AHD_HP_BOARD);
    eval("sub AHD_RESET_POLL_ACTIVE () { 0x200000; }") unless defined(&AHD_RESET_POLL_ACTIVE);
    eval("sub AHD_UPDATE_PEND_CMDS () { 0x400000; }") unless defined(&AHD_UPDATE_PEND_CMDS);
    eval("sub AHD_RUNNING_QOUTFIFO () { 0x800000; }") unless defined(&AHD_RUNNING_QOUTFIFO);
    eval("sub AHD_HAD_FIRST_SEL () { 0x1000000; }") unless defined(&AHD_HAD_FIRST_SEL);
    eval("sub AHD_SHUTDOWN_RECOVERY () { 0x2000000; }") unless defined(&AHD_SHUTDOWN_RECOVERY);
    eval("sub AHD_HOSTRAID_BOARD () { 0x4000000; }") unless defined(&AHD_HOSTRAID_BOARD);
    eval 'sub MAX_CDB_LEN () {16;}' unless defined(&MAX_CDB_LEN);
    eval 'sub MAX_CDB_LEN_WITH_SENSE_ADDR () {( &MAX_CDB_LEN - $sizeof{ &sense_addr_t});}' unless defined(&MAX_CDB_LEN_WITH_SENSE_ADDR);
    eval 'sub SG_PTR_MASK () {0xfffffff8;}' unless defined(&SG_PTR_MASK);
    eval 'sub AHD_DMA_LAST_SEG () {0x80000000;}' unless defined(&AHD_DMA_LAST_SEG);
    eval 'sub AHD_SG_HIGH_ADDR_MASK () {0x7f000000;}' unless defined(&AHD_SG_HIGH_ADDR_MASK);
    eval 'sub AHD_SG_LEN_MASK () {0xffffff;}' unless defined(&AHD_SG_LEN_MASK);
    eval("sub SCB_FLAG_NONE () { 0x00000; }") unless defined(&SCB_FLAG_NONE);
    eval("sub SCB_TRANSMISSION_ERROR () { 0x00001; }") unless defined(&SCB_TRANSMISSION_ERROR);
    eval("sub SCB_OTHERTCL_TIMEOUT () { 0x00002; }") unless defined(&SCB_OTHERTCL_TIMEOUT);
    eval("sub SCB_DEVICE_RESET () { 0x00004; }") unless defined(&SCB_DEVICE_RESET);
    eval("sub SCB_SENSE () { 0x00008; }") unless defined(&SCB_SENSE);
    eval("sub SCB_CDB32_PTR () { 0x00010; }") unless defined(&SCB_CDB32_PTR);
    eval("sub SCB_RECOVERY_SCB () { 0x00020; }") unless defined(&SCB_RECOVERY_SCB);
    eval("sub SCB_AUTO_NEGOTIATE () { 0x00040; }") unless defined(&SCB_AUTO_NEGOTIATE);
    eval("sub SCB_NEGOTIATE () { 0x00080; }") unless defined(&SCB_NEGOTIATE);
    eval("sub SCB_ABORT () { 0x00100; }") unless defined(&SCB_ABORT);
    eval("sub SCB_ACTIVE () { 0x00200; }") unless defined(&SCB_ACTIVE);
    eval("sub SCB_TARGET_IMMEDIATE () { 0x00400; }") unless defined(&SCB_TARGET_IMMEDIATE);
    eval("sub SCB_PACKETIZED () { 0x00800; }") unless defined(&SCB_PACKETIZED);
    eval("sub SCB_EXPECT_PPR_BUSFREE () { 0x01000; }") unless defined(&SCB_EXPECT_PPR_BUSFREE);
    eval("sub SCB_PKT_SENSE () { 0x02000; }") unless defined(&SCB_PKT_SENSE);
    eval("sub SCB_CMDPHASE_ABORT () { 0x04000; }") unless defined(&SCB_CMDPHASE_ABORT);
    eval("sub SCB_ON_COL_LIST () { 0x08000; }") unless defined(&SCB_ON_COL_LIST);
    eval("sub SCB_SILENT () { 0x10000; }") unless defined(&SCB_SILENT);
    eval("sub SCB_TIMEDOUT () { 0x20000; }") unless defined(&SCB_TIMEDOUT);
    eval 'sub pending_links () { ($links2->{le});}' unless defined(&pending_links);
    eval 'sub collision_links () { ($links2->{le});}' unless defined(&collision_links);
    unless(defined(&__linux__)) {
    }
    eval 'sub AHD_MAX_LQ_CRC_ERRORS () {5;}' unless defined(&AHD_MAX_LQ_CRC_ERRORS);
    eval 'sub AHD_TMODE_EVENT_BUFFER_SIZE () {8;}' unless defined(&AHD_TMODE_EVENT_BUFFER_SIZE);
    eval 'sub EVENT_TYPE_BUS_RESET () {0xff;}' unless defined(&EVENT_TYPE_BUS_RESET);
    if(defined(&AHD_TARGET_MODE)) {
    } else {
    }
    eval 'sub AHD_TRANS_CUR () {0x1;}' unless defined(&AHD_TRANS_CUR);
    eval 'sub AHD_TRANS_ACTIVE () {0x3;}' unless defined(&AHD_TRANS_ACTIVE);
    eval 'sub AHD_TRANS_GOAL () {0x4;}' unless defined(&AHD_TRANS_GOAL);
    eval 'sub AHD_TRANS_USER () {0x8;}' unless defined(&AHD_TRANS_USER);
    eval 'sub AHD_PERIOD_10MHz () {0x19;}' unless defined(&AHD_PERIOD_10MHz);
    eval 'sub AHD_WIDTH_UNKNOWN () {0xff;}' unless defined(&AHD_WIDTH_UNKNOWN);
    eval 'sub AHD_PERIOD_UNKNOWN () {0xff;}' unless defined(&AHD_PERIOD_UNKNOWN);
    eval 'sub AHD_OFFSET_UNKNOWN () {0xff;}' unless defined(&AHD_OFFSET_UNKNOWN);
    eval 'sub AHD_PPR_OPTS_UNKNOWN () {0xff;}' unless defined(&AHD_PPR_OPTS_UNKNOWN);
    eval 'sub AHD_SYNCRATE_160 () {0x8;}' unless defined(&AHD_SYNCRATE_160);
    eval 'sub AHD_SYNCRATE_PACED () {0x8;}' unless defined(&AHD_SYNCRATE_PACED);
    eval 'sub AHD_SYNCRATE_DT () {0x9;}' unless defined(&AHD_SYNCRATE_DT);
    eval 'sub AHD_SYNCRATE_ULTRA2 () {0xa;}' unless defined(&AHD_SYNCRATE_ULTRA2);
    eval 'sub AHD_SYNCRATE_ULTRA () {0xc;}' unless defined(&AHD_SYNCRATE_ULTRA);
    eval 'sub AHD_SYNCRATE_FAST () {0x19;}' unless defined(&AHD_SYNCRATE_FAST);
    eval 'sub AHD_SYNCRATE_MIN_DT () { &AHD_SYNCRATE_FAST;}' unless defined(&AHD_SYNCRATE_MIN_DT);
    eval 'sub AHD_SYNCRATE_SYNC () {0x32;}' unless defined(&AHD_SYNCRATE_SYNC);
    eval 'sub AHD_SYNCRATE_MIN () {0x60;}' unless defined(&AHD_SYNCRATE_MIN);
    eval 'sub AHD_SYNCRATE_ASYNC () {0xff;}' unless defined(&AHD_SYNCRATE_ASYNC);
    eval 'sub AHD_SYNCRATE_MAX () { &AHD_SYNCRATE_160;}' unless defined(&AHD_SYNCRATE_MAX);
    eval 'sub AHD_ASYNC_XFER_PERIOD () {0x44;}' unless defined(&AHD_ASYNC_XFER_PERIOD);
    eval 'sub AHD_SYNCRATE_REVA_120 () {0x8;}' unless defined(&AHD_SYNCRATE_REVA_120);
    eval 'sub AHD_SYNCRATE_REVA_160 () {0x7;}' unless defined(&AHD_SYNCRATE_REVA_160);
    eval 'sub CFXFER () {0x3f;}' unless defined(&CFXFER);
    eval 'sub CFXFER_ASYNC () {0x3f;}' unless defined(&CFXFER_ASYNC);
    eval 'sub CFQAS () {0x40;}' unless defined(&CFQAS);
    eval 'sub CFPACKETIZED () {0x80;}' unless defined(&CFPACKETIZED);
    eval 'sub CFSTART () {0x100;}' unless defined(&CFSTART);
    eval 'sub CFINCBIOS () {0x200;}' unless defined(&CFINCBIOS);
    eval 'sub CFDISC () {0x400;}' unless defined(&CFDISC);
    eval 'sub CFMULTILUNDEV () {0x800;}' unless defined(&CFMULTILUNDEV);
    eval 'sub CFWIDEB () {0x1000;}' unless defined(&CFWIDEB);
    eval 'sub CFHOSTMANAGED () {0x8000;}' unless defined(&CFHOSTMANAGED);
    eval 'sub CFSUPREM () {0x1;}' unless defined(&CFSUPREM);
    eval 'sub CFSUPREMB () {0x2;}' unless defined(&CFSUPREMB);
    eval 'sub CFBIOSSTATE () {0xc;}' unless defined(&CFBIOSSTATE);
    eval 'sub CFBS_DISABLED () {0x;}' unless defined(&CFBS_DISABLED);
    eval 'sub CFBS_ENABLED () {0x4;}' unless defined(&CFBS_ENABLED);
    eval 'sub CFBS_DISABLED_SCAN () {0x8;}' unless defined(&CFBS_DISABLED_SCAN);
    eval 'sub CFENABLEDV () {0x10;}' unless defined(&CFENABLEDV);
    eval 'sub CFCTRL_A () {0x20;}' unless defined(&CFCTRL_A);
    eval 'sub CFSPARITY () {0x40;}' unless defined(&CFSPARITY);
    eval 'sub CFEXTEND () {0x80;}' unless defined(&CFEXTEND);
    eval 'sub CFBOOTCD () {0x100;}' unless defined(&CFBOOTCD);
    eval 'sub CFMSG_LEVEL () {0x600;}' unless defined(&CFMSG_LEVEL);
    eval 'sub CFMSG_VERBOSE () {0x;}' unless defined(&CFMSG_VERBOSE);
    eval 'sub CFMSG_SILENT () {0x200;}' unless defined(&CFMSG_SILENT);
    eval 'sub CFMSG_DIAG () {0x400;}' unless defined(&CFMSG_DIAG);
    eval 'sub CFRESETB () {0x800;}' unless defined(&CFRESETB);
    eval 'sub CFAUTOTERM () {0x1;}' unless defined(&CFAUTOTERM);
    eval 'sub CFSTERM () {0x2;}' unless defined(&CFSTERM);
    eval 'sub CFWSTERM () {0x4;}' unless defined(&CFWSTERM);
    eval 'sub CFSEAUTOTERM () {0x8;}' unless defined(&CFSEAUTOTERM);
    eval 'sub CFSELOWTERM () {0x10;}' unless defined(&CFSELOWTERM);
    eval 'sub CFSEHIGHTERM () {0x20;}' unless defined(&CFSEHIGHTERM);
    eval 'sub CFSTPWLEVEL () {0x40;}' unless defined(&CFSTPWLEVEL);
    eval 'sub CFBIOSAUTOTERM () {0x80;}' unless defined(&CFBIOSAUTOTERM);
    eval 'sub CFTERM_MENU () {0x100;}' unless defined(&CFTERM_MENU);
    eval 'sub CFCLUSTERENB () {0x8000;}' unless defined(&CFCLUSTERENB);
    eval 'sub CFSCSIID () {0xf;}' unless defined(&CFSCSIID);
    eval 'sub CFBRTIME () {0xff00;}' unless defined(&CFBRTIME);
    eval 'sub CFMAXTARG () {0xff;}' unless defined(&CFMAXTARG);
    eval 'sub CFBOOTLUN () {0xf00;}' unless defined(&CFBOOTLUN);
    eval 'sub CFBOOTID () {0xf000;}' unless defined(&CFBOOTID);
    eval 'sub CFSIGNATURE () {0x400;}' unless defined(&CFSIGNATURE);
    eval 'sub VPDMASTERBIOS () {0x1;}' unless defined(&VPDMASTERBIOS);
    eval 'sub VPDBOOTHOST () {0x2;}' unless defined(&VPDBOOTHOST);
    eval 'sub FLXADDR_TERMCTL () {0x;}' unless defined(&FLXADDR_TERMCTL);
    eval 'sub FLX_TERMCTL_ENSECHIGH () {0x8;}' unless defined(&FLX_TERMCTL_ENSECHIGH);
    eval 'sub FLX_TERMCTL_ENSECLOW () {0x4;}' unless defined(&FLX_TERMCTL_ENSECLOW);
    eval 'sub FLX_TERMCTL_ENPRIHIGH () {0x2;}' unless defined(&FLX_TERMCTL_ENPRIHIGH);
    eval 'sub FLX_TERMCTL_ENPRILOW () {0x1;}' unless defined(&FLX_TERMCTL_ENPRILOW);
    eval 'sub FLXADDR_ROMSTAT_CURSENSECTL () {0x1;}' unless defined(&FLXADDR_ROMSTAT_CURSENSECTL);
    eval 'sub FLX_ROMSTAT_SEECFG () {0xf0;}' unless defined(&FLX_ROMSTAT_SEECFG);
    eval 'sub FLX_ROMSTAT_EECFG () {0xf;}' unless defined(&FLX_ROMSTAT_EECFG);
    eval 'sub FLX_ROMSTAT_SEE_93C66 () {0x;}' unless defined(&FLX_ROMSTAT_SEE_93C66);
    eval 'sub FLX_ROMSTAT_SEE_NONE () {0xf0;}' unless defined(&FLX_ROMSTAT_SEE_NONE);
    eval 'sub FLX_ROMSTAT_EE_512x8 () {0x;}' unless defined(&FLX_ROMSTAT_EE_512x8);
    eval 'sub FLX_ROMSTAT_EE_1MBx8 () {0x1;}' unless defined(&FLX_ROMSTAT_EE_1MBx8);
    eval 'sub FLX_ROMSTAT_EE_2MBx8 () {0x2;}' unless defined(&FLX_ROMSTAT_EE_2MBx8);
    eval 'sub FLX_ROMSTAT_EE_4MBx8 () {0x3;}' unless defined(&FLX_ROMSTAT_EE_4MBx8);
    eval 'sub FLX_ROMSTAT_EE_16MBx8 () {0x4;}' unless defined(&FLX_ROMSTAT_EE_16MBx8);
    eval 'sub CURSENSE_ENB () {0x1;}' unless defined(&CURSENSE_ENB);
    eval 'sub FLXADDR_FLEXSTAT () {0x2;}' unless defined(&FLXADDR_FLEXSTAT);
    eval 'sub FLX_FSTAT_BUSY () {0x1;}' unless defined(&FLX_FSTAT_BUSY);
    eval 'sub FLXADDR_CURRENT_STAT () {0x4;}' unless defined(&FLXADDR_CURRENT_STAT);
    eval 'sub FLX_CSTAT_SEC_HIGH () {0xc0;}' unless defined(&FLX_CSTAT_SEC_HIGH);
    eval 'sub FLX_CSTAT_SEC_LOW () {0x30;}' unless defined(&FLX_CSTAT_SEC_LOW);
    eval 'sub FLX_CSTAT_PRI_HIGH () {0xc;}' unless defined(&FLX_CSTAT_PRI_HIGH);
    eval 'sub FLX_CSTAT_PRI_LOW () {0x3;}' unless defined(&FLX_CSTAT_PRI_LOW);
    eval 'sub FLX_CSTAT_MASK () {0x3;}' unless defined(&FLX_CSTAT_MASK);
    eval 'sub FLX_CSTAT_SHIFT () {2;}' unless defined(&FLX_CSTAT_SHIFT);
    eval 'sub FLX_CSTAT_OKAY () {0x;}' unless defined(&FLX_CSTAT_OKAY);
    eval 'sub FLX_CSTAT_OVER () {0x1;}' unless defined(&FLX_CSTAT_OVER);
    eval 'sub FLX_CSTAT_UNDER () {0x2;}' unless defined(&FLX_CSTAT_UNDER);
    eval 'sub FLX_CSTAT_INVALID () {0x3;}' unless defined(&FLX_CSTAT_INVALID);
    eval("sub MSG_FLAG_NONE () { 0x00; }") unless defined(&MSG_FLAG_NONE);
    eval("sub MSG_FLAG_EXPECT_PPR_BUSFREE () { 0x01; }") unless defined(&MSG_FLAG_EXPECT_PPR_BUSFREE);
    eval("sub MSG_FLAG_IU_REQ_CHANGED () { 0x02; }") unless defined(&MSG_FLAG_IU_REQ_CHANGED);
    eval("sub MSG_FLAG_EXPECT_IDE_BUSFREE () { 0x04; }") unless defined(&MSG_FLAG_EXPECT_IDE_BUSFREE);
    eval("sub MSG_FLAG_EXPECT_QASREJ_BUSFREE () { 0x08; }") unless defined(&MSG_FLAG_EXPECT_QASREJ_BUSFREE);
    eval("sub MSG_FLAG_PACKETIZED () { 0x10; }") unless defined(&MSG_FLAG_PACKETIZED);
    eval("sub MSG_TYPE_NONE () { 0x00; }") unless defined(&MSG_TYPE_NONE);
    eval("sub MSG_TYPE_INITIATOR_MSGOUT () { 0x01; }") unless defined(&MSG_TYPE_INITIATOR_MSGOUT);
    eval("sub MSG_TYPE_INITIATOR_MSGIN () { 0x02; }") unless defined(&MSG_TYPE_INITIATOR_MSGIN);
    eval("sub MSG_TYPE_TARGET_MSGOUT () { 0x03; }") unless defined(&MSG_TYPE_TARGET_MSGOUT);
    eval("sub MSG_TYPE_TARGET_MSGIN () { 0x04; }") unless defined(&MSG_TYPE_TARGET_MSGIN);
    eval("sub MSGLOOP_IN_PROG () { 0; }") unless defined(&MSGLOOP_IN_PROG);
    eval("sub MSGLOOP_MSGCOMPLETE () { 1; }") unless defined(&MSGLOOP_MSGCOMPLETE);
    eval("sub MSGLOOP_TERMINATED () { 2; }") unless defined(&MSGLOOP_TERMINATED);
    eval("sub AHD_MODE_DFF0 () { 0; }") unless defined(&AHD_MODE_DFF0);
    eval("sub AHD_MODE_DFF1 () { 1; }") unless defined(&AHD_MODE_DFF1);
    eval("sub AHD_MODE_CCHAN () { 2; }") unless defined(&AHD_MODE_CCHAN);
    eval("sub AHD_MODE_SCSI () { 3; }") unless defined(&AHD_MODE_SCSI);
    eval("sub AHD_MODE_CFG () { 4; }") unless defined(&AHD_MODE_CFG);
    eval("sub AHD_MODE_UNKNOWN () { 5; }") unless defined(&AHD_MODE_UNKNOWN);
    eval 'sub AHD_MK_MSK {
        local($x) = @_;
	    eval q((0x1 << ($x)));
    }' unless defined(&AHD_MK_MSK);
    eval 'sub AHD_MODE_DFF0_MSK () { &AHD_MK_MSK( &AHD_MODE_DFF0);}' unless defined(&AHD_MODE_DFF0_MSK);
    eval 'sub AHD_MODE_DFF1_MSK () { &AHD_MK_MSK( &AHD_MODE_DFF1);}' unless defined(&AHD_MODE_DFF1_MSK);
    eval 'sub AHD_MODE_CCHAN_MSK () { &AHD_MK_MSK( &AHD_MODE_CCHAN);}' unless defined(&AHD_MODE_CCHAN_MSK);
    eval 'sub AHD_MODE_SCSI_MSK () { &AHD_MK_MSK( &AHD_MODE_SCSI);}' unless defined(&AHD_MODE_SCSI_MSK);
    eval 'sub AHD_MODE_CFG_MSK () { &AHD_MK_MSK( &AHD_MODE_CFG);}' unless defined(&AHD_MODE_CFG_MSK);
    eval 'sub AHD_MODE_UNKNOWN_MSK () { &AHD_MK_MSK( &AHD_MODE_UNKNOWN);}' unless defined(&AHD_MODE_UNKNOWN_MSK);
    eval 'sub AHD_MODE_ANY_MSK () {(~0);}' unless defined(&AHD_MODE_ANY_MSK);
    eval 'sub AIC_SCB_DATA {
        local($softc) = @_;
	    eval q((($softc)-> &scb_data));
    }' unless defined(&AIC_SCB_DATA);
    unless(defined(&__linux__)) {
    }
    eval 'sub AHD_STAT_UPDATE_MS () {250;}' unless defined(&AHD_STAT_UPDATE_MS);
    eval 'sub AHD_STAT_BUCKETS () {4;}' unless defined(&AHD_STAT_BUCKETS);
    eval 'sub AHD_INT_COALESCING_TIMER_DEFAULT () {250;}' unless defined(&AHD_INT_COALESCING_TIMER_DEFAULT);
    eval 'sub AHD_INT_COALESCING_MAXCMDS_DEFAULT () {10;}' unless defined(&AHD_INT_COALESCING_MAXCMDS_DEFAULT);
    eval 'sub AHD_INT_COALESCING_MAXCMDS_MAX () {127;}' unless defined(&AHD_INT_COALESCING_MAXCMDS_MAX);
    eval 'sub AHD_INT_COALESCING_MINCMDS_DEFAULT () {5;}' unless defined(&AHD_INT_COALESCING_MINCMDS_DEFAULT);
    eval 'sub AHD_INT_COALESCING_MINCMDS_MAX () {127;}' unless defined(&AHD_INT_COALESCING_MINCMDS_MAX);
    eval 'sub AHD_INT_COALESCING_THRESHOLD_DEFAULT () {2000;}' unless defined(&AHD_INT_COALESCING_THRESHOLD_DEFAULT);
    eval 'sub AHD_INT_COALESCING_STOP_THRESHOLD_DEFAULT () {1000;}' unless defined(&AHD_INT_COALESCING_STOP_THRESHOLD_DEFAULT);
    eval 'sub AHD_PRECOMP_SLEW_INDEX () {( &AHD_ANNEXCOL_PRECOMP_SLEW -  &AHD_ANNEXCOL_PER_DEV0);}' unless defined(&AHD_PRECOMP_SLEW_INDEX);
    eval 'sub AHD_AMPLITUDE_INDEX () {( &AHD_ANNEXCOL_AMPLITUDE -  &AHD_ANNEXCOL_PER_DEV0);}' unless defined(&AHD_AMPLITUDE_INDEX);
    eval 'sub AHD_SET_SLEWRATE {
        local($ahd, $new_slew) = @_;
	    eval q( &do { ($ahd)-> $iocell_opts[ &AHD_PRECOMP_SLEW_INDEX] &= ~ &AHD_SLEWRATE_MASK; ($ahd)-> $iocell_opts[ &AHD_PRECOMP_SLEW_INDEX] |= ((($new_slew) <<  &AHD_SLEWRATE_SHIFT) &  &AHD_SLEWRATE_MASK); }  &while (0));
    }' unless defined(&AHD_SET_SLEWRATE);
    eval 'sub AHD_SET_PRECOMP {
        local($ahd, $new_pcomp) = @_;
	    eval q( &do { ($ahd)-> $iocell_opts[ &AHD_PRECOMP_SLEW_INDEX] &= ~ &AHD_PRECOMP_MASK; ($ahd)-> $iocell_opts[ &AHD_PRECOMP_SLEW_INDEX] |= ((($new_pcomp) <<  &AHD_PRECOMP_SHIFT) &  &AHD_PRECOMP_MASK); }  &while (0));
    }' unless defined(&AHD_SET_PRECOMP);
    eval 'sub AHD_SET_AMPLITUDE {
        local($ahd, $new_amp) = @_;
	    eval q( &do { ($ahd)-> $iocell_opts[ &AHD_AMPLITUDE_INDEX] &= ~ &AHD_AMPLITUDE_MASK; ($ahd)-> $iocell_opts[ &AHD_AMPLITUDE_INDEX] |= ((($new_amp) <<  &AHD_AMPLITUDE_SHIFT) &  &AHD_AMPLITUDE_MASK); }  &while (0));
    }' unless defined(&AHD_SET_AMPLITUDE);
    eval("sub ROLE_UNKNOWN () { 0; }") unless defined(&ROLE_UNKNOWN);
    eval("sub ROLE_INITIATOR () { 1; }") unless defined(&ROLE_INITIATOR);
    eval("sub ROLE_TARGET () { 2; }") unless defined(&ROLE_TARGET);
    eval 'sub AHD_PCI_IOADDR () { &PCI_MAPREG_START;}' unless defined(&AHD_PCI_IOADDR);
    eval 'sub AHD_PCI_MEMADDR () {( &PCI_MAPREG_START + 4);}' unless defined(&AHD_PCI_MEMADDR);
    eval 'sub AHD_PCI_IOADDR1 () {( &PCI_MAPREG_START + 12);}' unless defined(&AHD_PCI_IOADDR1);
    if(defined(&AHD_TARGET_MODE)) {
    }
    eval("sub SEARCH_COMPLETE () { 0; }") unless defined(&SEARCH_COMPLETE);
    eval("sub SEARCH_COUNT () { 1; }") unless defined(&SEARCH_COUNT);
    eval("sub SEARCH_REMOVE () { 2; }") unless defined(&SEARCH_REMOVE);
    eval("sub SEARCH_PRINT () { 3; }") unless defined(&SEARCH_PRINT);
    eval("sub AHD_NEG_TO_GOAL () { 0; }") unless defined(&AHD_NEG_TO_GOAL);
    eval("sub AHD_NEG_IF_NON_ASYNC () { 1; }") unless defined(&AHD_NEG_IF_NON_ASYNC);
    eval("sub AHD_NEG_ALWAYS () { 2; }") unless defined(&AHD_NEG_ALWAYS);
    eval("sub AHD_QUEUE_NONE () { 0; }") unless defined(&AHD_QUEUE_NONE);
    eval("sub AHD_QUEUE_BASIC () { 1; }") unless defined(&AHD_QUEUE_BASIC);
    eval("sub AHD_QUEUE_TAGGED () { 2; }") unless defined(&AHD_QUEUE_TAGGED);
    if(defined(&AHD_TARGET_MODE)) {
	unless(defined(&AHD_TMODE_ENABLE)) {
	    eval 'sub AHD_TMODE_ENABLE () {0;}' unless defined(&AHD_TMODE_ENABLE);
	}
    }
    if(defined(&AHD_DEBUG)) {
	eval 'sub AHD_DEBUG_OPTS () {0;}' unless defined(&AHD_DEBUG_OPTS);
	eval 'sub AHD_SHOW_MISC () {0x1;}' unless defined(&AHD_SHOW_MISC);
	eval 'sub AHD_SHOW_SENSE () {0x2;}' unless defined(&AHD_SHOW_SENSE);
	eval 'sub AHD_SHOW_RECOVERY () {0x4;}' unless defined(&AHD_SHOW_RECOVERY);
	eval 'sub AHD_DUMP_SEEPROM () {0x8;}' unless defined(&AHD_DUMP_SEEPROM);
	eval 'sub AHD_SHOW_TERMCTL () {0x10;}' unless defined(&AHD_SHOW_TERMCTL);
	eval 'sub AHD_SHOW_MEMORY () {0x20;}' unless defined(&AHD_SHOW_MEMORY);
	eval 'sub AHD_SHOW_MESSAGES () {0x40;}' unless defined(&AHD_SHOW_MESSAGES);
	eval 'sub AHD_SHOW_MODEPTR () {0x80;}' unless defined(&AHD_SHOW_MODEPTR);
	eval 'sub AHD_SHOW_SELTO () {0x100;}' unless defined(&AHD_SHOW_SELTO);
	eval 'sub AHD_SHOW_FIFOS () {0x200;}' unless defined(&AHD_SHOW_FIFOS);
	eval 'sub AHD_SHOW_QFULL () {0x400;}' unless defined(&AHD_SHOW_QFULL);
	eval 'sub AHD_SHOW_DV () {0x800;}' unless defined(&AHD_SHOW_DV);
	eval 'sub AHD_SHOW_MASKED_ERRORS () {0x1000;}' unless defined(&AHD_SHOW_MASKED_ERRORS);
	eval 'sub AHD_SHOW_QUEUE () {0x2000;}' unless defined(&AHD_SHOW_QUEUE);
	eval 'sub AHD_SHOW_TQIN () {0x4000;}' unless defined(&AHD_SHOW_TQIN);
	eval 'sub AHD_SHOW_SG () {0x8000;}' unless defined(&AHD_SHOW_SG);
	eval 'sub AHD_SHOW_INT_COALESCING () {0x10000;}' unless defined(&AHD_SHOW_INT_COALESCING);
	eval 'sub AHD_DEBUG_SEQUENCER () {0x20000;}' unless defined(&AHD_DEBUG_SEQUENCER);
    }
}
1;
