require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_M68K_VMPARAM_H_)) {
    eval 'sub _M68K_VMPARAM_H_ () {1;}' unless defined(&_M68K_VMPARAM_H_);
    eval 'sub USRTEXT () {8192;}' unless defined(&USRTEXT);
    eval 'sub USRSTACK () {(- &HIGHPAGES* &NBPG);}' unless defined(&USRSTACK);
    eval 'sub LOWPAGES () {0;}' unless defined(&LOWPAGES);
    eval 'sub HIGHPAGES () {(0x100000/ &NBPG);}' unless defined(&HIGHPAGES);
    unless(defined(&MAXTSIZ)) {
	eval 'sub MAXTSIZ () {(8*1024*1024);}' unless defined(&MAXTSIZ);
    }
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(32*1024*1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(64*1024*1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(2*1024*1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () { &MAXDSIZ;}' unless defined(&MAXSSIZ);
    }
    eval 'sub STACKGAP_RANDOM () {256*1024;}' unless defined(&STACKGAP_RANDOM);
    eval 'sub USRPTSIZE () {(1*  &NPTEPG);}' unless defined(&USRPTSIZE);
    unless(defined(&USRIOSIZE)) {
	eval 'sub USRIOSIZE () {(1*  &NPTEPG);}' unless defined(&USRIOSIZE);
    }
    unless(defined(&SHMMAXPGS)) {
	eval 'sub SHMMAXPGS () {1024;}' unless defined(&SHMMAXPGS);
    }
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t)0);}' unless defined(&VM_MIN_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t)( &USRSTACK));}' unless defined(&VM_MAXUSER_ADDRESS);
    eval 'sub VM_MAX_ADDRESS () {(( &vaddr_t)(0-( &UPAGES* &NBPG)));}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t)0);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
    eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t)(0- &NBPG));}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    eval 'sub VM_PHYS_SIZE () {( &USRIOSIZE* &PAGE_SIZE);}' unless defined(&VM_PHYS_SIZE);
    eval 'sub VM_KERNEL_PT_PAGES () {(( &vsize_t)2);}' unless defined(&VM_KERNEL_PT_PAGES);
    eval 'sub pcbb {
        local($p) = @_;
	    eval q((($p)-> &p_addr));
    }' unless defined(&pcbb);
    eval 'sub VM_PHYSSEG_NOADD () {1;}' unless defined(&VM_PHYSSEG_NOADD);
    eval 'sub VM_NFREELIST () {1;}' unless defined(&VM_NFREELIST);
    eval 'sub VM_FREELIST_DEFAULT () {0;}' unless defined(&VM_FREELIST_DEFAULT);
    unless(defined(&_LOCORE)) {
	require 'machine/pte.ph';
	eval 'sub PV_CI () {(0x1 <<  &PG_SHIFT);}' unless defined(&PV_CI);
	eval 'sub PV_PTPAGE () {(0x2 <<  &PG_SHIFT);}' unless defined(&PV_PTPAGE);
	eval 'sub __HAVE_VM_PAGE_MD () {1;}' unless defined(&__HAVE_VM_PAGE_MD);
	eval 'sub VM_MDPAGE_INIT {
	    local($pg) = @_;
    	    eval q( &do { ($pg)-> ($mdpage->{pvent}->{pv_next}) =  &NULL; ($pg)-> ($mdpage->{pvent}->{pv_pmap}) =  &NULL; ($pg)-> ($mdpage->{pvent}->{pv_va}) = 0; ($pg)-> ($mdpage->{pvent}->{pv_ptste}) =  &NULL; ($pg)-> ($mdpage->{pvent}->{pv_ptpmap}) =  &NULL; ($pg)-> ($mdpage->{pvent}->{pv_flags}) = 0; }  &while (0));
	}' unless defined(&VM_MDPAGE_INIT);
    }
}
1;
