require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&HEADER_BN_H)) {
    eval 'sub HEADER_BN_H () {1;}' unless defined(&HEADER_BN_H);
    require 'openssl/e_os2.ph';
    unless(defined(&OPENSSL_NO_FP_API)) {
	require 'stdio.ph';
    }
    if(defined(&__cplusplus)) {
    }
    if(defined(&OPENSSL_SYS_VMS)) {
	undef(&BN_LLONG) if defined(&BN_LLONG);
    }
    eval 'sub BN_MUL_COMBA () {1;}' unless defined(&BN_MUL_COMBA);
    eval 'sub BN_SQR_COMBA () {1;}' unless defined(&BN_SQR_COMBA);
    eval 'sub BN_RECURSION () {1;}' unless defined(&BN_RECURSION);
    if(defined( &OPENSSL_SYS_MSDOS) || defined( &OPENSSL_SYS_WINDOWS) || defined( &OPENSSL_SYS_WIN32) || defined( &linux)) {
	unless(defined(&BN_DIV2W)) {
	    eval 'sub BN_DIV2W () {1;}' unless defined(&BN_DIV2W);
	}
    }
    if(defined(&SIXTY_FOUR_BIT_LONG)) {
	eval 'sub BN_ULLONG () {\'unsigned long long\';}' unless defined(&BN_ULLONG);
	eval 'sub BN_ULONG () {\'unsigned long\';}' unless defined(&BN_ULONG);
	eval 'sub BN_LONG () {\'long\';}' unless defined(&BN_LONG);
	eval 'sub BN_BITS () {128;}' unless defined(&BN_BITS);
	eval 'sub BN_BYTES () {8;}' unless defined(&BN_BYTES);
	eval 'sub BN_BITS2 () {64;}' unless defined(&BN_BITS2);
	eval 'sub BN_BITS4 () {32;}' unless defined(&BN_BITS4);
	eval 'sub BN_MASK () {(3.40282366920938e+38);}' unless defined(&BN_MASK);
	eval 'sub BN_MASK2 () {(1.84467440737096e+19);}' unless defined(&BN_MASK2);
	eval 'sub BN_MASK2l () {(0xffffffff);}' unless defined(&BN_MASK2l);
	eval 'sub BN_MASK2h () {(1.84467440694146e+19);}' unless defined(&BN_MASK2h);
	eval 'sub BN_MASK2h1 () {(1.84467440715621e+19);}' unless defined(&BN_MASK2h1);
	eval 'sub BN_TBIT () {(9.22337203685478e+18);}' unless defined(&BN_TBIT);
	eval 'sub BN_DEC_CONV () {(10000000000000000000);}' unless defined(&BN_DEC_CONV);
	eval 'sub BN_DEC_FMT1 () {"%lu";}' unless defined(&BN_DEC_FMT1);
	eval 'sub BN_DEC_FMT2 () {"%019lu";}' unless defined(&BN_DEC_FMT2);
	eval 'sub BN_DEC_NUM () {19;}' unless defined(&BN_DEC_NUM);
    }
    if(defined(&SIXTY_FOUR_BIT)) {
	undef(&BN_LLONG) if defined(&BN_LLONG);
	undef(&BN_ULLONG) if defined(&BN_ULLONG);
	eval 'sub BN_ULONG () {\'unsigned long long\';}' unless defined(&BN_ULONG);
	eval 'sub BN_LONG () {\'long long\';}' unless defined(&BN_LONG);
	eval 'sub BN_BITS () {128;}' unless defined(&BN_BITS);
	eval 'sub BN_BYTES () {8;}' unless defined(&BN_BYTES);
	eval 'sub BN_BITS2 () {64;}' unless defined(&BN_BITS2);
	eval 'sub BN_BITS4 () {32;}' unless defined(&BN_BITS4);
	eval 'sub BN_MASK2 () {(1.84467440737096e+19);}' unless defined(&BN_MASK2);
	eval 'sub BN_MASK2l () {(0xffffffff);}' unless defined(&BN_MASK2l);
	eval 'sub BN_MASK2h () {(1.84467440694146e+19);}' unless defined(&BN_MASK2h);
	eval 'sub BN_MASK2h1 () {(1.84467440715621e+19);}' unless defined(&BN_MASK2h1);
	eval 'sub BN_TBIT () {(9.22337203685478e+18);}' unless defined(&BN_TBIT);
	eval 'sub BN_DEC_CONV () {(10000000000000000000);}' unless defined(&BN_DEC_CONV);
	eval 'sub BN_DEC_FMT1 () {"%llu";}' unless defined(&BN_DEC_FMT1);
	eval 'sub BN_DEC_FMT2 () {"%019llu";}' unless defined(&BN_DEC_FMT2);
	eval 'sub BN_DEC_NUM () {19;}' unless defined(&BN_DEC_NUM);
    }
    if(defined(&THIRTY_TWO_BIT)) {
	if(defined( &OPENSSL_SYS_WIN32)  && !defined( &__GNUC__)) {
	    eval 'sub BN_ULLONG () {\'unsigned _int64\';}' unless defined(&BN_ULLONG);
	} else {
	    eval 'sub BN_ULLONG () {\'unsigned long long\';}' unless defined(&BN_ULLONG);
	}
	eval 'sub BN_ULONG () {\'unsigned long\';}' unless defined(&BN_ULONG);
	eval 'sub BN_LONG () {\'long\';}' unless defined(&BN_LONG);
	eval 'sub BN_BITS () {64;}' unless defined(&BN_BITS);
	eval 'sub BN_BYTES () {4;}' unless defined(&BN_BYTES);
	eval 'sub BN_BITS2 () {32;}' unless defined(&BN_BITS2);
	eval 'sub BN_BITS4 () {16;}' unless defined(&BN_BITS4);
	if(defined(&OPENSSL_SYS_WIN32)) {
	    eval 'sub BN_MASK () {(1.84467440737096e+19);}' unless defined(&BN_MASK);
	} else {
	    eval 'sub BN_MASK () {(1.84467440737096e+19);}' unless defined(&BN_MASK);
	}
	eval 'sub BN_MASK2 () {(0xffffffff);}' unless defined(&BN_MASK2);
	eval 'sub BN_MASK2l () {(0xffff);}' unless defined(&BN_MASK2l);
	eval 'sub BN_MASK2h1 () {(0xffff8000);}' unless defined(&BN_MASK2h1);
	eval 'sub BN_MASK2h () {(0xffff0000);}' unless defined(&BN_MASK2h);
	eval 'sub BN_TBIT () {(0x80000000);}' unless defined(&BN_TBIT);
	eval 'sub BN_DEC_CONV () {(1000000000);}' unless defined(&BN_DEC_CONV);
	eval 'sub BN_DEC_FMT1 () {"%lu";}' unless defined(&BN_DEC_FMT1);
	eval 'sub BN_DEC_FMT2 () {"%09lu";}' unless defined(&BN_DEC_FMT2);
	eval 'sub BN_DEC_NUM () {9;}' unless defined(&BN_DEC_NUM);
    }
    if(defined(&SIXTEEN_BIT)) {
	unless(defined(&BN_DIV2W)) {
	    eval 'sub BN_DIV2W () {1;}' unless defined(&BN_DIV2W);
	}
	eval 'sub BN_ULLONG () {\'unsigned long\';}' unless defined(&BN_ULLONG);
	eval 'sub BN_ULONG () {\'unsigned short\';}' unless defined(&BN_ULONG);
	eval 'sub BN_LONG () {\'short\';}' unless defined(&BN_LONG);
	eval 'sub BN_BITS () {32;}' unless defined(&BN_BITS);
	eval 'sub BN_BYTES () {2;}' unless defined(&BN_BYTES);
	eval 'sub BN_BITS2 () {16;}' unless defined(&BN_BITS2);
	eval 'sub BN_BITS4 () {8;}' unless defined(&BN_BITS4);
	eval 'sub BN_MASK () {(0xffffffff);}' unless defined(&BN_MASK);
	eval 'sub BN_MASK2 () {(0xffff);}' unless defined(&BN_MASK2);
	eval 'sub BN_MASK2l () {(0xff);}' unless defined(&BN_MASK2l);
	eval 'sub BN_MASK2h1 () {(0xff80);}' unless defined(&BN_MASK2h1);
	eval 'sub BN_MASK2h () {(0xff00);}' unless defined(&BN_MASK2h);
	eval 'sub BN_TBIT () {(0x8000);}' unless defined(&BN_TBIT);
	eval 'sub BN_DEC_CONV () {(100000);}' unless defined(&BN_DEC_CONV);
	eval 'sub BN_DEC_FMT1 () {"%u";}' unless defined(&BN_DEC_FMT1);
	eval 'sub BN_DEC_FMT2 () {"%05u";}' unless defined(&BN_DEC_FMT2);
	eval 'sub BN_DEC_NUM () {5;}' unless defined(&BN_DEC_NUM);
    }
    if(defined(&EIGHT_BIT)) {
	unless(defined(&BN_DIV2W)) {
	    eval 'sub BN_DIV2W () {1;}' unless defined(&BN_DIV2W);
	}
	eval 'sub BN_ULLONG () {\'unsigned short\';}' unless defined(&BN_ULLONG);
	eval 'sub BN_ULONG () {\'unsigned char\';}' unless defined(&BN_ULONG);
	eval 'sub BN_LONG () {\'char\';}' unless defined(&BN_LONG);
	eval 'sub BN_BITS () {16;}' unless defined(&BN_BITS);
	eval 'sub BN_BYTES () {1;}' unless defined(&BN_BYTES);
	eval 'sub BN_BITS2 () {8;}' unless defined(&BN_BITS2);
	eval 'sub BN_BITS4 () {4;}' unless defined(&BN_BITS4);
	eval 'sub BN_MASK () {(0xffff);}' unless defined(&BN_MASK);
	eval 'sub BN_MASK2 () {(0xff);}' unless defined(&BN_MASK2);
	eval 'sub BN_MASK2l () {(0xf);}' unless defined(&BN_MASK2l);
	eval 'sub BN_MASK2h1 () {(0xf8);}' unless defined(&BN_MASK2h1);
	eval 'sub BN_MASK2h () {(0xf0);}' unless defined(&BN_MASK2h);
	eval 'sub BN_TBIT () {(0x80);}' unless defined(&BN_TBIT);
	eval 'sub BN_DEC_CONV () {(100);}' unless defined(&BN_DEC_CONV);
	eval 'sub BN_DEC_FMT1 () {"%u";}' unless defined(&BN_DEC_FMT1);
	eval 'sub BN_DEC_FMT2 () {"%02u";}' unless defined(&BN_DEC_FMT2);
	eval 'sub BN_DEC_NUM () {2;}' unless defined(&BN_DEC_NUM);
    }
    eval 'sub BN_DEFAULT_BITS () {1280;}' unless defined(&BN_DEFAULT_BITS);
    if(defined(&BIGNUM)) {
	undef(&BIGNUM) if defined(&BIGNUM);
    }
    eval 'sub BN_FLG_MALLOCED () {0x1;}' unless defined(&BN_FLG_MALLOCED);
    eval 'sub BN_FLG_STATIC_DATA () {0x2;}' unless defined(&BN_FLG_STATIC_DATA);
    eval 'sub BN_FLG_FREE () {0x8000;}' unless defined(&BN_FLG_FREE);
    eval 'sub BN_set_flags {
        local($b,$n) = @_;
	    eval q((($b)-> &flags|=($n)));
    }' unless defined(&BN_set_flags);
    eval 'sub BN_get_flags {
        local($b,$n) = @_;
	    eval q((($b)-> &flags($n)));
    }' unless defined(&BN_get_flags);
    eval 'sub BN_prime_checks () {0;}' unless defined(&BN_prime_checks);
    eval 'sub BN_prime_checks_for_size {
        local($b) = @_;
	    eval q((($b) >= 1300? 2: ($b) >= 850? 3: ($b) >= 650? 4: ($b) >= 550? 5: ($b) >= 450? 6: ($b) >= 400? 7: ($b) >= 350? 8: ($b) >= 300? 9: ($b) >= 250? 12: ($b) >= 200? 15: ($b) >= 150? 18: 27));
    }' unless defined(&BN_prime_checks_for_size);
    eval 'sub BN_num_bytes {
        local($a) = @_;
	    eval q((( &BN_num_bits($a)+7)/8));
    }' unless defined(&BN_num_bytes);
    eval 'sub BN_abs_is_word {
        local($a,$w) = @_;
	    eval q(((($a)-> &top == 1)  && (($a)-> $d[0] == ( &BN_ULONG)($w))));
    }' unless defined(&BN_abs_is_word);
    eval 'sub BN_is_zero {
        local($a) = @_;
	    eval q(((($a)-> &top == 0) ||  &BN_abs_is_word($a,0)));
    }' unless defined(&BN_is_zero);
    eval 'sub BN_is_one {
        local($a) = @_;
	    eval q(( &BN_abs_is_word(($a),1)  && !($a)-> &neg));
    }' unless defined(&BN_is_one);
    eval 'sub BN_is_word {
        local($a,$w) = @_;
	    eval q((($w) ?  &BN_abs_is_word(($a),($w))  && !($a)-> &neg :  &BN_is_zero(($a))));
    }' unless defined(&BN_is_word);
    eval 'sub BN_is_odd {
        local($a) = @_;
	    eval q(((($a)-> &top > 0)  && (($a)-> $d[0] & 1)));
    }' unless defined(&BN_is_odd);
    eval 'sub BN_one {
        local($a) = @_;
	    eval q(( &BN_set_word(($a),1)));
    }' unless defined(&BN_one);
    eval 'sub BN_zero {
        local($a) = @_;
	    eval q(( &BN_set_word(($a),0)));
    }' unless defined(&BN_zero);
    eval 'sub BN_mod {
        local($rem,$m,$d,$ctx) = @_;
	    eval q( &BN_div( &NULL,($rem),($m),($d),($ctx)));
    }' unless defined(&BN_mod);
    unless(defined(&OPENSSL_NO_FP_API)) {
    }
    if(defined(&HEADER_BIO_H)) {
    } else {
    }
    eval 'sub BN_to_montgomery {
        local($r,$a,$mont,$ctx) = @_;
	    eval q( &BN_mod_mul_montgomery( ($r),($a),(($mont)-> &RR),($mont),($ctx)));
    }' unless defined(&BN_to_montgomery);
    eval 'sub bn_expand {
        local($a,$bits) = @_;
	    eval q((((((($bits+ &BN_BITS2-1))/ &BN_BITS2)) <= ($a)-> &dmax)? ($a): &bn_expand2(($a),($bits)/ &BN_BITS2+1)));
    }' unless defined(&bn_expand);
    eval 'sub bn_wexpand {
        local($a,$words) = @_;
	    eval q(((($words) <= ($a)-> &dmax)?($a): &bn_expand2(($a),($words))));
    }' unless defined(&bn_wexpand);
    eval 'sub bn_fix_top {
        local($a) = @_;
	    eval q({  &BN_ULONG * &ftl;  &if (($a)-> &top > 0) {  &for ( &ftl= (($a)-> $d[($a)-> &top-1]); ($a)-> &top > 0; ($a)-> &top--)  &if (*( &ftl--))  &break; } });
    }' unless defined(&bn_fix_top);
    if(defined(&BN_DEBUG)) {
	eval 'sub bn_print {
	    local($a) = @_;
    	    eval q({ &fprintf( &stderr, $a \\"=\\");  &BN_print_fp( &stderr,$a);  &fprintf( &stderr,\\"\\\\n\\");});
	}' unless defined(&bn_print);
	eval 'sub bn_dump {
	    local($a,$n) = @_;
    	    eval q( &bn_dump1( &stderr,$a,$a,$n););
	}' unless defined(&bn_dump);
    } else {
	eval 'sub bn_print {
	    local($a) = @_;
    	    eval q();
	}' unless defined(&bn_print);
	eval 'sub bn_dump {
	    local($a,$b) = @_;
    	    eval q();
	}' unless defined(&bn_dump);
    }
    eval 'sub BN_F_BN_BLINDING_CONVERT () {100;}' unless defined(&BN_F_BN_BLINDING_CONVERT);
    eval 'sub BN_F_BN_BLINDING_INVERT () {101;}' unless defined(&BN_F_BN_BLINDING_INVERT);
    eval 'sub BN_F_BN_BLINDING_NEW () {102;}' unless defined(&BN_F_BN_BLINDING_NEW);
    eval 'sub BN_F_BN_BLINDING_UPDATE () {103;}' unless defined(&BN_F_BN_BLINDING_UPDATE);
    eval 'sub BN_F_BN_BN2DEC () {104;}' unless defined(&BN_F_BN_BN2DEC);
    eval 'sub BN_F_BN_BN2HEX () {105;}' unless defined(&BN_F_BN_BN2HEX);
    eval 'sub BN_F_BN_CTX_GET () {116;}' unless defined(&BN_F_BN_CTX_GET);
    eval 'sub BN_F_BN_CTX_NEW () {106;}' unless defined(&BN_F_BN_CTX_NEW);
    eval 'sub BN_F_BN_DIV () {107;}' unless defined(&BN_F_BN_DIV);
    eval 'sub BN_F_BN_EXPAND2 () {108;}' unless defined(&BN_F_BN_EXPAND2);
    eval 'sub BN_F_BN_EXPAND_INTERNAL () {120;}' unless defined(&BN_F_BN_EXPAND_INTERNAL);
    eval 'sub BN_F_BN_MOD_EXP2_MONT () {118;}' unless defined(&BN_F_BN_MOD_EXP2_MONT);
    eval 'sub BN_F_BN_MOD_EXP_MONT () {109;}' unless defined(&BN_F_BN_MOD_EXP_MONT);
    eval 'sub BN_F_BN_MOD_EXP_MONT_WORD () {117;}' unless defined(&BN_F_BN_MOD_EXP_MONT_WORD);
    eval 'sub BN_F_BN_MOD_INVERSE () {110;}' unless defined(&BN_F_BN_MOD_INVERSE);
    eval 'sub BN_F_BN_MOD_LSHIFT_QUICK () {119;}' unless defined(&BN_F_BN_MOD_LSHIFT_QUICK);
    eval 'sub BN_F_BN_MOD_MUL_RECIPROCAL () {111;}' unless defined(&BN_F_BN_MOD_MUL_RECIPROCAL);
    eval 'sub BN_F_BN_MOD_SQRT () {121;}' unless defined(&BN_F_BN_MOD_SQRT);
    eval 'sub BN_F_BN_MPI2BN () {112;}' unless defined(&BN_F_BN_MPI2BN);
    eval 'sub BN_F_BN_NEW () {113;}' unless defined(&BN_F_BN_NEW);
    eval 'sub BN_F_BN_RAND () {114;}' unless defined(&BN_F_BN_RAND);
    eval 'sub BN_F_BN_RAND_RANGE () {122;}' unless defined(&BN_F_BN_RAND_RANGE);
    eval 'sub BN_F_BN_USUB () {115;}' unless defined(&BN_F_BN_USUB);
    eval 'sub BN_R_ARG2_LT_ARG3 () {100;}' unless defined(&BN_R_ARG2_LT_ARG3);
    eval 'sub BN_R_BAD_RECIPROCAL () {101;}' unless defined(&BN_R_BAD_RECIPROCAL);
    eval 'sub BN_R_BIGNUM_TOO_LONG () {114;}' unless defined(&BN_R_BIGNUM_TOO_LONG);
    eval 'sub BN_R_CALLED_WITH_EVEN_MODULUS () {102;}' unless defined(&BN_R_CALLED_WITH_EVEN_MODULUS);
    eval 'sub BN_R_DIV_BY_ZERO () {103;}' unless defined(&BN_R_DIV_BY_ZERO);
    eval 'sub BN_R_ENCODING_ERROR () {104;}' unless defined(&BN_R_ENCODING_ERROR);
    eval 'sub BN_R_EXPAND_ON_STATIC_BIGNUM_DATA () {105;}' unless defined(&BN_R_EXPAND_ON_STATIC_BIGNUM_DATA);
    eval 'sub BN_R_INPUT_NOT_REDUCED () {110;}' unless defined(&BN_R_INPUT_NOT_REDUCED);
    eval 'sub BN_R_INVALID_LENGTH () {106;}' unless defined(&BN_R_INVALID_LENGTH);
    eval 'sub BN_R_INVALID_RANGE () {115;}' unless defined(&BN_R_INVALID_RANGE);
    eval 'sub BN_R_NOT_A_SQUARE () {111;}' unless defined(&BN_R_NOT_A_SQUARE);
    eval 'sub BN_R_NOT_INITIALIZED () {107;}' unless defined(&BN_R_NOT_INITIALIZED);
    eval 'sub BN_R_NO_INVERSE () {108;}' unless defined(&BN_R_NO_INVERSE);
    eval 'sub BN_R_P_IS_NOT_PRIME () {112;}' unless defined(&BN_R_P_IS_NOT_PRIME);
    eval 'sub BN_R_TOO_MANY_ITERATIONS () {113;}' unless defined(&BN_R_TOO_MANY_ITERATIONS);
    eval 'sub BN_R_TOO_MANY_TEMPORARY_VARIABLES () {109;}' unless defined(&BN_R_TOO_MANY_TEMPORARY_VARIABLES);
    if(defined(&__cplusplus)) {
    }
}
1;
