require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_VM_PARAM_)) {
    eval 'sub _VM_PARAM_ () {1;}' unless defined(&_VM_PARAM_);
    require 'machine/vmparam.ph';
    unless(defined(&TRUE)) {
	eval 'sub TRUE () {1;}' unless defined(&TRUE);
    }
    unless(defined(&FALSE)) {
	eval 'sub FALSE () {0;}' unless defined(&FALSE);
    }
    eval 'sub DEFAULT_PAGE_SIZE () {4096;}' unless defined(&DEFAULT_PAGE_SIZE);
    if(defined( &_KERNEL)  && !defined( &PAGE_SIZE)) {
	eval 'sub PAGE_SIZE () { ($uvmexp->{pagesize});}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () { ($uvmexp->{pagemask});}' unless defined(&PAGE_MASK);
	eval 'sub PAGE_SHIFT () { ($uvmexp->{pageshift});}' unless defined(&PAGE_SHIFT);
    }
    eval 'sub VM_METER () {1;}' unless defined(&VM_METER);
    eval 'sub VM_LOADAVG () {2;}' unless defined(&VM_LOADAVG);
    eval 'sub VM_PSSTRINGS () {3;}' unless defined(&VM_PSSTRINGS);
    eval 'sub VM_UVMEXP () {4;}' unless defined(&VM_UVMEXP);
    eval 'sub VM_SWAPENCRYPT () {5;}' unless defined(&VM_SWAPENCRYPT);
    eval 'sub VM_NKMEMPAGES () {6;}' unless defined(&VM_NKMEMPAGES);
    eval 'sub VM_ANONMIN () {7;}' unless defined(&VM_ANONMIN);
    eval 'sub VM_VTEXTMIN () {8;}' unless defined(&VM_VTEXTMIN);
    eval 'sub VM_VNODEMIN () {9;}' unless defined(&VM_VNODEMIN);
    eval 'sub VM_MAXSLP () {10;}' unless defined(&VM_MAXSLP);
    eval 'sub VM_USPACE () {11;}' unless defined(&VM_USPACE);
    eval 'sub VM_MAXID () {12;}' unless defined(&VM_MAXID);
    eval 'sub CTL_VM_NAMES () {{ { 0, 0}, { "vmmeter",  &CTLTYPE_STRUCT }, { "loadavg",  &CTLTYPE_STRUCT }, { "psstrings",  &CTLTYPE_STRUCT }, { "uvmexp",  &CTLTYPE_STRUCT }, { "swapencrypt",  &CTLTYPE_NODE }, { "nkmempages",  &CTLTYPE_INT }, { "anonmin",  &CTLTYPE_INT }, { "vtextmin",  &CTLTYPE_INT }, { "vnodemin",  &CTLTYPE_INT }, { "maxslp",  &CTLTYPE_INT }, { "uspace",  &CTLTYPE_INT }, };}' unless defined(&CTL_VM_NAMES);
    eval 'sub SWAPSKIPBYTES () {8192;}' unless defined(&SWAPSKIPBYTES);
    eval 'sub KERN_SUCCESS () {0;}' unless defined(&KERN_SUCCESS);
    eval 'sub KERN_INVALID_ADDRESS () { &EFAULT;}' unless defined(&KERN_INVALID_ADDRESS);
    eval 'sub KERN_PROTECTION_FAILURE () { &EACCES;}' unless defined(&KERN_PROTECTION_FAILURE);
    eval 'sub KERN_NO_SPACE () { &ENOMEM;}' unless defined(&KERN_NO_SPACE);
    eval 'sub KERN_INVALID_ARGUMENT () { &EINVAL;}' unless defined(&KERN_INVALID_ARGUMENT);
    eval 'sub KERN_FAILURE () { &EFAULT;}' unless defined(&KERN_FAILURE);
    eval 'sub KERN_RESOURCE_SHORTAGE () { &ENOMEM;}' unless defined(&KERN_RESOURCE_SHORTAGE);
    eval 'sub KERN_PAGES_LOCKED () {9;}' unless defined(&KERN_PAGES_LOCKED);
    unless(defined(&ASSEMBLER)) {
	if(defined(&_KERNEL)) {
	    eval 'sub atop {
	        local($x) = @_;
    		eval q(((( &paddr_t)($x)) >>  &PAGE_SHIFT));
	    }' unless defined(&atop);
	    eval 'sub ptoa {
	        local($x) = @_;
    		eval q((( &vaddr_t)(( &vaddr_t)($x) <<  &PAGE_SHIFT)));
	    }' unless defined(&ptoa);
	    eval 'sub round_page {
	        local($x) = @_;
    		eval q(((($x) +  &PAGE_MASK) & ~ &PAGE_MASK));
	    }' unless defined(&round_page);
	    eval 'sub trunc_page {
	        local($x) = @_;
    		eval q((($x) & ~ &PAGE_MASK));
	    }' unless defined(&trunc_page);
	    if(defined(&UBC)) {
	    }
	} else {
	    eval 'sub round_page {
	        local($x) = @_;
    		eval q((((( &vaddr_t)($x) + ( &vm_page_size - 1)) /  &vm_page_size) *  &vm_page_size));
	    }' unless defined(&round_page);
	    eval 'sub trunc_page {
	        local($x) = @_;
    		eval q((((( &vaddr_t)($x)) /  &vm_page_size) *  &vm_page_size));
	    }' unless defined(&trunc_page);
	}
    }
}
1;
