require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&RAL_TX_RING_COUNT)) {
    sub RAL_TX_RING_COUNT () {	48;}
}
unless(defined(&RAL_ATIM_RING_COUNT)) {
    sub RAL_ATIM_RING_COUNT () {	4;}
}
unless(defined(&RAL_PRIO_RING_COUNT)) {
    sub RAL_PRIO_RING_COUNT () {	16;}
}
unless(defined(&RAL_BEACON_RING_COUNT)) {
    sub RAL_BEACON_RING_COUNT () {	1;}
}
unless(defined(&RAL_RX_RING_COUNT)) {
    sub RAL_RX_RING_COUNT () {	32;}
}
unless(defined(&RAL_TX_DESC_SIZE)) {
    sub RAL_TX_DESC_SIZE () {	($sizeof{'struct ral_tx_desc'});}
}
unless(defined(&RAL_RX_DESC_SIZE)) {
    sub RAL_RX_DESC_SIZE () {	($sizeof{'struct ral_rx_desc'});}
}
unless(defined(&RAL_MAX_SCATTER)) {
    sub RAL_MAX_SCATTER () {	1;}
}
unless(defined(&RAL_CSR0)) {
    sub RAL_CSR0 () {	0x;}
}
unless(defined(&RAL_CSR1)) {
    sub RAL_CSR1 () {	0x4;}
}
unless(defined(&RAL_CSR3)) {
    sub RAL_CSR3 () {	0xc;}
}
unless(defined(&RAL_CSR4)) {
    sub RAL_CSR4 () {	0x10;}
}
unless(defined(&RAL_CSR5)) {
    sub RAL_CSR5 () {	0x14;}
}
unless(defined(&RAL_CSR6)) {
    sub RAL_CSR6 () {	0x18;}
}
unless(defined(&RAL_CSR7)) {
    sub RAL_CSR7 () {	0x1c;}
}
unless(defined(&RAL_CSR8)) {
    sub RAL_CSR8 () {	0x20;}
}
unless(defined(&RAL_CSR9)) {
    sub RAL_CSR9 () {	0x24;}
}
unless(defined(&RAL_SECCSR0)) {
    sub RAL_SECCSR0 () {	0x28;}
}
unless(defined(&RAL_CSR11)) {
    sub RAL_CSR11 () {	0x2c;}
}
unless(defined(&RAL_CSR12)) {
    sub RAL_CSR12 () {	0x30;}
}
unless(defined(&RAL_CSR13)) {
    sub RAL_CSR13 () {	0x34;}
}
unless(defined(&RAL_CSR14)) {
    sub RAL_CSR14 () {	0x38;}
}
unless(defined(&RAL_CSR15)) {
    sub RAL_CSR15 () {	0x3c;}
}
unless(defined(&RAL_CSR16)) {
    sub RAL_CSR16 () {	0x40;}
}
unless(defined(&RAL_CSR17)) {
    sub RAL_CSR17 () {	0x44;}
}
unless(defined(&RAL_CSR18)) {
    sub RAL_CSR18 () {	0x48;}
}
unless(defined(&RAL_CSR19)) {
    sub RAL_CSR19 () {	0x4c;}
}
unless(defined(&RAL_CSR20)) {
    sub RAL_CSR20 () {	0x50;}
}
unless(defined(&RAL_CSR21)) {
    sub RAL_CSR21 () {	0x54;}
}
unless(defined(&RAL_CSR22)) {
    sub RAL_CSR22 () {	0x58;}
}
unless(defined(&RAL_TXCSR0)) {
    sub RAL_TXCSR0 () {	0x60;}
}
unless(defined(&RAL_TXCSR1)) {
    sub RAL_TXCSR1 () {	0x64;}
}
unless(defined(&RAL_TXCSR2)) {
    sub RAL_TXCSR2 () {	0x68;}
}
unless(defined(&RAL_TXCSR3)) {
    sub RAL_TXCSR3 () {	0x6c;}
}
unless(defined(&RAL_TXCSR4)) {
    sub RAL_TXCSR4 () {	0x70;}
}
unless(defined(&RAL_TXCSR5)) {
    sub RAL_TXCSR5 () {	0x74;}
}
unless(defined(&RAL_TXCSR6)) {
    sub RAL_TXCSR6 () {	0x78;}
}
unless(defined(&RAL_TXCSR7)) {
    sub RAL_TXCSR7 () {	0x7c;}
}
unless(defined(&RAL_RXCSR0)) {
    sub RAL_RXCSR0 () {	0x80;}
}
unless(defined(&RAL_RXCSR1)) {
    sub RAL_RXCSR1 () {	0x84;}
}
unless(defined(&RAL_RXCSR2)) {
    sub RAL_RXCSR2 () {	0x88;}
}
unless(defined(&RAL_PCICSR)) {
    sub RAL_PCICSR () {	0x8c;}
}
unless(defined(&RAL_RXCSR3)) {
    sub RAL_RXCSR3 () {	0x90;}
}
unless(defined(&RAL_TXCSR9)) {
    sub RAL_TXCSR9 () {	0x94;}
}
unless(defined(&RAL_ARSP_PLCP_0)) {
    sub RAL_ARSP_PLCP_0 () {	0x98;}
}
unless(defined(&RAL_ARSP_PLCP_1)) {
    sub RAL_ARSP_PLCP_1 () {	0x9c;}
}
unless(defined(&RAL_CNT0)) {
    sub RAL_CNT0 () {	0xa0;}
}
unless(defined(&RAL_CNT1)) {
    sub RAL_CNT1 () {	0xac;}
}
unless(defined(&RAL_CNT2)) {
    sub RAL_CNT2 () {	0xb0;}
}
unless(defined(&RAL_CNT3)) {
    sub RAL_CNT3 () {	0xb8;}
}
unless(defined(&RAL_CNT4)) {
    sub RAL_CNT4 () {	0xbc;}
}
unless(defined(&RAL_CNT5)) {
    sub RAL_CNT5 () {	0xc0;}
}
unless(defined(&RAL_PWRCSR0)) {
    sub RAL_PWRCSR0 () {	0xc4;}
}
unless(defined(&RAL_PSCSR0)) {
    sub RAL_PSCSR0 () {	0xc8;}
}
unless(defined(&RAL_PSCSR1)) {
    sub RAL_PSCSR1 () {	0xcc;}
}
unless(defined(&RAL_PSCSR2)) {
    sub RAL_PSCSR2 () {	0xd0;}
}
unless(defined(&RAL_PSCSR3)) {
    sub RAL_PSCSR3 () {	0xd4;}
}
unless(defined(&RAL_PWRCSR1)) {
    sub RAL_PWRCSR1 () {	0xd8;}
}
unless(defined(&RAL_TIMECSR)) {
    sub RAL_TIMECSR () {	0xdc;}
}
unless(defined(&RAL_MACCSR0)) {
    sub RAL_MACCSR0 () {	0xe0;}
}
unless(defined(&RAL_MACCSR1)) {
    sub RAL_MACCSR1 () {	0xe4;}
}
unless(defined(&RAL_RALINKCSR)) {
    sub RAL_RALINKCSR () {	0xe8;}
}
unless(defined(&RAL_BCNCSR)) {
    sub RAL_BCNCSR () {	0xec;}
}
unless(defined(&RAL_BBPCSR)) {
    sub RAL_BBPCSR () {	0xf0;}
}
unless(defined(&RAL_RFCSR)) {
    sub RAL_RFCSR () {	0xf4;}
}
unless(defined(&RAL_LEDCSR)) {
    sub RAL_LEDCSR () {	0xf8;}
}
unless(defined(&RAL_SECCSR3)) {
    sub RAL_SECCSR3 () {	0xfc;}
}
unless(defined(&RAL_DMACSR0)) {
    sub RAL_DMACSR0 () {	0x100;}
}
unless(defined(&RAL_DMACSR1)) {
    sub RAL_DMACSR1 () {	0x104;}
}
unless(defined(&RAL_DMACSR2)) {
    sub RAL_DMACSR2 () {	0x104;}
}
unless(defined(&RAL_DMACSR3)) {
    sub RAL_DMACSR3 () {	0x104;}
}
unless(defined(&RAL_TXACKCSR0)) {
    sub RAL_TXACKCSR0 () {	0x110;}
}
unless(defined(&RAL_GPIOCSR)) {
    sub RAL_GPIOCSR () {	0x120;}
}
unless(defined(&RAL_BBBPPCSR)) {
    sub RAL_BBBPPCSR () {	0x124;}
}
unless(defined(&RAL_FIFOCSR0)) {
    sub RAL_FIFOCSR0 () {	0x128;}
}
unless(defined(&RAL_FIFOCSR1)) {
    sub RAL_FIFOCSR1 () {	0x12c;}
}
unless(defined(&RAL_BCNOCSR)) {
    sub RAL_BCNOCSR () {	0x130;}
}
unless(defined(&RAL_RLPWCSR)) {
    sub RAL_RLPWCSR () {	0x134;}
}
unless(defined(&RAL_TESTCSR)) {
    sub RAL_TESTCSR () {	0x138;}
}
unless(defined(&RAL_PLCP1MCSR)) {
    sub RAL_PLCP1MCSR () {	0x13c;}
}
unless(defined(&RAL_PLCP2MCSR)) {
    sub RAL_PLCP2MCSR () {	0x140;}
}
unless(defined(&RAL_PLCP5p5MCSR)) {
    sub RAL_PLCP5p5MCSR () {	0x144;}
}
unless(defined(&RAL_PLCP11MCSR)) {
    sub RAL_PLCP11MCSR () {	0x148;}
}
unless(defined(&RAL_ACKPCTCSR)) {
    sub RAL_ACKPCTCSR () {	0x14c;}
}
unless(defined(&RAL_ARTCSR1)) {
    sub RAL_ARTCSR1 () {	0x150;}
}
unless(defined(&RAL_ARTCSR2)) {
    sub RAL_ARTCSR2 () {	0x154;}
}
unless(defined(&RAL_SECCSR1)) {
    sub RAL_SECCSR1 () {	0x158;}
}
unless(defined(&RAL_BBPCSR1)) {
    sub RAL_BBPCSR1 () {	0x15c;}
}
unless(defined(&RAL_DISABLE_RX)) {
    sub RAL_DISABLE_RX () {	(1<< 0);}
}
unless(defined(&RAL_DROP_CRC_ERROR)) {
    sub RAL_DROP_CRC_ERROR () {	(1<< 1);}
}
unless(defined(&RAL_DROP_PHY_ERROR)) {
    sub RAL_DROP_PHY_ERROR () {	(1<< 2);}
}
unless(defined(&RAL_DROP_CTL)) {
    sub RAL_DROP_CTL () {	(1<< 3);}
}
unless(defined(&RAL_DROP_NOT_TO_ME)) {
    sub RAL_DROP_NOT_TO_ME () {	(1<< 4);}
}
unless(defined(&RAL_DROP_TODS)) {
    sub RAL_DROP_TODS () {	(1<< 5);}
}
unless(defined(&RAL_DROP_VERSION_ERROR)) {
    sub RAL_DROP_VERSION_ERROR () {	(1<< 6);}
}
unless(defined(&RAL_RESET_ASIC)) {
    sub RAL_RESET_ASIC () {	(1<< 0);}
}
unless(defined(&RAL_RESET_BBP)) {
    sub RAL_RESET_BBP () {	(1<< 1);}
}
unless(defined(&RAL_HOST_READY)) {
    sub RAL_HOST_READY () {	(1<< 2);}
}
unless(defined(&RAL_ENABLE_TSF)) {
    sub RAL_ENABLE_TSF () {	(1<< 0);}
}
unless(defined(&RAL_ENABLE_TSF_SYNC)) {
    sub RAL_ENABLE_TSF_SYNC {
	local($x) = @_;
	eval q(((($x) & 0x3) << 1));
    }
}
unless(defined(&RAL_ENABLE_TBCN)) {
    sub RAL_ENABLE_TBCN () {	(1<< 3);}
}
unless(defined(&RAL_ENABLE_BEACON_GENERATOR)) {
    sub RAL_ENABLE_BEACON_GENERATOR () {	(1<< 6);}
}
unless(defined(&RAL_EEPROM_C)) {
    sub RAL_EEPROM_C () {	(1<< 1);}
}
unless(defined(&RAL_EEPROM_S)) {
    sub RAL_EEPROM_S () {	(1<< 2);}
}
unless(defined(&RAL_EEPROM_D)) {
    sub RAL_EEPROM_D () {	(1<< 3);}
}
unless(defined(&RAL_EEPROM_Q)) {
    sub RAL_EEPROM_Q () {	(1<< 4);}
}
unless(defined(&RAL_EEPROM_93C46)) {
    sub RAL_EEPROM_93C46 () {	(1<< 5);}
}
unless(defined(&RAL_EEPROM_SHIFT_D)) {
    sub RAL_EEPROM_SHIFT_D () {	3;}
}
unless(defined(&RAL_EEPROM_SHIFT_Q)) {
    sub RAL_EEPROM_SHIFT_Q () {	4;}
}
unless(defined(&RAL_KICK_TX)) {
    sub RAL_KICK_TX () {	(1<< 0);}
}
unless(defined(&RAL_KICK_ATIM)) {
    sub RAL_KICK_ATIM () {	(1<< 1);}
}
unless(defined(&RAL_KICK_PRIO)) {
    sub RAL_KICK_PRIO () {	(1<< 2);}
}
unless(defined(&RAL_ABORT_TX)) {
    sub RAL_ABORT_TX () {	(1<< 3);}
}
unless(defined(&RAL_KICK_DECRYPT)) {
    sub RAL_KICK_DECRYPT () {	(1<< 0);}
}
unless(defined(&RAL_KICK_ENCRYPT)) {
    sub RAL_KICK_ENCRYPT () {	(1<< 0);}
}
unless(defined(&RAL_BEACON_EXPIRE)) {
    sub RAL_BEACON_EXPIRE () {	0x1;}
}
unless(defined(&RAL_WAKEUP_EXPIRE)) {
    sub RAL_WAKEUP_EXPIRE () {	0x2;}
}
unless(defined(&RAL_ATIM_EXPIRE)) {
    sub RAL_ATIM_EXPIRE () {	0x4;}
}
unless(defined(&RAL_TX_DONE)) {
    sub RAL_TX_DONE () {	0x8;}
}
unless(defined(&RAL_ATIM_DONE)) {
    sub RAL_ATIM_DONE () {	0x10;}
}
unless(defined(&RAL_PRIO_DONE)) {
    sub RAL_PRIO_DONE () {	0x20;}
}
unless(defined(&RAL_RX_DONE)) {
    sub RAL_RX_DONE () {	0x40;}
}
unless(defined(&RAL_DECRYPTION_DONE)) {
    sub RAL_DECRYPTION_DONE () {	0x80;}
}
unless(defined(&RAL_ENCRYPTION_DONE)) {
    sub RAL_ENCRYPTION_DONE () {	0x100;}
}
unless(defined(&RAL_INTR_MASK)) {
    sub RAL_INTR_MASK () {	(~( &RAL_BEACON_EXPIRE |  &RAL_WAKEUP_EXPIRE |  &RAL_TX_DONE |  &RAL_PRIO_DONE |  &RAL_RX_DONE |  &RAL_DECRYPTION_DONE |  &RAL_ENCRYPTION_DONE));}
}
unless(defined(&RAL_TX_BUSY)) {
    sub RAL_TX_BUSY () {	(1<< 0);}
}
unless(defined(&RAL_TX_VALID)) {
    sub RAL_TX_VALID () {	(1<< 1);}
}
unless(defined(&RAL_TX_RESULT_MASK)) {
    sub RAL_TX_RESULT_MASK () {	0x1c;}
}
unless(defined(&RAL_TX_SUCCESS)) {
    sub RAL_TX_SUCCESS () {	(0<< 2);}
}
unless(defined(&RAL_TX_SUCCESS_RETRY)) {
    sub RAL_TX_SUCCESS_RETRY () {	(1<< 2);}
}
unless(defined(&RAL_TX_FAIL_RETRY)) {
    sub RAL_TX_FAIL_RETRY () {	(2<< 2);}
}
unless(defined(&RAL_TX_FAIL_INVALID)) {
    sub RAL_TX_FAIL_INVALID () {	(3<< 2);}
}
unless(defined(&RAL_TX_FAIL_OTHER)) {
    sub RAL_TX_FAIL_OTHER () {	(4<< 2);}
}
unless(defined(&RAL_TX_MORE_FRAG)) {
    sub RAL_TX_MORE_FRAG () {	(1<< 8);}
}
unless(defined(&RAL_TX_ACK)) {
    sub RAL_TX_ACK () {	(1<< 9);}
}
unless(defined(&RAL_TX_TIMESTAMP)) {
    sub RAL_TX_TIMESTAMP () {	(1<< 10);}
}
unless(defined(&RAL_TX_OFDM)) {
    sub RAL_TX_OFDM () {	(1<< 11);}
}
unless(defined(&RAL_TX_CIPHER_BUSY)) {
    sub RAL_TX_CIPHER_BUSY () {	(1<< 12);}
}
unless(defined(&RAL_TX_IFS_MASK)) {
    sub RAL_TX_IFS_MASK () {	0x6000;}
}
unless(defined(&RAL_TX_IFS_BACKOFF)) {
    sub RAL_TX_IFS_BACKOFF () {	(0<< 13);}
}
unless(defined(&RAL_TX_IFS_SIFS)) {
    sub RAL_TX_IFS_SIFS () {	(1<< 13);}
}
unless(defined(&RAL_TX_IFS_NEWBACKOFF)) {
    sub RAL_TX_IFS_NEWBACKOFF () {	(2<< 13);}
}
unless(defined(&RAL_TX_IFS_NONE)) {
    sub RAL_TX_IFS_NONE () {	(3<< 13);}
}
unless(defined(&RAL_TX_LONG_RETRY)) {
    sub RAL_TX_LONG_RETRY () {	(1<< 15);}
}
unless(defined(&RAL_TX_CIPHER_MASK)) {
    sub RAL_TX_CIPHER_MASK () {	0xe0000000;}
}
unless(defined(&RAL_TX_CIPHER_NONE)) {
    sub RAL_TX_CIPHER_NONE () {	(0<< 29);}
}
unless(defined(&RAL_TX_CIPHER_WEP40)) {
    sub RAL_TX_CIPHER_WEP40 () {	(1<< 29);}
}
unless(defined(&RAL_TX_CIPHER_WEP104)) {
    sub RAL_TX_CIPHER_WEP104 () {	(2<< 29);}
}
unless(defined(&RAL_TX_CIPHER_TKIP)) {
    sub RAL_TX_CIPHER_TKIP () {	(3<< 29);}
}
unless(defined(&RAL_TX_CIPHER_AES)) {
    sub RAL_TX_CIPHER_AES () {	(4<< 29);}
}
unless(defined(&RAL_LOGCWMAX)) {
    sub RAL_LOGCWMAX {
	local($x) = @_;
	eval q(((($x) & 0xf) << 12));
    }
}
unless(defined(&RAL_LOGCWMIN)) {
    sub RAL_LOGCWMIN {
	local($x) = @_;
	eval q(((($x) & 0xf) << 8));
    }
}
unless(defined(&RAL_AIFSN)) {
    sub RAL_AIFSN {
	local($x) = @_;
	eval q(((($x) & 0x3) << 6));
    }
}
unless(defined(&RAL_IVOFFSET)) {
    sub RAL_IVOFFSET {
	local($x) = @_;
	eval q(((($x) & 0x3f)));
    }
}
unless(defined(&RAL_PLCP_LENGEXT)) {
    sub RAL_PLCP_LENGEXT () {	0x80;}
}
unless(defined(&RAL_RX_BUSY)) {
    sub RAL_RX_BUSY () {	(1<< 0);}
}
unless(defined(&RAL_RX_CRC_ERROR)) {
    sub RAL_RX_CRC_ERROR () {	(1<< 5);}
}
unless(defined(&RAL_RX_PHY_ERROR)) {
    sub RAL_RX_PHY_ERROR () {	(1<< 7);}
}
unless(defined(&RAL_RX_CIPHER_BUSY)) {
    sub RAL_RX_CIPHER_BUSY () {	(1<< 8);}
}
unless(defined(&RAL_RX_ICV_ERROR)) {
    sub RAL_RX_ICV_ERROR () {	(1<< 9);}
}
unless(defined(&RAL_RX_CIPHER_MASK)) {
    sub RAL_RX_CIPHER_MASK () {	0xe0000000;}
}
unless(defined(&RAL_RX_CIPHER_NONE)) {
    sub RAL_RX_CIPHER_NONE () {	(0<< 29);}
}
unless(defined(&RAL_RX_CIPHER_WEP40)) {
    sub RAL_RX_CIPHER_WEP40 () {	(1<< 29);}
}
unless(defined(&RAL_RX_CIPHER_WEP104)) {
    sub RAL_RX_CIPHER_WEP104 () {	(2<< 29);}
}
unless(defined(&RAL_RX_CIPHER_TKIP)) {
    sub RAL_RX_CIPHER_TKIP () {	(3<< 29);}
}
unless(defined(&RAL_RX_CIPHER_AES)) {
    sub RAL_RX_CIPHER_AES () {	(4<< 29);}
}
unless(defined(&RAL_RF1)) {
    sub RAL_RF1 () {	0;}
}
unless(defined(&RAL_RF2)) {
    sub RAL_RF2 () {	2;}
}
unless(defined(&RAL_RF3)) {
    sub RAL_RF3 () {	1;}
}
unless(defined(&RAL_RF4)) {
    sub RAL_RF4 () {	3;}
}
unless(defined(&RAL_RF1_AUTOTUNE)) {
    sub RAL_RF1_AUTOTUNE () {	0x8000;}
}
unless(defined(&RAL_RF3_AUTOTUNE)) {
    sub RAL_RF3_AUTOTUNE () {	0x40;}
}
unless(defined(&RAL_BBP_BUSY)) {
    sub RAL_BBP_BUSY () {	(1<< 15);}
}
unless(defined(&RAL_BBP_WRITE)) {
    sub RAL_BBP_WRITE () {	(1<< 16);}
}
unless(defined(&RAL_RF_20BIT)) {
    sub RAL_RF_20BIT () {	(20<< 24);}
}
unless(defined(&RAL_RF_BUSY)) {
    sub RAL_RF_BUSY () {	(1<< 31);}
}
unless(defined(&RAL_RF_2522)) {
    sub RAL_RF_2522 () {	0x;}
}
unless(defined(&RAL_RF_2523)) {
    sub RAL_RF_2523 () {	0x1;}
}
unless(defined(&RAL_RF_2524)) {
    sub RAL_RF_2524 () {	0x2;}
}
unless(defined(&RAL_RF_2525)) {
    sub RAL_RF_2525 () {	0x3;}
}
unless(defined(&RAL_RF_2525E)) {
    sub RAL_RF_2525E () {	0x4;}
}
unless(defined(&RAL_RF_2526)) {
    sub RAL_RF_2526 () {	0x5;}
}
unless(defined(&RAL_RF_5222)) {
    sub RAL_RF_5222 () {	0x10;}
}
unless(defined(&RAL_BBP_VERSION)) {
    sub RAL_BBP_VERSION () {	0;}
}
unless(defined(&RAL_BBP_TX)) {
    sub RAL_BBP_TX () {	2;}
}
unless(defined(&RAL_BBP_RX)) {
    sub RAL_BBP_RX () {	14;}
}
unless(defined(&RAL_BBP_ANTA)) {
    sub RAL_BBP_ANTA () {	0x;}
}
unless(defined(&RAL_BBP_DIVERSITY)) {
    sub RAL_BBP_DIVERSITY () {	0x1;}
}
unless(defined(&RAL_BBP_ANTB)) {
    sub RAL_BBP_ANTB () {	0x2;}
}
unless(defined(&RAL_BBP_ANTMASK)) {
    sub RAL_BBP_ANTMASK () {	0x3;}
}
unless(defined(&RAL_BBP_FLIPIQ)) {
    sub RAL_BBP_FLIPIQ () {	0x4;}
}
unless(defined(&RAL_LED_MODE_DEFAULT)) {
    sub RAL_LED_MODE_DEFAULT () {	0;}
}
unless(defined(&RAL_LED_MODE_TXRX_ACTIVITY)) {
    sub RAL_LED_MODE_TXRX_ACTIVITY () {	1;}
}
unless(defined(&RAL_LED_MODE_SINGLE)) {
    sub RAL_LED_MODE_SINGLE () {	2;}
}
unless(defined(&RAL_LED_MODE_ASUS)) {
    sub RAL_LED_MODE_ASUS () {	3;}
}
unless(defined(&RAL_JAPAN_FILTER)) {
    sub RAL_JAPAN_FILTER () {	0x8;}
}
unless(defined(&RAL_EEPROM_CONFIG0)) {
    sub RAL_EEPROM_CONFIG0 () {	16;}
}
unless(defined(&RAL_EEPROM_BBP_BASE)) {
    sub RAL_EEPROM_BBP_BASE () {	19;}
}
unless(defined(&RAL_EEPROM_TXPOWER)) {
    sub RAL_EEPROM_TXPOWER () {	35;}
}
unless(defined(&RAL_EEPROM_DELAY)) {
    sub RAL_EEPROM_DELAY () {	1;}
}
unless(defined(&RAL_READ)) {
    sub RAL_READ {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&RAL_WRITE)) {
    sub RAL_WRITE {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&RAL_EEPROM_CTL)) {
    sub RAL_EEPROM_CTL {
	local($sc, $val) = @_;
	eval q( &do {  &RAL_WRITE(($sc),  &RAL_CSR21, ($val));  &DELAY( &RAL_EEPROM_DELAY); }  &while ( 0));
    }
}
1;
