require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_BIT_TWIDDLE)) {
    eval 'sub _BIT_TWIDDLE () {1;}' unless defined(&_BIT_TWIDDLE);
    eval 'sub BIT {
        local($n) = @_;
	    eval q(((($n) == 32) ? 0: (( &u_int32_t)1<< ($n))));
    }' unless defined(&BIT);
    eval 'sub BITS {
        local($m, $n) = @_;
	    eval q((( &BIT( &MAX(($m), ($n)) + 1) - 1) ^ ( &BIT( &MIN(($m), ($n))) - 1)));
    }' unless defined(&BITS);
    eval 'sub LOWEST_SET_BIT {
        local($x) = @_;
	    eval q((((($x) - 1) & ($x)) ^ ($x)));
    }' unless defined(&LOWEST_SET_BIT);
    eval 'sub GTEQ_POWER {
        local($x, $p) = @_;
	    eval q(((($x) >> ($p)) != 0));
    }' unless defined(&GTEQ_POWER);
    eval 'sub MASK_TO_SHIFT2 {
        local($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 1) ? 1: 0));
    }' unless defined(&MASK_TO_SHIFT2);
    eval 'sub MASK_TO_SHIFT4 {
        local($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 2) ? 2+  &MASK_TO_SHIFT2(($m) >> 2) :  &MASK_TO_SHIFT2(($m))));
    }' unless defined(&MASK_TO_SHIFT4);
    eval 'sub MASK_TO_SHIFT8 {
        local($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 4) ? 4+  &MASK_TO_SHIFT4(($m) >> 4) :  &MASK_TO_SHIFT4(($m))));
    }' unless defined(&MASK_TO_SHIFT8);
    eval 'sub MASK_TO_SHIFT16 {
        local($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 8) ? 8+  &MASK_TO_SHIFT8(($m) >> 8) :  &MASK_TO_SHIFT8(($m))));
    }' unless defined(&MASK_TO_SHIFT16);
    eval 'sub MASK_TO_SHIFT {
        local($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 16) ? 16+  &MASK_TO_SHIFT16(($m) >> 16) :  &MASK_TO_SHIFT16(($m))));
    }' unless defined(&MASK_TO_SHIFT);
    eval 'sub MASK_AND_RSHIFT {
        local($x, $mask) = @_;
	    eval q(((($x) & ($mask)) >>  &MASK_TO_SHIFT($mask)));
    }' unless defined(&MASK_AND_RSHIFT);
    eval 'sub LSHIFT {
        local($x, $mask) = @_;
	    eval q((($x) <<  &MASK_TO_SHIFT($mask)));
    }' unless defined(&LSHIFT);
    eval 'sub MASK_AND_REPLACE {
        local($reg, $val, $mask) = @_;
	    eval q((($reg & ~$mask) |  &LSHIFT($val, $mask)));
    }' unless defined(&MASK_AND_REPLACE);
    eval 'sub PRESHIFT {
        local($m) = @_;
	    eval q( &MASK_AND_RSHIFT(($m), ($m)));
    }' unless defined(&PRESHIFT);
}
unless(defined(&RTW_IDR0)) {
    sub RTW_IDR0 () {	0x;}
}
unless(defined(&RTW_IDR1)) {
    sub RTW_IDR1 () {	0x4;}
}
unless(defined(&RTW_MAR0)) {
    sub RTW_MAR0 () {	0x8;}
}
unless(defined(&RTW_MAR1)) {
    sub RTW_MAR1 () {	0xc;}
}
unless(defined(&RTW_TSFTRL)) {
    sub RTW_TSFTRL () {	0x18;}
}
unless(defined(&RTW_TSFTRH)) {
    sub RTW_TSFTRH () {	0x1c;}
}
unless(defined(&RTW_TLPDA)) {
    sub RTW_TLPDA () {	0x20;}
}
unless(defined(&RTW_TNPDA)) {
    sub RTW_TNPDA () {	0x24;}
}
unless(defined(&RTW_THPDA)) {
    sub RTW_THPDA () {	0x28;}
}
unless(defined(&RTW_BRSR)) {
    sub RTW_BRSR () {	0x2c;}
}
unless(defined(&RTW8180_BRSR_BPLCP)) {
    sub RTW8180_BRSR_BPLCP () {	 &BIT(8);}
}
unless(defined(&RTW8180_BRSR_MBR_MASK)) {
    sub RTW8180_BRSR_MBR_MASK () {	 &BITS(1,0);}
}
unless(defined(&RTW8180_BRSR_MBR_1MBPS)) {
    sub RTW8180_BRSR_MBR_1MBPS () {	 &LSHIFT(0,  &RTW8180_BRSR_MBR_MASK);}
}
unless(defined(&RTW8180_BRSR_MBR_2MBPS)) {
    sub RTW8180_BRSR_MBR_2MBPS () {	 &LSHIFT(1,  &RTW8180_BRSR_MBR_MASK);}
}
unless(defined(&RTW8180_BRSR_MBR_5MBPS)) {
    sub RTW8180_BRSR_MBR_5MBPS () {	 &LSHIFT(2,  &RTW8180_BRSR_MBR_MASK);}
}
unless(defined(&RTW8180_BRSR_MBR_11MBPS)) {
    sub RTW8180_BRSR_MBR_11MBPS () {	 &LSHIFT(3,  &RTW8180_BRSR_MBR_MASK);}
}
unless(defined(&RTW8185_BRSR_MBR_MASK)) {
    sub RTW8185_BRSR_MBR_MASK () {	 &BITS(11, 0);}
}
unless(defined(&RTW8185_BRSR_MBR_1MBPS)) {
    sub RTW8185_BRSR_MBR_1MBPS () {	 &BIT(0);}
}
unless(defined(&RTW8185_BRSR_MBR_2MBPS)) {
    sub RTW8185_BRSR_MBR_2MBPS () {	 &BIT(1);}
}
unless(defined(&RTW8185_BRSR_MBR_5MBPS)) {
    sub RTW8185_BRSR_MBR_5MBPS () {	 &BIT(2);}
}
unless(defined(&RTW8185_BRSR_MBR_11MBPS)) {
    sub RTW8185_BRSR_MBR_11MBPS () {	 &BIT(3);}
}
unless(defined(&RTW8185_BRSR_MBR_6MBPS)) {
    sub RTW8185_BRSR_MBR_6MBPS () {	 &BIT(4);}
}
unless(defined(&RTW8185_BRSR_MBR_9MBPS)) {
    sub RTW8185_BRSR_MBR_9MBPS () {	 &BIT(5);}
}
unless(defined(&RTW8185_BRSR_MBR_12MBPS)) {
    sub RTW8185_BRSR_MBR_12MBPS () {	 &BIT(6);}
}
unless(defined(&RTW8185_BRSR_MBR_18MBPS)) {
    sub RTW8185_BRSR_MBR_18MBPS () {	 &BIT(7);}
}
unless(defined(&RTW8185_BRSR_MBR_24MBPS)) {
    sub RTW8185_BRSR_MBR_24MBPS () {	 &BIT(8);}
}
unless(defined(&RTW8185_BRSR_MBR_36MBPS)) {
    sub RTW8185_BRSR_MBR_36MBPS () {	 &BIT(9);}
}
unless(defined(&RTW8185_BRSR_MBR_48MBPS)) {
    sub RTW8185_BRSR_MBR_48MBPS () {	 &BIT(10);}
}
unless(defined(&RTW8185_BRSR_MBR_54MBPS)) {
    sub RTW8185_BRSR_MBR_54MBPS () {	 &BIT(11);}
}
unless(defined(&RTW_BSSID)) {
    sub RTW_BSSID () {	0x2e;}
}
unless(defined(&RTW_BSSID16)) {
    sub RTW_BSSID16 () {	0x2e;}
}
unless(defined(&RTW_BSSID32)) {
    sub RTW_BSSID32 () {	(0x2e + 4);}
}
unless(defined(&RTW_BSSID0)) {
    sub RTW_BSSID0 () {	 &RTW_BSSID16;}
}
unless(defined(&RTW_BSSID1)) {
    sub RTW_BSSID1 () {	( &RTW_BSSID0 + 1);}
}
unless(defined(&RTW_BSSID2)) {
    sub RTW_BSSID2 () {	( &RTW_BSSID1 + 1);}
}
unless(defined(&RTW_BSSID3)) {
    sub RTW_BSSID3 () {	( &RTW_BSSID2 + 1);}
}
unless(defined(&RTW_BSSID4)) {
    sub RTW_BSSID4 () {	( &RTW_BSSID3 + 1);}
}
unless(defined(&RTW_BSSID5)) {
    sub RTW_BSSID5 () {	( &RTW_BSSID4 + 1);}
}
unless(defined(&RTW8185_RR)) {
    sub RTW8185_RR () {	0x34;}
}
unless(defined(&RTW8185_RR_MAX)) {
    sub RTW8185_RR_MAX () {	 &BIT(7, 4);}
}
unless(defined(&RTW8185_RR_MAX_1MPBS)) {
    sub RTW8185_RR_MAX_1MPBS () {	 &LSHIFT(0,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MAX_2MPBS)) {
    sub RTW8185_RR_MAX_2MPBS () {	 &LSHIFT(1,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MAX_5MPBS)) {
    sub RTW8185_RR_MAX_5MPBS () {	 &LSHIFT(2,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MAX_11MPBS)) {
    sub RTW8185_RR_MAX_11MPBS () {	 &LSHIFT(3,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MAX_6MPBS)) {
    sub RTW8185_RR_MAX_6MPBS () {	 &LSHIFT(4,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MAX_9MPBS)) {
    sub RTW8185_RR_MAX_9MPBS () {	 &LSHIFT(5,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MAX_12MPBS)) {
    sub RTW8185_RR_MAX_12MPBS () {	 &LSHIFT(6,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MAX_18MPBS)) {
    sub RTW8185_RR_MAX_18MPBS () {	 &LSHIFT(7,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MAX_24MPBS)) {
    sub RTW8185_RR_MAX_24MPBS () {	 &LSHIFT(8,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MAX_36MPBS)) {
    sub RTW8185_RR_MAX_36MPBS () {	 &LSHIFT(9,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MAX_48MPBS)) {
    sub RTW8185_RR_MAX_48MPBS () {	 &LSHIFT(10,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MAX_54MPBS)) {
    sub RTW8185_RR_MAX_54MPBS () {	 &LSHIFT(11,  &RTW8185_RR_MAX_MASK);}
}
unless(defined(&RTW8185_RR_MIN_MASK)) {
    sub RTW8185_RR_MIN_MASK () {	 &BIT(3, 0);}
}
unless(defined(&RTW8185_RR_MIN_1MPBS)) {
    sub RTW8185_RR_MIN_1MPBS () {	 &LSHIFT(0,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_RR_MIN_2MPBS)) {
    sub RTW8185_RR_MIN_2MPBS () {	 &LSHIFT(1,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_RR_MIN_5MPBS)) {
    sub RTW8185_RR_MIN_5MPBS () {	 &LSHIFT(2,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_RR_MIN_11MPBS)) {
    sub RTW8185_RR_MIN_11MPBS () {	 &LSHIFT(3,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_RR_MIN_6MPBS)) {
    sub RTW8185_RR_MIN_6MPBS () {	 &LSHIFT(4,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_RR_MIN_9MPBS)) {
    sub RTW8185_RR_MIN_9MPBS () {	 &LSHIFT(5,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_RR_MIN_12MPBS)) {
    sub RTW8185_RR_MIN_12MPBS () {	 &LSHIFT(6,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_RR_MIN_18MPBS)) {
    sub RTW8185_RR_MIN_18MPBS () {	 &LSHIFT(7,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_RR_MIN_24MPBS)) {
    sub RTW8185_RR_MIN_24MPBS () {	 &LSHIFT(8,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_RR_MIN_36MPBS)) {
    sub RTW8185_RR_MIN_36MPBS () {	 &LSHIFT(9,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_RR_MIN_48MPBS)) {
    sub RTW8185_RR_MIN_48MPBS () {	 &LSHIFT(10,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_RR_MIN_54MPBS)) {
    sub RTW8185_RR_MIN_54MPBS () {	 &LSHIFT(11,  &RTW8185_RR_MIN_MASK);}
}
unless(defined(&RTW8185_EIFS_TIMER)) {
    sub RTW8185_EIFS_TIMER () {	0x35;}
}
unless(defined(&RTW_CR)) {
    sub RTW_CR () {	0x37;}
}
unless(defined(&RTW_CR_RST)) {
    sub RTW_CR_RST () {	 &BIT(4);}
}
unless(defined(&RTW_CR_RE)) {
    sub RTW_CR_RE () {	 &BIT(3);}
}
unless(defined(&RTW_CR_TE)) {
    sub RTW_CR_TE () {	 &BIT(2);}
}
unless(defined(&RTW_CR_MULRW)) {
    sub RTW_CR_MULRW () {	 &BIT(0);}
}
unless(defined(&RTW_IMR)) {
    sub RTW_IMR () {	0x3c;}
}
unless(defined(&RTW_ISR)) {
    sub RTW_ISR () {	0x3e;}
}
unless(defined(&RTW_INTR_TXFOVW)) {
    sub RTW_INTR_TXFOVW () {	 &BIT(15);}
}
unless(defined(&RTW_INTR_TIMEOUT)) {
    sub RTW_INTR_TIMEOUT () {	 &BIT(14);}
}
unless(defined(&RTW_INTR_BCNINT)) {
    sub RTW_INTR_BCNINT () {	 &BIT(13);}
}
unless(defined(&RTW_INTR_ATIMINT)) {
    sub RTW_INTR_ATIMINT () {	 &BIT(12);}
}
unless(defined(&RTW_INTR_TBDER)) {
    sub RTW_INTR_TBDER () {	 &BIT(11);}
}
unless(defined(&RTW_INTR_TBDOK)) {
    sub RTW_INTR_TBDOK () {	 &BIT(10);}
}
unless(defined(&RTW_INTR_THPDER)) {
    sub RTW_INTR_THPDER () {	 &BIT(9);}
}
unless(defined(&RTW_INTR_THPDOK)) {
    sub RTW_INTR_THPDOK () {	 &BIT(8);}
}
unless(defined(&RTW_INTR_TNPDER)) {
    sub RTW_INTR_TNPDER () {	 &BIT(7);}
}
unless(defined(&RTW_INTR_TNPDOK)) {
    sub RTW_INTR_TNPDOK () {	 &BIT(6);}
}
unless(defined(&RTW_INTR_RXFOVW)) {
    sub RTW_INTR_RXFOVW () {	 &BIT(5);}
}
unless(defined(&RTW_INTR_RDU)) {
    sub RTW_INTR_RDU () {	 &BIT(4);}
}
unless(defined(&RTW_INTR_TLPDER)) {
    sub RTW_INTR_TLPDER () {	 &BIT(3);}
}
unless(defined(&RTW_INTR_TLPDOK)) {
    sub RTW_INTR_TLPDOK () {	 &BIT(2);}
}
unless(defined(&RTW_INTR_RER)) {
    sub RTW_INTR_RER () {	 &BIT(1);}
}
unless(defined(&RTW_INTR_ROK)) {
    sub RTW_INTR_ROK () {	 &BIT(0);}
}
unless(defined(&RTW_INTR_RX)) {
    sub RTW_INTR_RX () {	( &RTW_INTR_RER| &RTW_INTR_ROK);}
}
unless(defined(&RTW_INTR_TX)) {
    sub RTW_INTR_TX () {	( &RTW_INTR_TLPDER| &RTW_INTR_TLPDOK| &RTW_INTR_THPDER|  &RTW_INTR_THPDOK| &RTW_INTR_TNPDER| &RTW_INTR_TNPDOK|  &RTW_INTR_TBDER| &RTW_INTR_TBDOK);}
}
unless(defined(&RTW_INTR_BEACON)) {
    sub RTW_INTR_BEACON () {	( &RTW_INTR_BCNINT);}
}
unless(defined(&RTW_INTR_IOERROR)) {
    sub RTW_INTR_IOERROR () {	( &RTW_INTR_TXFOVW| &RTW_INTR_RXFOVW| &RTW_INTR_RDU);}
}
unless(defined(&RTW_TCR)) {
    sub RTW_TCR () {	0x40;}
}
unless(defined(&RTW_TCR_CWMIN)) {
    sub RTW_TCR_CWMIN () {	 &BIT(31);}
}
unless(defined(&RTW_TCR_SWSEQ)) {
    sub RTW_TCR_SWSEQ () {	 &BIT(30);}
}
unless(defined(&RTW8185_TCR_NOPROBERSPTO)) {
    sub RTW8185_TCR_NOPROBERSPTO () {	 &BIT(29);}
}
unless(defined(&RTW_TCR_HWVERID_MASK)) {
    sub RTW_TCR_HWVERID_MASK () {	 &BITS(27, 25);}
}
unless(defined(&RTW_TCR_HWVERID_RTL8180D)) {
    sub RTW_TCR_HWVERID_RTL8180D () {	 &BIT(26);}
}
unless(defined(&RTW_TCR_HWVERID_RTL8180F)) {
    sub RTW_TCR_HWVERID_RTL8180F () {	 &BITS(26, 25);}
}
unless(defined(&RTW_TCR_HWVERID_RTL8185)) {
    sub RTW_TCR_HWVERID_RTL8185 () {	( &BIT(27) |  &BIT(25));}
}
unless(defined(&RTW8180_TCR_SAT)) {
    sub RTW8180_TCR_SAT () {	 &BIT(24);}
}
unless(defined(&RTW8185_TCR_PLCPLENGTH)) {
    sub RTW8185_TCR_PLCPLENGTH () {	 &BIT(24);}
}
unless(defined(&RTW_TCR_MXDMA_MASK)) {
    sub RTW_TCR_MXDMA_MASK () {	 &BITS(23,21);}
}
unless(defined(&RTW_TCR_MXDMA_16)) {
    sub RTW_TCR_MXDMA_16 () {	 &LSHIFT(0,  &RTW_TCR_MXDMA_MASK);}
}
unless(defined(&RTW_TCR_MXDMA_32)) {
    sub RTW_TCR_MXDMA_32 () {	 &LSHIFT(1,  &RTW_TCR_MXDMA_MASK);}
}
unless(defined(&RTW_TCR_MXDMA_64)) {
    sub RTW_TCR_MXDMA_64 () {	 &LSHIFT(2,  &RTW_TCR_MXDMA_MASK);}
}
unless(defined(&RTW_TCR_MXDMA_128)) {
    sub RTW_TCR_MXDMA_128 () {	 &LSHIFT(3,  &RTW_TCR_MXDMA_MASK);}
}
unless(defined(&RTW_TCR_MXDMA_256)) {
    sub RTW_TCR_MXDMA_256 () {	 &LSHIFT(4,  &RTW_TCR_MXDMA_MASK);}
}
unless(defined(&RTW_TCR_MXDMA_512)) {
    sub RTW_TCR_MXDMA_512 () {	 &LSHIFT(5,  &RTW_TCR_MXDMA_MASK);}
}
unless(defined(&RTW_TCR_MXDMA_1024)) {
    sub RTW_TCR_MXDMA_1024 () {	 &LSHIFT(6,  &RTW_TCR_MXDMA_MASK);}
}
unless(defined(&RTW_TCR_MXDMA_2048)) {
    sub RTW_TCR_MXDMA_2048 () {	 &LSHIFT(7,  &RTW_TCR_MXDMA_MASK);}
}
unless(defined(&RTW_TCR_DISCW)) {
    sub RTW_TCR_DISCW () {	 &BIT(20);}
}
unless(defined(&RTW_TCR_ICV)) {
    sub RTW_TCR_ICV () {	 &BIT(19);}
}
unless(defined(&RTW_TCR_LBK_MASK)) {
    sub RTW_TCR_LBK_MASK () {	 &BITS(18,17);}
}
unless(defined(&RTW_TCR_LBK_NORMAL)) {
    sub RTW_TCR_LBK_NORMAL () {	 &LSHIFT(0,  &RTW_TCR_LBK_MASK);}
}
unless(defined(&RTW_TCR_LBK_MAC)) {
    sub RTW_TCR_LBK_MAC () {	 &LSHIFT(1,  &RTW_TCR_LBK_MASK);}
}
unless(defined(&RTW_TCR_LBK_BBP)) {
    sub RTW_TCR_LBK_BBP () {	 &LSHIFT(2,  &RTW_TCR_LBK_MASK);}
}
unless(defined(&RTW_TCR_LBK_CONT)) {
    sub RTW_TCR_LBK_CONT () {	 &LSHIFT(3,  &RTW_TCR_LBK_MASK);}
}
unless(defined(&RTW_TCR_CRC)) {
    sub RTW_TCR_CRC () {	 &BIT(16);}
}
unless(defined(&RTW_TCR_SRL_MASK)) {
    sub RTW_TCR_SRL_MASK () {	 &BITS(15,8);}
}
unless(defined(&RTW_TCR_LRL_MASK)) {
    sub RTW_TCR_LRL_MASK () {	 &BITS(7,0);}
}
unless(defined(&RTW_RCR)) {
    sub RTW_RCR () {	0x44;}
}
unless(defined(&RTW_RCR_ONLYERLPKT)) {
    sub RTW_RCR_ONLYERLPKT () {	 &BIT(31);}
}
unless(defined(&RTW_RCR_ENCS2)) {
    sub RTW_RCR_ENCS2 () {	 &BIT(30);}
}
unless(defined(&RTW_RCR_ENCS1)) {
    sub RTW_RCR_ENCS1 () {	 &BIT(29);}
}
unless(defined(&RTW_RCR_ENMARP)) {
    sub RTW_RCR_ENMARP () {	 &BIT(28);}
}
unless(defined(&RTW_RCR_CBSSID)) {
    sub RTW_RCR_CBSSID () {	 &BIT(23);}
}
unless(defined(&RTW_RCR_APWRMGT)) {
    sub RTW_RCR_APWRMGT () {	 &BIT(22);}
}
unless(defined(&RTW_RCR_ADD3)) {
    sub RTW_RCR_ADD3 () {	 &BIT(21);}
}
unless(defined(&RTW_RCR_AMF)) {
    sub RTW_RCR_AMF () {	 &BIT(20);}
}
unless(defined(&RTW_RCR_ACF)) {
    sub RTW_RCR_ACF () {	 &BIT(19);}
}
unless(defined(&RTW_RCR_ADF)) {
    sub RTW_RCR_ADF () {	 &BIT(18);}
}
unless(defined(&RTW8180_RCR_RXFTH_MASK)) {
    sub RTW8180_RCR_RXFTH_MASK () {	 &BITS(15,13);}
}
unless(defined(&RTW8180_RCR_RXFTH_64)) {
    sub RTW8180_RCR_RXFTH_64 () {	 &LSHIFT(2,  &RTW8180_RCR_RXFTH_MASK);}
}
unless(defined(&RTW8180_RCR_RXFTH_128)) {
    sub RTW8180_RCR_RXFTH_128 () {	 &LSHIFT(3,  &RTW8180_RCR_RXFTH_MASK);}
}
unless(defined(&RTW8180_RCR_RXFTH_256)) {
    sub RTW8180_RCR_RXFTH_256 () {	 &LSHIFT(4,  &RTW8180_RCR_RXFTH_MASK);}
}
unless(defined(&RTW8180_RCR_RXFTH_512)) {
    sub RTW8180_RCR_RXFTH_512 () {	 &LSHIFT(5,  &RTW8180_RCR_RXFTH_MASK);}
}
unless(defined(&RTW8180_RCR_RXFTH_1024)) {
    sub RTW8180_RCR_RXFTH_1024 () {	 &LSHIFT(6,  &RTW8180_RCR_RXFTH_MASK);}
}
unless(defined(&RTW8180_RCR_RXFTH_WHOLE)) {
    sub RTW8180_RCR_RXFTH_WHOLE () {	 &LSHIFT(7,  &RTW8180_RCR_RXFTH_MASK);}
}
unless(defined(&RTW_RCR_AICV)) {
    sub RTW_RCR_AICV () {	 &BIT(12);}
}
unless(defined(&RTW_RCR_MXDMA_MASK)) {
    sub RTW_RCR_MXDMA_MASK () {	 &BITS(10,8);}
}
unless(defined(&RTW_RCR_MXDMA_16)) {
    sub RTW_RCR_MXDMA_16 () {	 &LSHIFT(0,  &RTW_RCR_MXDMA_MASK);}
}
unless(defined(&RTW_RCR_MXDMA_32)) {
    sub RTW_RCR_MXDMA_32 () {	 &LSHIFT(1,  &RTW_RCR_MXDMA_MASK);}
}
unless(defined(&RTW_RCR_MXDMA_64)) {
    sub RTW_RCR_MXDMA_64 () {	 &LSHIFT(2,  &RTW_RCR_MXDMA_MASK);}
}
unless(defined(&RTW_RCR_MXDMA_128)) {
    sub RTW_RCR_MXDMA_128 () {	 &LSHIFT(3,  &RTW_RCR_MXDMA_MASK);}
}
unless(defined(&RTW_RCR_MXDMA_256)) {
    sub RTW_RCR_MXDMA_256 () {	 &LSHIFT(4,  &RTW_RCR_MXDMA_MASK);}
}
unless(defined(&RTW_RCR_MXDMA_512)) {
    sub RTW_RCR_MXDMA_512 () {	 &LSHIFT(5,  &RTW_RCR_MXDMA_MASK);}
}
unless(defined(&RTW_RCR_MXDMA_1024)) {
    sub RTW_RCR_MXDMA_1024 () {	 &LSHIFT(6,  &RTW_RCR_MXDMA_MASK);}
}
unless(defined(&RTW_RCR_MXDMA_UNLIMITED)) {
    sub RTW_RCR_MXDMA_UNLIMITED () {	 &LSHIFT(7,  &RTW_RCR_MXDMA_MASK);}
}
unless(defined(&RTW_RCR_9356SEL)) {
    sub RTW_RCR_9356SEL () {	 &BIT(6);}
}
unless(defined(&RTW_RCR_ACRC32)) {
    sub RTW_RCR_ACRC32 () {	 &BIT(5);}
}
unless(defined(&RTW_RCR_AB)) {
    sub RTW_RCR_AB () {	 &BIT(3);}
}
unless(defined(&RTW_RCR_AM)) {
    sub RTW_RCR_AM () {	 &BIT(2);}
}
unless(defined(&RTW_RCR_APM)) {
    sub RTW_RCR_APM () {	 &BIT(1);}
}
unless(defined(&RTW_RCR_AAP)) {
    sub RTW_RCR_AAP () {	 &BIT(0);}
}
unless(defined(&RTW_RCR_MONITOR)) {
    sub RTW_RCR_MONITOR () {	(  &RTW_RCR_AAP |  &RTW_RCR_ACF |  &RTW_RCR_ACRC32 |  &RTW_RCR_AICV | 0);}
}
unless(defined(&RTW_RCR_PKTFILTER_MASK)) {
    sub RTW_RCR_PKTFILTER_MASK () {	(  &RTW_RCR_AAP |  &RTW_RCR_AB |  &RTW_RCR_ACF |  &RTW_RCR_ACRC32 |  &RTW_RCR_ADD3 |  &RTW_RCR_ADF |  &RTW_RCR_AICV |  &RTW_RCR_AM |  &RTW_RCR_AMF |  &RTW_RCR_APM |  &RTW_RCR_APWRMGT | 0);}
}
unless(defined(&RTW_RCR_PKTFILTER_DEFAULT)) {
    sub RTW_RCR_PKTFILTER_DEFAULT () {	(  &RTW_RCR_ADF |  &RTW_RCR_AMF |  &RTW_RCR_APM |  &RTW_RCR_APWRMGT | 0);}
}
unless(defined(&RTW_TINT)) {
    sub RTW_TINT () {	0x48;}
}
unless(defined(&RTW_TBDA)) {
    sub RTW_TBDA () {	0x4c;}
}
unless(defined(&RTW_9346CR)) {
    sub RTW_9346CR () {	0x50;}
}
unless(defined(&RTW_9346CR_EEM_MASK)) {
    sub RTW_9346CR_EEM_MASK () {	 &BITS(7,6);}
}
unless(defined(&RTW_9346CR_EEM_NORMAL)) {
    sub RTW_9346CR_EEM_NORMAL () {	 &LSHIFT(0,  &RTW_9346CR_EEM_MASK);}
}
unless(defined(&RTW_9346CR_EEM_AUTOLOAD)) {
    sub RTW_9346CR_EEM_AUTOLOAD () {	 &LSHIFT(1,  &RTW_9346CR_EEM_MASK);}
}
unless(defined(&RTW_9346CR_EEM_PROGRAM)) {
    sub RTW_9346CR_EEM_PROGRAM () {	 &LSHIFT(2,  &RTW_9346CR_EEM_MASK);}
}
unless(defined(&RTW_9346CR_EEM_CONFIG)) {
    sub RTW_9346CR_EEM_CONFIG () {	 &LSHIFT(3,  &RTW_9346CR_EEM_MASK);}
}
unless(defined(&RTW_9346CR_EECS)) {
    sub RTW_9346CR_EECS () {	 &BIT(3);}
}
unless(defined(&RTW_9346CR_EESK)) {
    sub RTW_9346CR_EESK () {	 &BIT(2);}
}
unless(defined(&RTW_9346CR_EEDI)) {
    sub RTW_9346CR_EEDI () {	 &BIT(1);}
}
unless(defined(&RTW_9346CR_EEDO)) {
    sub RTW_9346CR_EEDO () {	 &BIT(0);}
}
unless(defined(&RTW_CONFIG0)) {
    sub RTW_CONFIG0 () {	0x51;}
}
unless(defined(&RTW8180_CONFIG0_WEP40)) {
    sub RTW8180_CONFIG0_WEP40 () {	 &BIT(7);}
}
unless(defined(&RTW8180_CONFIG0_WEP104)) {
    sub RTW8180_CONFIG0_WEP104 () {	 &BIT(6);}
}
unless(defined(&RTW8180_CONFIG0_LEDGPOEN)) {
    sub RTW8180_CONFIG0_LEDGPOEN () {	 &BIT(4);}
}
unless(defined(&RTW_CONFIG0_AUXPWR)) {
    sub RTW_CONFIG0_AUXPWR () {	 &BIT(3);}
}
unless(defined(&RTW8180_CONFIG0_GL_MASK)) {
    sub RTW8180_CONFIG0_GL_MASK () {	 &BITS(1,0);}
}
unless(defined(&RTW8180_CONFIG0_GL_USA)) {
    sub RTW8180_CONFIG0_GL_USA () {	 &LSHIFT(3,  &RTW8180_CONFIG0_GL_MASK);}
}
unless(defined(&RTW8180_CONFIG0_GL_EUROPE)) {
    sub RTW8180_CONFIG0_GL_EUROPE () {	 &LSHIFT(2,  &RTW8180_CONFIG0_GL_MASK);}
}
unless(defined(&RTW8180_CONFIG0_GL_JAPAN)) {
    sub RTW8180_CONFIG0_GL_JAPAN () {	 &LSHIFT(1,  &RTW8180_CONFIG0_GL_MASK);}
}
unless(defined(&RTW8180_CONFIG0_GL_JAPAN2)) {
    sub RTW8180_CONFIG0_GL_JAPAN2 () {	 &LSHIFT(0,  &RTW8180_CONFIG0_GL_MASK);}
}
unless(defined(&RTW_CONFIG1)) {
    sub RTW_CONFIG1 () {	0x52;}
}
unless(defined(&RTW_CONFIG1_LEDS_MASK)) {
    sub RTW_CONFIG1_LEDS_MASK () {	 &BITS(7,6);}
}
unless(defined(&RTW_CONFIG1_LEDS_ACT_INFRA)) {
    sub RTW_CONFIG1_LEDS_ACT_INFRA () {	 &LSHIFT(0,  &RTW_CONFIG1_LEDS_MASK);}
}
unless(defined(&RTW_CONFIG1_LEDS_ACT_LINK)) {
    sub RTW_CONFIG1_LEDS_ACT_LINK () {	 &LSHIFT(1,  &RTW_CONFIG1_LEDS_MASK);}
}
unless(defined(&RTW_CONFIG1_LEDS_TX_RX)) {
    sub RTW_CONFIG1_LEDS_TX_RX () {	 &LSHIFT(2,  &RTW_CONFIG1_LEDS_MASK);}
}
unless(defined(&RTW_CONFIG1_LEDS_LINKACT_INFRA)) {
    sub RTW_CONFIG1_LEDS_LINKACT_INFRA () {	 &LSHIFT(3,  &RTW_CONFIG1_LEDS_MASK);}
}
unless(defined(&RTW_CONFIG1_LWACT)) {
    sub RTW_CONFIG1_LWACT () {	 &BIT(4);}
}
unless(defined(&RTW_CONFIG1_MEMMAP)) {
    sub RTW_CONFIG1_MEMMAP () {	 &BIT(3);}
}
unless(defined(&RTW_CONFIG1_IOMAP)) {
    sub RTW_CONFIG1_IOMAP () {	 &BIT(2);}
}
unless(defined(&RTW_CONFIG1_VPD)) {
    sub RTW_CONFIG1_VPD () {	 &BIT(1);}
}
unless(defined(&RTW_CONFIG1_PMEN)) {
    sub RTW_CONFIG1_PMEN () {	 &BIT(0);}
}
unless(defined(&RTW_CONFIG2)) {
    sub RTW_CONFIG2 () {	0x53;}
}
unless(defined(&RTW_CONFIG2_LCK)) {
    sub RTW_CONFIG2_LCK () {	 &BIT(7);}
}
unless(defined(&RTW8180_CONFIG2_ANT)) {
    sub RTW8180_CONFIG2_ANT () {	 &BIT(6);}
}
unless(defined(&RTW_CONFIG2_DPS)) {
    sub RTW_CONFIG2_DPS () {	 &BIT(3);}
}
unless(defined(&RTW_CONFIG2_PAPESIGN)) {
    sub RTW_CONFIG2_PAPESIGN () {	 &BIT(2);}
}
unless(defined(&RTW_CONFIG2_PAPETIME_MASK)) {
    sub RTW_CONFIG2_PAPETIME_MASK () {	 &BITS(1,0);}
}
unless(defined(&RTW_ANAPARM)) {
    sub RTW_ANAPARM () {	0x54;}
}
unless(defined(&RTW_ANAPARM_RFPOW0_MASK)) {
    sub RTW_ANAPARM_RFPOW0_MASK () {	 &BITS(30,28);}
}
unless(defined(&RTW_ANAPARM_RFPOW_MASK)) {
    sub RTW_ANAPARM_RFPOW_MASK () {	( &RTW_ANAPARM_RFPOW0_MASK| &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_TXDACOFF)) {
    sub RTW_ANAPARM_TXDACOFF () {	 &BIT(27);}
}
unless(defined(&RTW_ANAPARM_RFPOW1_MASK)) {
    sub RTW_ANAPARM_RFPOW1_MASK () {	 &BITS(26,20);}
}
unless(defined(&RTW_ANAPARM_RFPOW_MAXIM_ON)) {
    sub RTW_ANAPARM_RFPOW_MAXIM_ON () {	 &LSHIFT(0x8,  &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_RFPOW_MAXIM_SLEEP)) {
    sub RTW_ANAPARM_RFPOW_MAXIM_SLEEP () {	 &LSHIFT(0x378,  &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_RFPOW_MAXIM_OFF)) {
    sub RTW_ANAPARM_RFPOW_MAXIM_OFF () {	 &LSHIFT(0x379,  &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_RFPOW_RFMD_ON)) {
    sub RTW_ANAPARM_RFPOW_RFMD_ON () {	 &LSHIFT(0x408,  &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_RFPOW_RFMD_SLEEP)) {
    sub RTW_ANAPARM_RFPOW_RFMD_SLEEP () {	 &LSHIFT(0x378,  &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_RFPOW_RFMD_OFF)) {
    sub RTW_ANAPARM_RFPOW_RFMD_OFF () {	 &LSHIFT(0x379,  &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_RFPOW_ANA_PHILIPS_ON)) {
    sub RTW_ANAPARM_RFPOW_ANA_PHILIPS_ON () {	 &LSHIFT(0x328,  &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_RFPOW_DIG_PHILIPS_ON)) {
    sub RTW_ANAPARM_RFPOW_DIG_PHILIPS_ON () {	 &LSHIFT(0x8,  &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_RFPOW_PHILIPS_SLEEP)) {
    sub RTW_ANAPARM_RFPOW_PHILIPS_SLEEP () {	 &LSHIFT(0x378,  &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_RFPOW_PHILIPS_OFF)) {
    sub RTW_ANAPARM_RFPOW_PHILIPS_OFF () {	 &LSHIFT(0x379,  &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_RFPOW_PHILIPS_ON)) {
    sub RTW_ANAPARM_RFPOW_PHILIPS_ON () {	 &LSHIFT(0x328,  &RTW_ANAPARM_RFPOW1_MASK);}
}
unless(defined(&RTW_ANAPARM_CARDSP_MASK)) {
    sub RTW_ANAPARM_CARDSP_MASK () {	 &BITS(19,0);}
}
unless(defined(&RTW_MSR)) {
    sub RTW_MSR () {	0x58;}
}
unless(defined(&RTW_MSR_NETYPE_MASK)) {
    sub RTW_MSR_NETYPE_MASK () {	 &BITS(3,2);}
}
unless(defined(&RTW_MSR_NETYPE_AP_OK)) {
    sub RTW_MSR_NETYPE_AP_OK () {	 &LSHIFT(3,  &RTW_MSR_NETYPE_MASK);}
}
unless(defined(&RTW_MSR_NETYPE_INFRA_OK)) {
    sub RTW_MSR_NETYPE_INFRA_OK () {	 &LSHIFT(2,  &RTW_MSR_NETYPE_MASK);}
}
unless(defined(&RTW_MSR_NETYPE_ADHOC_OK)) {
    sub RTW_MSR_NETYPE_ADHOC_OK () {	 &LSHIFT(1,  &RTW_MSR_NETYPE_MASK);}
}
unless(defined(&RTW_MSR_NETYPE_NOLINK)) {
    sub RTW_MSR_NETYPE_NOLINK () {	 &LSHIFT(0,  &RTW_MSR_NETYPE_MASK);}
}
unless(defined(&RTW_CONFIG3)) {
    sub RTW_CONFIG3 () {	0x59;}
}
unless(defined(&RTW_CONFIG3_GNTSEL)) {
    sub RTW_CONFIG3_GNTSEL () {	 &BIT(7);}
}
unless(defined(&RTW_CONFIG3_PARMEN)) {
    sub RTW_CONFIG3_PARMEN () {	 &BIT(6);}
}
unless(defined(&RTW_CONFIG3_MAGIC)) {
    sub RTW_CONFIG3_MAGIC () {	 &BIT(5);}
}
unless(defined(&RTW_CONFIG3_CARDBEN)) {
    sub RTW_CONFIG3_CARDBEN () {	 &BIT(3);}
}
unless(defined(&RTW_CONFIG3_CLKRUNEN)) {
    sub RTW_CONFIG3_CLKRUNEN () {	 &BIT(2);}
}
unless(defined(&RTW_CONFIG3_FUNCREGEN)) {
    sub RTW_CONFIG3_FUNCREGEN () {	 &BIT(1);}
}
unless(defined(&RTW_CONFIG3_FBTBEN)) {
    sub RTW_CONFIG3_FBTBEN () {	 &BIT(0);}
}
unless(defined(&RTW_CONFIG4)) {
    sub RTW_CONFIG4 () {	0x5a;}
}
unless(defined(&RTW_CONFIG4_VCOPDN)) {
    sub RTW_CONFIG4_VCOPDN () {	 &BIT(7);}
}
unless(defined(&RTW_CONFIG4_PWROFF)) {
    sub RTW_CONFIG4_PWROFF () {	 &BIT(6);}
}
unless(defined(&RTW_CONFIG4_PWRMGT)) {
    sub RTW_CONFIG4_PWRMGT () {	 &BIT(5);}
}
unless(defined(&RTW_CONFIG4_LWPME)) {
    sub RTW_CONFIG4_LWPME () {	 &BIT(4);}
}
unless(defined(&RTW_CONFIG4_LWPTN)) {
    sub RTW_CONFIG4_LWPTN () {	 &BIT(2);}
}
unless(defined(&RTW_CONFIG4_RFTYPE_MASK)) {
    sub RTW_CONFIG4_RFTYPE_MASK () {	 &BITS(1,0);}
}
unless(defined(&RTW_CONFIG4_RFTYPE_INTERSIL)) {
    sub RTW_CONFIG4_RFTYPE_INTERSIL () {	 &LSHIFT(1,  &RTW_CONFIG4_RFTYPE_MASK);}
}
unless(defined(&RTW_CONFIG4_RFTYPE_RFMD)) {
    sub RTW_CONFIG4_RFTYPE_RFMD () {	 &LSHIFT(2,  &RTW_CONFIG4_RFTYPE_MASK);}
}
unless(defined(&RTW_CONFIG4_RFTYPE_PHILIPS)) {
    sub RTW_CONFIG4_RFTYPE_PHILIPS () {	 &LSHIFT(3,  &RTW_CONFIG4_RFTYPE_MASK);}
}
unless(defined(&RTW_TESTR)) {
    sub RTW_TESTR () {	0x5b;}
}
unless(defined(&RTW_PSR)) {
    sub RTW_PSR () {	0x5e;}
}
unless(defined(&RTW_PSR_GPO)) {
    sub RTW_PSR_GPO () {	 &BIT(7);}
}
unless(defined(&RTW_PSR_GPI)) {
    sub RTW_PSR_GPI () {	 &BIT(6);}
}
unless(defined(&RTW_PSR_LEDGPO1)) {
    sub RTW_PSR_LEDGPO1 () {	 &BIT(5);}
}
unless(defined(&RTW_PSR_LEDGPO0)) {
    sub RTW_PSR_LEDGPO0 () {	 &BIT(4);}
}
unless(defined(&RTW_PSR_UWF)) {
    sub RTW_PSR_UWF () {	 &BIT(1);}
}
unless(defined(&RTW_PSR_PSEN)) {
    sub RTW_PSR_PSEN () {	 &BIT(0);}
}
unless(defined(&RTW8180_SCR)) {
    sub RTW8180_SCR () {	0x5f;}
}
unless(defined(&RTW8180_SCR_KM_MASK)) {
    sub RTW8180_SCR_KM_MASK () {	 &BITS(5,4);}
}
unless(defined(&RTW8180_SCR_KM_WEP104)) {
    sub RTW8180_SCR_KM_WEP104 () {	 &LSHIFT(1,  &RTW8180_SCR_KM_MASK);}
}
unless(defined(&RTW8180_SCR_KM_WEP40)) {
    sub RTW8180_SCR_KM_WEP40 () {	 &LSHIFT(0,  &RTW8180_SCR_KM_MASK);}
}
unless(defined(&RTW8180_SCR_TXSECON)) {
    sub RTW8180_SCR_TXSECON () {	 &BIT(1);}
}
unless(defined(&RTW8180_SCR_RXSECON)) {
    sub RTW8180_SCR_RXSECON () {	 &BIT(0);}
}
unless(defined(&RTW8185_RFPARM)) {
    sub RTW8185_RFPARM () {	0x60;}
}
unless(defined(&RTW_BCNITV)) {
    sub RTW_BCNITV () {	0x70;}
}
unless(defined(&RTW_BCNITV_BCNITV_MASK)) {
    sub RTW_BCNITV_BCNITV_MASK () {	 &BITS(9,0);}
}
unless(defined(&RTW_ATIMWND)) {
    sub RTW_ATIMWND () {	0x72;}
}
unless(defined(&RTW_ATIMWND_ATIMWND)) {
    sub RTW_ATIMWND_ATIMWND () {	 &BITS(9,0);}
}
unless(defined(&RTW_BINTRITV)) {
    sub RTW_BINTRITV () {	0x74;}
}
unless(defined(&RTW_BINTRITV_BINTRITV)) {
    sub RTW_BINTRITV_BINTRITV () {	 &BITS(9,0);}
}
unless(defined(&RTW_ATIMTRITV)) {
    sub RTW_ATIMTRITV () {	0x76;}
}
unless(defined(&RTW_ATIMTRITV_ATIMTRITV)) {
    sub RTW_ATIMTRITV_ATIMTRITV () {	 &BITS(9,0);}
}
unless(defined(&RTW_PHYDELAY)) {
    sub RTW_PHYDELAY () {	0x78;}
}
unless(defined(&RTW_PHYDELAY_REVC_MAGIC)) {
    sub RTW_PHYDELAY_REVC_MAGIC () {	 &BIT(3);}
}
unless(defined(&RTW_PHYDELAY_PHYDELAY)) {
    sub RTW_PHYDELAY_PHYDELAY () {	 &BITS(2,0);}
}
unless(defined(&RTW_CRCOUNT)) {
    sub RTW_CRCOUNT () {	0x79;}
}
unless(defined(&RTW_CRCOUNT_MAGIC)) {
    sub RTW_CRCOUNT_MAGIC () {	0x4c;}
}
unless(defined(&RTW_CRC16ERR)) {
    sub RTW_CRC16ERR () {	0x7a;}
}
unless(defined(&RTW_BB)) {
    sub RTW_BB () {	0x7c;}
}
unless(defined(&RTW_BB_RD_MASK)) {
    sub RTW_BB_RD_MASK () {	 &BITS(23,16);}
}
unless(defined(&RTW_BB_WR_MASK)) {
    sub RTW_BB_WR_MASK () {	 &BITS(15,8);}
}
unless(defined(&RTW_BB_WREN)) {
    sub RTW_BB_WREN () {	 &BIT(7);}
}
unless(defined(&RTW_BB_ADDR_MASK)) {
    sub RTW_BB_ADDR_MASK () {	 &BITS(6,0);}
}
unless(defined(&RTW_PHYADDR)) {
    sub RTW_PHYADDR () {	0x7c;}
}
unless(defined(&RTW_PHYDATAW)) {
    sub RTW_PHYDATAW () {	0x7d;}
}
unless(defined(&RTW_PHYDATAR)) {
    sub RTW_PHYDATAR () {	0x7e;}
}
unless(defined(&RTW8180_PHYCFG)) {
    sub RTW8180_PHYCFG () {	0x80;}
}
unless(defined(&RTW8180_PHYCFG_MAC_POLL)) {
    sub RTW8180_PHYCFG_MAC_POLL () {	 &BIT(31);}
}
unless(defined(&RTW8180_PHYCFG_HST)) {
    sub RTW8180_PHYCFG_HST () {	 &BIT(30);}
}
unless(defined(&RTW8180_PHYCFG_MAC_RFTYPE_MASK)) {
    sub RTW8180_PHYCFG_MAC_RFTYPE_MASK () {	 &BITS(29,28);}
}
unless(defined(&RTW8180_PHYCFG_MAC_RFTYPE_INTERSIL)) {
    sub RTW8180_PHYCFG_MAC_RFTYPE_INTERSIL () {	 &LSHIFT(0,  &RTW8180_PHYCFG_MAC_RFTYPE_MASK);}
}
unless(defined(&RTW8180_PHYCFG_MAC_RFTYPE_RFMD)) {
    sub RTW8180_PHYCFG_MAC_RFTYPE_RFMD () {	 &LSHIFT(1,  &RTW8180_PHYCFG_MAC_RFTYPE_MASK);}
}
unless(defined(&RTW8180_PHYCFG_MAC_RFTYPE_GCT)) {
    sub RTW8180_PHYCFG_MAC_RFTYPE_GCT () {	 &RTW8180_PHYCFG_MAC_RFTYPE_RFMD;}
}
unless(defined(&RTW8180_PHYCFG_MAC_RFTYPE_PHILIPS)) {
    sub RTW8180_PHYCFG_MAC_RFTYPE_PHILIPS () {	 &LSHIFT(3,  &RTW8180_PHYCFG_MAC_RFTYPE_MASK);}
}
unless(defined(&RTW8180_PHYCFG_MAC_PHILIPS_ADDR_MASK)) {
    sub RTW8180_PHYCFG_MAC_PHILIPS_ADDR_MASK () {	 &BITS(27,24);}
}
unless(defined(&RTW8180_PHYCFG_MAC_PHILIPS_DATA_MASK)) {
    sub RTW8180_PHYCFG_MAC_PHILIPS_DATA_MASK () {	 &BITS(23,0);}
}
unless(defined(&RTW8180_PHYCFG_MAC_MAXIM_LODATA_MASK)) {
    sub RTW8180_PHYCFG_MAC_MAXIM_LODATA_MASK () {	 &BITS(27,24);}
}
unless(defined(&RTW8180_PHYCFG_MAC_MAXIM_ADDR_MASK)) {
    sub RTW8180_PHYCFG_MAC_MAXIM_ADDR_MASK () {	 &BITS(11,8);}
}
unless(defined(&RTW8180_PHYCFG_MAC_MAXIM_HIDATA_MASK)) {
    sub RTW8180_PHYCFG_MAC_MAXIM_HIDATA_MASK () {	 &BITS(7,0);}
}
unless(defined(&RTW8180_PHYCFG_HST_EN)) {
    sub RTW8180_PHYCFG_HST_EN () {	 &BIT(2);}
}
unless(defined(&RTW8180_PHYCFG_HST_CLK)) {
    sub RTW8180_PHYCFG_HST_CLK () {	 &BIT(1);}
}
unless(defined(&RTW8180_PHYCFG_HST_DATA)) {
    sub RTW8180_PHYCFG_HST_DATA () {	 &BIT(0);}
}
unless(defined(&RTW8185_RFPINSOUTPUT)) {
    sub RTW8185_RFPINSOUTPUT () {	0x80;}
}
unless(defined(&RTW8185_RFPINSOUTPUT_MASK)) {
    sub RTW8185_RFPINSOUTPUT_MASK () {	0xfff3;}
}
unless(defined(&RTW8185_RFPINSENABLE)) {
    sub RTW8185_RFPINSENABLE () {	0x82;}
}
unless(defined(&RTW8185_RFPINSENABLE_ENABLE)) {
    sub RTW8185_RFPINSENABLE_ENABLE () {	0x7;}
}
unless(defined(&RTW_MAXIM_HIDATA_MASK)) {
    sub RTW_MAXIM_HIDATA_MASK () {	 &BITS(11,4);}
}
unless(defined(&RTW_MAXIM_LODATA_MASK)) {
    sub RTW_MAXIM_LODATA_MASK () {	 &BITS(3,0);}
}
unless(defined(&RTW_WAKEUP0L)) {
    sub RTW_WAKEUP0L () {	0x84;}
}
unless(defined(&RTW_WAKEUP0H)) {
    sub RTW_WAKEUP0H () {	0x88;}
}
unless(defined(&RTW_WAKEUP1L)) {
    sub RTW_WAKEUP1L () {	0x8c;}
}
unless(defined(&RTW_WAKEUP1H)) {
    sub RTW_WAKEUP1H () {	0x90;}
}
unless(defined(&RTW_WAKEUP2LL)) {
    sub RTW_WAKEUP2LL () {	0x94;}
}
unless(defined(&RTW_WAKEUP2LH)) {
    sub RTW_WAKEUP2LH () {	0x98;}
}
unless(defined(&RTW_WAKEUP2HL)) {
    sub RTW_WAKEUP2HL () {	0x9c;}
}
unless(defined(&RTW_WAKEUP2HH)) {
    sub RTW_WAKEUP2HH () {	0xa0;}
}
unless(defined(&RTW_WAKEUP3LL)) {
    sub RTW_WAKEUP3LL () {	0xa4;}
}
unless(defined(&RTW_WAKEUP3LH)) {
    sub RTW_WAKEUP3LH () {	0xa8;}
}
unless(defined(&RTW_WAKEUP3HL)) {
    sub RTW_WAKEUP3HL () {	0xac;}
}
unless(defined(&RTW_WAKEUP3HH)) {
    sub RTW_WAKEUP3HH () {	0xb0;}
}
unless(defined(&RTW_WAKEUP4LL)) {
    sub RTW_WAKEUP4LL () {	0xb4;}
}
unless(defined(&RTW_WAKEUP4LH)) {
    sub RTW_WAKEUP4LH () {	0xb8;}
}
unless(defined(&RTW_WAKEUP4HL)) {
    sub RTW_WAKEUP4HL () {	0xbc;}
}
unless(defined(&RTW_WAKEUP4HH)) {
    sub RTW_WAKEUP4HH () {	0xc0;}
}
unless(defined(&RTW_CRC0)) {
    sub RTW_CRC0 () {	0xc4;}
}
unless(defined(&RTW_CRC1)) {
    sub RTW_CRC1 () {	0xc6;}
}
unless(defined(&RTW_CRC2)) {
    sub RTW_CRC2 () {	0xc8;}
}
unless(defined(&RTW_CRC3)) {
    sub RTW_CRC3 () {	0xca;}
}
unless(defined(&RTW_CRC4)) {
    sub RTW_CRC4 () {	0xcc;}
}
unless(defined(&RTW8180_DK0)) {
    sub RTW8180_DK0 () {	0x90;}
}
unless(defined(&RTW8180_DK1)) {
    sub RTW8180_DK1 () {	0xa0;}
}
unless(defined(&RTW8180_DK2)) {
    sub RTW8180_DK2 () {	0xb0;}
}
unless(defined(&RTW8180_DK3)) {
    sub RTW8180_DK3 () {	0xc0;}
}
unless(defined(&RTW8185_RFPINSSELECT)) {
    sub RTW8185_RFPINSSELECT () {	0x84;}
}
unless(defined(&RTW8185_RFPINSSELECT_ENABLE)) {
    sub RTW8185_RFPINSSELECT_ENABLE () {	0x7;}
}
unless(defined(&RTW8185_RFPINSINPUT)) {
    sub RTW8185_RFPINSINPUT () {	0x86;}
}
unless(defined(&RTW8185_RFPARA)) {
    sub RTW8185_RFPARA () {	0x88;}
}
unless(defined(&RTW8185_RFTIMING)) {
    sub RTW8185_RFTIMING () {	0x8c;}
}
unless(defined(&RTW8185_GPO)) {
    sub RTW8185_GPO () {	0x90;}
}
unless(defined(&RTW8185_GPE)) {
    sub RTW8185_GPE () {	0x91;}
}
unless(defined(&RTW8185_GPI)) {
    sub RTW8185_GPI () {	0x92;}
}
unless(defined(&RTW8185_TXAGCCTL)) {
    sub RTW8185_TXAGCCTL () {	0x9c;}
}
unless(defined(&RTW8185_CCKTXAGC)) {
    sub RTW8185_CCKTXAGC () {	0x9d;}
}
unless(defined(&RTW8185_OFDMTXAGC)) {
    sub RTW8185_OFDMTXAGC () {	0x9e;}
}
unless(defined(&RTW8185_ANTSEL)) {
    sub RTW8185_ANTSEL () {	0x9f;}
}
unless(defined(&RTW8185_CAMRW)) {
    sub RTW8185_CAMRW () {	0xa0;}
}
unless(defined(&RTW8185_CAMRW_POOLING)) {
    sub RTW8185_CAMRW_POOLING () {	 &BIT(31);}
}
unless(defined(&RTW8185_CAMRW_WRITE)) {
    sub RTW8185_CAMRW_WRITE () {	 &BIT(16);}
}
unless(defined(&RTW8185_CAMRW_ADDRESS)) {
    sub RTW8185_CAMRW_ADDRESS () {	 &BITS(6, 0);}
}
unless(defined(&RTW8185_CAMOUTPUT)) {
    sub RTW8185_CAMOUTPUT () {	0xa4;}
}
unless(defined(&RTW8185_CAMINPUT)) {
    sub RTW8185_CAMINPUT () {	0xa8;}
}
unless(defined(&RTW8185_CAMDEBUG)) {
    sub RTW8185_CAMDEBUG () {	0xac;}
}
unless(defined(&RTW8185_CAMDEBUG_SELTXRXINFO)) {
    sub RTW8185_CAMDEBUG_SELTXRXINFO () {	 &BIT(31);}
}
unless(defined(&RTW8185_CAMDEBUG_KEYFOUND)) {
    sub RTW8185_CAMDEBUG_KEYFOUND () {	 &BIT(30);}
}
unless(defined(&RTW8185_CAMDEBUG_WPACONFIG)) {
    sub RTW8185_CAMDEBUG_WPACONFIG () {	 &BITS(29, 24);}
}
unless(defined(&RTW8185_CAMDEBUG_CAMKEY)) {
    sub RTW8185_CAMDEBUG_CAMKEY () {	 &BITS(23, 0);}
}
unless(defined(&RTW8185_WPACONFIG)) {
    sub RTW8185_WPACONFIG () {	0xb0;}
}
unless(defined(&RTW8185_WPACONFIG_RXWPADUMMY)) {
    sub RTW8185_WPACONFIG_RXWPADUMMY () {	 &BIT(8);}
}
unless(defined(&RTW8185_WPACONFIG_DISRX_AESMIC)) {
    sub RTW8185_WPACONFIG_DISRX_AESMIC () {	 &BIT(3);}
}
unless(defined(&RTW8185_WPACONFIG_RXDECRYPT)) {
    sub RTW8185_WPACONFIG_RXDECRYPT () {	 &BIT(2);}
}
unless(defined(&RTW8185_WPACONFIG_TXENCRYPT)) {
    sub RTW8185_WPACONFIG_TXENCRYPT () {	 &BIT(1);}
}
unless(defined(&RTW8185_WPACONFIG_USEDEFAULTKEY)) {
    sub RTW8185_WPACONFIG_USEDEFAULTKEY () {	 &BIT(0);}
}
unless(defined(&RTW8185_AESMASK)) {
    sub RTW8185_AESMASK () {	0xb2;}
}
unless(defined(&RTW8185_SIFS)) {
    sub RTW8185_SIFS () {	0xb4;}
}
unless(defined(&RTW8185_DIFS)) {
    sub RTW8185_DIFS () {	0xb5;}
}
unless(defined(&RTW8185_SLOTTIME)) {
    sub RTW8185_SLOTTIME () {	0xb6;}
}
unless(defined(&RTW8185_UTUNE)) {
    sub RTW8185_UTUNE () {	0xb7;}
}
unless(defined(&RTW8185_CWCONFIG)) {
    sub RTW8185_CWCONFIG () {	0xbc;}
}
unless(defined(&RTW8185_CWCONFIG_PPRETRYLIMIT)) {
    sub RTW8185_CWCONFIG_PPRETRYLIMIT () {	 &BIT(1);}
}
unless(defined(&RTW8185_CWCONFIG_PPCW)) {
    sub RTW8185_CWCONFIG_PPCW () {	 &BIT(1);}
}
unless(defined(&RTW8185_CWVALUES)) {
    sub RTW8185_CWVALUES () {	0xbd;}
}
unless(defined(&RTW8185_CWVALUES_CWMAX)) {
    sub RTW8185_CWVALUES_CWMAX () {	 &BITS(7, 4);}
}
unless(defined(&RTW8185_CWVALUES_CWMIN)) {
    sub RTW8185_CWVALUES_CWMIN () {	 &BITS(3, 0);}
}
unless(defined(&RTW8185_RATEFALLBACKCTL)) {
    sub RTW8185_RATEFALLBACKCTL () {	0xbe;}
}
unless(defined(&RTW8185_RATEFALLBACKCTL_ENABLE)) {
    sub RTW8185_RATEFALLBACKCTL_ENABLE () {	 &BIT(7);}
}
unless(defined(&RTW8185_RATEFALLBACKCTL_STEP)) {
    sub RTW8185_RATEFALLBACKCTL_STEP () {	 &BITS(1, 0);}
}
unless(defined(&RTW_CONFIG5)) {
    sub RTW_CONFIG5 () {	0xd8;}
}
unless(defined(&RTW_CONFIG5_TXFIFOOK)) {
    sub RTW_CONFIG5_TXFIFOOK () {	 &BIT(7);}
}
unless(defined(&RTW_CONFIG5_RXFIFOOK)) {
    sub RTW_CONFIG5_RXFIFOOK () {	 &BIT(6);}
}
unless(defined(&RTW_CONFIG5_CALON)) {
    sub RTW_CONFIG5_CALON () {	 &BIT(5);}
}
unless(defined(&RTW_CONFIG5_EACPI)) {
    sub RTW_CONFIG5_EACPI () {	 &BIT(2);}
}
unless(defined(&RTW_CONFIG5_LANWAKE)) {
    sub RTW_CONFIG5_LANWAKE () {	 &BIT(1);}
}
unless(defined(&RTW_CONFIG5_PMESTS)) {
    sub RTW_CONFIG5_PMESTS () {	 &BIT(0);}
}
unless(defined(&RTW_TPPOLL)) {
    sub RTW_TPPOLL () {	0xd9;}
}
unless(defined(&RTW_TPPOLL_BQ)) {
    sub RTW_TPPOLL_BQ () {	 &BIT(7);}
}
unless(defined(&RTW_TPPOLL_HPQ)) {
    sub RTW_TPPOLL_HPQ () {	 &BIT(6);}
}
unless(defined(&RTW_TPPOLL_NPQ)) {
    sub RTW_TPPOLL_NPQ () {	 &BIT(5);}
}
unless(defined(&RTW_TPPOLL_LPQ)) {
    sub RTW_TPPOLL_LPQ () {	 &BIT(4);}
}
unless(defined(&RTW_TPPOLL_SBQ)) {
    sub RTW_TPPOLL_SBQ () {	 &BIT(3);}
}
unless(defined(&RTW_TPPOLL_SHPQ)) {
    sub RTW_TPPOLL_SHPQ () {	 &BIT(2);}
}
unless(defined(&RTW_TPPOLL_SNPQ)) {
    sub RTW_TPPOLL_SNPQ () {	 &BIT(1);}
}
unless(defined(&RTW_TPPOLL_SLPQ)) {
    sub RTW_TPPOLL_SLPQ () {	 &BIT(0);}
}
unless(defined(&RTW_TPPOLL_ALL)) {
    sub RTW_TPPOLL_ALL () {	( &RTW_TPPOLL_BQ |  &RTW_TPPOLL_HPQ |  &RTW_TPPOLL_NPQ |  &RTW_TPPOLL_LPQ);}
}
unless(defined(&RTW_TPPOLL_SALL)) {
    sub RTW_TPPOLL_SALL () {	( &RTW_TPPOLL_SBQ |  &RTW_TPPOLL_SHPQ |  &RTW_TPPOLL_SNPQ |  &RTW_TPPOLL_SLPQ);}
}
unless(defined(&RTW_CWR)) {
    sub RTW_CWR () {	0xdc;}
}
unless(defined(&RTW_CWR_CW)) {
    sub RTW_CWR_CW () {	 &BITS(9,0);}
}
unless(defined(&RTW_RETRYCTR)) {
    sub RTW_RETRYCTR () {	0xde;}
}
unless(defined(&RTW_RETRYCTR_RETRYCT)) {
    sub RTW_RETRYCTR_RETRYCT () {	 &BITS(7,0);}
}
unless(defined(&RTW_RDSAR)) {
    sub RTW_RDSAR () {	0xe4;}
}
unless(defined(&RTW_FER)) {
    sub RTW_FER () {	0xf0;}
}
unless(defined(&RTW_FER_INTR)) {
    sub RTW_FER_INTR () {	 &BIT(15);}
}
unless(defined(&RTW_FER_GWAKE)) {
    sub RTW_FER_GWAKE () {	 &BIT(4);}
}
unless(defined(&RTW_FEMR)) {
    sub RTW_FEMR () {	0xf4;}
}
unless(defined(&RTW_FEMR_INTR)) {
    sub RTW_FEMR_INTR () {	 &BIT(15);}
}
unless(defined(&RTW_FEMR_WKUP)) {
    sub RTW_FEMR_WKUP () {	 &BIT(14);}
}
unless(defined(&RTW_FEMR_GWAKE)) {
    sub RTW_FEMR_GWAKE () {	 &BIT(4);}
}
unless(defined(&RTW_FPSR)) {
    sub RTW_FPSR () {	0xf8;}
}
unless(defined(&RTW_FPSR_INTR)) {
    sub RTW_FPSR_INTR () {	 &BIT(15);}
}
unless(defined(&RTW_FPSR_GWAKE)) {
    sub RTW_FPSR_GWAKE () {	 &BIT(4);}
}
unless(defined(&RTW_FFER)) {
    sub RTW_FFER () {	0xfc;}
}
unless(defined(&RTW_FFER_INTR)) {
    sub RTW_FFER_INTR () {	 &BIT(15);}
}
unless(defined(&RTW_FFER_GWAKE)) {
    sub RTW_FFER_GWAKE () {	 &BIT(4);}
}
unless(defined(&RTW_SR_ID)) {
    sub RTW_SR_ID () {	0x;}
}
unless(defined(&RTW_SR_VID)) {
    sub RTW_SR_VID () {	0x2;}
}
unless(defined(&RTW_SR_DID)) {
    sub RTW_SR_DID () {	0x4;}
}
unless(defined(&RTW_SR_SVID)) {
    sub RTW_SR_SVID () {	0x6;}
}
unless(defined(&RTW_SR_SMID)) {
    sub RTW_SR_SMID () {	0x8;}
}
unless(defined(&RTW_SR_MNGNT)) {
    sub RTW_SR_MNGNT () {	0xa;}
}
unless(defined(&RTW_SR_MXLAT)) {
    sub RTW_SR_MXLAT () {	0xb;}
}
unless(defined(&RTW_SR_RFCHIPID)) {
    sub RTW_SR_RFCHIPID () {	0xc;}
}
unless(defined(&RTW_SR_CONFIG3)) {
    sub RTW_SR_CONFIG3 () {	0xd;}
}
unless(defined(&RTW_SR_MAC)) {
    sub RTW_SR_MAC () {	0xe;}
}
unless(defined(&RTW_SR_CONFIG0)) {
    sub RTW_SR_CONFIG0 () {	0x14;}
}
unless(defined(&RTW_SR_CONFIG1)) {
    sub RTW_SR_CONFIG1 () {	0x15;}
}
unless(defined(&RTW_SR_PMC)) {
    sub RTW_SR_PMC () {	0x16;}
}
unless(defined(&RTW_SR_CONFIG2)) {
    sub RTW_SR_CONFIG2 () {	0x18;}
}
unless(defined(&RTW_SR_CONFIG4)) {
    sub RTW_SR_CONFIG4 () {	0x19;}
}
unless(defined(&RTW_SR_ANAPARM)) {
    sub RTW_SR_ANAPARM () {	0x1a;}
}
unless(defined(&RTW_SR_TESTR)) {
    sub RTW_SR_TESTR () {	0x1e;}
}
unless(defined(&RTW_SR_CONFIG5)) {
    sub RTW_SR_CONFIG5 () {	0x1f;}
}
unless(defined(&RTW_SR_TXPOWER1)) {
    sub RTW_SR_TXPOWER1 () {	0x20;}
}
unless(defined(&RTW_SR_TXPOWER2)) {
    sub RTW_SR_TXPOWER2 () {	0x21;}
}
unless(defined(&RTW_SR_TXPOWER3)) {
    sub RTW_SR_TXPOWER3 () {	0x22;}
}
unless(defined(&RTW_SR_TXPOWER4)) {
    sub RTW_SR_TXPOWER4 () {	0x23;}
}
unless(defined(&RTW_SR_TXPOWER5)) {
    sub RTW_SR_TXPOWER5 () {	0x24;}
}
unless(defined(&RTW_SR_TXPOWER6)) {
    sub RTW_SR_TXPOWER6 () {	0x25;}
}
unless(defined(&RTW_SR_TXPOWER7)) {
    sub RTW_SR_TXPOWER7 () {	0x26;}
}
unless(defined(&RTW_SR_TXPOWER8)) {
    sub RTW_SR_TXPOWER8 () {	0x27;}
}
unless(defined(&RTW_SR_TXPOWER9)) {
    sub RTW_SR_TXPOWER9 () {	0x28;}
}
unless(defined(&RTW_SR_TXPOWER10)) {
    sub RTW_SR_TXPOWER10 () {	0x29;}
}
unless(defined(&RTW_SR_TXPOWER11)) {
    sub RTW_SR_TXPOWER11 () {	0x2a;}
}
unless(defined(&RTW_SR_TXPOWER12)) {
    sub RTW_SR_TXPOWER12 () {	0x2b;}
}
unless(defined(&RTW_SR_TXPOWER13)) {
    sub RTW_SR_TXPOWER13 () {	0x2c;}
}
unless(defined(&RTW_SR_TXPOWER14)) {
    sub RTW_SR_TXPOWER14 () {	0x2d;}
}
unless(defined(&RTW_SR_CHANNELPLAN)) {
    sub RTW_SR_CHANNELPLAN () {	0x2e;}
}
unless(defined(&RTW_SR_ENERGYDETTHR)) {
    sub RTW_SR_ENERGYDETTHR () {	0x2f;}
}
unless(defined(&RTW_SR_ENERGYDETTHR_DEFAULT)) {
    sub RTW_SR_ENERGYDETTHR_DEFAULT () {	0xc;}
}
unless(defined(&RTW_SR_CISPOINTER)) {
    sub RTW_SR_CISPOINTER () {	0x30;}
}
unless(defined(&RTW_SR_RFPARM)) {
    sub RTW_SR_RFPARM () {	0x32;}
}
unless(defined(&RTW_SR_RFPARM_DIGPHY)) {
    sub RTW_SR_RFPARM_DIGPHY () {	 &BIT(0);}
}
unless(defined(&RTW_SR_RFPARM_DFLANTB)) {
    sub RTW_SR_RFPARM_DFLANTB () {	 &BIT(1);}
}
unless(defined(&RTW_SR_RFPARM_CS_MASK)) {
    sub RTW_SR_RFPARM_CS_MASK () {	 &BITS(2,3);}
}
unless(defined(&RTW_SR_VERSION)) {
    sub RTW_SR_VERSION () {	0x3c;}
}
unless(defined(&RTW_SR_CRC)) {
    sub RTW_SR_CRC () {	0x3e;}
}
unless(defined(&RTW_SR_VPD)) {
    sub RTW_SR_VPD () {	0x40;}
}
unless(defined(&RTW_SR_CIS)) {
    sub RTW_SR_CIS () {	0x80;}
}
unless(defined(&RTW_DESC_ALIGNMENT)) {
    sub RTW_DESC_ALIGNMENT () {	256;}
}
unless(defined(&td_stat)) {
    sub td_stat () {	 &td_ctl0;}
}
unless(defined(&RTW_TXCTL0_OWN)) {
    sub RTW_TXCTL0_OWN () {	 &BIT(31);}
}
unless(defined(&RTW_TXCTL0_RSVD0)) {
    sub RTW_TXCTL0_RSVD0 () {	 &BIT(30);}
}
unless(defined(&RTW_TXCTL0_FS)) {
    sub RTW_TXCTL0_FS () {	 &BIT(29);}
}
unless(defined(&RTW_TXCTL0_LS)) {
    sub RTW_TXCTL0_LS () {	 &BIT(28);}
}
unless(defined(&RTW_TXCTL0_RATE_MASK)) {
    sub RTW_TXCTL0_RATE_MASK () {	 &BITS(27,24);}
}
unless(defined(&RTW_TXCTL0_RATE_1MBPS)) {
    sub RTW_TXCTL0_RATE_1MBPS () {	 &LSHIFT(0,  &RTW_TXCTL0_RATE_MASK);}
}
unless(defined(&RTW_TXCTL0_RATE_2MBPS)) {
    sub RTW_TXCTL0_RATE_2MBPS () {	 &LSHIFT(1,  &RTW_TXCTL0_RATE_MASK);}
}
unless(defined(&RTW_TXCTL0_RATE_5MBPS)) {
    sub RTW_TXCTL0_RATE_5MBPS () {	 &LSHIFT(2,  &RTW_TXCTL0_RATE_MASK);}
}
unless(defined(&RTW_TXCTL0_RATE_11MBPS)) {
    sub RTW_TXCTL0_RATE_11MBPS () {	 &LSHIFT(3,  &RTW_TXCTL0_RATE_MASK);}
}
unless(defined(&RTW_TXCTL0_RTSEN)) {
    sub RTW_TXCTL0_RTSEN () {	 &BIT(23);}
}
unless(defined(&RTW_TXCTL0_RTSRATE_MASK)) {
    sub RTW_TXCTL0_RTSRATE_MASK () {	 &BITS(22,19);}
}
unless(defined(&RTW_TXCTL0_RTSRATE_1MBPS)) {
    sub RTW_TXCTL0_RTSRATE_1MBPS () {	 &LSHIFT(0,  &RTW_TXCTL0_RTSRATE_MASK);}
}
unless(defined(&RTW_TXCTL0_RTSRATE_2MBPS)) {
    sub RTW_TXCTL0_RTSRATE_2MBPS () {	 &LSHIFT(1,  &RTW_TXCTL0_RTSRATE_MASK);}
}
unless(defined(&RTW_TXCTL0_RTSRATE_5MBPS)) {
    sub RTW_TXCTL0_RTSRATE_5MBPS () {	 &LSHIFT(2,  &RTW_TXCTL0_RTSRATE_MASK);}
}
unless(defined(&RTW_TXCTL0_RTSRATE_11MBPS)) {
    sub RTW_TXCTL0_RTSRATE_11MBPS () {	 &LSHIFT(3,  &RTW_TXCTL0_RTSRATE_MASK);}
}
unless(defined(&RTW_TXCTL0_BEACON)) {
    sub RTW_TXCTL0_BEACON () {	 &BIT(18);}
}
unless(defined(&RTW_TXCTL0_MOREFRAG)) {
    sub RTW_TXCTL0_MOREFRAG () {	 &BIT(17);}
}
unless(defined(&RTW_TXCTL0_SPLCP)) {
    sub RTW_TXCTL0_SPLCP () {	 &BIT(16);}
}
unless(defined(&RTW_TXCTL0_KEYID_MASK)) {
    sub RTW_TXCTL0_KEYID_MASK () {	 &BITS(15,14);}
}
unless(defined(&RTW_TXCTL0_RSVD1_MASK)) {
    sub RTW_TXCTL0_RSVD1_MASK () {	 &BITS(13,12);}
}
unless(defined(&RTW_TXCTL0_TPKTSIZE_MASK)) {
    sub RTW_TXCTL0_TPKTSIZE_MASK () {	 &BITS(11,0);}
}
unless(defined(&RTW_TXSTAT_OWN)) {
    sub RTW_TXSTAT_OWN () {	 &RTW_TXCTL0_OWN;}
}
unless(defined(&RTW_TXSTAT_RSVD0)) {
    sub RTW_TXSTAT_RSVD0 () {	 &RTW_TXCTL0_RSVD0;}
}
unless(defined(&RTW_TXSTAT_FS)) {
    sub RTW_TXSTAT_FS () {	 &RTW_TXCTL0_FS;}
}
unless(defined(&RTW_TXSTAT_LS)) {
    sub RTW_TXSTAT_LS () {	 &RTW_TXCTL0_LS;}
}
unless(defined(&RTW_TXSTAT_RSVD1_MASK)) {
    sub RTW_TXSTAT_RSVD1_MASK () {	 &BITS(27,16);}
}
unless(defined(&RTW_TXSTAT_TOK)) {
    sub RTW_TXSTAT_TOK () {	 &BIT(15);}
}
unless(defined(&RTW_TXSTAT_RTSRETRY_MASK)) {
    sub RTW_TXSTAT_RTSRETRY_MASK () {	 &BITS(14,8);}
}
unless(defined(&RTW_TXSTAT_DRC_MASK)) {
    sub RTW_TXSTAT_DRC_MASK () {	 &BITS(7,0);}
}
unless(defined(&RTW_TXCTL1_LENGEXT)) {
    sub RTW_TXCTL1_LENGEXT () {	 &BIT(31);}
}
unless(defined(&RTW_TXCTL1_LENGTH_MASK)) {
    sub RTW_TXCTL1_LENGTH_MASK () {	 &BITS(30,16);}
}
unless(defined(&RTW_TXCTL1_RTSDUR_MASK)) {
    sub RTW_TXCTL1_RTSDUR_MASK () {	 &BITS(15,0);}
}
unless(defined(&RTW_TXLEN_LENGTH_MASK)) {
    sub RTW_TXLEN_LENGTH_MASK () {	 &BITS(11,0);}
}
unless(defined(&rd_stat)) {
    sub rd_stat () {	 &rd_ctl;}
}
unless(defined(&rd_rssi)) {
    sub rd_rssi () {	 &rd_rsvd0;}
}
unless(defined(&rd_tsftl)) {
    sub rd_tsftl () {	 &rd_buf;}
}
unless(defined(&rd_tsfth)) {
    sub rd_tsfth () {	 &rd_rsvd1;}
}
unless(defined(&RTW_RXCTL_OWN)) {
    sub RTW_RXCTL_OWN () {	 &BIT(31);}
}
unless(defined(&RTW_RXCTL_EOR)) {
    sub RTW_RXCTL_EOR () {	 &BIT(30);}
}
unless(defined(&RTW_RXCTL_FS)) {
    sub RTW_RXCTL_FS () {	 &BIT(29);}
}
unless(defined(&RTW_RXCTL_LS)) {
    sub RTW_RXCTL_LS () {	 &BIT(28);}
}
unless(defined(&RTW_RXCTL_RSVD0_MASK)) {
    sub RTW_RXCTL_RSVD0_MASK () {	 &BITS(29,12);}
}
unless(defined(&RTW_RXCTL_LENGTH_MASK)) {
    sub RTW_RXCTL_LENGTH_MASK () {	 &BITS(11,0);}
}
unless(defined(&RTW_RXSTAT_OWN)) {
    sub RTW_RXSTAT_OWN () {	 &RTW_RXCTL_OWN;}
}
unless(defined(&RTW_RXSTAT_EOR)) {
    sub RTW_RXSTAT_EOR () {	 &RTW_RXCTL_EOR;}
}
unless(defined(&RTW_RXSTAT_FS)) {
    sub RTW_RXSTAT_FS () {	 &RTW_RXCTL_FS;}
}
unless(defined(&RTW_RXSTAT_LS)) {
    sub RTW_RXSTAT_LS () {	 &RTW_RXCTL_LS;}
}
unless(defined(&RTW_RXSTAT_DMAFAIL)) {
    sub RTW_RXSTAT_DMAFAIL () {	 &BIT(27);}
}
unless(defined(&RTW_RXSTAT_BOVF)) {
    sub RTW_RXSTAT_BOVF () {	 &BIT(26);}
}
unless(defined(&RTW_RXSTAT_SPLCP)) {
    sub RTW_RXSTAT_SPLCP () {	 &BIT(25);}
}
unless(defined(&RTW_RXSTAT_RSVD1)) {
    sub RTW_RXSTAT_RSVD1 () {	 &BIT(24);}
}
unless(defined(&RTW_RXSTAT_RATE_MASK)) {
    sub RTW_RXSTAT_RATE_MASK () {	 &BITS(23,20);}
}
unless(defined(&RTW_RXSTAT_RATE_1MBPS)) {
    sub RTW_RXSTAT_RATE_1MBPS () {	 &LSHIFT(0,  &RTW_RXSTAT_RATE_MASK);}
}
unless(defined(&RTW_RXSTAT_RATE_2MBPS)) {
    sub RTW_RXSTAT_RATE_2MBPS () {	 &LSHIFT(1,  &RTW_RXSTAT_RATE_MASK);}
}
unless(defined(&RTW_RXSTAT_RATE_5MBPS)) {
    sub RTW_RXSTAT_RATE_5MBPS () {	 &LSHIFT(2,  &RTW_RXSTAT_RATE_MASK);}
}
unless(defined(&RTW_RXSTAT_RATE_11MBPS)) {
    sub RTW_RXSTAT_RATE_11MBPS () {	 &LSHIFT(3,  &RTW_RXSTAT_RATE_MASK);}
}
unless(defined(&RTW_RXSTAT_MIC)) {
    sub RTW_RXSTAT_MIC () {	 &BIT(19);}
}
unless(defined(&RTW_RXSTAT_MAR)) {
    sub RTW_RXSTAT_MAR () {	 &BIT(18);}
}
unless(defined(&RTW_RXSTAT_PAR)) {
    sub RTW_RXSTAT_PAR () {	 &BIT(17);}
}
unless(defined(&RTW_RXSTAT_BAR)) {
    sub RTW_RXSTAT_BAR () {	 &BIT(16);}
}
unless(defined(&RTW_RXSTAT_RES)) {
    sub RTW_RXSTAT_RES () {	 &BIT(15);}
}
unless(defined(&RTW_RXSTAT_PWRMGT)) {
    sub RTW_RXSTAT_PWRMGT () {	 &BIT(14);}
}
unless(defined(&RTW_RXSTAT_CRC16)) {
    sub RTW_RXSTAT_CRC16 () {	 &BIT(14);}
}
unless(defined(&RTW_RXSTAT_CRC32)) {
    sub RTW_RXSTAT_CRC32 () {	 &BIT(13);}
}
unless(defined(&RTW_RXSTAT_ICV)) {
    sub RTW_RXSTAT_ICV () {	 &BIT(12);}
}
unless(defined(&RTW_RXSTAT_LENGTH_MASK)) {
    sub RTW_RXSTAT_LENGTH_MASK () {	 &BITS(11,0);}
}
unless(defined(&RTW_RXSTAT_ONESEG)) {
    sub RTW_RXSTAT_ONESEG () {	( &RTW_RXSTAT_FS| &RTW_RXSTAT_LS);}
}
unless(defined(&RTW_RXSTAT_IOERROR)) {
    sub RTW_RXSTAT_IOERROR () {	( &RTW_RXSTAT_DMAFAIL| &RTW_RXSTAT_BOVF);}
}
unless(defined(&RTW_RXSTAT_DEBUG)) {
    sub RTW_RXSTAT_DEBUG () {	( &RTW_RXSTAT_SPLCP| &RTW_RXSTAT_MAR|  &RTW_RXSTAT_PAR| &RTW_RXSTAT_BAR|  &RTW_RXSTAT_PWRMGT| &RTW_RXSTAT_CRC32|  &RTW_RXSTAT_ICV);}
}
unless(defined(&RTW_RXRSSI_VLAN)) {
    sub RTW_RXRSSI_VLAN () {	 &BITS(32,16);}
}
unless(defined(&RTW_RXRSSI_RSSI)) {
    sub RTW_RXRSSI_RSSI () {	 &BITS(15,8);}
}
unless(defined(&RTW_RXRSSI_IMR_RSSI)) {
    sub RTW_RXRSSI_IMR_RSSI () {	 &BITS(15,9);}
}
unless(defined(&RTW_RXRSSI_IMR_LNA)) {
    sub RTW_RXRSSI_IMR_LNA () {	 &BIT(8);}
}
unless(defined(&RTW_RXRSSI_SQ)) {
    sub RTW_RXRSSI_SQ () {	 &BITS(7,0);}
}
unless(defined(&RTW_READ8)) {
    sub RTW_READ8 {
	local($regs, $ofs) = @_;
	eval q( &bus_space_read_1(($regs)-> &r_bt, ($regs)-> &r_bh, ($ofs)));
    }
}
unless(defined(&RTW_READ16)) {
    sub RTW_READ16 {
	local($regs, $ofs) = @_;
	eval q( &bus_space_read_2(($regs)-> &r_bt, ($regs)-> &r_bh, ($ofs)));
    }
}
unless(defined(&RTW_READ)) {
    sub RTW_READ {
	local($regs, $ofs) = @_;
	eval q( &bus_space_read_4(($regs)-> &r_bt, ($regs)-> &r_bh, ($ofs)));
    }
}
unless(defined(&RTW_WRITE8)) {
    sub RTW_WRITE8 {
	local($regs, $ofs, $val) = @_;
	eval q( &bus_space_write_1(($regs)-> &r_bt, ($regs)-> &r_bh, ($ofs), ($val)));
    }
}
unless(defined(&RTW_WRITE16)) {
    sub RTW_WRITE16 {
	local($regs, $ofs, $val) = @_;
	eval q( &bus_space_write_2(($regs)-> &r_bt, ($regs)-> &r_bh, ($ofs), ($val)));
    }
}
unless(defined(&RTW_WRITE)) {
    sub RTW_WRITE {
	local($regs, $ofs, $val) = @_;
	eval q( &bus_space_write_4(($regs)-> &r_bt, ($regs)-> &r_bh, ($ofs), ($val)));
    }
}
unless(defined(&RTW_ISSET)) {
    sub RTW_ISSET {
	local($regs, $reg, $mask) = @_;
	eval q(( &RTW_READ(($regs), ($reg)) & ($mask)));
    }
}
unless(defined(&RTW_CLR)) {
    sub RTW_CLR {
	local($regs, $reg, $mask) = @_;
	eval q( &RTW_WRITE(($regs), ($reg),  &RTW_READ(($regs), ($reg)) & ~($mask)));
    }
}
unless(defined(&BUS_SPACE_BARRIER_SYNC)) {
    eval 'sub BUS_SPACE_BARRIER_SYNC () {( &BUS_SPACE_BARRIER_READ| &BUS_SPACE_BARRIER_WRITE);}' unless defined(&BUS_SPACE_BARRIER_SYNC);
}
unless(defined(&BUS_SPACE_BARRIER_READ_BEFORE_READ)) {
    eval 'sub BUS_SPACE_BARRIER_READ_BEFORE_READ () { &BUS_SPACE_BARRIER_READ;}' unless defined(&BUS_SPACE_BARRIER_READ_BEFORE_READ);
}
unless(defined(&BUS_SPACE_BARRIER_READ_BEFORE_WRITE)) {
    eval 'sub BUS_SPACE_BARRIER_READ_BEFORE_WRITE () { &BUS_SPACE_BARRIER_READ;}' unless defined(&BUS_SPACE_BARRIER_READ_BEFORE_WRITE);
}
unless(defined(&BUS_SPACE_BARRIER_WRITE_BEFORE_READ)) {
    eval 'sub BUS_SPACE_BARRIER_WRITE_BEFORE_READ () { &BUS_SPACE_BARRIER_WRITE;}' unless defined(&BUS_SPACE_BARRIER_WRITE_BEFORE_READ);
}
unless(defined(&BUS_SPACE_BARRIER_WRITE_BEFORE_WRITE)) {
    eval 'sub BUS_SPACE_BARRIER_WRITE_BEFORE_WRITE () { &BUS_SPACE_BARRIER_WRITE;}' unless defined(&BUS_SPACE_BARRIER_WRITE_BEFORE_WRITE);
}
unless(defined(&RTW_BARRIER)) {
    sub RTW_BARRIER {
	local($regs, $reg0, $reg1, $flags) = @_;
	eval q( &bus_space_barrier(($regs)-> &r_bh, ($regs)-> &r_bt,  &MIN($reg0, $reg1),  &MAX($reg0, $reg1) -  &MIN($reg0, $reg1) + 4, $flags));
    }
}
unless(defined(&RTW_SYNC)) {
    sub RTW_SYNC {
	local($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_SYNC));
    }
}
unless(defined(&RTW_WBW)) {
    sub RTW_WBW {
	local($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_WRITE_BEFORE_WRITE));
    }
}
unless(defined(&RTW_WBR)) {
    sub RTW_WBR {
	local($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_WRITE_BEFORE_READ));
    }
}
unless(defined(&RTW_RBR)) {
    sub RTW_RBR {
	local($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_READ_BEFORE_READ));
    }
}
unless(defined(&RTW_RBW)) {
    sub RTW_RBW {
	local($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_READ_BEFORE_WRITE));
    }
}
unless(defined(&RTW_WBRW)) {
    sub RTW_WBRW {
	local($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_WRITE_BEFORE_READ |  &BUS_SPACE_BARRIER_WRITE_BEFORE_WRITE));
    }
}
unless(defined(&RTW_BBP_SYS1)) {
    sub RTW_BBP_SYS1 () {	0x;}
}
unless(defined(&RTW_BBP_TXAGC)) {
    sub RTW_BBP_TXAGC () {	0x3;}
}
unless(defined(&RTW_BBP_LNADET)) {
    sub RTW_BBP_LNADET () {	0x4;}
}
unless(defined(&RTW_BBP_IFAGCINI)) {
    sub RTW_BBP_IFAGCINI () {	0x5;}
}
unless(defined(&RTW_BBP_IFAGCLIMIT)) {
    sub RTW_BBP_IFAGCLIMIT () {	0x6;}
}
unless(defined(&RTW_BBP_IFAGCDET)) {
    sub RTW_BBP_IFAGCDET () {	0x7;}
}
unless(defined(&RTW_BBP_ANTATTEN)) {
    sub RTW_BBP_ANTATTEN () {	0x10;}
}
unless(defined(&RTW_BBP_ANTATTEN_PHILIPS_MAGIC)) {
    sub RTW_BBP_ANTATTEN_PHILIPS_MAGIC () {	0x91;}
}
unless(defined(&RTW_BBP_ANTATTEN_INTERSIL_MAGIC)) {
    sub RTW_BBP_ANTATTEN_INTERSIL_MAGIC () {	0x92;}
}
unless(defined(&RTW_BBP_ANTATTEN_RFMD_MAGIC)) {
    sub RTW_BBP_ANTATTEN_RFMD_MAGIC () {	0x93;}
}
unless(defined(&RTW_BBP_ANTATTEN_MAXIM_MAGIC)) {
    sub RTW_BBP_ANTATTEN_MAXIM_MAGIC () {	0xb3;}
}
unless(defined(&RTW_BBP_ANTATTEN_DFLANTB)) {
    sub RTW_BBP_ANTATTEN_DFLANTB () {	0x40;}
}
unless(defined(&RTW_BBP_ANTATTEN_CHAN14)) {
    sub RTW_BBP_ANTATTEN_CHAN14 () {	0xc;}
}
unless(defined(&RTW_BBP_TRL)) {
    sub RTW_BBP_TRL () {	0x11;}
}
unless(defined(&RTW_BBP_SYS2)) {
    sub RTW_BBP_SYS2 () {	0x12;}
}
unless(defined(&RTW_BBP_SYS2_ANTDIV)) {
    sub RTW_BBP_SYS2_ANTDIV () {	0x80;}
}
unless(defined(&RTW_BBP_SYS2_RATE_MASK)) {
    sub RTW_BBP_SYS2_RATE_MASK () {	 &BITS(5,4);}
}
unless(defined(&RTW_BBP_SYS3)) {
    sub RTW_BBP_SYS3 () {	0x13;}
}
unless(defined(&RTW_BBP_SYS3_CSTHRESH_MASK)) {
    sub RTW_BBP_SYS3_CSTHRESH_MASK () {	 &BITS(0,3);}
}
unless(defined(&RTW_BBP_CHESTLIM)) {
    sub RTW_BBP_CHESTLIM () {	0x19;}
}
unless(defined(&RTW_BBP_CHSQLIM)) {
    sub RTW_BBP_CHSQLIM () {	0x1a;}
}
1;
