require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_AR5K_H)) {
    eval 'sub _AR5K_H () {1;}' unless defined(&_AR5K_H);
    require 'sys/param.ph';
    require 'sys/systm.ph';
    require 'sys/sysctl.ph';
    require 'sys/malloc.ph';
    require 'sys/lock.ph';
    require 'sys/kernel.ph';
    require 'sys/socket.ph';
    require 'sys/sockio.ph';
    require 'sys/errno.ph';
    require 'machine/endian.ph';
    require 'machine/bus.ph';
    require 'net/if.ph';
    require 'net/if_dl.ph';
    require 'net/if_media.ph';
    require 'net/if_arp.ph';
    require 'net/if_llc.ph';
    if(defined(&INET)) {
	require 'netinet/in.ph';
	require 'netinet/if_ether.ph';
    }
    require 'net80211/ieee80211_var.ph';
    require 'net80211/ieee80211_compat.ph';
    require 'net80211/ieee80211_radiotap.ph';
    require 'net80211/ieee80211_regdomain.ph';
    eval("sub AR5K_AR5210 () { 0; }") unless defined(&AR5K_AR5210);
    eval("sub AR5K_AR5211 () { 1; }") unless defined(&AR5K_AR5211);
    eval("sub AR5K_AR5212 () { 2; }") unless defined(&AR5K_AR5212);
    eval("sub AR5K_AR5110 () { 0; }") unless defined(&AR5K_AR5110);
    eval("sub AR5K_AR5111 () { 1; }") unless defined(&AR5K_AR5111);
    eval("sub AR5K_AR5112 () { 2; }") unless defined(&AR5K_AR5112);
    eval("sub AH_FALSE () { 0; }") unless defined(&AH_FALSE);
    eval("sub AH_TRUE () { 1; }") unless defined(&AH_TRUE);
    eval("sub HAL_MODE_11A () { 0x001; }") unless defined(&HAL_MODE_11A);
    eval("sub HAL_MODE_TURBO () { 0x002; }") unless defined(&HAL_MODE_TURBO);
    eval("sub HAL_MODE_11B () { 0x004; }") unless defined(&HAL_MODE_11B);
    eval("sub HAL_MODE_PUREG () { 0x008; }") unless defined(&HAL_MODE_PUREG);
    eval("sub HAL_MODE_11G () { 0x010; }") unless defined(&HAL_MODE_11G);
    eval("sub HAL_MODE_108G () { 0x020; }") unless defined(&HAL_MODE_108G);
    eval("sub HAL_MODE_XR () { 0x040; }") unless defined(&HAL_MODE_XR);
    eval("sub HAL_MODE_ALL () { 0xfff; }") unless defined(&HAL_MODE_ALL);
    eval("sub HAL_ANT_VARIABLE () { 0; }") unless defined(&HAL_ANT_VARIABLE);
    eval("sub HAL_ANT_FIXED_A () { 1; }") unless defined(&HAL_ANT_FIXED_A);
    eval("sub HAL_ANT_FIXED_B () { 2; }") unless defined(&HAL_ANT_FIXED_B);
    eval("sub HAL_ANT_MAX () { 3; }") unless defined(&HAL_ANT_MAX);
    eval("sub HAL_M_STA () { 1; }") unless defined(&HAL_M_STA);
    eval("sub HAL_M_IBSS () { 0; }") unless defined(&HAL_M_IBSS);
    eval("sub HAL_M_HOSTAP () { 6; }") unless defined(&HAL_M_HOSTAP);
    eval("sub HAL_M_MONITOR () { 8; }") unless defined(&HAL_M_MONITOR);
    eval 'sub HAL_OK () {0;}' unless defined(&HAL_OK);
    eval 'sub HAL_EINPROGRESS () { &EINPROGRESS;}' unless defined(&HAL_EINPROGRESS);
    eval("sub HAL_TX_QUEUE_INACTIVE () { 0; }") unless defined(&HAL_TX_QUEUE_INACTIVE);
    eval("sub HAL_TX_QUEUE_DATA () { 1; }") unless defined(&HAL_TX_QUEUE_DATA);
    eval("sub HAL_TX_QUEUE_BEACON () { 2; }") unless defined(&HAL_TX_QUEUE_BEACON);
    eval("sub HAL_TX_QUEUE_CAB () { 3; }") unless defined(&HAL_TX_QUEUE_CAB);
    eval("sub HAL_TX_QUEUE_PSPOLL () { 4; }") unless defined(&HAL_TX_QUEUE_PSPOLL);
    eval 'sub HAL_NUM_TX_QUEUES () {10;}' unless defined(&HAL_NUM_TX_QUEUES);
    eval("sub HAL_TX_QUEUE_ID_DATA_MIN () { 0; }") unless defined(&HAL_TX_QUEUE_ID_DATA_MIN);
    eval("sub HAL_TX_QUEUE_ID_DATA_MAX () { 6; }") unless defined(&HAL_TX_QUEUE_ID_DATA_MAX);
    eval("sub HAL_TX_QUEUE_ID_PSPOLL () { 7; }") unless defined(&HAL_TX_QUEUE_ID_PSPOLL);
    eval("sub HAL_TX_QUEUE_ID_BEACON () { 8; }") unless defined(&HAL_TX_QUEUE_ID_BEACON);
    eval("sub HAL_TX_QUEUE_ID_CAB () { 9; }") unless defined(&HAL_TX_QUEUE_ID_CAB);
    eval("sub HAL_WME_AC_BK () { 0; }") unless defined(&HAL_WME_AC_BK);
    eval("sub HAL_WME_AC_BE () { 1; }") unless defined(&HAL_WME_AC_BE);
    eval("sub HAL_WME_AC_VI () { 2; }") unless defined(&HAL_WME_AC_VI);
    eval("sub HAL_WME_AC_VO () { 3; }") unless defined(&HAL_WME_AC_VO);
    eval("sub HAL_WME_UPSD () { 4; }") unless defined(&HAL_WME_UPSD);
    eval 'sub AR5K_TXQ_FLAG_TXINT_ENABLE () {0x1;}' unless defined(&AR5K_TXQ_FLAG_TXINT_ENABLE);
    eval 'sub AR5K_TXQ_FLAG_TXDESCINT_ENABLE () {0x2;}' unless defined(&AR5K_TXQ_FLAG_TXDESCINT_ENABLE);
    eval 'sub AR5K_TXQ_FLAG_BACKOFF_DISABLE () {0x4;}' unless defined(&AR5K_TXQ_FLAG_BACKOFF_DISABLE);
    eval 'sub AR5K_TXQ_FLAG_COMPRESSION_ENABLE () {0x8;}' unless defined(&AR5K_TXQ_FLAG_COMPRESSION_ENABLE);
    eval 'sub AR5K_TXQ_FLAG_RDYTIME_EXP_POLICY_ENABLE () {0x10;}' unless defined(&AR5K_TXQ_FLAG_RDYTIME_EXP_POLICY_ENABLE);
    eval 'sub AR5K_TXQ_FLAG_FRAG_BURST_BACKOFF_ENABLE () {0x20;}' unless defined(&AR5K_TXQ_FLAG_FRAG_BURST_BACKOFF_ENABLE);
    eval 'sub AR5K_TXQ_FLAG_POST_FR_BKOFF_DIS () {0x40;}' unless defined(&AR5K_TXQ_FLAG_POST_FR_BKOFF_DIS);
    eval("sub HAL_PKT_TYPE_NORMAL () { 0; }") unless defined(&HAL_PKT_TYPE_NORMAL);
    eval("sub HAL_PKT_TYPE_ATIM () { 1; }") unless defined(&HAL_PKT_TYPE_ATIM);
    eval("sub HAL_PKT_TYPE_PSPOLL () { 2; }") unless defined(&HAL_PKT_TYPE_PSPOLL);
    eval("sub HAL_PKT_TYPE_BEACON () { 3; }") unless defined(&HAL_PKT_TYPE_BEACON);
    eval("sub HAL_PKT_TYPE_PROBE_RESP () { 4; }") unless defined(&HAL_PKT_TYPE_PROBE_RESP);
    eval("sub HAL_PKT_TYPE_PIFS () { 5; }") unless defined(&HAL_PKT_TYPE_PIFS);
    eval 'sub AR5K_CCK_SIFS_TIME () {10;}' unless defined(&AR5K_CCK_SIFS_TIME);
    eval 'sub AR5K_CCK_PREAMBLE_BITS () {144;}' unless defined(&AR5K_CCK_PREAMBLE_BITS);
    eval 'sub AR5K_CCK_PLCP_BITS () {48;}' unless defined(&AR5K_CCK_PLCP_BITS);
    eval 'sub AR5K_CCK_NUM_BITS {
        local($_frmlen) = @_;
	    eval q(($_frmlen << 3));
    }' unless defined(&AR5K_CCK_NUM_BITS);
    eval 'sub AR5K_CCK_PHY_TIME {
        local($_sp) = @_;
	    eval q(($_sp ? (( &AR5K_CCK_PREAMBLE_BITS +  &AR5K_CCK_PLCP_BITS) >> 1) : ( &AR5K_CCK_PREAMBLE_BITS +  &AR5K_CCK_PLCP_BITS)));
    }' unless defined(&AR5K_CCK_PHY_TIME);
    eval 'sub AR5K_CCK_TX_TIME {
        local($_kbps, $_frmlen, $_sp) = @_;
	    eval q( &AR5K_CCK_PHY_TIME($_sp) + (( &AR5K_CCK_NUM_BITS($_frmlen) * 1000) / $_kbps) +  &AR5K_CCK_SIFS_TIME);
    }' unless defined(&AR5K_CCK_TX_TIME);
    eval 'sub AR5K_OFDM_SIFS_TIME () {16;}' unless defined(&AR5K_OFDM_SIFS_TIME);
    eval 'sub AR5K_OFDM_PREAMBLE_TIME () {20;}' unless defined(&AR5K_OFDM_PREAMBLE_TIME);
    eval 'sub AR5K_OFDM_PLCP_BITS () {22;}' unless defined(&AR5K_OFDM_PLCP_BITS);
    eval 'sub AR5K_OFDM_SYMBOL_TIME () {4;}' unless defined(&AR5K_OFDM_SYMBOL_TIME);
    eval 'sub AR5K_OFDM_NUM_BITS {
        local($_frmlen) = @_;
	    eval q(( &AR5K_OFDM_PLCP_BITS + ($_frmlen << 3)));
    }' unless defined(&AR5K_OFDM_NUM_BITS);
    eval 'sub AR5K_OFDM_NUM_BITS_PER_SYM {
        local($_kbps) = @_;
	    eval q((($_kbps *  &AR5K_OFDM_SYMBOL_TIME) / 1000));
    }' unless defined(&AR5K_OFDM_NUM_BITS_PER_SYM);
    eval 'sub AR5K_OFDM_NUM_BITS {
        local($_frmlen) = @_;
	    eval q(( &AR5K_OFDM_PLCP_BITS + ($_frmlen << 3)));
    }' unless defined(&AR5K_OFDM_NUM_BITS);
    eval 'sub AR5K_OFDM_NUM_SYMBOLS {
        local($_kbps, $_frmlen) = @_;
	    eval q( &howmany( &AR5K_OFDM_NUM_BITS($_frmlen),  &AR5K_OFDM_NUM_BITS_PER_SYM($_kbps)));
    }' unless defined(&AR5K_OFDM_NUM_SYMBOLS);
    eval 'sub AR5K_OFDM_TX_TIME {
        local($_kbps, $_frmlen) = @_;
	    eval q( &AR5K_OFDM_PREAMBLE_TIME +  &AR5K_OFDM_SIFS_TIME + ( &AR5K_OFDM_NUM_SYMBOLS($_kbps, $_frmlen) *  &AR5K_OFDM_SYMBOL_TIME));
    }' unless defined(&AR5K_OFDM_TX_TIME);
    eval 'sub AR5K_TURBO_SIFS_TIME () {8;}' unless defined(&AR5K_TURBO_SIFS_TIME);
    eval 'sub AR5K_TURBO_PREAMBLE_TIME () {14;}' unless defined(&AR5K_TURBO_PREAMBLE_TIME);
    eval 'sub AR5K_TURBO_PLCP_BITS () {22;}' unless defined(&AR5K_TURBO_PLCP_BITS);
    eval 'sub AR5K_TURBO_SYMBOL_TIME () {4;}' unless defined(&AR5K_TURBO_SYMBOL_TIME);
    eval 'sub AR5K_TURBO_NUM_BITS {
        local($_frmlen) = @_;
	    eval q(( &AR5K_TURBO_PLCP_BITS + ($_frmlen << 3)));
    }' unless defined(&AR5K_TURBO_NUM_BITS);
    eval 'sub AR5K_TURBO_NUM_BITS_PER_SYM {
        local($_kbps) = @_;
	    eval q(((($_kbps << 1) *  &AR5K_TURBO_SYMBOL_TIME) / 1000));
    }' unless defined(&AR5K_TURBO_NUM_BITS_PER_SYM);
    eval 'sub AR5K_TURBO_NUM_BITS {
        local($_frmlen) = @_;
	    eval q(( &AR5K_TURBO_PLCP_BITS + ($_frmlen << 3)));
    }' unless defined(&AR5K_TURBO_NUM_BITS);
    eval 'sub AR5K_TURBO_NUM_SYMBOLS {
        local($_kbps, $_frmlen) = @_;
	    eval q( &howmany( &AR5K_TURBO_NUM_BITS($_frmlen),  &AR5K_TURBO_NUM_BITS_PER_SYM($_kbps)));
    }' unless defined(&AR5K_TURBO_NUM_SYMBOLS);
    eval 'sub AR5K_TURBO_TX_TIME {
        local($_kbps, $_frmlen) = @_;
	    eval q( &AR5K_TURBO_PREAMBLE_TIME +  &AR5K_TURBO_SIFS_TIME + ( &AR5K_TURBO_NUM_SYMBOLS($_kbps, $_frmlen) *  &AR5K_TURBO_SYMBOL_TIME));
    }' unless defined(&AR5K_TURBO_TX_TIME);
    eval 'sub AR5K_XR_SIFS_TIME () {16;}' unless defined(&AR5K_XR_SIFS_TIME);
    eval 'sub AR5K_XR_PLCP_BITS () {22;}' unless defined(&AR5K_XR_PLCP_BITS);
    eval 'sub AR5K_XR_SYMBOL_TIME () {4;}' unless defined(&AR5K_XR_SYMBOL_TIME);
    eval 'sub AR5K_XR_PREAMBLE_TIME {
        local($_kbps) = @_;
	    eval q(((($_kbps) < 1000) ? 173: 76));
    }' unless defined(&AR5K_XR_PREAMBLE_TIME);
    eval 'sub AR5K_XR_NUM_BITS_PER_SYM {
        local($_kbps) = @_;
	    eval q((($_kbps *  &AR5K_XR_SYMBOL_TIME) / 1000));
    }' unless defined(&AR5K_XR_NUM_BITS_PER_SYM);
    eval 'sub AR5K_XR_NUM_BITS {
        local($_frmlen) = @_;
	    eval q(( &AR5K_XR_PLCP_BITS + ($_frmlen << 3)));
    }' unless defined(&AR5K_XR_NUM_BITS);
    eval 'sub AR5K_XR_NUM_SYMBOLS {
        local($_kbps, $_frmlen) = @_;
	    eval q( &howmany( &AR5K_XR_NUM_BITS($_frmlen),  &AR5K_XR_NUM_BITS_PER_SYM($_kbps)));
    }' unless defined(&AR5K_XR_NUM_SYMBOLS);
    eval 'sub AR5K_XR_TX_TIME {
        local($_kbps, $_frmlen) = @_;
	    eval q( &AR5K_XR_PREAMBLE_TIME($_kbps) +  &AR5K_XR_SIFS_TIME + ( &AR5K_XR_NUM_SYMBOLS($_kbps, $_frmlen) *  &AR5K_XR_SYMBOL_TIME));
    }' unless defined(&AR5K_XR_TX_TIME);
    eval 'sub HAL_RX_FILTER_UCAST () {0x1;}' unless defined(&HAL_RX_FILTER_UCAST);
    eval 'sub HAL_RX_FILTER_MCAST () {0x2;}' unless defined(&HAL_RX_FILTER_MCAST);
    eval 'sub HAL_RX_FILTER_BCAST () {0x4;}' unless defined(&HAL_RX_FILTER_BCAST);
    eval 'sub HAL_RX_FILTER_CONTROL () {0x8;}' unless defined(&HAL_RX_FILTER_CONTROL);
    eval 'sub HAL_RX_FILTER_BEACON () {0x10;}' unless defined(&HAL_RX_FILTER_BEACON);
    eval 'sub HAL_RX_FILTER_PROM () {0x20;}' unless defined(&HAL_RX_FILTER_PROM);
    eval 'sub HAL_RX_FILTER_PROBEREQ () {0x80;}' unless defined(&HAL_RX_FILTER_PROBEREQ);
    eval 'sub HAL_RX_FILTER_PHYERR () {0x100;}' unless defined(&HAL_RX_FILTER_PHYERR);
    eval 'sub HAL_RX_FILTER_PHYRADAR () {0x200;}' unless defined(&HAL_RX_FILTER_PHYRADAR);
    eval 'sub HAL_BEACON_PERIOD () {0xffff;}' unless defined(&HAL_BEACON_PERIOD);
    eval 'sub HAL_BEACON_ENA () {0x800000;}' unless defined(&HAL_BEACON_ENA);
    eval 'sub HAL_BEACON_RESET_TSF () {0x1000000;}' unless defined(&HAL_BEACON_RESET_TSF);
    eval 'sub bs_nexttbtt () { &bs_next_beacon;}' unless defined(&bs_nexttbtt);
    eval 'sub bs_intval () { &bs_interval;}' unless defined(&bs_intval);
    eval 'sub bs_nextdtim () { &bs_next_dtim;}' unless defined(&bs_nextdtim);
    eval 'sub bs_bmissthreshold () { &bs_bmiss_threshold;}' unless defined(&bs_bmissthreshold);
    eval 'sub bs_sleepduration () { &bs_sleep_duration;}' unless defined(&bs_sleepduration);
    eval 'sub bs_dtimperiod () { &bs_dtim_period;}' unless defined(&bs_dtimperiod);
    eval("sub HAL_PM_UNDEFINED () { 0; }") unless defined(&HAL_PM_UNDEFINED);
    eval("sub HAL_PM_AUTO () { 1; }") unless defined(&HAL_PM_AUTO);
    eval("sub HAL_PM_AWAKE () { 2; }") unless defined(&HAL_PM_AWAKE);
    eval("sub HAL_PM_FULL_SLEEP () { 3; }") unless defined(&HAL_PM_FULL_SLEEP);
    eval("sub HAL_PM_NETWORK_SLEEP () { 4; }") unless defined(&HAL_PM_NETWORK_SLEEP);
    eval("sub HAL_CIPHER_WEP () { 0; }") unless defined(&HAL_CIPHER_WEP);
    eval("sub HAL_CIPHER_AES_CCM () { 1; }") unless defined(&HAL_CIPHER_AES_CCM);
    eval("sub HAL_CIPHER_CKIP () { 2; }") unless defined(&HAL_CIPHER_CKIP);
    eval 'sub AR5K_KEYVAL_LENGTH_40 () {5;}' unless defined(&AR5K_KEYVAL_LENGTH_40);
    eval 'sub AR5K_KEYVAL_LENGTH_104 () {13;}' unless defined(&AR5K_KEYVAL_LENGTH_104);
    eval 'sub AR5K_KEYVAL_LENGTH_128 () {16;}' unless defined(&AR5K_KEYVAL_LENGTH_128);
    eval 'sub AR5K_KEYVAL_LENGTH_MAX () { &AR5K_KEYVAL_LENGTH_128;}' unless defined(&AR5K_KEYVAL_LENGTH_MAX);
    eval 'sub AR5K_ASSERT_ENTRY {
        local($_e, $_s) = @_;
	    eval q( &do {  &if ($_e >= $_s)  &return ( &AH_FALSE); }  &while (0));
    }' unless defined(&AR5K_ASSERT_ENTRY);
    eval 'sub AR5K_MAX_RATES () {32;}' unless defined(&AR5K_MAX_RATES);
    eval 'sub r_valid () { &valid;}' unless defined(&r_valid);
    eval 'sub r_phy () { &phy;}' unless defined(&r_phy);
    eval 'sub r_rate_kbps () { &rateKbps;}' unless defined(&r_rate_kbps);
    eval 'sub r_rate_code () { &rateCode;}' unless defined(&r_rate_code);
    eval 'sub r_short_preamble () { &shortPreamble;}' unless defined(&r_short_preamble);
    eval 'sub r_dot11_rate () { &dot11Rate;}' unless defined(&r_dot11_rate);
    eval 'sub r_control_rate () { &controlRate;}' unless defined(&r_control_rate);
    eval 'sub rt_rate_count () { &rateCount;}' unless defined(&rt_rate_count);
    eval 'sub rt_rate_code_index () { &rateCodeToIndex;}' unless defined(&rt_rate_code_index);
    eval 'sub rt_info () { &info;}' unless defined(&rt_info);
    eval 'sub AR5K_RATES_11A () {{ 8, { 255, 255, 255, 255, 255, 255, 255, 255, 6, 4, 2, 0, 7, 5, 3, 1, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, { { 1,  &IEEE80211_T_OFDM, 6000, 11, 0, 140, 0}, { 1,  &IEEE80211_T_OFDM, 9000, 15, 0, 18, 0}, { 1,  &IEEE80211_T_OFDM, 12000, 10, 0, 152, 2}, { 1,  &IEEE80211_T_OFDM, 18000, 14, 0, 36, 2}, { 1,  &IEEE80211_T_OFDM, 24000, 9, 0, 176, 4}, { 1,  &IEEE80211_T_OFDM, 36000, 13, 0, 72, 4}, { 1,  &IEEE80211_T_OFDM, 48000, 8, 0, 96, 4}, { 1,  &IEEE80211_T_OFDM, 54000, 12, 0, 108, 4} } };}' unless defined(&AR5K_RATES_11A);
    eval 'sub AR5K_RATES_11B () {{ 4, { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 3, 2, 1, 0, 255, 255, 255, 255}, { { 1,  &IEEE80211_T_CCK, 1000, 27, 0x, 130, 0}, { 1,  &IEEE80211_T_CCK, 2000, 26, 0x4, 132, 1}, { 1,  &IEEE80211_T_CCK, 5500, 25, 0x4, 139, 1}, { 1,  &IEEE80211_T_CCK, 11000, 24, 0x4, 150, 1} } };}' unless defined(&AR5K_RATES_11B);
    eval 'sub AR5K_RATES_11G () {{ 12, { 255, 255, 255, 255, 255, 255, 255, 255, 10, 8, 6, 4, 11, 9, 7, 5, 255, 255, 255, 255, 255, 255, 255, 255, 3, 2, 1, 0, 255, 255, 255, 255}, { { 1,  &IEEE80211_T_CCK, 1000, 27, 0x, 2, 0}, { 1,  &IEEE80211_T_CCK, 2000, 26, 0x4, 4, 1}, { 1,  &IEEE80211_T_CCK, 5500, 25, 0x4, 11, 1}, { 1,  &IEEE80211_T_CCK, 11000, 24, 0x4, 22, 1}, { 0,  &IEEE80211_T_OFDM, 6000, 11, 0, 12, 4}, { 0,  &IEEE80211_T_OFDM, 9000, 15, 0, 18, 4}, { 1,  &IEEE80211_T_OFDM, 12000, 10, 0, 24, 6}, { 1,  &IEEE80211_T_OFDM, 18000, 14, 0, 36, 6}, { 1,  &IEEE80211_T_OFDM, 24000, 9, 0, 48, 8}, { 1,  &IEEE80211_T_OFDM, 36000, 13, 0, 72, 8}, { 1,  &IEEE80211_T_OFDM, 48000, 8, 0, 96, 8}, { 1,  &IEEE80211_T_OFDM, 54000, 12, 0, 108, 8} } };}' unless defined(&AR5K_RATES_11G);
    eval 'sub AR5K_RATES_TURBO () {{ 8, { 255, 255, 255, 255, 255, 255, 255, 255, 6, 4, 2, 0, 7, 5, 3, 1, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, { { 1,  &IEEE80211_T_TURBO, 6000, 11, 0, 140, 0}, { 1,  &IEEE80211_T_TURBO, 9000, 15, 0, 18, 0}, { 1,  &IEEE80211_T_TURBO, 12000, 10, 0, 152, 2}, { 1,  &IEEE80211_T_TURBO, 18000, 14, 0, 36, 2}, { 1,  &IEEE80211_T_TURBO, 24000, 9, 0, 176, 4}, { 1,  &IEEE80211_T_TURBO, 36000, 13, 0, 72, 4}, { 1,  &IEEE80211_T_TURBO, 48000, 8, 0, 96, 4}, { 1,  &IEEE80211_T_TURBO, 54000, 12, 0, 108, 4} } };}' unless defined(&AR5K_RATES_TURBO);
    eval 'sub AR5K_RATES_XR () {{ 12, { 255, 3, 1, 255, 255, 255, 2, 0, 10, 8, 6, 4, 11, 9, 7, 5, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, { { 1,  &IEEE80211_T_XR, 500, 7, 0, 129, 0}, { 1,  &IEEE80211_T_XR, 1000, 2, 0, 139, 1}, { 1,  &IEEE80211_T_XR, 2000, 6, 0, 150, 2}, { 1,  &IEEE80211_T_XR, 3000, 1, 0, 150, 3}, { 1,  &IEEE80211_T_OFDM, 6000, 11, 0, 140, 4}, { 1,  &IEEE80211_T_OFDM, 9000, 15, 0, 18, 4}, { 1,  &IEEE80211_T_OFDM, 12000, 10, 0, 152, 6}, { 1,  &IEEE80211_T_OFDM, 18000, 14, 0, 36, 6}, { 1,  &IEEE80211_T_OFDM, 24000, 9, 0, 176, 8}, { 1,  &IEEE80211_T_OFDM, 36000, 13, 0, 72, 8}, { 1,  &IEEE80211_T_OFDM, 48000, 8, 0, 96, 8}, { 1,  &IEEE80211_T_OFDM, 54000, 12, 0, 108, 8} } };}' unless defined(&AR5K_RATES_XR);
    eval("sub HAL_RFGAIN_INACTIVE () { 0; }") unless defined(&HAL_RFGAIN_INACTIVE);
    eval("sub HAL_RFGAIN_READ_REQUESTED () { 1; }") unless defined(&HAL_RFGAIN_READ_REQUESTED);
    eval("sub HAL_RFGAIN_NEED_CHANGE () { 2; }") unless defined(&HAL_RFGAIN_NEED_CHANGE);
    eval 'sub c_channel () { &channel;}' unless defined(&c_channel);
    eval 'sub c_channel_flags () { &channelFlags;}' unless defined(&c_channel_flags);
    eval 'sub HAL_SLOT_TIME_9 () {396;}' unless defined(&HAL_SLOT_TIME_9);
    eval 'sub HAL_SLOT_TIME_20 () {880;}' unless defined(&HAL_SLOT_TIME_20);
    eval 'sub HAL_SLOT_TIME_MAX () {0xffff;}' unless defined(&HAL_SLOT_TIME_MAX);
    eval 'sub CHANNEL_A () {( &IEEE80211_CHAN_5GHZ |  &IEEE80211_CHAN_OFDM);}' unless defined(&CHANNEL_A);
    eval 'sub CHANNEL_B () {( &IEEE80211_CHAN_2GHZ |  &IEEE80211_CHAN_CCK);}' unless defined(&CHANNEL_B);
    eval 'sub CHANNEL_G () {( &IEEE80211_CHAN_2GHZ |  &IEEE80211_CHAN_DYN);}' unless defined(&CHANNEL_G);
    eval 'sub CHANNEL_PUREG () {( &IEEE80211_CHAN_2GHZ |  &IEEE80211_CHAN_OFDM);}' unless defined(&CHANNEL_PUREG);
    eval 'sub CHANNEL_T () {( &CHANNEL_A |  &IEEE80211_CHAN_TURBO);}' unless defined(&CHANNEL_T);
    eval 'sub CHANNEL_TG () {( &CHANNEL_PUREG |  &IEEE80211_CHAN_TURBO);}' unless defined(&CHANNEL_TG);
    eval 'sub CHANNEL_XR () {( &CHANNEL_A |  &IEEE80211_CHAN_XR);}' unless defined(&CHANNEL_XR);
    eval("sub HAL_CHIP_5GHZ () { IEEE80211_CHAN_5GHZ; }") unless defined(&HAL_CHIP_5GHZ);
    eval("sub HAL_CHIP_2GHZ () { IEEE80211_CHAN_2GHZ; }") unless defined(&HAL_CHIP_2GHZ);
    eval 'sub HAL_INT_RX () {0x1;}' unless defined(&HAL_INT_RX);
    eval 'sub HAL_INT_RXDESC () {0x2;}' unless defined(&HAL_INT_RXDESC);
    eval 'sub HAL_INT_RXNOFRM () {0x8;}' unless defined(&HAL_INT_RXNOFRM);
    eval 'sub HAL_INT_RXEOL () {0x10;}' unless defined(&HAL_INT_RXEOL);
    eval 'sub HAL_INT_RXORN () {0x20;}' unless defined(&HAL_INT_RXORN);
    eval 'sub HAL_INT_TX () {0x40;}' unless defined(&HAL_INT_TX);
    eval 'sub HAL_INT_TXDESC () {0x80;}' unless defined(&HAL_INT_TXDESC);
    eval 'sub HAL_INT_TXURN () {0x800;}' unless defined(&HAL_INT_TXURN);
    eval 'sub HAL_INT_MIB () {0x1000;}' unless defined(&HAL_INT_MIB);
    eval 'sub HAL_INT_RXPHY () {0x4000;}' unless defined(&HAL_INT_RXPHY);
    eval 'sub HAL_INT_RXKCM () {0x8000;}' unless defined(&HAL_INT_RXKCM);
    eval 'sub HAL_INT_SWBA () {0x10000;}' unless defined(&HAL_INT_SWBA);
    eval 'sub HAL_INT_BMISS () {0x40000;}' unless defined(&HAL_INT_BMISS);
    eval 'sub HAL_INT_BNR () {0x100000;}' unless defined(&HAL_INT_BNR);
    eval 'sub HAL_INT_GPIO () {0x1000000;}' unless defined(&HAL_INT_GPIO);
    eval 'sub HAL_INT_FATAL () {0x40000000;}' unless defined(&HAL_INT_FATAL);
    eval 'sub HAL_INT_GLOBAL () {0x80000000;}' unless defined(&HAL_INT_GLOBAL);
    eval 'sub HAL_INT_NOCARD () {0xffffffff;}' unless defined(&HAL_INT_NOCARD);
    eval 'sub HAL_INT_COMMON () {(  &HAL_INT_RXNOFRM |  &HAL_INT_RXDESC |  &HAL_INT_RXEOL |  &HAL_INT_RXORN |  &HAL_INT_TXURN |  &HAL_INT_TXDESC |  &HAL_INT_MIB |  &HAL_INT_RXPHY |  &HAL_INT_RXKCM |  &HAL_INT_SWBA |  &HAL_INT_BMISS |  &HAL_INT_GPIO );}' unless defined(&HAL_INT_COMMON);
    eval 'sub HAL_LED_INIT () { &IEEE80211_S_INIT;}' unless defined(&HAL_LED_INIT);
    eval 'sub HAL_LED_SCAN () { &IEEE80211_S_SCAN;}' unless defined(&HAL_LED_SCAN);
    eval 'sub HAL_LED_AUTH () { &IEEE80211_S_AUTH;}' unless defined(&HAL_LED_AUTH);
    eval 'sub HAL_LED_ASSOC () { &IEEE80211_S_ASSOC;}' unless defined(&HAL_LED_ASSOC);
    eval 'sub HAL_LED_RUN () { &IEEE80211_S_RUN;}' unless defined(&HAL_LED_RUN);
    eval 'sub AR5K_SOFTLED_PIN () {0;}' unless defined(&AR5K_SOFTLED_PIN);
    eval 'sub AR5K_SOFTLED_ON () {0;}' unless defined(&AR5K_SOFTLED_ON);
    eval 'sub AR5K_SOFTLED_OFF () {1;}' unless defined(&AR5K_SOFTLED_OFF);
    eval 'sub AR5K_GAIN_CRN_FIX_BITS_5111 () {4;}' unless defined(&AR5K_GAIN_CRN_FIX_BITS_5111);
    eval 'sub AR5K_GAIN_CRN_FIX_BITS_5112 () {7;}' unless defined(&AR5K_GAIN_CRN_FIX_BITS_5112);
    eval 'sub AR5K_GAIN_CRN_MAX_FIX_BITS () { &AR5K_GAIN_CRN_FIX_BITS_5112;}' unless defined(&AR5K_GAIN_CRN_MAX_FIX_BITS);
    eval 'sub AR5K_GAIN_DYN_ADJUST_HI_MARGIN () {15;}' unless defined(&AR5K_GAIN_DYN_ADJUST_HI_MARGIN);
    eval 'sub AR5K_GAIN_DYN_ADJUST_LO_MARGIN () {20;}' unless defined(&AR5K_GAIN_DYN_ADJUST_LO_MARGIN);
    eval 'sub AR5K_GAIN_CCK_PROBE_CORR () {5;}' unless defined(&AR5K_GAIN_CCK_PROBE_CORR);
    eval 'sub AR5K_GAIN_CCK_OFDM_GAIN_DELTA () {15;}' unless defined(&AR5K_GAIN_CCK_OFDM_GAIN_DELTA);
    eval 'sub AR5K_GAIN_STEP_COUNT () {10;}' unless defined(&AR5K_GAIN_STEP_COUNT);
    eval 'sub AR5K_GAIN_PARAM_TX_CLIP () {0;}' unless defined(&AR5K_GAIN_PARAM_TX_CLIP);
    eval 'sub AR5K_GAIN_PARAM_PD_90 () {1;}' unless defined(&AR5K_GAIN_PARAM_PD_90);
    eval 'sub AR5K_GAIN_PARAM_PD_84 () {2;}' unless defined(&AR5K_GAIN_PARAM_PD_84);
    eval 'sub AR5K_GAIN_PARAM_GAIN_SEL () {3;}' unless defined(&AR5K_GAIN_PARAM_GAIN_SEL);
    eval 'sub AR5K_GAIN_PARAM_MIX_ORN () {0;}' unless defined(&AR5K_GAIN_PARAM_MIX_ORN);
    eval 'sub AR5K_GAIN_PARAM_PD_138 () {1;}' unless defined(&AR5K_GAIN_PARAM_PD_138);
    eval 'sub AR5K_GAIN_PARAM_PD_137 () {2;}' unless defined(&AR5K_GAIN_PARAM_PD_137);
    eval 'sub AR5K_GAIN_PARAM_PD_136 () {3;}' unless defined(&AR5K_GAIN_PARAM_PD_136);
    eval 'sub AR5K_GAIN_PARAM_PD_132 () {4;}' unless defined(&AR5K_GAIN_PARAM_PD_132);
    eval 'sub AR5K_GAIN_PARAM_PD_131 () {5;}' unless defined(&AR5K_GAIN_PARAM_PD_131);
    eval 'sub AR5K_GAIN_PARAM_PD_130 () {6;}' unless defined(&AR5K_GAIN_PARAM_PD_130);
    eval 'sub AR5K_GAIN_CHECK_ADJUST {
        local($_g) = @_;
	    eval q((($_g)-> &g_current <= ($_g)-> &g_low || ($_g)-> &g_current >= ($_g)-> &g_high));
    }' unless defined(&AR5K_GAIN_CHECK_ADJUST);
    eval 'sub AR5K_AR5111_GAIN_OPT () {{ 4, 9, { { { 4, 1, 1, 1}, 6}, { { 4, 0, 1, 1}, 4}, { { 3, 1, 1, 1}, 3}, { { 4, 0, 0, 1}, 1}, { { 4, 1, 1, 0}, 0}, { { 4, 0, 1, 0}, -2}, { { 3, 1, 1, 0}, -3}, { { 4, 0, 0, 0}, -4}, { { 2, 1, 1, 0}, -6} } };}' unless defined(&AR5K_AR5111_GAIN_OPT);
    eval 'sub AR5K_AR5112_GAIN_OPT () {{ 1, 8, { { { 3, 0, 0, 0, 0, 0, 0}, 6}, { { 2, 0, 0, 0, 0, 0, 0}, 0}, { { 1, 0, 0, 0, 0, 0, 0}, -3}, { { 0, 0, 0, 0, 0, 0, 0}, -6}, { { 0, 1, 1, 0, 0, 0, 0}, -8}, { { 0, 1, 1, 0, 1, 1, 0}, -10}, { { 0, 1, 0, 1, 1, 1, 0}, -13}, { { 0, 1, 0, 1, 1, 0, 1}, -16}, } };}' unless defined(&AR5K_AR5112_GAIN_OPT);
    eval 'sub AR5K_EEPROM_MAGIC () {0x3d;}' unless defined(&AR5K_EEPROM_MAGIC);
    eval 'sub AR5K_EEPROM_MAGIC_VALUE () {0x5aa5;}' unless defined(&AR5K_EEPROM_MAGIC_VALUE);
    eval 'sub AR5K_EEPROM_PROTECT () {0x3f;}' unless defined(&AR5K_EEPROM_PROTECT);
    eval 'sub AR5K_EEPROM_PROTECT_RD_0_31 () {0x1;}' unless defined(&AR5K_EEPROM_PROTECT_RD_0_31);
    eval 'sub AR5K_EEPROM_PROTECT_WR_0_31 () {0x2;}' unless defined(&AR5K_EEPROM_PROTECT_WR_0_31);
    eval 'sub AR5K_EEPROM_PROTECT_RD_32_63 () {0x4;}' unless defined(&AR5K_EEPROM_PROTECT_RD_32_63);
    eval 'sub AR5K_EEPROM_PROTECT_WR_32_63 () {0x8;}' unless defined(&AR5K_EEPROM_PROTECT_WR_32_63);
    eval 'sub AR5K_EEPROM_PROTECT_RD_64_127 () {0x10;}' unless defined(&AR5K_EEPROM_PROTECT_RD_64_127);
    eval 'sub AR5K_EEPROM_PROTECT_WR_64_127 () {0x20;}' unless defined(&AR5K_EEPROM_PROTECT_WR_64_127);
    eval 'sub AR5K_EEPROM_PROTECT_RD_128_191 () {0x40;}' unless defined(&AR5K_EEPROM_PROTECT_RD_128_191);
    eval 'sub AR5K_EEPROM_PROTECT_WR_128_191 () {0x80;}' unless defined(&AR5K_EEPROM_PROTECT_WR_128_191);
    eval 'sub AR5K_EEPROM_PROTECT_RD_192_207 () {0x100;}' unless defined(&AR5K_EEPROM_PROTECT_RD_192_207);
    eval 'sub AR5K_EEPROM_PROTECT_WR_192_207 () {0x200;}' unless defined(&AR5K_EEPROM_PROTECT_WR_192_207);
    eval 'sub AR5K_EEPROM_PROTECT_RD_208_223 () {0x400;}' unless defined(&AR5K_EEPROM_PROTECT_RD_208_223);
    eval 'sub AR5K_EEPROM_PROTECT_WR_208_223 () {0x800;}' unless defined(&AR5K_EEPROM_PROTECT_WR_208_223);
    eval 'sub AR5K_EEPROM_PROTECT_RD_224_239 () {0x1000;}' unless defined(&AR5K_EEPROM_PROTECT_RD_224_239);
    eval 'sub AR5K_EEPROM_PROTECT_WR_224_239 () {0x2000;}' unless defined(&AR5K_EEPROM_PROTECT_WR_224_239);
    eval 'sub AR5K_EEPROM_PROTECT_RD_240_255 () {0x4000;}' unless defined(&AR5K_EEPROM_PROTECT_RD_240_255);
    eval 'sub AR5K_EEPROM_PROTECT_WR_240_255 () {0x8000;}' unless defined(&AR5K_EEPROM_PROTECT_WR_240_255);
    eval 'sub AR5K_EEPROM_REG_DOMAIN () {0xbf;}' unless defined(&AR5K_EEPROM_REG_DOMAIN);
    eval 'sub AR5K_EEPROM_INFO_BASE () {0xc0;}' unless defined(&AR5K_EEPROM_INFO_BASE);
    eval 'sub AR5K_EEPROM_INFO_MAX () {(0x400 -  &AR5K_EEPROM_INFO_BASE);}' unless defined(&AR5K_EEPROM_INFO_MAX);
    eval 'sub AR5K_EEPROM_INFO {
        local($_n) = @_;
	    eval q(( &AR5K_EEPROM_INFO_BASE + ($_n)));
    }' unless defined(&AR5K_EEPROM_INFO);
    eval 'sub AR5K_EEPROM_VERSION () { &AR5K_EEPROM_INFO(1);}' unless defined(&AR5K_EEPROM_VERSION);
    eval 'sub AR5K_EEPROM_VERSION_3_0 () {0x3000;}' unless defined(&AR5K_EEPROM_VERSION_3_0);
    eval 'sub AR5K_EEPROM_VERSION_3_1 () {0x3001;}' unless defined(&AR5K_EEPROM_VERSION_3_1);
    eval 'sub AR5K_EEPROM_VERSION_3_2 () {0x3002;}' unless defined(&AR5K_EEPROM_VERSION_3_2);
    eval 'sub AR5K_EEPROM_VERSION_3_3 () {0x3003;}' unless defined(&AR5K_EEPROM_VERSION_3_3);
    eval 'sub AR5K_EEPROM_VERSION_3_4 () {0x3004;}' unless defined(&AR5K_EEPROM_VERSION_3_4);
    eval 'sub AR5K_EEPROM_VERSION_4_0 () {0x4000;}' unless defined(&AR5K_EEPROM_VERSION_4_0);
    eval 'sub AR5K_EEPROM_VERSION_4_1 () {0x4001;}' unless defined(&AR5K_EEPROM_VERSION_4_1);
    eval 'sub AR5K_EEPROM_VERSION_4_2 () {0x4002;}' unless defined(&AR5K_EEPROM_VERSION_4_2);
    eval 'sub AR5K_EEPROM_VERSION_4_3 () {0x4003;}' unless defined(&AR5K_EEPROM_VERSION_4_3);
    eval 'sub AR5K_EEPROM_VERSION_4_6 () {0x4006;}' unless defined(&AR5K_EEPROM_VERSION_4_6);
    eval 'sub AR5K_EEPROM_VERSION_4_7 () {0x3007;}' unless defined(&AR5K_EEPROM_VERSION_4_7);
    eval 'sub AR5K_EEPROM_MODE_11A () {0;}' unless defined(&AR5K_EEPROM_MODE_11A);
    eval 'sub AR5K_EEPROM_MODE_11B () {1;}' unless defined(&AR5K_EEPROM_MODE_11B);
    eval 'sub AR5K_EEPROM_MODE_11G () {2;}' unless defined(&AR5K_EEPROM_MODE_11G);
    eval 'sub AR5K_EEPROM_HDR () { &AR5K_EEPROM_INFO(2);}' unless defined(&AR5K_EEPROM_HDR);
    eval 'sub AR5K_EEPROM_HDR_11A {
        local($_v) = @_;
	    eval q(((($_v) >>  &AR5K_EEPROM_MODE_11A) & 0x1));
    }' unless defined(&AR5K_EEPROM_HDR_11A);
    eval 'sub AR5K_EEPROM_HDR_11B {
        local($_v) = @_;
	    eval q(((($_v) >>  &AR5K_EEPROM_MODE_11B) & 0x1));
    }' unless defined(&AR5K_EEPROM_HDR_11B);
    eval 'sub AR5K_EEPROM_HDR_11G {
        local($_v) = @_;
	    eval q(((($_v) >>  &AR5K_EEPROM_MODE_11G) & 0x1));
    }' unless defined(&AR5K_EEPROM_HDR_11G);
    eval 'sub AR5K_EEPROM_HDR_T_2GHZ_DIS {
        local($_v) = @_;
	    eval q(((($_v) >> 3) & 0x1));
    }' unless defined(&AR5K_EEPROM_HDR_T_2GHZ_DIS);
    eval 'sub AR5K_EEPROM_HDR_T_5GHZ_DBM {
        local($_v) = @_;
	    eval q(((($_v) >> 4) & 0x7f));
    }' unless defined(&AR5K_EEPROM_HDR_T_5GHZ_DBM);
    eval 'sub AR5K_EEPROM_HDR_DEVICE {
        local($_v) = @_;
	    eval q(((($_v) >> 11) & 0x7));
    }' unless defined(&AR5K_EEPROM_HDR_DEVICE);
    eval 'sub AR5K_EEPROM_HDR_T_5GHZ_DIS {
        local($_v) = @_;
	    eval q(((($_v) >> 15) & 0x1));
    }' unless defined(&AR5K_EEPROM_HDR_T_5GHZ_DIS);
    eval 'sub AR5K_EEPROM_HDR_RFKILL {
        local($_v) = @_;
	    eval q(((($_v) >> 14) & 0x1));
    }' unless defined(&AR5K_EEPROM_HDR_RFKILL);
    eval 'sub AR5K_EEPROM_RFKILL_GPIO_SEL () {0x1c;}' unless defined(&AR5K_EEPROM_RFKILL_GPIO_SEL);
    eval 'sub AR5K_EEPROM_RFKILL_GPIO_SEL_S () {2;}' unless defined(&AR5K_EEPROM_RFKILL_GPIO_SEL_S);
    eval 'sub AR5K_EEPROM_RFKILL_POLARITY () {0x2;}' unless defined(&AR5K_EEPROM_RFKILL_POLARITY);
    eval 'sub AR5K_EEPROM_RFKILL_POLARITY_S () {1;}' unless defined(&AR5K_EEPROM_RFKILL_POLARITY_S);
    eval 'sub AR5K_EEPROM_OFF {
        local($_v, $_v3_0, $_v3_3) = @_;
	    eval q(((($_v) >=  &AR5K_EEPROM_VERSION_3_3) ? $_v3_3 : $_v3_0));
    }' unless defined(&AR5K_EEPROM_OFF);
    eval 'sub AR5K_EEPROM_ANT_GAIN {
        local($_v) = @_;
	    eval q( &AR5K_EEPROM_OFF($_v, 0xc4, 0xc3));
    }' unless defined(&AR5K_EEPROM_ANT_GAIN);
    eval 'sub AR5K_EEPROM_ANT_GAIN_5GHZ {
        local($_v) = @_;
	    eval q((( &int8_t)((($_v) >> 8) & 0xff)));
    }' unless defined(&AR5K_EEPROM_ANT_GAIN_5GHZ);
    eval 'sub AR5K_EEPROM_ANT_GAIN_2GHZ {
        local($_v) = @_;
	    eval q((( &int8_t)(($_v) & 0xff)));
    }' unless defined(&AR5K_EEPROM_ANT_GAIN_2GHZ);
    eval 'sub AR5K_EEPROM_MODES_11A {
        local($_v) = @_;
	    eval q( &AR5K_EEPROM_OFF($_v, 0xc5, 0xd4));
    }' unless defined(&AR5K_EEPROM_MODES_11A);
    eval 'sub AR5K_EEPROM_MODES_11B {
        local($_v) = @_;
	    eval q( &AR5K_EEPROM_OFF($_v, 0xd0, 0xf2));
    }' unless defined(&AR5K_EEPROM_MODES_11B);
    eval 'sub AR5K_EEPROM_MODES_11G {
        local($_v) = @_;
	    eval q( &AR5K_EEPROM_OFF($_v, 0xda, 0x10d));
    }' unless defined(&AR5K_EEPROM_MODES_11G);
    eval 'sub AR5K_EEPROM_CTL {
        local($_v) = @_;
	    eval q( &AR5K_EEPROM_OFF($_v, 0xe4, 0x128));
    }' unless defined(&AR5K_EEPROM_CTL);
    eval 'sub AR5K_EEPROM_OBDB0_2GHZ () {0xec;}' unless defined(&AR5K_EEPROM_OBDB0_2GHZ);
    eval 'sub AR5K_EEPROM_OBDB1_2GHZ () {0xed;}' unless defined(&AR5K_EEPROM_OBDB1_2GHZ);
    eval 'sub AR5K_EEPROM_MISC0 () {0xc4;}' unless defined(&AR5K_EEPROM_MISC0);
    eval 'sub AR5K_EEPROM_EARSTART {
        local($_v) = @_;
	    eval q((($_v) & 0xfff));
    }' unless defined(&AR5K_EEPROM_EARSTART);
    eval 'sub AR5K_EEPROM_EEMAP {
        local($_v) = @_;
	    eval q(((($_v) >> 14) & 0x3));
    }' unless defined(&AR5K_EEPROM_EEMAP);
    eval 'sub AR5K_EEPROM_MISC1 () {0xc5;}' unless defined(&AR5K_EEPROM_MISC1);
    eval 'sub AR5K_EEPROM_TARGET_PWRSTART {
        local($_v) = @_;
	    eval q((($_v) & 0xfff));
    }' unless defined(&AR5K_EEPROM_TARGET_PWRSTART);
    eval 'sub AR5K_EEPROM_HAS32KHZCRYSTAL {
        local($_v) = @_;
	    eval q(((($_v) >> 14) & 0x1));
    }' unless defined(&AR5K_EEPROM_HAS32KHZCRYSTAL);
    eval 'sub AR5K_EEPROM_EEP_SCALE () {100;}' unless defined(&AR5K_EEPROM_EEP_SCALE);
    eval 'sub AR5K_EEPROM_EEP_DELTA () {10;}' unless defined(&AR5K_EEPROM_EEP_DELTA);
    eval 'sub AR5K_EEPROM_N_MODES () {3;}' unless defined(&AR5K_EEPROM_N_MODES);
    eval 'sub AR5K_EEPROM_N_5GHZ_CHAN () {10;}' unless defined(&AR5K_EEPROM_N_5GHZ_CHAN);
    eval 'sub AR5K_EEPROM_N_2GHZ_CHAN () {3;}' unless defined(&AR5K_EEPROM_N_2GHZ_CHAN);
    eval 'sub AR5K_EEPROM_MAX_CHAN () {10;}' unless defined(&AR5K_EEPROM_MAX_CHAN);
    eval 'sub AR5K_EEPROM_N_PCDAC () {11;}' unless defined(&AR5K_EEPROM_N_PCDAC);
    eval 'sub AR5K_EEPROM_N_TEST_FREQ () {8;}' unless defined(&AR5K_EEPROM_N_TEST_FREQ);
    eval 'sub AR5K_EEPROM_N_EDGES () {8;}' unless defined(&AR5K_EEPROM_N_EDGES);
    eval 'sub AR5K_EEPROM_N_INTERCEPTS () {11;}' unless defined(&AR5K_EEPROM_N_INTERCEPTS);
    eval 'sub AR5K_EEPROM_FREQ_M {
        local($_v) = @_;
	    eval q( &AR5K_EEPROM_OFF($_v, 0x7f, 0xff));
    }' unless defined(&AR5K_EEPROM_FREQ_M);
    eval 'sub AR5K_EEPROM_PCDAC_M () {0x3f;}' unless defined(&AR5K_EEPROM_PCDAC_M);
    eval 'sub AR5K_EEPROM_PCDAC_START () {1;}' unless defined(&AR5K_EEPROM_PCDAC_START);
    eval 'sub AR5K_EEPROM_PCDAC_STOP () {63;}' unless defined(&AR5K_EEPROM_PCDAC_STOP);
    eval 'sub AR5K_EEPROM_PCDAC_STEP () {1;}' unless defined(&AR5K_EEPROM_PCDAC_STEP);
    eval 'sub AR5K_EEPROM_NON_EDGE_M () {0x40;}' unless defined(&AR5K_EEPROM_NON_EDGE_M);
    eval 'sub AR5K_EEPROM_CHANNEL_POWER () {8;}' unless defined(&AR5K_EEPROM_CHANNEL_POWER);
    eval 'sub AR5K_EEPROM_N_OBDB () {4;}' unless defined(&AR5K_EEPROM_N_OBDB);
    eval 'sub AR5K_EEPROM_OBDB_DIS () {0xffff;}' unless defined(&AR5K_EEPROM_OBDB_DIS);
    eval 'sub AR5K_EEPROM_CHANNEL_DIS () {0xff;}' unless defined(&AR5K_EEPROM_CHANNEL_DIS);
    eval 'sub AR5K_EEPROM_SCALE_OC_DELTA {
        local($_x) = @_;
	    eval q(((($_x) * 2) / 10));
    }' unless defined(&AR5K_EEPROM_SCALE_OC_DELTA);
    eval 'sub AR5K_EEPROM_N_CTLS {
        local($_v) = @_;
	    eval q( &AR5K_EEPROM_OFF($_v, 16, 32));
    }' unless defined(&AR5K_EEPROM_N_CTLS);
    eval 'sub AR5K_EEPROM_MAX_CTLS () {32;}' unless defined(&AR5K_EEPROM_MAX_CTLS);
    eval 'sub AR5K_EEPROM_N_XPD_PER_CHANNEL () {4;}' unless defined(&AR5K_EEPROM_N_XPD_PER_CHANNEL);
    eval 'sub AR5K_EEPROM_N_XPD0_POINTS () {4;}' unless defined(&AR5K_EEPROM_N_XPD0_POINTS);
    eval 'sub AR5K_EEPROM_N_XPD3_POINTS () {3;}' unless defined(&AR5K_EEPROM_N_XPD3_POINTS);
    eval 'sub AR5K_EEPROM_N_INTERCEPT_10_2GHZ () {35;}' unless defined(&AR5K_EEPROM_N_INTERCEPT_10_2GHZ);
    eval 'sub AR5K_EEPROM_N_INTERCEPT_10_5GHZ () {55;}' unless defined(&AR5K_EEPROM_N_INTERCEPT_10_5GHZ);
    eval 'sub AR5K_EEPROM_POWER_M () {0x3f;}' unless defined(&AR5K_EEPROM_POWER_M);
    eval 'sub AR5K_EEPROM_POWER_MIN () {0;}' unless defined(&AR5K_EEPROM_POWER_MIN);
    eval 'sub AR5K_EEPROM_POWER_MAX () {3150;}' unless defined(&AR5K_EEPROM_POWER_MAX);
    eval 'sub AR5K_EEPROM_POWER_STEP () {50;}' unless defined(&AR5K_EEPROM_POWER_STEP);
    eval 'sub AR5K_EEPROM_POWER_TABLE_SIZE () {64;}' unless defined(&AR5K_EEPROM_POWER_TABLE_SIZE);
    eval 'sub AR5K_EEPROM_N_POWER_LOC_11B () {4;}' unless defined(&AR5K_EEPROM_N_POWER_LOC_11B);
    eval 'sub AR5K_EEPROM_N_POWER_LOC_11G () {6;}' unless defined(&AR5K_EEPROM_N_POWER_LOC_11G);
    eval 'sub AR5K_EEPROM_I_GAIN () {10;}' unless defined(&AR5K_EEPROM_I_GAIN);
    eval 'sub AR5K_EEPROM_CCK_OFDM_DELTA () {15;}' unless defined(&AR5K_EEPROM_CCK_OFDM_DELTA);
    eval 'sub AR5K_EEPROM_N_IQ_CAL () {2;}' unless defined(&AR5K_EEPROM_N_IQ_CAL);
    eval 'sub AR5K_TXPOWER_OFDM {
        local($_r, $_v) = @_;
	    eval q(( ((0& 1) << (($_v) + 6)) | ((( ($hal->{ah_txpower}->{txp_rates[&(_r)]})) & 0x3f) << ($_v)) ));
    }' unless defined(&AR5K_TXPOWER_OFDM);
    eval 'sub AR5K_TXPOWER_CCK {
        local($_r, $_v) = @_;
	    eval q(( ( ($hal->{ah_txpower}->{txp_rates[&(_r)]}) & 0x3f) << ($_v) ));
    }' unless defined(&AR5K_TXPOWER_CCK);
    eval 'sub HAL_TXSTAT_ALTRATE () {0x80;}' unless defined(&HAL_TXSTAT_ALTRATE);
    eval 'sub HAL_TXERR_XRETRY () {0x1;}' unless defined(&HAL_TXERR_XRETRY);
    eval 'sub HAL_TXERR_FILT () {0x2;}' unless defined(&HAL_TXERR_FILT);
    eval 'sub HAL_TXERR_FIFO () {0x4;}' unless defined(&HAL_TXERR_FIFO);
    eval 'sub HAL_RXERR_CRC () {0x1;}' unless defined(&HAL_RXERR_CRC);
    eval 'sub HAL_RXERR_PHY () {0x2;}' unless defined(&HAL_RXERR_PHY);
    eval 'sub HAL_RXERR_FIFO () {0x4;}' unless defined(&HAL_RXERR_FIFO);
    eval 'sub HAL_RXERR_DECRYPT () {0x8;}' unless defined(&HAL_RXERR_DECRYPT);
    eval 'sub HAL_RXERR_MIC () {0x10;}' unless defined(&HAL_RXERR_MIC);
    eval 'sub HAL_RXKEYIX_INVALID () {(( &u_int8_t) - 1);}' unless defined(&HAL_RXKEYIX_INVALID);
    eval 'sub HAL_TXKEYIX_INVALID () {(( &u_int32_t) - 1);}' unless defined(&HAL_TXKEYIX_INVALID);
    eval 'sub HAL_PHYERR_UNDERRUN () {0x;}' unless defined(&HAL_PHYERR_UNDERRUN);
    eval 'sub HAL_PHYERR_TIMING () {0x1;}' unless defined(&HAL_PHYERR_TIMING);
    eval 'sub HAL_PHYERR_PARITY () {0x2;}' unless defined(&HAL_PHYERR_PARITY);
    eval 'sub HAL_PHYERR_RATE () {0x3;}' unless defined(&HAL_PHYERR_RATE);
    eval 'sub HAL_PHYERR_LENGTH () {0x4;}' unless defined(&HAL_PHYERR_LENGTH);
    eval 'sub HAL_PHYERR_RADAR () {0x5;}' unless defined(&HAL_PHYERR_RADAR);
    eval 'sub HAL_PHYERR_SERVICE () {0x6;}' unless defined(&HAL_PHYERR_SERVICE);
    eval 'sub HAL_PHYERR_TOR () {0x7;}' unless defined(&HAL_PHYERR_TOR);
    eval 'sub HAL_PHYERR_OFDM_TIMING () {0x11;}' unless defined(&HAL_PHYERR_OFDM_TIMING);
    eval 'sub HAL_PHYERR_OFDM_SIGNAL_PARITY () {0x12;}' unless defined(&HAL_PHYERR_OFDM_SIGNAL_PARITY);
    eval 'sub HAL_PHYERR_OFDM_RATE_ILLEGAL () {0x13;}' unless defined(&HAL_PHYERR_OFDM_RATE_ILLEGAL);
    eval 'sub HAL_PHYERR_OFDM_LENGTH_ILLEGAL () {0x14;}' unless defined(&HAL_PHYERR_OFDM_LENGTH_ILLEGAL);
    eval 'sub HAL_PHYERR_OFDM_POWER_DROP () {0x15;}' unless defined(&HAL_PHYERR_OFDM_POWER_DROP);
    eval 'sub HAL_PHYERR_OFDM_SERVICE () {0x16;}' unless defined(&HAL_PHYERR_OFDM_SERVICE);
    eval 'sub HAL_PHYERR_OFDM_RESTART () {0x17;}' unless defined(&HAL_PHYERR_OFDM_RESTART);
    eval 'sub HAL_PHYERR_CCK_TIMING () {0x19;}' unless defined(&HAL_PHYERR_CCK_TIMING);
    eval 'sub HAL_PHYERR_CCK_HEADER_CRC () {0x1a;}' unless defined(&HAL_PHYERR_CCK_HEADER_CRC);
    eval 'sub HAL_PHYERR_CCK_RATE_ILLEGAL () {0x1b;}' unless defined(&HAL_PHYERR_CCK_RATE_ILLEGAL);
    eval 'sub HAL_PHYERR_CCK_SERVICE () {0x1e;}' unless defined(&HAL_PHYERR_CCK_SERVICE);
    eval 'sub HAL_PHYERR_CCK_RESTART () {0x1f;}' unless defined(&HAL_PHYERR_CCK_RESTART);
    eval 'sub ds_rxstat () { ($ds_us->{rx});}' unless defined(&ds_rxstat);
    eval 'sub ds_txstat () { ($ds_us->{tx});}' unless defined(&ds_txstat);
    eval 'sub HAL_RXDESC_INTREQ () {0x20;}' unless defined(&HAL_RXDESC_INTREQ);
    eval 'sub HAL_TXDESC_CLRDMASK () {0x1;}' unless defined(&HAL_TXDESC_CLRDMASK);
    eval 'sub HAL_TXDESC_NOACK () {0x2;}' unless defined(&HAL_TXDESC_NOACK);
    eval 'sub HAL_TXDESC_RTSENA () {0x4;}' unless defined(&HAL_TXDESC_RTSENA);
    eval 'sub HAL_TXDESC_CTSENA () {0x8;}' unless defined(&HAL_TXDESC_CTSENA);
    eval 'sub HAL_TXDESC_INTREQ () {0x10;}' unless defined(&HAL_TXDESC_INTREQ);
    eval 'sub HAL_TXDESC_VEOL () {0x20;}' unless defined(&HAL_TXDESC_VEOL);
    eval 'sub AR5K_HAL_FUNCTION {
        local($_hal, $_n, $_f) = @_;
	    eval q(($_hal)-> &ah_$_f =  &ar5k_$_n &_$_f);
    }' unless defined(&AR5K_HAL_FUNCTION);
    eval 'sub AR5K_HAL_FUNCTIONS {
        local($_t, $_n, $_a) = @_;
	    eval q($_t  &const  &HAL_RATE_TABLE *($_a $_n &_get_rate_table)(\'struct ath_hal\' *, \'u_int\'  &mode); $_t  &void ($_a $_n &_detach); $_t  &HAL_BOOL ($_a $_n &_reset)(\'struct ath_hal\' *,  &HAL_OPMODE,  &HAL_CHANNEL *,  &HAL_BOOL  &change_channel,  &HAL_STATUS * &status); $_t  &void ($_a $_n &_set_opmode); $_t  &HAL_BOOL ($_a $_n &_calibrate)(\'struct ath_hal\'*,  &HAL_CHANNEL *); $_t  &HAL_BOOL ($_a $_n &_update_tx_triglevel)(\'struct ath_hal\'*,  &HAL_BOOL  &level); $_t  &int ($_a $_n &_setup_tx_queue)(\'struct ath_hal\' *,  &HAL_TX_QUEUE,  &const  &HAL_TXQ_INFO *); $_t  &HAL_BOOL ($_a $_n &_setup_tx_queueprops)(\'struct ath_hal\' *, \'int\'  &queue,  &const  &HAL_TXQ_INFO *); $_t  &HAL_BOOL ($_a $_n &_release_tx_queue)(\'struct ath_hal\' *, \'u_int\'  &queue); $_t  &HAL_BOOL ($_a $_n &_reset_tx_queue)(\'struct ath_hal\' *, \'u_int\'  &queue); $_t  &u_int32_t ($_a $_n &_get_tx_buf)(\'struct ath_hal\' *, \'u_int\'  &queue); $_t  &HAL_BOOL ($_a $_n &_put_tx_buf)(\'struct ath_hal\' *, \'u_int\',  &u_int32_t  &phys_addr); $_t  &HAL_BOOL ($_a $_n &_tx_start)(\'struct ath_hal\' *, \'u_int\'  &queue); $_t  &HAL_BOOL ($_a $_n &_stop_tx_dma)(\'struct ath_hal\' *, \'u_int\'  &queue); $_t  &HAL_BOOL ($_a $_n &_setup_tx_desc)(\'struct ath_hal\' *, \'struct ath_desc\' *, \'u_int\'  &packet_length, \'u_int\'  &header_length,  &HAL_PKT_TYPE  &type, \'u_int\'  &txPower, \'u_int\'  &tx_rate0, \'u_int\'  &tx_tries0, \'u_int\'  &key_index, \'u_int\'  &antenna_mode, \'u_int\'  &flags, \'u_int\'  &rtscts_rate, \'u_int\'  &rtscts_duration); $_t  &HAL_BOOL ($_a $_n &_setup_xtx_desc)(\'struct ath_hal\' *, \'struct ath_desc\' *, \'u_int\'  &tx_rate1, \'u_int\'  &tx_tries1, \'u_int\'  &tx_rate2, \'u_int\'  &tx_tries2, \'u_int\'  &tx_rate3, \'u_int\'  &tx_tries3); $_t  &HAL_BOOL ($_a $_n &_fill_tx_desc)(\'struct ath_hal\' *, \'struct ath_desc\' *, \'u_int\'  &segLen,  &HAL_BOOL  &firstSeg,  &HAL_BOOL  &lastSeg); $_t  &HAL_STATUS ($_a $_n &_proc_tx_desc)(\'struct ath_hal\' *, \'struct ath_desc\' *); $_t  &HAL_BOOL ($_a $_n &_has_veol); $_t  &u_int32_t ($_a $_n &_get_rx_buf); $_t  &void ($_a $_n &_put_rx_buf)(\'struct ath_hal\'*,  &u_int32_t  &rxdp); $_t  &void ($_a $_n &_start_rx); $_t  &HAL_BOOL ($_a $_n &_stop_rx_dma); $_t  &void ($_a $_n &_start_rx_pcu); $_t  &void ($_a $_n &_stop_pcu_recv); $_t  &void ($_a $_n &_set_mcast_filter)(\'struct ath_hal\'*,  &u_int32_t  &filter0,  &u_int32_t  &filter1); $_t  &HAL_BOOL ($_a $_n &_set_mcast_filterindex)(\'struct ath_hal\'*,  &u_int32_t  &index); $_t  &HAL_BOOL ($_a $_n &_clear_mcast_filter_idx)(\'struct ath_hal\'*,  &u_int32_t  &index); $_t  &u_int32_t ($_a $_n &_get_rx_filter); $_t  &void ($_a $_n &_set_rx_filter)(\'struct ath_hal\'*,  &u_int32_t); $_t  &HAL_BOOL ($_a $_n &_setup_rx_desc)(\'struct ath_hal\' *, \'struct ath_desc\' *,  &u_int32_t  &size, \'u_int\'  &flags); $_t  &HAL_STATUS ($_a $_n &_proc_rx_desc)(\'struct ath_hal\' *, \'struct ath_desc\' *,  &u_int32_t  &phyAddr, \'struct ath_desc\' * &next); $_t  &void ($_a $_n &_set_rx_signal); $_t  &void ($_a $_n &_dump_state); $_t  &HAL_BOOL ($_a $_n &_get_diag_state)(\'struct ath_hal\' *, \'int\',  &void **, \'u_int\' *); $_t  &void ($_a $_n &_get_lladdr)(\'struct ath_hal\' *,  &u_int8_t *); $_t  &HAL_BOOL ($_a $_n &_set_lladdr)(\'struct ath_hal\' *,  &const  &u_int8_t*); $_t  &HAL_BOOL ($_a $_n &_set_regdomain)(\'struct ath_hal\'*,  &u_int16_t,  &HAL_STATUS *); $_t  &void ($_a $_n &_set_ledstate)(\'struct ath_hal\'*,  &HAL_LED_STATE); $_t  &void ($_a $_n &_set_associd)(\'struct ath_hal\'*,  &const  &u_int8_t * &bssid,  &u_int16_t  &assocId,  &u_int16_t  &timOffset); $_t  &HAL_BOOL ($_a $_n &_set_gpio_output)(\'struct ath_hal\' *,  &u_int32_t  &gpio); $_t  &HAL_BOOL ($_a $_n &_set_gpio_input)(\'struct ath_hal\' *,  &u_int32_t  &gpio); $_t  &u_int32_t ($_a $_n &_get_gpio)(\'struct ath_hal\' *,  &u_int32_t  &gpio); $_t  &HAL_BOOL ($_a $_n &_set_gpio)(\'struct ath_hal\' *,  &u_int32_t  &gpio,  &u_int32_t  &val); $_t  &void ($_a $_n &_set_gpio_intr)(\'struct ath_hal\'*, \'u_int\',  &u_int32_t); $_t  &u_int32_t ($_a $_n &_get_tsf32); $_t  &u_int64_t ($_a $_n &_get_tsf64); $_t  &void ($_a $_n &_reset_tsf); $_t  &u_int16_t ($_a $_n &_get_regdomain); $_t  &HAL_BOOL ($_a $_n &_detect_card_present); $_t  &void ($_a $_n &_update_mib_counters)(\'struct ath_hal\'*,  &HAL_MIB_STATS*); $_t  &HAL_BOOL ($_a $_n &_is_cipher_supported)(\'struct ath_hal\'*,  &HAL_CIPHER); $_t  &HAL_RFGAIN ($_a $_n &_get_rf_gain); $_t  &HAL_BOOL ($_a $_n &_set_slot_time)(\'struct ath_hal\'*, \'u_int\'); $_t  &u_int ($_a $_n &_get_slot_time); $_t  &HAL_BOOL ($_a $_n &_set_ack_timeout)(\'struct ath_hal\' *, \'u_int\'); $_t  &u_int ($_a $_n &_get_ack_timeout); $_t  &HAL_BOOL ($_a $_n &_set_cts_timeout)(\'struct ath_hal\'*, \'u_int\'); $_t  &u_int ($_a $_n &_get_cts_timeout); $_t  &u_int32_t ($_a $_n &_get_keycache_size); $_t  &HAL_BOOL ($_a $_n &_reset_key)(\'struct ath_hal\'*,  &u_int16_t); $_t  &HAL_BOOL ($_a $_n &_is_key_valid)(\'struct ath_hal\' *,  &u_int16_t); $_t  &HAL_BOOL ($_a $_n &_set_key)(\'struct ath_hal\'*,  &u_int16_t,  &const  &HAL_KEYVAL *,  &const  &u_int8_t *, \'int\'); $_t  &HAL_BOOL ($_a $_n &_set_key_lladdr)(\'struct ath_hal\'*,  &u_int16_t,  &const  &u_int8_t *); $_t  &HAL_BOOL ($_a $_n &_set_power)(\'struct ath_hal\'*,  &HAL_POWER_MODE  &mode,  &HAL_BOOL  &set_chip,  &u_int16_t  &sleep_duration); $_t  &HAL_POWER_MODE ($_a $_n &_get_power_mode); $_t  &HAL_BOOL ($_a $_n &_query_pspoll_support); $_t  &HAL_BOOL ($_a $_n &_init_pspoll); $_t  &HAL_BOOL ($_a $_n &_enable_pspoll)(\'struct ath_hal\' *,  &u_int8_t *,  &u_int16_t); $_t  &HAL_BOOL ($_a $_n &_disable_pspoll); $_t  &void ($_a $_n &_init_beacon)(\'struct ath_hal\' *,  &u_int32_t  &nexttbtt,  &u_int32_t  &intval); $_t  &void ($_a $_n &_set_beacon_timers)(\'struct ath_hal\' *,  &const  &HAL_BEACON_STATE *,  &u_int32_t  &tsf,  &u_int32_t  &dtimCount,  &u_int32_t  &cfpCcount); $_t  &void ($_a $_n &_reset_beacon); $_t  &HAL_BOOL ($_a $_n &_wait_for_beacon)(\'struct ath_hal\' *,  &bus_addr_t); $_t  &HAL_BOOL ($_a $_n &_is_intr_pending); $_t  &HAL_BOOL ($_a $_n &_get_isr)(\'struct ath_hal\' *,  &u_int32_t *); $_t  &u_int32_t ($_a $_n &_get_intr); $_t  &HAL_INT ($_a $_n &_set_intr)(\'struct ath_hal\' *,  &HAL_INT); $_t  &HAL_BOOL ($_a $_n &_get_capabilities); $_t  &void ($_a $_n &_radar_alert)(\'struct ath_hal\' *,  &HAL_BOOL  &enable); $_t  &HAL_BOOL ($_a $_n &_eeprom_is_busy); $_t  &int ($_a $_n &_eeprom_read)(\'struct ath_hal\' *,  &u_int32_t  &offset,  &u_int16_t * &data); $_t  &int ($_a $_n &_eeprom_write)(\'struct ath_hal\' *,  &u_int32_t  &offset,  &u_int16_t  &data););
    }' unless defined(&AR5K_HAL_FUNCTIONS);
    eval 'sub AR5K_MAX_GPIO () {10;}' unless defined(&AR5K_MAX_GPIO);
    eval 'sub AR5K_MAX_RF_BANKS () {8;}' unless defined(&AR5K_MAX_RF_BANKS);
    eval 'sub ah_getcountrycode () { &ah_country_code;}' unless defined(&ah_getcountrycode);
    eval 'sub ah_macVersion () { &ah_mac_version;}' unless defined(&ah_macVersion);
    eval 'sub ah_macRev () { &ah_mac_revision;}' unless defined(&ah_macRev);
    eval 'sub ah_phyRev () { &ah_phy_revision;}' unless defined(&ah_phyRev);
    eval 'sub ah_analog5GhzRev () { &ah_radio_5ghz_revision;}' unless defined(&ah_analog5GhzRev);
    eval 'sub ah_analog2GhzRev () { &ah_radio_2ghz_revision;}' unless defined(&ah_analog2GhzRev);
    eval 'sub ah_regdomain () { ($ah_capabilities->{cap_regdomain}->{reg_current});}' unless defined(&ah_regdomain);
    eval 'sub ah_modes () { ($ah_capabilities->{cap_mode});}' unless defined(&ah_modes);
    eval 'sub ah_ee_version () { ($ah_capabilities->{cap_eeprom}->{ee_version});}' unless defined(&ah_ee_version);
    eval("sub AR5K_VERSION_VER () { 0; }") unless defined(&AR5K_VERSION_VER);
    eval("sub AR5K_VERSION_REV () { 1; }") unless defined(&AR5K_VERSION_REV);
    eval("sub AR5K_VERSION_RAD () { 2; }") unless defined(&AR5K_VERSION_RAD);
    eval 'sub AR5K_SREV_NAME () {{ { "5210",  &AR5K_VERSION_VER,  &AR5K_SREV_VER_AR5210 }, { "5311",  &AR5K_VERSION_VER,  &AR5K_SREV_VER_AR5311 }, { "5311a",  &AR5K_VERSION_VER,  &AR5K_SREV_VER_AR5311A }, { "5311b",  &AR5K_VERSION_VER,  &AR5K_SREV_VER_AR5311B }, { "5211",  &AR5K_VERSION_VER,  &AR5K_SREV_VER_AR5211 }, { "5212",  &AR5K_VERSION_VER,  &AR5K_SREV_VER_AR5212 }, { "xxxx",  &AR5K_VERSION_VER,  &AR5K_SREV_UNKNOWN }, { "5110",  &AR5K_VERSION_RAD,  &AR5K_SREV_RAD_5110 }, { "5111",  &AR5K_VERSION_RAD,  &AR5K_SREV_RAD_5111 }, { "2111",  &AR5K_VERSION_RAD,  &AR5K_SREV_RAD_2111 }, { "5112",  &AR5K_VERSION_RAD,  &AR5K_SREV_RAD_5112 }, { "2112",  &AR5K_VERSION_RAD,  &AR5K_SREV_RAD_2112 }, { "xxxx",  &AR5K_VERSION_RAD,  &AR5K_SREV_UNKNOWN } };}' unless defined(&AR5K_SREV_NAME);
    eval 'sub AR5K_SREV_UNKNOWN () {0xffff;}' unless defined(&AR5K_SREV_UNKNOWN);
    eval 'sub AR5K_SREV_REV_FPGA () {1;}' unless defined(&AR5K_SREV_REV_FPGA);
    eval 'sub AR5K_SREV_REV_PROTO () {2;}' unless defined(&AR5K_SREV_REV_PROTO);
    eval 'sub AR5K_SREV_REV_PROTOA () {3;}' unless defined(&AR5K_SREV_REV_PROTOA);
    eval 'sub AR5K_SREV_REV_AR5210 () {4;}' unless defined(&AR5K_SREV_REV_AR5210);
    eval 'sub AR5K_SREV_REV_AR5210M () {5;}' unless defined(&AR5K_SREV_REV_AR5210M);
    eval 'sub AR5K_SREV_REV_AR5210M23 () {7;}' unless defined(&AR5K_SREV_REV_AR5210M23);
    eval 'sub AR5K_SREV_REV_AR521023 () {8;}' unless defined(&AR5K_SREV_REV_AR521023);
    eval 'sub AR5K_SREV_VER_AR5210 () {0;}' unless defined(&AR5K_SREV_VER_AR5210);
    eval 'sub AR5K_SREV_VER_AR5311 () {1;}' unless defined(&AR5K_SREV_VER_AR5311);
    eval 'sub AR5K_SREV_VER_AR5311A () {2;}' unless defined(&AR5K_SREV_VER_AR5311A);
    eval 'sub AR5K_SREV_VER_AR5311B () {3;}' unless defined(&AR5K_SREV_VER_AR5311B);
    eval 'sub AR5K_SREV_VER_AR5211 () {4;}' unless defined(&AR5K_SREV_VER_AR5211);
    eval 'sub AR5K_SREV_VER_AR5212 () {5;}' unless defined(&AR5K_SREV_VER_AR5212);
    eval 'sub AR5K_SREV_RAD_5110 () {0x;}' unless defined(&AR5K_SREV_RAD_5110);
    eval 'sub AR5K_SREV_RAD_5111 () {0x10;}' unless defined(&AR5K_SREV_RAD_5111);
    eval 'sub AR5K_SREV_RAD_5111A () {0x15;}' unless defined(&AR5K_SREV_RAD_5111A);
    eval 'sub AR5K_SREV_RAD_2111 () {0x20;}' unless defined(&AR5K_SREV_RAD_2111);
    eval 'sub AR5K_SREV_RAD_5112 () {0x30;}' unless defined(&AR5K_SREV_RAD_5112);
    eval 'sub AR5K_SREV_RAD_5112A () {0x35;}' unless defined(&AR5K_SREV_RAD_5112A);
    eval 'sub AR5K_SREV_RAD_2112 () {0x40;}' unless defined(&AR5K_SREV_RAD_2112);
    eval 'sub AR5K_SREV_RAD_2112A () {0x45;}' unless defined(&AR5K_SREV_RAD_2112A);
    eval 'sub HAL_ABI_VERSION () {0x4090901;}' unless defined(&HAL_ABI_VERSION);
    eval 'sub AR5K_PRINTF () {( &fmt, ...)  &printf("%s: "  &fmt,  &__func__,  &__VA_ARGS__);}' unless defined(&AR5K_PRINTF);
    eval 'sub AR5K_PRINT {
        local($fmt) = @_;
	    eval q( &printf(\\"%s: \\" $fmt,  &__func__));
    }' unless defined(&AR5K_PRINT);
    if(defined(&AR5K_DEBUG)) {
	eval 'sub AR5K_TRACE () { &printf("%s:%d\\n",  &__func__,  &__LINE__);}' unless defined(&AR5K_TRACE);
    } else {
	eval 'sub AR5K_TRACE () {1;}' unless defined(&AR5K_TRACE);
    }
    eval 'sub AR5K_DELAY {
        local($_n) = @_;
	    eval q( &delay($_n));
    }' unless defined(&AR5K_DELAY);
    eval 'sub AR5K_ELEMENTS {
        local($_array) = @_;
	    eval q(($sizeof{$_array} / $sizeof{$_array->[0]}));
    }' unless defined(&AR5K_ELEMENTS);
    eval 'sub AR5K_TUNE_DMA_BEACON_RESP () {2;}' unless defined(&AR5K_TUNE_DMA_BEACON_RESP);
    eval 'sub AR5K_TUNE_SW_BEACON_RESP () {10;}' unless defined(&AR5K_TUNE_SW_BEACON_RESP);
    eval 'sub AR5K_TUNE_ADDITIONAL_SWBA_BACKOFF () {0;}' unless defined(&AR5K_TUNE_ADDITIONAL_SWBA_BACKOFF);
    eval 'sub AR5K_TUNE_RADAR_ALERT () { &AH_FALSE;}' unless defined(&AR5K_TUNE_RADAR_ALERT);
    eval 'sub AR5K_TUNE_MIN_TX_FIFO_THRES () {1;}' unless defined(&AR5K_TUNE_MIN_TX_FIFO_THRES);
    eval 'sub AR5K_TUNE_MAX_TX_FIFO_THRES () {(( &IEEE80211_MAX_LEN / 64) + 1);}' unless defined(&AR5K_TUNE_MAX_TX_FIFO_THRES);
    eval 'sub AR5K_TUNE_RSSI_THRES () {1792;}' unless defined(&AR5K_TUNE_RSSI_THRES);
    eval 'sub AR5K_TUNE_REGISTER_TIMEOUT () {20000;}' unless defined(&AR5K_TUNE_REGISTER_TIMEOUT);
    eval 'sub AR5K_TUNE_REGISTER_DWELL_TIME () {20000;}' unless defined(&AR5K_TUNE_REGISTER_DWELL_TIME);
    eval 'sub AR5K_TUNE_BEACON_INTERVAL () {100;}' unless defined(&AR5K_TUNE_BEACON_INTERVAL);
    eval 'sub AR5K_TUNE_AIFS () {2;}' unless defined(&AR5K_TUNE_AIFS);
    eval 'sub AR5K_TUNE_AIFS_11B () {2;}' unless defined(&AR5K_TUNE_AIFS_11B);
    eval 'sub AR5K_TUNE_AIFS_XR () {0;}' unless defined(&AR5K_TUNE_AIFS_XR);
    eval 'sub AR5K_TUNE_CWMIN () {15;}' unless defined(&AR5K_TUNE_CWMIN);
    eval 'sub AR5K_TUNE_CWMIN_11B () {31;}' unless defined(&AR5K_TUNE_CWMIN_11B);
    eval 'sub AR5K_TUNE_CWMIN_XR () {3;}' unless defined(&AR5K_TUNE_CWMIN_XR);
    eval 'sub AR5K_TUNE_CWMAX () {1023;}' unless defined(&AR5K_TUNE_CWMAX);
    eval 'sub AR5K_TUNE_CWMAX_11B () {1023;}' unless defined(&AR5K_TUNE_CWMAX_11B);
    eval 'sub AR5K_TUNE_CWMAX_XR () {7;}' unless defined(&AR5K_TUNE_CWMAX_XR);
    eval 'sub AR5K_TUNE_NOISE_FLOOR () {-72;}' unless defined(&AR5K_TUNE_NOISE_FLOOR);
    eval 'sub AR5K_TUNE_MAX_TXPOWER () {60;}' unless defined(&AR5K_TUNE_MAX_TXPOWER);
    eval 'sub AR5K_TUNE_DEFAULT_TXPOWER () {30;}' unless defined(&AR5K_TUNE_DEFAULT_TXPOWER);
    eval 'sub AR5K_TUNE_TPC_TXPOWER () { &AH_TRUE;}' unless defined(&AR5K_TUNE_TPC_TXPOWER);
    eval 'sub AR5K_TUNE_ANT_DIVERSITY () { &AH_TRUE;}' unless defined(&AR5K_TUNE_ANT_DIVERSITY);
    eval 'sub AR5K_TUNE_HWTXTRIES () {4;}' unless defined(&AR5K_TUNE_HWTXTRIES);
    eval 'sub AR5K_TUNE_REGDOMAIN () { &DMN_FCC1_FCCA;}' unless defined(&AR5K_TUNE_REGDOMAIN);
    eval 'sub AR5K_TUNE_CTRY () { &CTRY_DEFAULT;}' unless defined(&AR5K_TUNE_CTRY);
    eval 'sub AR5K_INIT_MODE () {(  &IEEE80211_CHAN_5GHZ |  &IEEE80211_CHAN_OFDM );}' unless defined(&AR5K_INIT_MODE);
    eval 'sub AR5K_INIT_TX_LATENCY () {502;}' unless defined(&AR5K_INIT_TX_LATENCY);
    eval 'sub AR5K_INIT_USEC () {39;}' unless defined(&AR5K_INIT_USEC);
    eval 'sub AR5K_INIT_USEC_TURBO () {79;}' unless defined(&AR5K_INIT_USEC_TURBO);
    eval 'sub AR5K_INIT_USEC_32 () {31;}' unless defined(&AR5K_INIT_USEC_32);
    eval 'sub AR5K_INIT_CARR_SENSE_EN () {1;}' unless defined(&AR5K_INIT_CARR_SENSE_EN);
    eval 'sub AR5K_INIT_PROG_IFS () {920;}' unless defined(&AR5K_INIT_PROG_IFS);
    eval 'sub AR5K_INIT_PROG_IFS_TURBO () {960;}' unless defined(&AR5K_INIT_PROG_IFS_TURBO);
    eval 'sub AR5K_INIT_EIFS () {3440;}' unless defined(&AR5K_INIT_EIFS);
    eval 'sub AR5K_INIT_EIFS_TURBO () {6880;}' unless defined(&AR5K_INIT_EIFS_TURBO);
    eval 'sub AR5K_INIT_SLOT_TIME () {396;}' unless defined(&AR5K_INIT_SLOT_TIME);
    eval 'sub AR5K_INIT_SLOT_TIME_TURBO () {480;}' unless defined(&AR5K_INIT_SLOT_TIME_TURBO);
    eval 'sub AR5K_INIT_ACK_CTS_TIMEOUT () {1024;}' unless defined(&AR5K_INIT_ACK_CTS_TIMEOUT);
    eval 'sub AR5K_INIT_ACK_CTS_TIMEOUT_TURBO () {0x8000800;}' unless defined(&AR5K_INIT_ACK_CTS_TIMEOUT_TURBO);
    eval 'sub AR5K_INIT_SIFS () {560;}' unless defined(&AR5K_INIT_SIFS);
    eval 'sub AR5K_INIT_SIFS_TURBO () {480;}' unless defined(&AR5K_INIT_SIFS_TURBO);
    eval 'sub AR5K_INIT_SH_RETRY () {10;}' unless defined(&AR5K_INIT_SH_RETRY);
    eval 'sub AR5K_INIT_LG_RETRY () { &AR5K_INIT_SH_RETRY;}' unless defined(&AR5K_INIT_LG_RETRY);
    eval 'sub AR5K_INIT_SSH_RETRY () {32;}' unless defined(&AR5K_INIT_SSH_RETRY);
    eval 'sub AR5K_INIT_SLG_RETRY () { &AR5K_INIT_SSH_RETRY;}' unless defined(&AR5K_INIT_SLG_RETRY);
    eval 'sub AR5K_INIT_TX_RETRY () {10;}' unless defined(&AR5K_INIT_TX_RETRY);
    eval 'sub AR5K_INIT_TOPS () {8;}' unless defined(&AR5K_INIT_TOPS);
    eval 'sub AR5K_INIT_RXNOFRM () {8;}' unless defined(&AR5K_INIT_RXNOFRM);
    eval 'sub AR5K_INIT_RPGTO () {0;}' unless defined(&AR5K_INIT_RPGTO);
    eval 'sub AR5K_INIT_TXNOFRM () {0;}' unless defined(&AR5K_INIT_TXNOFRM);
    eval 'sub AR5K_INIT_BEACON_PERIOD () {65535;}' unless defined(&AR5K_INIT_BEACON_PERIOD);
    eval 'sub AR5K_INIT_TIM_OFFSET () {0;}' unless defined(&AR5K_INIT_TIM_OFFSET);
    eval 'sub AR5K_INIT_BEACON_EN () {0;}' unless defined(&AR5K_INIT_BEACON_EN);
    eval 'sub AR5K_INIT_RESET_TSF () {0;}' unless defined(&AR5K_INIT_RESET_TSF);
    eval 'sub AR5K_INIT_TRANSMIT_LATENCY () {( ( &AR5K_INIT_TX_LATENCY << 14) | ( &AR5K_INIT_USEC_32 << 7) | ( &AR5K_INIT_USEC) );}' unless defined(&AR5K_INIT_TRANSMIT_LATENCY);
    eval 'sub AR5K_INIT_TRANSMIT_LATENCY_TURBO () {( ( &AR5K_INIT_TX_LATENCY << 14) | ( &AR5K_INIT_USEC_32 << 7) | ( &AR5K_INIT_USEC_TURBO) );}' unless defined(&AR5K_INIT_TRANSMIT_LATENCY_TURBO);
    eval 'sub AR5K_INIT_PROTO_TIME_CNTRL () {( ( &AR5K_INIT_CARR_SENSE_EN << 26) | ( &AR5K_INIT_EIFS << 12) | ( &AR5K_INIT_PROG_IFS) );}' unless defined(&AR5K_INIT_PROTO_TIME_CNTRL);
    eval 'sub AR5K_INIT_PROTO_TIME_CNTRL_TURBO () {( ( &AR5K_INIT_CARR_SENSE_EN << 26) | ( &AR5K_INIT_EIFS_TURBO << 12) | ( &AR5K_INIT_PROG_IFS_TURBO) );}' unless defined(&AR5K_INIT_PROTO_TIME_CNTRL_TURBO);
    eval 'sub AR5K_INIT_BEACON_CONTROL () {( ( &AR5K_INIT_RESET_TSF << 24) | ( &AR5K_INIT_BEACON_EN << 23) | ( &AR5K_INIT_TIM_OFFSET << 16) | ( &AR5K_INIT_BEACON_PERIOD) );}' unless defined(&AR5K_INIT_BEACON_CONTROL);
    eval 'sub AR5K_REG_WRITE {
        local($_reg, $_val) = @_;
	    eval q( &bus_space_write_4( ($hal->{ah_st}),  ($hal->{ah_sh}), ($_reg), ($_val)));
    }' unless defined(&AR5K_REG_WRITE);
    eval 'sub AR5K_REG_READ {
        local($_reg) = @_;
	    eval q( &bus_space_read_4( ($hal->{ah_st}),  ($hal->{ah_sh}), ($_reg)));
    }' unless defined(&AR5K_REG_READ);
    eval 'sub AR5K_REG_SM {
        local($_val, $_flags) = @_;
	    eval q(((($_val) << $_flags &_S) & ($_flags)));
    }' unless defined(&AR5K_REG_SM);
    eval 'sub AR5K_REG_MS {
        local($_val, $_flags) = @_;
	    eval q(((($_val) & ($_flags)) >> $_flags &_S));
    }' unless defined(&AR5K_REG_MS);
    eval 'sub AR5K_REG_WRITE_BITS {
        local($_reg, $_flags, $_val) = @_;
	    eval q( &AR5K_REG_WRITE($_reg, ( &AR5K_REG_READ($_reg) &~ ($_flags)) | ((($_val) << $_flags &_S) & ($_flags))));
    }' unless defined(&AR5K_REG_WRITE_BITS);
    eval 'sub AR5K_REG_MASKED_BITS {
        local($_reg, $_flags, $_mask) = @_;
	    eval q( &AR5K_REG_WRITE($_reg, ( &AR5K_REG_READ($_reg) & ($_mask)) | ($_flags)));
    }' unless defined(&AR5K_REG_MASKED_BITS);
    eval 'sub AR5K_REG_ENABLE_BITS {
        local($_reg, $_flags) = @_;
	    eval q( &AR5K_REG_WRITE($_reg,  &AR5K_REG_READ($_reg) | ($_flags)));
    }' unless defined(&AR5K_REG_ENABLE_BITS);
    eval 'sub AR5K_REG_DISABLE_BITS {
        local($_reg, $_flags) = @_;
	    eval q( &AR5K_REG_WRITE($_reg,  &AR5K_REG_READ($_reg) &~ ($_flags)));
    }' unless defined(&AR5K_REG_DISABLE_BITS);
    eval 'sub AR5K_PHY_WRITE {
        local($_reg, $_val) = @_;
	    eval q( &AR5K_REG_WRITE( ($hal->{ah_phy}) + (($_reg) << 2), $_val));
    }' unless defined(&AR5K_PHY_WRITE);
    eval 'sub AR5K_PHY_READ {
        local($_reg) = @_;
	    eval q( &AR5K_REG_READ( ($hal->{ah_phy}) + (($_reg) << 2)));
    }' unless defined(&AR5K_PHY_READ);
    eval 'sub AR5K_REG_WAIT {
        local($_i) = @_;
	    eval q( &if ($_i % 64)  &AR5K_DELAY(1););
    }' unless defined(&AR5K_REG_WAIT);
    eval 'sub AR5K_EEPROM_READ {
        local($_o, $_v) = @_;
	    eval q({  &if (( &ret =  ($hal->{ah_eeprom_read})( &hal, ($_o), ($_v))) != 0)  &return ( &ret); });
    }' unless defined(&AR5K_EEPROM_READ);
    eval 'sub AR5K_EEPROM_READ_HDR {
        local($_o, $_v) = @_;
	    eval q( &AR5K_EEPROM_READ($_o,  ($hal->{ah_capabilities}->{cap_eeprom}->{_v})););
    }' unless defined(&AR5K_EEPROM_READ_HDR);
    eval 'sub AR5K_REG_READ_Q {
        local($_reg, $_queue) = @_;
	    eval q(( &AR5K_REG_READ($_reg) & (1<< $_queue)));
    }' unless defined(&AR5K_REG_READ_Q);
    eval 'sub AR5K_REG_WRITE_Q {
        local($_reg, $_queue) = @_;
	    eval q( &AR5K_REG_WRITE($_reg, (1<< $_queue)));
    }' unless defined(&AR5K_REG_WRITE_Q);
    eval 'sub AR5K_Q_ENABLE_BITS {
        local($_reg, $_queue) = @_;
	    eval q( &do { $_reg |= 1<< $_queue; }  &while (0));
    }' unless defined(&AR5K_Q_ENABLE_BITS);
    eval 'sub AR5K_Q_DISABLE_BITS {
        local($_reg, $_queue) = @_;
	    eval q( &do { $_reg &= ~(1<< $_queue); }  &while (0));
    }' unless defined(&AR5K_Q_DISABLE_BITS);
    eval 'sub AR5K_LE_READ_2 {
        local($_p) = @_;
	    eval q(((( &const  &u_int8_t *)($_p))[0] | ((( &const  &u_int8_t *)($_p))[1] << 8)));
    }' unless defined(&AR5K_LE_READ_2);
    eval 'sub AR5K_LE_READ_4 {
        local($_p) = @_;
	    eval q(((( &const  &u_int8_t *)($_p))[0] | ((( &const  &u_int8_t *)($_p))[1] << 8) | ((( &const  &u_int8_t *)($_p))[2] << 16) | ((( &const  &u_int8_t *)($_p))[3] << 24)));
    }' unless defined(&AR5K_LE_READ_4);
    eval 'sub AR5K_LE_WRITE_2 {
        local($_p, $_val) = @_;
	    eval q((((( &u_int8_t *)($_p))[0] = (( &u_int32_t)($_val) & 0xff)), ((( &u_int8_t *)($_p))[1] = ((( &u_int32_t)($_val) >> 8) & 0xff))));
    }' unless defined(&AR5K_LE_WRITE_2);
    eval 'sub AR5K_LE_WRITE_4 {
        local($_p, $_val) = @_;
	    eval q((((( &u_int8_t *)($_p))[0] = (( &u_int32_t)($_val) & 0xff)), ((( &u_int8_t *)($_p))[1] = ((( &u_int32_t)($_val) >> 8) & 0xff)), ((( &u_int8_t *)($_p))[2] = ((( &u_int32_t)($_val) >> 16) & 0xff)), ((( &u_int8_t *)($_p))[3] = ((( &u_int32_t)($_val) >> 24) & 0xff))));
    }' unless defined(&AR5K_LE_WRITE_4);
    eval("sub AR5K_INI_WRITE () { 0; }") unless defined(&AR5K_INI_WRITE);
    eval("sub AR5K_INI_READ () { 1; }") unless defined(&AR5K_INI_READ);
    eval 'sub AR5K_INI_VAL_11A () {0;}' unless defined(&AR5K_INI_VAL_11A);
    eval 'sub AR5K_INI_VAL_11A_TURBO () {1;}' unless defined(&AR5K_INI_VAL_11A_TURBO);
    eval 'sub AR5K_INI_VAL_11B () {2;}' unless defined(&AR5K_INI_VAL_11B);
    eval 'sub AR5K_INI_VAL_11G () {3;}' unless defined(&AR5K_INI_VAL_11G);
    eval 'sub AR5K_INI_VAL_11G_TURBO () {4;}' unless defined(&AR5K_INI_VAL_11G_TURBO);
    eval 'sub AR5K_INI_VAL_XR () {0;}' unless defined(&AR5K_INI_VAL_XR);
    eval 'sub AR5K_INI_VAL_MAX () {5;}' unless defined(&AR5K_INI_VAL_MAX);
    eval 'sub AR5K_INI_PHY_5111 () {0;}' unless defined(&AR5K_INI_PHY_5111);
    eval 'sub AR5K_INI_PHY_5112 () {1;}' unless defined(&AR5K_INI_PHY_5112);
    eval 'sub AR5K_INI_PHY_511X () {1;}' unless defined(&AR5K_INI_PHY_511X);
    eval 'sub AR5K_AR5111_INI_RF_MAX_BANKS () { &AR5K_MAX_RF_BANKS;}' unless defined(&AR5K_AR5111_INI_RF_MAX_BANKS);
    eval 'sub AR5K_AR5112_INI_RF_MAX_BANKS () { &AR5K_MAX_RF_BANKS;}' unless defined(&AR5K_AR5112_INI_RF_MAX_BANKS);
    eval 'sub AR5K_AR5111_INI_RF () {{ { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x380000, 0x380000, 0x380000, 0x380000, 0x380000 } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 0, 0x989c, { 0x, 0x, 0xc0, 0x80, 0x80 } }, { 0, 0x989c, { 0x400f9, 0x400f9, 0x400ff, 0x400fd, 0x400fd } }, { 0, 0x98d4, { 0x, 0x, 0x4, 0x4, 0x4 } }, { 1, 0x98d4, { 0x20, 0x20, 0x20, 0x20, 0x20 } }, { 2, 0x98d4, { 0x10, 0x14, 0x10, 0x10, 0x14 } }, { 3, 0x98d8, { 0x601068, 0x601068, 0x601068, 0x601068, 0x601068 } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000 } }, { 6, 0x989c, { 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000 } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0x, 0x, 0xa000000, 0x, 0x } }, { 6, 0x989c, { 0x3800c0, 0x380080, 0x23800c0, 0x3800c0, 0x3800c0 } }, { 6, 0x989c, { 0x20006, 0x20006, 0x6, 0x20006, 0x20006 } }, { 6, 0x989c, { 0x89, 0x89, 0x89, 0x89, 0x89 } }, { 6, 0x989c, { 0xa0, 0xa0, 0xa0, 0xa0, 0xa0 } }, { 6, 0x989c, { 0x40007, 0x40007, 0x40007, 0x40007, 0x40007 } }, { 6, 0x98d4, { 0x1a, 0x1a, 0x1a, 0x1a, 0x1a } }, { 7, 0x989c, { 0x40, 0x48, 0x40, 0x40, 0x40 } }, { 7, 0x989c, { 0x10, 0x10, 0x10, 0x10, 0x10 } }, { 7, 0x989c, { 0x8, 0x8, 0x8, 0x8, 0x8 } }, { 7, 0x989c, { 0x4f, 0x4f, 0x4f, 0x4f, 0x4f } }, { 7, 0x989c, { 0xf1, 0xf1, 0x61, 0xf1, 0xf1 } }, { 7, 0x989c, { 0x904f, 0x904f, 0x904c, 0x904f, 0x904f } }, { 7, 0x989c, { 0x125a, 0x125a, 0x129a, 0x125a, 0x125a } }, { 7, 0x98cc, { 0xe, 0xe, 0xf, 0xe, 0xe } }, };}' unless defined(&AR5K_AR5111_INI_RF);
    eval 'sub AR5K_AR5112_INI_RF () {{ { 1, 0x98d4, { 0x20, 0x20, 0x20, 0x20, 0x20 } }, { 2, 0x98d0, { 0x3060408, 0x3070408, 0x3060408, 0x3060408, 0x3070408 } }, { 3, 0x98dc, { 0xa0c0c0, 0xa0c0c0, 0xe0c0c0, 0xe0c0c0, 0xe0c0c0 } }, { 6, 0x989c, { 0xf000000, 0xf000000, 0xf000000, 0xf000000, 0xf000000 } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0x800000, 0x800000, 0x800000, 0x800000, 0x800000 } }, { 6, 0x989c, { 0x2a0000, 0x2a0000, 0x2a0000, 0x2a0000, 0x2a0000 } }, { 6, 0x989c, { 0x10000, 0x10000, 0x10000, 0x10000, 0x10000 } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0x180000, 0x180000, 0x180000, 0x180000, 0x180000 } }, { 6, 0x989c, { 0x600000, 0x600000, 0x6e0000, 0x6e0000, 0x6e0000 } }, { 6, 0x989c, { 0xc70000, 0xc70000, 0xc70000, 0xc70000, 0xc70000 } }, { 6, 0x989c, { 0x4b0000, 0x4b0000, 0x4b0000, 0x4b0000, 0x4b0000 } }, { 6, 0x989c, { 0x4480000, 0x4480000, 0x4480000, 0x4480000, 0x4480000 } }, { 6, 0x989c, { 0x220000, 0x220000, 0x220000, 0x220000, 0x220000 } }, { 6, 0x989c, { 0xe40000, 0xe40000, 0xe40000, 0xe40000, 0xe40000 } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0xfc0000, 0xfc0000, 0xfc0000, 0xfc0000, 0xfc0000 } }, { 6, 0x989c, { 0xff0000, 0xff0000, 0xff0000, 0xff0000, 0xff0000 } }, { 6, 0x989c, { 0x43f0000, 0x43f0000, 0x43f0000, 0x43f0000, 0x43f0000 } }, { 6, 0x989c, { 0xc0000, 0xc0000, 0xc0000, 0xc0000, 0xc0000 } }, { 6, 0x989c, { 0x2190000, 0x2190000, 0x2190000, 0x2190000, 0x2190000 } }, { 6, 0x989c, { 0x240000, 0x240000, 0x240000, 0x240000, 0x240000 } }, { 6, 0x989c, { 0xb40000, 0xb40000, 0xb40000, 0xb40000, 0xb40000 } }, { 6, 0x989c, { 0x990000, 0x990000, 0x990000, 0x990000, 0x990000 } }, { 6, 0x989c, { 0x500000, 0x500000, 0x500000, 0x500000, 0x500000 } }, { 6, 0x989c, { 0x2a0000, 0x2a0000, 0x2a0000, 0x2a0000, 0x2a0000 } }, { 6, 0x989c, { 0x120000, 0x120000, 0x120000, 0x120000, 0x120000 } }, { 6, 0x989c, { 0xc0320000, 0xc0320000, 0xc0320000, 0xc0320000, 0xc0320000 } }, { 6, 0x989c, { 0x1740000, 0x1740000, 0x1740000, 0x1740000, 0x1740000 } }, { 6, 0x989c, { 0x110000, 0x110000, 0x110000, 0x110000, 0x110000 } }, { 6, 0x989c, { 0x86280000, 0x86280000, 0x86280000, 0x86280000, 0x86280000 } }, { 6, 0x989c, { 0x31840000, 0x31840000, 0x31840000, 0x31840000, 0x31840000 } }, { 6, 0x989c, { 0xf20080, 0xf20080, 0xf20080, 0xf20080, 0xf20080 } }, { 6, 0x989c, { 0x70019, 0x70019, 0x70019, 0x70019, 0x70019 } }, { 6, 0x989c, { 0x3, 0x3, 0x3, 0x3, 0x3 } }, { 6, 0x989c, { 0x, 0x, 0x, 0x, 0x } }, { 6, 0x989c, { 0xb2, 0xb2, 0xb2, 0xb2, 0xb2 } }, { 6, 0x989c, { 0xb02084, 0xb02084, 0xb02084, 0xb02084, 0xb02084 } }, { 6, 0x989c, { 0x4125a4, 0x4125a4, 0x4125a4, 0x4125a4, 0x4125a4 } }, { 6, 0x989c, { 0x119220, 0x119220, 0x119220, 0x119220, 0x119220 } }, { 6, 0x989c, { 0x1a4800, 0x1a4800, 0x1a4800, 0x1a4800, 0x1a4800 } }, { 6, 0x98d8, { 0xb0230, 0xb0230, 0xb0230, 0xb0230, 0xb0230 } }, { 7, 0x989c, { 0x94, 0x94, 0x94, 0x94, 0x94 } }, { 7, 0x989c, { 0x91, 0x91, 0x91, 0x91, 0x91 } }, { 7, 0x989c, { 0x12, 0x12, 0x12, 0x12, 0x12 } }, { 7, 0x989c, { 0x80, 0x80, 0x80, 0x80, 0x80 } }, { 7, 0x989c, { 0xd9, 0xd9, 0xd9, 0xd9, 0xd9 } }, { 7, 0x989c, { 0x60, 0x60, 0x60, 0x60, 0x60 } }, { 7, 0x989c, { 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 } }, { 7, 0x989c, { 0xa2, 0xa2, 0xa2, 0xa2, 0xa2 } }, { 7, 0x989c, { 0x52, 0x52, 0x52, 0x52, 0x52 } }, { 7, 0x989c, { 0xd4, 0xd4, 0xd4, 0xd4, 0xd4 } }, { 7, 0x989c, { 0x14cc, 0x14cc, 0x14cc, 0x14cc, 0x14cc } }, { 7, 0x989c, { 0x48c, 0x48c, 0x48c, 0x48c, 0x48c } }, { 7, 0x98c4, { 0x3, 0x3, 0x3, 0x3, 0x3 } }, };}' unless defined(&AR5K_AR5112_INI_RF);
    eval 'sub AR5K_INI_RFGAIN_5GHZ () {0;}' unless defined(&AR5K_INI_RFGAIN_5GHZ);
    eval 'sub AR5K_INI_RFGAIN_2GHZ () {1;}' unless defined(&AR5K_INI_RFGAIN_2GHZ);
    eval 'sub AR5K_INI_RFGAIN () {{ { 0x9a00, { { 0x1a9, 0x }, { 0x7, 0x7 } } }, { 0x9a04, { { 0x1e9, 0x40 }, { 0x47, 0x47 } } }, { 0x9a08, { { 0x29, 0x80 }, { 0x87, 0x87 } } }, { 0x9a0c, { { 0x69, 0x150 }, { 0x1a0, 0x1a0 } } }, { 0x9a10, { { 0x199, 0x190 }, { 0x1e0, 0x1e0 } } }, { 0x9a14, { { 0x1d9, 0x1d0 }, { 0x20, 0x20 } } }, { 0x9a18, { { 0x19, 0x10 }, { 0x60, 0x60 } } }, { 0x9a1c, { { 0x59, 0x44 }, { 0x1a1, 0x1a1 } } }, { 0x9a20, { { 0x99, 0x84 }, { 0x1e1, 0x1e1 } } }, { 0x9a24, { { 0x1a5, 0x148 }, { 0x21, 0x21 } } }, { 0x9a28, { { 0x1e5, 0x188 }, { 0x61, 0x61 } } }, { 0x9a2c, { { 0x25, 0x1c8 }, { 0x162, 0x162 } } }, { 0x9a30, { { 0x1c8, 0x14 }, { 0x1a2, 0x1a2 } } }, { 0x9a34, { { 0x8, 0x42 }, { 0x1e2, 0x1e2 } } }, { 0x9a38, { { 0x48, 0x82 }, { 0x22, 0x22 } } }, { 0x9a3c, { { 0x88, 0x178 }, { 0x62, 0x62 } } }, { 0x9a40, { { 0x198, 0x1b8 }, { 0x163, 0x163 } } }, { 0x9a44, { { 0x1d8, 0x1f8 }, { 0x1a3, 0x1a3 } } }, { 0x9a48, { { 0x18, 0x12 }, { 0x1e3, 0x1e3 } } }, { 0x9a4c, { { 0x58, 0x52 }, { 0x23, 0x23 } } }, { 0x9a50, { { 0x98, 0x92 }, { 0x63, 0x63 } } }, { 0x9a54, { { 0x1a4, 0x17c }, { 0x184, 0x184 } } }, { 0x9a58, { { 0x1e4, 0x1bc }, { 0x1c4, 0x1c4 } } }, { 0x9a5c, { { 0x24, 0x1fc }, { 0x4, 0x4 } } }, { 0x9a60, { { 0x64, 0xa }, { 0x1ea, 0xb } } }, { 0x9a64, { { 0xa4, 0x4a }, { 0x2a, 0x4b } } }, { 0x9a68, { { 0xe4, 0x8a }, { 0x6a, 0x8b } } }, { 0x9a6c, { { 0x10a, 0x15a }, { 0xaa, 0x1ac } } }, { 0x9a70, { { 0x14a, 0x19a }, { 0x1ab, 0x1ec } } }, { 0x9a74, { { 0x18a, 0x1da }, { 0x1eb, 0x2c } } }, { 0x9a78, { { 0x1ca, 0xe }, { 0x2b, 0x12 } } }, { 0x9a7c, { { 0xa, 0x4e }, { 0x6b, 0x52 } } }, { 0x9a80, { { 0x4a, 0x8e }, { 0xab, 0x92 } } }, { 0x9a84, { { 0x8a, 0x15e }, { 0x1ac, 0x193 } } }, { 0x9a88, { { 0x1ba, 0x19e }, { 0x1ec, 0x1d3 } } }, { 0x9a8c, { { 0x1fa, 0x1de }, { 0x2c, 0x13 } } }, { 0x9a90, { { 0x3a, 0x9 }, { 0x3a, 0x53 } } }, { 0x9a94, { { 0x7a, 0x49 }, { 0x7a, 0x93 } } }, { 0x9a98, { { 0x186, 0x89 }, { 0xba, 0x194 } } }, { 0x9a9c, { { 0x1c6, 0x179 }, { 0x1bb, 0x1d4 } } }, { 0x9aa0, { { 0x6, 0x1b9 }, { 0x1fb, 0x14 } } }, { 0x9aa4, { { 0x46, 0x1f9 }, { 0x3b, 0x3a } } }, { 0x9aa8, { { 0x86, 0x39 }, { 0x7b, 0x7a } } }, { 0x9aac, { { 0xc6, 0x79 }, { 0xbb, 0xba } } }, { 0x9ab0, { { 0xc6, 0xb9 }, { 0x1bc, 0x1bb } } }, { 0x9ab4, { { 0xc6, 0x1bd }, { 0x1fc, 0x1fb } } }, { 0x9ab8, { { 0xc6, 0x1fd }, { 0x3c, 0x3b } } }, { 0x9abc, { { 0xc6, 0x3d }, { 0x7c, 0x7b } } }, { 0x9ac0, { { 0xc6, 0x7d }, { 0xbc, 0xbb } } }, { 0x9ac4, { { 0xc6, 0xbd }, { 0xfc, 0x1bc } } }, { 0x9ac8, { { 0xc6, 0xfd }, { 0xfc, 0x1fc } } }, { 0x9acc, { { 0xc6, 0xfd }, { 0xfc, 0x3c } } }, { 0x9ad0, { { 0xc6, 0xfd }, { 0xfc, 0x7c } } }, { 0x9ad4, { { 0xc6, 0xfd }, { 0xfc, 0xbc } } }, { 0x9ad8, { { 0xc6, 0xfd }, { 0xfc, 0xfc } } }, { 0x9adc, { { 0xc6, 0xfd }, { 0xfc, 0xfc } } }, { 0x9ae0, { { 0xc6, 0xfd }, { 0xfc, 0xfc } } }, { 0x9ae4, { { 0xc6, 0xfd }, { 0xfc, 0xfc } } }, { 0x9ae8, { { 0xc6, 0xfd }, { 0xfc, 0xfc } } }, { 0x9aec, { { 0xc6, 0xfd }, { 0xfc, 0xfc } } }, { 0x9af0, { { 0xc6, 0xfd }, { 0xfc, 0xfc } } }, { 0x9af4, { { 0xc6, 0xfd }, { 0xfc, 0xfc } } }, { 0x9af8, { { 0xc6, 0xfd }, { 0xfc, 0xfc } } }, { 0x9afc, { { 0xc6, 0xfd }, { 0xfc, 0xfc } } }, };}' unless defined(&AR5K_INI_RFGAIN);
}
1;
