require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DEV_IC_RTWVAR_H_)) {
    eval 'sub _DEV_IC_RTWVAR_H_ () {1;}' unless defined(&_DEV_IC_RTWVAR_H_);
    require 'sys/device.ph';
    require 'sys/queue.ph';
    require 'sys/timeout.ph';
    if(defined(&RTW_DEBUG)) {
	eval 'sub RTW_DEBUG_TUNE () {0x1;}' unless defined(&RTW_DEBUG_TUNE);
	eval 'sub RTW_DEBUG_PKTFILT () {0x2;}' unless defined(&RTW_DEBUG_PKTFILT);
	eval 'sub RTW_DEBUG_XMIT () {0x4;}' unless defined(&RTW_DEBUG_XMIT);
	eval 'sub RTW_DEBUG_XMIT_DESC () {0x8;}' unless defined(&RTW_DEBUG_XMIT_DESC);
	eval 'sub RTW_DEBUG_NODE () {0x10;}' unless defined(&RTW_DEBUG_NODE);
	eval 'sub RTW_DEBUG_PWR () {0x20;}' unless defined(&RTW_DEBUG_PWR);
	eval 'sub RTW_DEBUG_ATTACH () {0x40;}' unless defined(&RTW_DEBUG_ATTACH);
	eval 'sub RTW_DEBUG_REGDUMP () {0x80;}' unless defined(&RTW_DEBUG_REGDUMP);
	eval 'sub RTW_DEBUG_ACCESS () {0x100;}' unless defined(&RTW_DEBUG_ACCESS);
	eval 'sub RTW_DEBUG_RESET () {0x200;}' unless defined(&RTW_DEBUG_RESET);
	eval 'sub RTW_DEBUG_INIT () {0x400;}' unless defined(&RTW_DEBUG_INIT);
	eval 'sub RTW_DEBUG_IOSTATE () {0x800;}' unless defined(&RTW_DEBUG_IOSTATE);
	eval 'sub RTW_DEBUG_RECV () {0x1000;}' unless defined(&RTW_DEBUG_RECV);
	eval 'sub RTW_DEBUG_RECV_DESC () {0x2000;}' unless defined(&RTW_DEBUG_RECV_DESC);
	eval 'sub RTW_DEBUG_IO_KICK () {0x4000;}' unless defined(&RTW_DEBUG_IO_KICK);
	eval 'sub RTW_DEBUG_INTR () {0x8000;}' unless defined(&RTW_DEBUG_INTR);
	eval 'sub RTW_DEBUG_PHY () {0x10000;}' unless defined(&RTW_DEBUG_PHY);
	eval 'sub RTW_DEBUG_PHYIO () {0x20000;}' unless defined(&RTW_DEBUG_PHYIO);
	eval 'sub RTW_DEBUG_PHYBITIO () {0x40000;}' unless defined(&RTW_DEBUG_PHYBITIO);
	eval 'sub RTW_DEBUG_TIMEOUT () {0x80000;}' unless defined(&RTW_DEBUG_TIMEOUT);
	eval 'sub RTW_DEBUG_BUGS () {0x100000;}' unless defined(&RTW_DEBUG_BUGS);
	eval 'sub RTW_DEBUG_BEACON () {0x200000;}' unless defined(&RTW_DEBUG_BEACON);
	eval 'sub RTW_DEBUG_LED () {0x400000;}' unless defined(&RTW_DEBUG_LED);
	eval 'sub RTW_DEBUG_MAX () {0x7fffff;}' unless defined(&RTW_DEBUG_MAX);
	eval 'sub RTW_DPRINTF {
	    local($__flags, $__x) = @_;
    	    eval q( &if (( &rtw_debug & ($__flags)) != 0)  &printf $__x);
	}' unless defined(&RTW_DPRINTF);
	eval 'sub DPRINTF {
	    local($__sc, $__flags, $__x) = @_;
    	    eval q( &if ((($__sc)-> ($sc_ic->{ic_if}->{if_flags}) &  &IFF_DEBUG) != 0)  &RTW_DPRINTF($__flags, $__x));
	}' unless defined(&DPRINTF);
    } else {
	eval 'sub RTW_DPRINTF {
	    local($__flags, $__x) = @_;
    	    eval q();
	}' unless defined(&RTW_DPRINTF);
	eval 'sub DPRINTF {
	    local($__sc, $__flags, $__x) = @_;
    	    eval q();
	}' unless defined(&DPRINTF);
    }
    eval 'sub KASSERT2 {
        local($__cond, $__msg) = @_;
	    eval q( &do {  &if (!($__cond))  &panic $__msg ; }  &while (0));
    }' unless defined(&KASSERT2);
    eval 'sub NEXT_ATTACH_STATE {
        local($sc, $state) = @_;
	    eval q( &do {  &DPRINTF($sc,  &RTW_DEBUG_ATTACH, (\\"%s: attach state %s\\\\n\\",  &__func__, $state));  ($sc->{sc_attach_state}) = $state; }  &while (0));
    }' unless defined(&NEXT_ATTACH_STATE);
    eval("sub RTW_LOCALE_USA () { 0; }") unless defined(&RTW_LOCALE_USA);
    eval("sub RTW_LOCALE_EUROPE () { 1; }") unless defined(&RTW_LOCALE_EUROPE);
    eval("sub RTW_LOCALE_JAPAN () { 2; }") unless defined(&RTW_LOCALE_JAPAN);
    eval("sub RTW_LOCALE_UNKNOWN () { 3; }") unless defined(&RTW_LOCALE_UNKNOWN);
    eval("sub RTW_RFCHIPID_RESERVED () { 0x00; }") unless defined(&RTW_RFCHIPID_RESERVED);
    eval("sub RTW_RFCHIPID_INTERSIL () { 0x01; }") unless defined(&RTW_RFCHIPID_INTERSIL);
    eval("sub RTW_RFCHIPID_RFMD2948 () { 0x02; }") unless defined(&RTW_RFCHIPID_RFMD2948);
    eval("sub RTW_RFCHIPID_PHILIPS () { 0x03; }") unless defined(&RTW_RFCHIPID_PHILIPS);
    eval("sub RTW_RFCHIPID_MAXIM2820 () { 0x04; }") unless defined(&RTW_RFCHIPID_MAXIM2820);
    eval("sub RTW_RFCHIPID_GCT () { 0x05; }") unless defined(&RTW_RFCHIPID_GCT);
    eval("sub RTW_RFCHIPID_RFMD2958 () { 0x06; }") unless defined(&RTW_RFCHIPID_RFMD2958);
    eval("sub RTW_RFCHIPID_MAXIM2822 () { 0x07; }") unless defined(&RTW_RFCHIPID_MAXIM2822);
    eval("sub RTW_RFCHIPID_MAXIM2825 () { 0x08; }") unless defined(&RTW_RFCHIPID_MAXIM2825);
    eval("sub RTW_RFCHIPID_RTL8225 () { 0x09; }") unless defined(&RTW_RFCHIPID_RTL8225);
    eval("sub RTW_RFCHIPID_RTL8255 () { 0x0a; }") unless defined(&RTW_RFCHIPID_RTL8255);
    eval 'sub RTW_F_ENABLED () {0x1;}' unless defined(&RTW_F_ENABLED);
    eval 'sub RTW_F_DIGPHY () {0x2;}' unless defined(&RTW_F_DIGPHY);
    eval 'sub RTW_F_DFLANTB () {0x4;}' unless defined(&RTW_F_DFLANTB);
    eval 'sub RTW_F_RTL8185 () {0x8;}' unless defined(&RTW_F_RTL8185);
    eval 'sub RTW_F_ANTDIV () {0x10;}' unless defined(&RTW_F_ANTDIV);
    eval 'sub RTW_F_9356SROM () {0x20;}' unless defined(&RTW_F_9356SROM);
    eval 'sub RTW_F_SLEEP () {0x40;}' unless defined(&RTW_F_SLEEP);
    eval 'sub RTW_F_INVALID () {0x80;}' unless defined(&RTW_F_INVALID);
    eval 'sub RTW_F_ALLPHY () {( &RTW_F_DIGPHY| &RTW_F_DFLANTB| &RTW_F_ANTDIV);}' unless defined(&RTW_F_ALLPHY);
    eval("sub RTW_ACCESS_NONE () { 0; }") unless defined(&RTW_ACCESS_NONE);
    eval("sub RTW_ACCESS_CONFIG () { 1; }") unless defined(&RTW_ACCESS_CONFIG);
    eval("sub RTW_ACCESS_ANAPARM () { 2; }") unless defined(&RTW_ACCESS_ANAPARM);
    eval 'sub RTW_SR_GET {
        local($sr, $ofs) = @_;
	    eval q(((($sr)-> $sr_content[($ofs)/2] >> ((($ofs) % 2== 0) ? 0: 8)) & 0xff));
    }' unless defined(&RTW_SR_GET);
    eval 'sub RTW_SR_GET16 {
        local($sr, $ofs) = @_;
	    eval q(( &RTW_SR_GET(($sr), ($ofs)) | ( &RTW_SR_GET(($sr), ($ofs) + 1) << 8)));
    }' unless defined(&RTW_SR_GET16);
    eval 'sub RTW_NTXPRI () {4;}' unless defined(&RTW_NTXPRI);
    eval 'sub RTW_TXPRILO () {0;}' unless defined(&RTW_TXPRILO);
    eval 'sub RTW_TXPRIMD () {1;}' unless defined(&RTW_TXPRIMD);
    eval 'sub RTW_TXPRIHI () {2;}' unless defined(&RTW_TXPRIHI);
    eval 'sub RTW_TXPRIBCN () {3;}' unless defined(&RTW_TXPRIBCN);
    eval 'sub RTW_MAXPKTSEGS () {64;}' unless defined(&RTW_MAXPKTSEGS);
    eval 'sub CASSERT {
        local($cond, $complaint) = @_;
	    eval q($complaint->[($cond) ? 0: -1] = $complaint->[($cond) ? 0: -1]);
    }' unless defined(&CASSERT);
    eval 'sub RTW_TXQLENLO () {64;}' unless defined(&RTW_TXQLENLO);
    eval 'sub RTW_TXQLENMD () {64;}' unless defined(&RTW_TXQLENMD);
    eval 'sub RTW_TXQLENHI () {64;}' unless defined(&RTW_TXQLENHI);
    eval 'sub RTW_TXQLENBCN () {1;}' unless defined(&RTW_TXQLENBCN);
    eval 'sub RTW_NTXDESCLO () { &RTW_TXQLENLO;}' unless defined(&RTW_NTXDESCLO);
    eval 'sub RTW_NTXDESCMD () { &RTW_TXQLENMD;}' unless defined(&RTW_NTXDESCMD);
    eval 'sub RTW_NTXDESCHI () { &RTW_TXQLENHI;}' unless defined(&RTW_NTXDESCHI);
    eval 'sub RTW_NTXDESCBCN () { &RTW_TXQLENBCN;}' unless defined(&RTW_NTXDESCBCN);
    eval 'sub RTW_NTXDESCTOTAL () {( &RTW_NTXDESCLO +  &RTW_NTXDESCMD +  &RTW_NTXDESCHI +  &RTW_NTXDESCBCN);}' unless defined(&RTW_NTXDESCTOTAL);
    eval 'sub RTW_RXQLEN () {64;}' unless defined(&RTW_RXQLEN);
    eval 'sub RTW_NEXT_IDX {
        local($__htc, $__idx) = @_;
	    eval q(((($__idx) + 1) % ($__htc)-> &tdb_ndesc));
    }' unless defined(&RTW_NEXT_IDX);
    eval 'sub RTW_NEXT_DESC {
        local($__htc, $__idx) = @_;
	    eval q((($__htc)-> &tdb_physbase + $sizeof{\'struct rtw_txdesc\'} *  &RTW_NEXT_IDX(($__htc), ($__idx))));
    }' unless defined(&RTW_NEXT_DESC);
    eval 'sub RTW_DESC_OFFSET {
        local($ring, $i) = @_;
	    eval q( &offsetof(\'struct rtw_descs\', $ring->[$i]));
    }' unless defined(&RTW_DESC_OFFSET);
    eval 'sub RTW_RING_OFFSET {
        local($ring) = @_;
	    eval q( &RTW_DESC_OFFSET($ring, 0));
    }' unless defined(&RTW_RING_OFFSET);
    eval 'sub RTW_RING_BASE {
        local($sc, $ring) = @_;
	    eval q((($sc)-> &sc_desc_physaddr +  &RTW_RING_OFFSET($ring)));
    }' unless defined(&RTW_RING_BASE);
    eval 'sub RTW_RX_RADIOTAP_PRESENT () {((1<<  &IEEE80211_RADIOTAP_TSFT) | (1<<  &IEEE80211_RADIOTAP_FLAGS) | (1<<  &IEEE80211_RADIOTAP_RATE) | (1<<  &IEEE80211_RADIOTAP_CHANNEL) | (1<<  &IEEE80211_RADIOTAP_LOCK_QUALITY) | (1<<  &IEEE80211_RADIOTAP_DB_ANTSIGNAL) | 0);}' unless defined(&RTW_RX_RADIOTAP_PRESENT);
    eval 'sub RTW_TX_RADIOTAP_PRESENT () {((1<<  &IEEE80211_RADIOTAP_FLAGS) | (1<<  &IEEE80211_RADIOTAP_RATE) | (1<<  &IEEE80211_RADIOTAP_CHANNEL) | 0);}' unless defined(&RTW_TX_RADIOTAP_PRESENT);
    eval("sub FINISHED () { 0; }") unless defined(&FINISHED);
    eval("sub FINISH_DESCMAP_LOAD () { 1; }") unless defined(&FINISH_DESCMAP_LOAD);
    eval("sub FINISH_DESCMAP_CREATE () { 2; }") unless defined(&FINISH_DESCMAP_CREATE);
    eval("sub FINISH_DESC_MAP () { 3; }") unless defined(&FINISH_DESC_MAP);
    eval("sub FINISH_DESC_ALLOC () { 4; }") unless defined(&FINISH_DESC_ALLOC);
    eval("sub FINISH_RXMAPS_CREATE () { 5; }") unless defined(&FINISH_RXMAPS_CREATE);
    eval("sub FINISH_TXMAPS_CREATE () { 6; }") unless defined(&FINISH_TXMAPS_CREATE);
    eval("sub FINISH_RESET () { 7; }") unless defined(&FINISH_RESET);
    eval("sub FINISH_READ_SROM () { 8; }") unless defined(&FINISH_READ_SROM);
    eval("sub FINISH_PARSE_SROM () { 9; }") unless defined(&FINISH_PARSE_SROM);
    eval("sub FINISH_RF_ATTACH () { 10; }") unless defined(&FINISH_RF_ATTACH);
    eval("sub FINISH_ID_STA () { 11; }") unless defined(&FINISH_ID_STA);
    eval("sub FINISH_TXDESCBLK_SETUP () { 12; }") unless defined(&FINISH_TXDESCBLK_SETUP);
    eval("sub FINISH_TXCTLBLK_SETUP () { 13; }") unless defined(&FINISH_TXCTLBLK_SETUP);
    eval("sub DETACHED () { 14; }") unless defined(&DETACHED);
    eval("sub RTW_OFF () { 0; }") unless defined(&RTW_OFF);
    eval("sub RTW_SLEEP () { 1; }") unless defined(&RTW_SLEEP);
    eval("sub RTW_ON () { 2; }") unless defined(&RTW_ON);
    eval 'sub RTW_LED_SLOW_TICKS () { &MAX(1,  &hz/2);}' unless defined(&RTW_LED_SLOW_TICKS);
    eval 'sub RTW_LED_FAST_TICKS () { &MAX(1,  &hz/10);}' unless defined(&RTW_LED_FAST_TICKS);
    eval 'sub RTW_LED0 () {0x1;}' unless defined(&RTW_LED0);
    eval 'sub RTW_LED1 () {0x2;}' unless defined(&RTW_LED1);
    eval 'sub RTW_LED_S_RX () {0x1;}' unless defined(&RTW_LED_S_RX);
    eval 'sub RTW_LED_S_TX () {0x2;}' unless defined(&RTW_LED_S_TX);
    eval 'sub RTW_LED_S_SLOW () {0x4;}' unless defined(&RTW_LED_S_SLOW);
    eval 'sub sc_desc_physaddr () { ($sc_desc_dmamap->{dm_segs[0]}->{ds_addr});}' unless defined(&sc_desc_physaddr);
    eval 'sub sc_if () { ($sc_ic->{ic_if});}' unless defined(&sc_if);
    eval 'sub sc_rxtap () { ($sc_rxtapu->{tap});}' unless defined(&sc_rxtap);
    eval 'sub sc_txtap () { ($sc_txtapu->{tap});}' unless defined(&sc_txtap);
}
1;
