#
# (C) Renaud Deraison
#
#
# Credits to: eEye


if(description)
{
 script_id(12054);
 script_bugtraq_id(9633, 9635, 9743);
 script_cve_id("CAN-2003-0818");
 script_version ("$Revision: 1.14 $");
 if(defined_func("script_xref"))script_xref(name:"IAVA", value:"2004-A-0001");
 
 name["english"] = "ASN.1 Parsing Vulnerabilities (NTLM check)";
 script_name(english:name["english"]);
 
 desc["english"] = "
 The remote Windows host has a ASN.1 library which is vulnerable to a 
flaw which could allow an attacker to execute arbitrary code on this host.

To exploit this flaw, an attacker would need to send a specially crafted
ASN.1 encoded packet with improperly advertised lengths.

This particular check sent a malformed NTLM packet and determined that 
the remote host is not patched.

Solution : http://www.microsoft.com/technet/security/bulletin/ms04-007.mspx
Risk factor : High";
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks if the remote host has a patched ASN.1 decoder (828028)";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Renaud Deraison");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 script_require_ports(139,445); 
 script_dependencies("netbios_name_get.nasl");
 exit(0);
}




include("misc_func.inc");
include("smb_nt.inc");


function smb_neg_prot_gssapi(soc)
{
 local_var neg_prot, r;
 
 neg_prot = raw_string
   	(
	 0x00, 0x00, 0x00, 0xA4, 0xFF, 0x53,
	 0x4D, 0x42, 0x72, 0x00, 0x00, 0x00, 0x00, 0x08,
	 0x01, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x4D, 0x0B, 0x00, 0x00, g_mlo, g_mhi, 0x00, 0x81,
	 0x00, 0x02
	 ) + "PC NETWORK PROGRAM 1.0" + raw_string(0x00, 0x02) +
	 "MICROSOFT NETWORKS 1.03" + raw_string(0x00, 0x02) + 
	 "MICROSOFT NETWORKS 3.0"  + raw_string(0x00, 0x02) + 
	 "LANMAN1.0" + raw_string(0x00, 0x02) + 
	 "LM1.2X002" + raw_string(0x00, 0x02) + 
	 "Samba" +     raw_string(0x00, 0x02) +
	 "NT LANMAN 1.0" + raw_string(0x00, 0x02) +
	 "NT LM 0.12" + raw_string(0x00);
	 
	 
 send(socket:soc, data:neg_prot);
 r = smb_recv(socket:soc, length:4000);
 return r;
}

function netbios(data)
{
 return raw_string(0,0,0,strlen(data) % 256) + data;
}

function smb(blob, suffix)
{
 local_var len, tot_len;
 len = strlen(blob);
 tot_len = len + strlen(suffix);

 return raw_string(0xff, 0x53, 
		   0x4d, 0x42, 0x73, 0x00, 0x00, 0x00, 0x00, 0x08,
		   0x01, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		   0x00, 0x00, 0x00, 0x00, g_mlo, g_mhi, 0x0c, 0xff,
		   0x00, 0x00, 0x00, 0x01, 0x40, 0x02, 0x00, 0x01,
		   0x00, 0x00, 0x00, 0x00, 0x00, len,  0x00, 0x00,
		   0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x80, tot_len,
		   0x00 ) + blob + suffix;
}


function gssapi(oid, spenego)
{
 local_var len;
 len = strlen(oid) + strlen(spenego);
 return raw_string(0x60, 0x84,0,0,0,len % 256) + oid + spenego;
}

# Returns SPNEGO OID (1.3.6.5.5.2)
function oid()
{
 local_var oid, len;
 oid = raw_string(0x2b, 0x06, 0x01, 0x05, 0x05, 0x02);
 len = strlen(oid);
 return raw_string(0x06, 0x83,0,0,len % 256) + oid;
}


# ANS.1 encodes our negTokenInit blob
function spenego(negTokenInit)
{
 local_var len;
 len = strlen(negTokenInit);

 return raw_string(0xa0, 0x82,0,len % 256) + negTokenInit;
}


# ASN.1 encodes our mechType and mechListMIC
function negTokenInit(mechType, mechListMIC)
{
 local_var len, data, data2;

 len = strlen(mechType); 
 data = raw_string(0xa0, len + 2, 0x30, len);
 len += strlen(data) + strlen(mechListMIC) + 8;

 len2 = strlen(mechListMIC);
 data2 = raw_string(0xa3, len2 + 6, 0x30, len2 + 4, 0xa0, len2 - 8 , 0x3b, 0x2e);


 return raw_string(0x30,0x81,len % 256) + data + mechType + data2 + mechListMIC;
}

# Returns OID 1.3.6.1.4.1.311.2.2.10 (NTMSSP)
function mechType()
{
 return raw_string(0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x02, 0x02, 0x0a);
}

function mechListMIC()
{
 local_var data;

 data = raw_string(0x04, 0x81, 0x01, 0x25) +
       	raw_string(0x24, 0x81, 0x27) + 
        	raw_string(0x04, 0x01, 0x00, 0x24, 0x22, 0x24, 0x20, 0x24,
			   0x18, 0x24, 0x16, 0x24, 0x14, 0x24, 0x12, 0x24,
			   0x10, 0x24, 0x0e, 0x24, 0x0c, 0x24, 0x0a, 0x24,
			   0x08, 0x24, 0x06, 0x24, 0x04, 0x24, 0x02, 0x04,
			   0x00, 0x04, 0x82, 0x00, 0x02, 0x39, 0x25)  +
        	raw_string(0xa1, 0x08) +
       			raw_string(0x04, 0x06) + 
				"Nessus";

 return data;
}






port = int(get_kb_item("SMB/transport"));

if ( ! port ) 
{
 port = 445;
 soc  = 0;
 if ( get_port_state(port) )
 {
  soc = open_sock_tcp(port);
 }
 if ( ! soc )
 {
  port = 139;
  if ( ! get_port_state(port) ) exit(0);
 }
}



if ( ! soc ) soc = open_sock_tcp(port);
if ( ! soc ) exit(0);

if ( port == 139 )
{
  name = kb_smb_name();
  r = smb_session_request(soc:soc,  remote:name); 
  if (  ! r ) exit(0);
}

r = smb_neg_prot_gssapi(soc:soc);
if ( ! r ) exit(0);


rawblob = netbios(data:smb(blob:gssapi(oid:oid(), spenego:spenego(negTokenInit:negTokenInit(mechType:mechType(), mechListMIC:mechListMIC()))), suffix:unicode(data:"Windows") + unicode(data:"Nessus") + raw_string(0,0)));


send(socket:soc, data:rawblob);
result = smb_recv(socket:soc, length:4096);
if ( ! result ) exit(0);
if ( strlen(result) < 13 ) exit(0);

code = substr(result, 9,12);
# 0x160000c0 -> vulnerable
# 0x0d0000c0 -> patched
if ( "160000c0" >< hexstr(code) ) security_hole(port);


