#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SuSE-SA:2003:048
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13816);
 script_bugtraq_id(9115);
 script_version ("$Revision: 1.5 $");
 script_cve_id("CAN-2003-0971");
 
 name["english"] = "SuSE-SA:2003:048: gpg";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SuSE-SA:2003:048 (gpg).


The gnupg (the SUSE package is named gpg) package is the most widely 
used software for cryptographic encryption/decryption of data.

Two independent errors have been found in gpg (GnuPG) packages as shipped
with SUSE products: 

A) A format string error in the client code that does key retrieval
from a (public) key server
B) A cryptographic error in gpg that results in a compromise of a
cryptographic keypair if ElGamal signing keys have been used for
generating the key.


A)
There exists a format string error in thhe client code for key retrieval
from a keyserver. gpg-1.2.x version packages are affected by this 
vulnerability.
The format string error can be used by an attacker performing a 
man-in-the-middle-attack between you and your keyserver, or by a
compromised keyserver. The result is a crash of gpg or a potential 
execution of arbitrary code provided by the attacker, if the keyserver
is used for key retrieval at the time of the attack.

B)
Werner Koch, the author of the gpg package, has publicly announced a
weakness in gpg that has been reported to him by Phong Nguyen: 
ElGamal signing keys can be attacked within seconds to reveal the
private key of the keypair. It is strongly advised that ElGamal signing
keys should be revoked immediately. Only ElGamal keys are affected, other
types are not vulnerable.

To find out if you are using an ElGamal signing key, list your public
keys using the command

gpg --list-keys your_keyid

Example:
$ gpg --list-keys build@suse.de
pub  1024D/9C800ACA 2000-10-19 SuSE Package Signing Key <build@suse.de>
sub  2048g/8495160C 2000-10-19 [expires: 2006-02-12]
$ 

If your key lists a capital 'G' after the key's length (like in
pub  1536G/...), then your key is vulnerable. A small letter 'g' after
the key length does NOT indicate any problem.
ElGamal keys can be used for primary keys as well as for subkeys. In the
case where only a subkey is an ElGamal key, it is sufficient to revoke
this specific subkey.

To revoke a key, generate a revocation certificate using the following 
command:

gpg --gen-revoke your_keyid > revocation_certificate.pgp

Then, the revokation certificate must be imported into your keyring:

gpg --import < revocation_certificate.pgp

As your last action, send the key with its revocation certificate
to the keyservers that know your key:

gpg --keyserver wwwkeys.eu.pgp.net --send-keys your_keyid


ElGamal keys can only be generated by gpg if a special option (--expert)
has been used to reveal 'expert' options, and if a warning has been
ignored after your choice to use ElGamal keys. Such keys are rare 
(Werner Koch reports 848 primary ElGamal signing keys and 324 vulnerable 
subkeys on the keyservers.). Therefore, we expect that only experienced
users of gpg may be vulnerable to the ElGamal signing key error.




Solution : http://www.suse.de/security/2003_048_gpg.html
Risk factor : Medium";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gpg package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gpg-1.2.2-121", release:"SUSE9.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"gpg-1.2.2rc1-98", release:"SUSE8.2") )
{
 security_warning(0);
 exit(0);
}
if (rpm_exists(rpm:"gpg-", release:"SUSE9.0")
 || rpm_exists(rpm:"gpg-", release:"SUSE8.2") )
{
 set_kb_item(name:"CAN-2003-0971", value:TRUE);
}
