#
# (C) Tenable Network Security
#

if(description)
{
 script_id(14724);
 script_version("$Revision: 1.10 $");
 script_cve_id("CAN-2004-0200");
 script_bugtraq_id(11173);
 if ( defined_func("script_xref") ) script_xref(name:"IAVA", value:"2004-A-0015");
 name["english"] = "Buffer Overrun in JPEG Processing (833987)";

 script_name(english:name["english"]);

 desc["english"] = "
The remote host is running a version of Windows which is vulnerable to a
buffer overrun vulnerability when viewing a JPEG file, which may allow an
attacker to execute arbitrary code on the remote host.

To exploit this flaw, an attacker would need to send a malformed JPEG file
to a user on the remote host and wait for him to open it using an
affected Microsoft application.

Solution : http://www.microsoft.com/technet/security/bulletin/ms04-028.mspx
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for ms04-028 via the registry";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);

 script_dependencies("smb_hotfixes.nasl" );
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_hotfixes.inc");
include("smb_nt.inc");
global_var soc, uid, tid;
global_var report;

if ( ! get_kb_item("SMB/registry_access" ) ) exit(0);

if ( hotfix_check_sp(xp:2, win2003:1) > 0 ) 
{
if ( hotfix_missing(name:"KB833987") > 0 ) 
	{
	security_hole(get_kb_item("SMB/transport"));
	exit(0);
	}
}


# Crawl through %ProgramFiles% to get the list of affected files
port = kb_smb_transport();
if(!port) port = 139;


report = make_list();
function add_file(file, version)
{
 report = make_list(report, file + " (version " + version + ")");
}


function get_dirs(socket, uid, tid, basedir, level)
{
 local_var ret,ret2, r, subdirs, subsub;
 

 if(level > 10)
 	return NULL;
	
 subdirs = NULL;
 ret = FindFirst2(socket:soc, uid:uid, tid:tid, pattern:basedir + "\*");
 if(isnull(ret))
 	return NULL;
	
 foreach r (ret)
 { 
  if(isnull(ret2))
  	ret2 = make_list(basedir + "\" + r);
  else
  	ret2 = make_list(ret2, basedir + "\" + r);
	
  if("." >!< r)
  	subsub  = get_dirs(socket:soc, uid:uid, tid:tid, basedir:basedir + "\" + r, level:level + 1);
  if(!isnull(subsub))
  {
  	if(isnull(subdirs))subdirs = make_list(subsub);
  	else	subdirs = make_list(subdirs, subsub);
  }
 }
 
 if(isnull(subdirs))
 	return ret2;
 else
 	return make_list(ret2, subdirs);
}

		

function list_gdiplus_files()
{
 num_gdi_plus_files = 0;
 soc = open_sock_tcp(port);
 if(soc)
 {
 r = smb_session_request(soc:soc,  remote:name);
 if(!r)return(FALSE);

  #
  # Negociate the protocol
  #
  prot = smb_neg_prot(soc:soc);
  if(!prot)exit(0);
  #
  # Set up our null session 
  #
  r = smb_session_setup(soc:soc, login:login, password:pass, domain:dom, prot:prot);
  if(!r)return(FALSE);
  # and extract our uid
  uid = session_extract_uid(reply:r);

  r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
  tid = tconx_extract_tid(reply:r);
 if(!tid){ close(soc); return(FALSE); }

 #
 # Create a pipe to \winreg
 #
 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r){ close(soc); return(FALSE);}
 # and extract its ID
 pipe = smbntcreatex_extract_pipe(reply:r);

 #
 # Setup things
 #
 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r){ close(soc); return(FALSE); }
 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:"SOFTWARE\Microsoft\Windows\CurrentVersion", reply: handle);
 if(strlen(key_h) > 92)
  {
    sz =  registry_get_item_sz(soc:soc, uid:uid, tid:tid, pipe:pipe, item:"ProgramFilesDir", reply:key_h);
   registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h); 
   dirraw =  registry_decode_sz(data:sz);
   dir = ereg_replace(pattern:"[A-Z]:\\(.*)", replace:"\1", string:dirraw);
   share = ereg_replace(pattern:"([A-Z]):\\.*", replace:"\1$", string:dirraw);
  }

  if ( ! dir || ! share ) exit(0);
 

  gdi_plus_file = NULL;
  r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
  if(r)
  { 
   tid = tconx_extract_tid(reply:r);
   dirs = get_dirs(socket:soc, uid:uid, tid:tid, basedir:dir, level:0);
  
   foreach dir (dirs)
   {
    if(ereg(pattern:"\\(gdiplus|mso)\.dll", string:dir, icase:TRUE))
    {
     if(isnull(gdi_plus_file)) gdi_plus_file = make_list(dir);
     else gdi_plus_file = make_list(gdi_plus_file, dir);
     num_gdi_plus_files ++;
     if (num_gdi_plus_files >= 10 )
     {
      return gdi_plus_file;
     }
    }
   }
  }
  else close(soc);
  }
  return(gdi_plus_file);
}		

function check_version(file)
{
 local_var i;
 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(fid)
 {
  v = GetFileVersion(socket:soc, uid:uid, tid:tid, fid:fid);
  if ( ! v ) return 0;
  z  = split(v, sep:".", keep:FALSE);
  if ( egrep(pattern:"gdiplus\.dll", icase:TRUE, string:file) )
   {
     # Older than 5.x or 5.1
     if ( int(z[0]) < 5 || (int(z[0]) == 5 && int(z[1]) < 1) ) add_file(file:file, version:v);
     # < 5.1.310.1355
     else if ( int(z[0]) == 5 && int(z[1]) == 1 && ( int(z[2]) < 3102 || (int(z[2]) == 3102 && int(z[3]) < 1355 ))) add_file(file:file, version:v);
     # < 5.2.3790.136
     else if ( int(z[0]) == 5 && int(z[1]) == 2 && ( int(z[2]) < 3790 || (int(z[2]) == 3790 && int(z[3]) < 136  ))) add_file(file:file, version:v);
     # < 6.0.3264.0
     else if ( int(z[0]) == 6 && int(z[1]) == 0 && int(z[2]) < 3264 ) add_file(file:file, version:v);
   }
   else if ( egrep(pattern:"mso\.dll", icase:TRUE, string:file) )
   {
     # Older than 10.0.6714
     if ( int(z[0]) < 10 || (int(z[0]) == 10 && int(z[1]) == 0 && int(z[2]) < 6714 )) add_file(file:file, version:v);
   }
 }
}


#
# Here we go
#		


name = kb_smb_name();
if(!name)exit(0);




login = kb_smb_login();
pass =  kb_smb_password();

if(!login)login = "";
if(!pass)pass = "";

dom = kb_smb_domain();


if(!get_port_state(port))exit(0);


files = list_gdiplus_files();
if(!isnull(files))
 {
  foreach f (files)
  {
   if ( "\Macromedia\" >!< f ) check_version(file:f);
  }
}

str = "
The remote host is running a version of Windows which is vulnerable to a
buffer overrun vulnerability when viewing a JPEG file, which may allow an
attacker to execute arbitrary code on the remote host.

To exploit this flaw, an attacker would need to send a malformed JPEG file
to a user on the remote host and wait for him to open it using an
affected Microsoft application.

The following files need to be updated : 

";

flag = 0;
foreach file (report)
{
 flag ++;
 str += file + '\n';
}


str += '\n\nSolution: http://www.microsoft.com/technet/security/bulletin/ms04-028.mspx\nRisk Factor: High\n';
if ( flag > 0 ) security_hole(port:port, data:str);

