#
# (C) Tenable Network Security
#

if(description)
{
 script_id(11928);
 script_bugtraq_id(8828);
 script_version("$Revision: 1.5 $");
 script_cve_id("CAN-2003-0711");
 
 name["english"] = "Buffer Overrun in Windows Help (825119)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
A security vulnerability exists in the Windows Help Service that could allow 
arbitrary code execution on an affected system. An attacker who successfully 
exploited this vulnerability could be able to run code with Local System on
this host.

Solution : see http://www.microsoft.com/technet/security/bulletin/ms03-044.mspx
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for hotfix 825119";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_full_access.nasl",
		     "smb_reg_service_pack.nasl",
		     "smb_reg_service_pack_XP.nasl",
		     "smb_reg_service_pack_W2K.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/registry_full_access","SMB/WindowsVersion");
 script_exclude_keys("SMB/Win2003/ServicePack");

 script_require_ports(139, 445);
 exit(0);
}

include("smb_nt.inc");

if ( ! get_kb_item("SMB/registry_access") ) exit(0);





rootfile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows NT\CurrentVersion", item:"PathName");
if(!rootfile)
{
 exit(0);
}
else
{
 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:rootfile);
 itircl =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1\system32\itircl.dll", string:rootfile);
}




function get_ver(filename)
{
name 	=  kb_smb_name();
login	=  kb_smb_login();
pass  	=  kb_smb_password();
domain 	=  kb_smb_domain();
port    =  kb_smb_transport();
if(!port) port = 139;



if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);



r = smb_session_request(soc:soc, remote:name);
if(!r)exit(0);

prot = smb_neg_prot(soc:soc);
if(!prot)exit(0);

r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
if(!r)exit(0);

uid = session_extract_uid(reply:r);



r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
tid = tconx_extract_tid(reply:r);
if(!tid)exit(0);

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:filename);
if ( fid )
 {
 v = GetFileVersion(socket:soc, uid:uid, tid:tid, fid:fid);
 return v;
 }
}



a = get_ver(filename:itircl);
if(a)
{
 # Fixed in 5.2.3790.80
  num = split(a, sep:".", keep:FALSE);
  if ( int(num[0]) < 5 ||
       ( int(num[0]) == 5 && int(num[1]) < 2) ||
       ( int(num[0]) == 5 && int(num[1]) == 2 && int(num[2]) < 3790 ) ||
       ( int(num[0]) == 5 && int(num[1]) == 2 && int(num[2]) == 3790 && int(num[3]) < 80 ))
        security_hole(kb_smb_transport());
        
  
}
